// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Mediator Mediator information
//
// swagger:model mediator
type Mediator struct {

	// BlueXP account token. This field is only applicable to the ONTAP cloud mediator.
	BluexpAccountToken *string `json:"bluexp_account_token,omitempty"`

	// BlueXP organization ID. This field is only applicable to the ONTAP cloud mediator.
	BluexpOrgID *string `json:"bluexp_org_id,omitempty"`

	// CA certificate for ONTAP Mediator. This is optional if the certificate is already installed.
	CaCertificate *string `json:"ca_certificate,omitempty"`

	// dr group
	DrGroup *MediatorInlineDrGroup `json:"dr_group,omitempty"`

	// The IP address of the mediator.
	// Example: 10.10.10.7
	IPAddress *string `json:"ip_address,omitempty"`

	// Indicates the mediator connectivity status of the local cluster. Possible values are connected, unreachable, unusable and down-high-latency. This field is only applicable to the mediators in SnapMirror active sync configuration.
	// Example: connected
	// Read Only: true
	LocalMediatorConnectivity *string `json:"local_mediator_connectivity,omitempty"`

	// The password used to connect to the REST server on the mediator.
	// Example: mypassword
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// peer cluster
	PeerCluster *MediatorInlinePeerCluster `json:"peer_cluster,omitempty"`

	// Indicates the mediator connectivity status of the peer cluster. Possible values are connected, unreachable, unknown and down-high-latency.
	// Example: connected
	// Read Only: true
	PeerMediatorConnectivity *string `json:"peer_mediator_connectivity,omitempty"`

	// The REST server's port number on the mediator.
	// Example: 31784
	Port *int64 `json:"port,omitempty"`

	// Indicates the connectivity status of the mediator.
	// Example: true
	// Read Only: true
	Reachable *bool `json:"reachable,omitempty"`

	// Client ID of the BlueXP service account. This field is only applicable to the ONTAP cloud mediator.
	ServiceAccountClientID *string `json:"service_account_client_id,omitempty"`

	// Client secret token of the BlueXP service account. This field is only applicable to the ONTAP cloud mediator.
	ServiceAccountClientSecret *string `json:"service_account_client_secret,omitempty"`

	// Indicates if strict validation of certificates is performed while making REST API calls to the mediator. This field is only applicable to the ONTAP Cloud Mediator.
	// Example: true
	StrictCertValidation *bool `json:"strict_cert_validation,omitempty"`

	// Mediator type. This field is only applicable to the mediators in SnapMirror active sync configuration.
	// Enum: ["cloud","on_prem"]
	Type *string `json:"type,omitempty"`

	// Indicates if the local cluster should use an http-proxy server while making REST API calls to the mediator. This field is only applicable to the ONTAP cloud mediator.
	// Example: true
	UseHTTPProxyLocal *bool `json:"use_http_proxy_local,omitempty"`

	// Indicates if the remote cluster should use an http-proxy server while making REST API calls to the mediator. This field is only applicable to the ONTAP cloud mediator.
	// Example: true
	UseHTTPProxyRemote *bool `json:"use_http_proxy_remote,omitempty"`

	// The username used to connect to the REST server on the mediator.
	// Example: myusername
	User *string `json:"user,omitempty"`

	// The unique identifier for the mediator service.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this mediator
func (m *Mediator) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDrGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeerCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Mediator) validateDrGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.DrGroup) { // not required
		return nil
	}

	if m.DrGroup != nil {
		if err := m.DrGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dr_group")
			}
			return err
		}
	}

	return nil
}

func (m *Mediator) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Mediator) validatePeerCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerCluster) { // not required
		return nil
	}

	if m.PeerCluster != nil {
		if err := m.PeerCluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster")
			}
			return err
		}
	}

	return nil
}

var mediatorTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cloud","on_prem"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mediatorTypeTypePropEnum = append(mediatorTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// mediator
	// Mediator
	// type
	// Type
	// cloud
	// END DEBUGGING
	// MediatorTypeCloud captures enum value "cloud"
	MediatorTypeCloud string = "cloud"

	// BEGIN DEBUGGING
	// mediator
	// Mediator
	// type
	// Type
	// on_prem
	// END DEBUGGING
	// MediatorTypeOnPrem captures enum value "on_prem"
	MediatorTypeOnPrem string = "on_prem"
)

// prop value enum
func (m *Mediator) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mediatorTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Mediator) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this mediator based on the context it is used
func (m *Mediator) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDrGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalMediatorConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeerCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeerMediatorConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReachable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Mediator) contextValidateDrGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.DrGroup != nil {
		if err := m.DrGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dr_group")
			}
			return err
		}
	}

	return nil
}

func (m *Mediator) contextValidateLocalMediatorConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local_mediator_connectivity", "body", m.LocalMediatorConnectivity); err != nil {
		return err
	}

	return nil
}

func (m *Mediator) contextValidatePeerCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.PeerCluster != nil {
		if err := m.PeerCluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster")
			}
			return err
		}
	}

	return nil
}

func (m *Mediator) contextValidatePeerMediatorConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "peer_mediator_connectivity", "body", m.PeerMediatorConnectivity); err != nil {
		return err
	}

	return nil
}

func (m *Mediator) contextValidateReachable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reachable", "body", m.Reachable); err != nil {
		return err
	}

	return nil
}

func (m *Mediator) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Mediator) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Mediator) UnmarshalBinary(b []byte) error {
	var res Mediator
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MediatorInlineDrGroup DR group reference.
//
// swagger:model mediator_inline_dr_group
type MediatorInlineDrGroup struct {

	// DR Group ID
	// Read Only: true
	ID *int64 `json:"id,omitempty"`
}

// Validate validates this mediator inline dr group
func (m *MediatorInlineDrGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this mediator inline dr group based on the context it is used
func (m *MediatorInlineDrGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MediatorInlineDrGroup) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dr_group"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MediatorInlineDrGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MediatorInlineDrGroup) UnmarshalBinary(b []byte) error {
	var res MediatorInlineDrGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MediatorInlinePeerCluster The peer cluster that the mediator service is used for.
//
// swagger:model mediator_inline_peer_cluster
type MediatorInlinePeerCluster struct {

	// links
	Links *MediatorInlinePeerClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster2
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: ebe27c49-1adf-4496-8335-ab862aebebf2
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this mediator inline peer cluster
func (m *MediatorInlinePeerCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MediatorInlinePeerCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this mediator inline peer cluster based on the context it is used
func (m *MediatorInlinePeerCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MediatorInlinePeerCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MediatorInlinePeerCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MediatorInlinePeerCluster) UnmarshalBinary(b []byte) error {
	var res MediatorInlinePeerCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MediatorInlinePeerClusterInlineLinks mediator inline peer cluster inline links
//
// swagger:model mediator_inline_peer_cluster_inline__links
type MediatorInlinePeerClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this mediator inline peer cluster inline links
func (m *MediatorInlinePeerClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MediatorInlinePeerClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this mediator inline peer cluster inline links based on the context it is used
func (m *MediatorInlinePeerClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MediatorInlinePeerClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peer_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MediatorInlinePeerClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MediatorInlinePeerClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res MediatorInlinePeerClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
