// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MediatorPing BlueXP cloud service ping API.
//
// swagger:model mediator_ping
type MediatorPing struct {

	// Indicates if the BlueXP cloud mediator is configurable. This depends on whether the ping latency is within a threshold.
	// Example: true
	// Read Only: true
	Configurable *bool `json:"configurable,omitempty"`

	// Indicates if the ping latency of the BlueXP cloud server is greater than a threshold.
	// Example: false
	// Read Only: true
	HighLatency *bool `json:"high_latency,omitempty"`

	// Ping latency in milliseconds.
	// Example: 150
	// Read Only: true
	LatencyMs *int64 `json:"latency_ms,omitempty"`

	// Indicates if the HTTP proxy is configured on the cluster for the REST API calls to the BlueXP cloud server.
	// Example: true
	// Read Only: true
	ProxyConfigured *bool `json:"proxy_configured,omitempty"`

	// Indicates if the HTTP proxy is used for the ping to the BlueXP cloud server.
	// Example: true
	// Read Only: true
	ProxyUsed *bool `json:"proxy_used,omitempty"`

	// Ping status of the BlueXP cloud service.
	// Example: true
	// Read Only: true
	Reachable *bool `json:"reachable,omitempty"`

	// Indicates if the ping to the BlueXP cloud server failed due to a timeout.
	// Example: false
	// Read Only: true
	TimeoutOccurred *bool `json:"timeout_occurred,omitempty"`

	// Mediator type.
	// Enum: ["cloud","on_prem"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this mediator ping
func (m *MediatorPing) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var mediatorPingTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cloud","on_prem"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mediatorPingTypeTypePropEnum = append(mediatorPingTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// mediator_ping
	// MediatorPing
	// type
	// Type
	// cloud
	// END DEBUGGING
	// MediatorPingTypeCloud captures enum value "cloud"
	MediatorPingTypeCloud string = "cloud"

	// BEGIN DEBUGGING
	// mediator_ping
	// MediatorPing
	// type
	// Type
	// on_prem
	// END DEBUGGING
	// MediatorPingTypeOnPrem captures enum value "on_prem"
	MediatorPingTypeOnPrem string = "on_prem"
)

// prop value enum
func (m *MediatorPing) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mediatorPingTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MediatorPing) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this mediator ping based on the context it is used
func (m *MediatorPing) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfigurable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHighLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyMs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProxyConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProxyUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReachable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeoutOccurred(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MediatorPing) contextValidateConfigurable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "configurable", "body", m.Configurable); err != nil {
		return err
	}

	return nil
}

func (m *MediatorPing) contextValidateHighLatency(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "high_latency", "body", m.HighLatency); err != nil {
		return err
	}

	return nil
}

func (m *MediatorPing) contextValidateLatencyMs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "latency_ms", "body", m.LatencyMs); err != nil {
		return err
	}

	return nil
}

func (m *MediatorPing) contextValidateProxyConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "proxy_configured", "body", m.ProxyConfigured); err != nil {
		return err
	}

	return nil
}

func (m *MediatorPing) contextValidateProxyUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "proxy_used", "body", m.ProxyUsed); err != nil {
		return err
	}

	return nil
}

func (m *MediatorPing) contextValidateReachable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reachable", "body", m.Reachable); err != nil {
		return err
	}

	return nil
}

func (m *MediatorPing) contextValidateTimeoutOccurred(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timeout_occurred", "body", m.TimeoutOccurred); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MediatorPing) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MediatorPing) UnmarshalBinary(b []byte) error {
	var res MediatorPing
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
