// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MediatorPingError mediator ping error
//
// swagger:model mediator_ping_error
type MediatorPingError struct {

	// Indicates if the BlueXP cloud mediator is configurable. This depends on whether the ping latency is within a threshold.
	// Example: false
	// Read Only: true
	Configurable *bool `json:"configurable,omitempty"`

	// error
	Error *MediatorPingErrorInlineError `json:"error,omitempty"`

	// Ping status of the BlueXP cloud service.
	// Example: false
	// Read Only: true
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this mediator ping error
func (m *MediatorPingError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MediatorPingError) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this mediator ping error based on the context it is used
func (m *MediatorPingError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfigurable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReachable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MediatorPingError) contextValidateConfigurable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "configurable", "body", m.Configurable); err != nil {
		return err
	}

	return nil
}

func (m *MediatorPingError) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *MediatorPingError) contextValidateReachable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "reachable", "body", m.Reachable); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MediatorPingError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MediatorPingError) UnmarshalBinary(b []byte) error {
	var res MediatorPingError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MediatorPingErrorInlineError mediator ping error inline error
//
// swagger:model mediator_ping_error_inline_error
type MediatorPingErrorInlineError struct {

	// Error code.
	Code *int64 `json:"code,omitempty"`

	// Error message string.
	Message *string `json:"message,omitempty"`
}

// Validate validates this mediator ping error inline error
func (m *MediatorPingErrorInlineError) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this mediator ping error inline error based on context it is used
func (m *MediatorPingErrorInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *MediatorPingErrorInlineError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MediatorPingErrorInlineError) UnmarshalBinary(b []byte) error {
	var res MediatorPingErrorInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
