// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Metrocluster Holds MetroCluster status and configuration parameters for the local and remote clusters. REST: /api/cluster/metrocluster
//
// swagger:model metrocluster
type Metrocluster struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Displays the MetroCluster configuration type.
	// Read Only: true
	// Enum: ["invalid","stretch","fabric","two_node_fabric","ip_fabric","ip_two_node_fabric","mixed_fabric"]
	ConfigurationType *string `json:"configuration_type,omitempty"`

	// Indicates if the encryption for NVLog and storage traffic is enabled.
	EncryptionEnabled *bool `json:"encryption_enabled,omitempty"`

	// local
	Local *MetroclusterInlineLocal `json:"local,omitempty"`

	// mediator
	Mediator *MetroclusterInlineMediator `json:"mediator,omitempty"`

	// DR Pairs to create as part of a MetroCluster configure.
	MetroclusterInlineDrPairs []*MetroclusterInlineDrPairsInlineArrayItem `json:"dr_pairs,omitempty"`

	// List of Port specifications.
	MetroclusterInlineMccipPorts []*MetroclusterInlineMccipPortsInlineArrayItem `json:"mccip_ports,omitempty"`

	// partner cluster
	PartnerCluster *MetroclusterInlinePartnerCluster `json:"partner_cluster,omitempty"`

	// remote
	Remote *MetroclusterInlineRemote `json:"remote,omitempty"`
}

// Validate validates this metrocluster
func (m *Metrocluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigurationType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMediator(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetroclusterInlineDrPairs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetroclusterInlineMccipPorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartnerCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Metrocluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var metroclusterTypeConfigurationTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["invalid","stretch","fabric","two_node_fabric","ip_fabric","ip_two_node_fabric","mixed_fabric"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterTypeConfigurationTypePropEnum = append(metroclusterTypeConfigurationTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster
	// Metrocluster
	// configuration_type
	// ConfigurationType
	// invalid
	// END DEBUGGING
	// MetroclusterConfigurationTypeInvalid captures enum value "invalid"
	MetroclusterConfigurationTypeInvalid string = "invalid"

	// BEGIN DEBUGGING
	// metrocluster
	// Metrocluster
	// configuration_type
	// ConfigurationType
	// stretch
	// END DEBUGGING
	// MetroclusterConfigurationTypeStretch captures enum value "stretch"
	MetroclusterConfigurationTypeStretch string = "stretch"

	// BEGIN DEBUGGING
	// metrocluster
	// Metrocluster
	// configuration_type
	// ConfigurationType
	// fabric
	// END DEBUGGING
	// MetroclusterConfigurationTypeFabric captures enum value "fabric"
	MetroclusterConfigurationTypeFabric string = "fabric"

	// BEGIN DEBUGGING
	// metrocluster
	// Metrocluster
	// configuration_type
	// ConfigurationType
	// two_node_fabric
	// END DEBUGGING
	// MetroclusterConfigurationTypeTwoNodeFabric captures enum value "two_node_fabric"
	MetroclusterConfigurationTypeTwoNodeFabric string = "two_node_fabric"

	// BEGIN DEBUGGING
	// metrocluster
	// Metrocluster
	// configuration_type
	// ConfigurationType
	// ip_fabric
	// END DEBUGGING
	// MetroclusterConfigurationTypeIPFabric captures enum value "ip_fabric"
	MetroclusterConfigurationTypeIPFabric string = "ip_fabric"

	// BEGIN DEBUGGING
	// metrocluster
	// Metrocluster
	// configuration_type
	// ConfigurationType
	// ip_two_node_fabric
	// END DEBUGGING
	// MetroclusterConfigurationTypeIPTwoNodeFabric captures enum value "ip_two_node_fabric"
	MetroclusterConfigurationTypeIPTwoNodeFabric string = "ip_two_node_fabric"

	// BEGIN DEBUGGING
	// metrocluster
	// Metrocluster
	// configuration_type
	// ConfigurationType
	// mixed_fabric
	// END DEBUGGING
	// MetroclusterConfigurationTypeMixedFabric captures enum value "mixed_fabric"
	MetroclusterConfigurationTypeMixedFabric string = "mixed_fabric"
)

// prop value enum
func (m *Metrocluster) validateConfigurationTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterTypeConfigurationTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Metrocluster) validateConfigurationType(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigurationType) { // not required
		return nil
	}

	// value enum
	if err := m.validateConfigurationTypeEnum("configuration_type", "body", *m.ConfigurationType); err != nil {
		return err
	}

	return nil
}

func (m *Metrocluster) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(m.Local) { // not required
		return nil
	}

	if m.Local != nil {
		if err := m.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local")
			}
			return err
		}
	}

	return nil
}

func (m *Metrocluster) validateMediator(formats strfmt.Registry) error {
	if swag.IsZero(m.Mediator) { // not required
		return nil
	}

	if m.Mediator != nil {
		if err := m.Mediator.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator")
			}
			return err
		}
	}

	return nil
}

func (m *Metrocluster) validateMetroclusterInlineDrPairs(formats strfmt.Registry) error {
	if swag.IsZero(m.MetroclusterInlineDrPairs) { // not required
		return nil
	}

	for i := 0; i < len(m.MetroclusterInlineDrPairs); i++ {
		if swag.IsZero(m.MetroclusterInlineDrPairs[i]) { // not required
			continue
		}

		if m.MetroclusterInlineDrPairs[i] != nil {
			if err := m.MetroclusterInlineDrPairs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dr_pairs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Metrocluster) validateMetroclusterInlineMccipPorts(formats strfmt.Registry) error {
	if swag.IsZero(m.MetroclusterInlineMccipPorts) { // not required
		return nil
	}

	for i := 0; i < len(m.MetroclusterInlineMccipPorts); i++ {
		if swag.IsZero(m.MetroclusterInlineMccipPorts[i]) { // not required
			continue
		}

		if m.MetroclusterInlineMccipPorts[i] != nil {
			if err := m.MetroclusterInlineMccipPorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mccip_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Metrocluster) validatePartnerCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.PartnerCluster) { // not required
		return nil
	}

	if m.PartnerCluster != nil {
		if err := m.PartnerCluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster")
			}
			return err
		}
	}

	return nil
}

func (m *Metrocluster) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(m.Remote) { // not required
		return nil
	}

	if m.Remote != nil {
		if err := m.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster based on the context it is used
func (m *Metrocluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfigurationType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMediator(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetroclusterInlineDrPairs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetroclusterInlineMccipPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartnerCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Metrocluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Metrocluster) contextValidateConfigurationType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "configuration_type", "body", m.ConfigurationType); err != nil {
		return err
	}

	return nil
}

func (m *Metrocluster) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if m.Local != nil {
		if err := m.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local")
			}
			return err
		}
	}

	return nil
}

func (m *Metrocluster) contextValidateMediator(ctx context.Context, formats strfmt.Registry) error {

	if m.Mediator != nil {
		if err := m.Mediator.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator")
			}
			return err
		}
	}

	return nil
}

func (m *Metrocluster) contextValidateMetroclusterInlineDrPairs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MetroclusterInlineDrPairs); i++ {

		if m.MetroclusterInlineDrPairs[i] != nil {
			if err := m.MetroclusterInlineDrPairs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dr_pairs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Metrocluster) contextValidateMetroclusterInlineMccipPorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MetroclusterInlineMccipPorts); i++ {

		if m.MetroclusterInlineMccipPorts[i] != nil {
			if err := m.MetroclusterInlineMccipPorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mccip_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Metrocluster) contextValidatePartnerCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.PartnerCluster != nil {
		if err := m.PartnerCluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster")
			}
			return err
		}
	}

	return nil
}

func (m *Metrocluster) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if m.Remote != nil {
		if err := m.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Metrocluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Metrocluster) UnmarshalBinary(b []byte) error {
	var res Metrocluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineDrPairsInlineArrayItem metrocluster inline dr pairs inline array item
//
// swagger:model metrocluster_inline_dr_pairs_inline_array_item
type MetroclusterInlineDrPairsInlineArrayItem struct {

	// node
	Node *MetroclusterInlineDrPairsInlineArrayItemInlineNode `json:"node,omitempty"`

	// partner
	Partner *MetroclusterInlineDrPairsInlineArrayItemInlinePartner `json:"partner,omitempty"`
}

// Validate validates this metrocluster inline dr pairs inline array item
func (m *MetroclusterInlineDrPairsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItem) validatePartner(formats strfmt.Registry) error {
	if swag.IsZero(m.Partner) { // not required
		return nil
	}

	if m.Partner != nil {
		if err := m.Partner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline dr pairs inline array item based on the context it is used
func (m *MetroclusterInlineDrPairsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItem) contextValidatePartner(ctx context.Context, formats strfmt.Registry) error {

	if m.Partner != nil {
		if err := m.Partner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineDrPairsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineDrPairsInlineArrayItemInlineNode Local node of the DR Group.
//
// swagger:model metrocluster_inline_dr_pairs_inline_array_item_inline_node
type MetroclusterInlineDrPairsInlineArrayItemInlineNode struct {

	// links
	Links *MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this metrocluster inline dr pairs inline array item inline node
func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline dr pairs inline array item inline node based on the context it is used
func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineDrPairsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks metrocluster inline dr pairs inline array item inline node inline links
//
// swagger:model metrocluster_inline_dr_pairs_inline_array_item_inline_node_inline__links
type MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster inline dr pairs inline array item inline node inline links
func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline dr pairs inline array item inline node inline links based on the context it is used
func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineDrPairsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineDrPairsInlineArrayItemInlinePartner Partner node of the DR Group.
//
// swagger:model metrocluster_inline_dr_pairs_inline_array_item_inline_partner
type MetroclusterInlineDrPairsInlineArrayItemInlinePartner struct {

	// links
	Links *MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this metrocluster inline dr pairs inline array item inline partner
func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline dr pairs inline array item inline partner based on the context it is used
func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartner) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineDrPairsInlineArrayItemInlinePartner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks metrocluster inline dr pairs inline array item inline partner inline links
//
// swagger:model metrocluster_inline_dr_pairs_inline_array_item_inline_partner_inline__links
type MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster inline dr pairs inline array item inline partner inline links
func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline dr pairs inline array item inline partner inline links based on the context it is used
func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineDrPairsInlineArrayItemInlinePartnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineLocal metrocluster inline local
//
// swagger:model metrocluster_inline_local
type MetroclusterInlineLocal struct {

	// This parameter specifies the configuration of automatic switchover.
	// The valid values for the parameter are ':'
	// cluster':' triggers an unplanned switchover if all nodes in a DR cluster are down.
	// dr_group':' triggers an unplanned switchover if both nodes of a DR group are down.
	// disabled':' automatic switchover is disabled.
	// If the cluster is not reachable due to errors, the parameter value will be set to
	// not_reachable. This value is read only.
	// If the cluster configuration is unknown, the parameter value will be set to
	// unknown and the value is read only.
	//
	// Enum: ["dr_group","cluster","disabled","not_reachable","unknown"]
	AutomaticUsoFailureDomain *string `json:"automatic_uso_failure_domain,omitempty"`

	// cluster
	Cluster *MetroclusterInlineLocalInlineCluster `json:"cluster,omitempty"`

	// Indicates the state of the local cluster configuration.
	// Read Only: true
	// Enum: ["configuration_error","configured","not_configured","not_reachable","partially_configured","unknown"]
	ConfigurationState *string `json:"configuration_state,omitempty"`

	// Specifies the mode of operation of the local cluster.
	// Read Only: true
	// Enum: ["normal","not_configured","not_reachable","partial_switchback","partial_switchover","switchover","unknown","waiting_for_switchback"]
	Mode *string `json:"mode,omitempty"`

	// Specifies whether the partner cluster is reachable from the local cluster.
	// Read Only: true
	PartnerClusterReachable *bool `json:"partner_cluster_reachable,omitempty"`

	// Indicates whether or not a periodic check is enabled on the local cluster.
	// Read Only: true
	PeriodicCheckEnabled *bool `json:"periodic_check_enabled,omitempty"`
}

// Validate validates this metrocluster inline local
func (m *MetroclusterInlineLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutomaticUsoFailureDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigurationState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var metroclusterInlineLocalTypeAutomaticUsoFailureDomainPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["dr_group","cluster","disabled","not_reachable","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInlineLocalTypeAutomaticUsoFailureDomainPropEnum = append(metroclusterInlineLocalTypeAutomaticUsoFailureDomainPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// dr_group
	// END DEBUGGING
	// MetroclusterInlineLocalAutomaticUsoFailureDomainDrGroup captures enum value "dr_group"
	MetroclusterInlineLocalAutomaticUsoFailureDomainDrGroup string = "dr_group"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// cluster
	// END DEBUGGING
	// MetroclusterInlineLocalAutomaticUsoFailureDomainCluster captures enum value "cluster"
	MetroclusterInlineLocalAutomaticUsoFailureDomainCluster string = "cluster"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// disabled
	// END DEBUGGING
	// MetroclusterInlineLocalAutomaticUsoFailureDomainDisabled captures enum value "disabled"
	MetroclusterInlineLocalAutomaticUsoFailureDomainDisabled string = "disabled"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// not_reachable
	// END DEBUGGING
	// MetroclusterInlineLocalAutomaticUsoFailureDomainNotReachable captures enum value "not_reachable"
	MetroclusterInlineLocalAutomaticUsoFailureDomainNotReachable string = "not_reachable"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// unknown
	// END DEBUGGING
	// MetroclusterInlineLocalAutomaticUsoFailureDomainUnknown captures enum value "unknown"
	MetroclusterInlineLocalAutomaticUsoFailureDomainUnknown string = "unknown"
)

// prop value enum
func (m *MetroclusterInlineLocal) validateAutomaticUsoFailureDomainEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInlineLocalTypeAutomaticUsoFailureDomainPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterInlineLocal) validateAutomaticUsoFailureDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.AutomaticUsoFailureDomain) { // not required
		return nil
	}

	// value enum
	if err := m.validateAutomaticUsoFailureDomainEnum("local"+"."+"automatic_uso_failure_domain", "body", *m.AutomaticUsoFailureDomain); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineLocal) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

var metroclusterInlineLocalTypeConfigurationStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["configuration_error","configured","not_configured","not_reachable","partially_configured","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInlineLocalTypeConfigurationStatePropEnum = append(metroclusterInlineLocalTypeConfigurationStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// configuration_state
	// ConfigurationState
	// configuration_error
	// END DEBUGGING
	// MetroclusterInlineLocalConfigurationStateConfigurationError captures enum value "configuration_error"
	MetroclusterInlineLocalConfigurationStateConfigurationError string = "configuration_error"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// configuration_state
	// ConfigurationState
	// configured
	// END DEBUGGING
	// MetroclusterInlineLocalConfigurationStateConfigured captures enum value "configured"
	MetroclusterInlineLocalConfigurationStateConfigured string = "configured"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// configuration_state
	// ConfigurationState
	// not_configured
	// END DEBUGGING
	// MetroclusterInlineLocalConfigurationStateNotConfigured captures enum value "not_configured"
	MetroclusterInlineLocalConfigurationStateNotConfigured string = "not_configured"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// configuration_state
	// ConfigurationState
	// not_reachable
	// END DEBUGGING
	// MetroclusterInlineLocalConfigurationStateNotReachable captures enum value "not_reachable"
	MetroclusterInlineLocalConfigurationStateNotReachable string = "not_reachable"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// configuration_state
	// ConfigurationState
	// partially_configured
	// END DEBUGGING
	// MetroclusterInlineLocalConfigurationStatePartiallyConfigured captures enum value "partially_configured"
	MetroclusterInlineLocalConfigurationStatePartiallyConfigured string = "partially_configured"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// configuration_state
	// ConfigurationState
	// unknown
	// END DEBUGGING
	// MetroclusterInlineLocalConfigurationStateUnknown captures enum value "unknown"
	MetroclusterInlineLocalConfigurationStateUnknown string = "unknown"
)

// prop value enum
func (m *MetroclusterInlineLocal) validateConfigurationStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInlineLocalTypeConfigurationStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterInlineLocal) validateConfigurationState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigurationState) { // not required
		return nil
	}

	// value enum
	if err := m.validateConfigurationStateEnum("local"+"."+"configuration_state", "body", *m.ConfigurationState); err != nil {
		return err
	}

	return nil
}

var metroclusterInlineLocalTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","not_configured","not_reachable","partial_switchback","partial_switchover","switchover","unknown","waiting_for_switchback"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInlineLocalTypeModePropEnum = append(metroclusterInlineLocalTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// mode
	// Mode
	// normal
	// END DEBUGGING
	// MetroclusterInlineLocalModeNormal captures enum value "normal"
	MetroclusterInlineLocalModeNormal string = "normal"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// mode
	// Mode
	// not_configured
	// END DEBUGGING
	// MetroclusterInlineLocalModeNotConfigured captures enum value "not_configured"
	MetroclusterInlineLocalModeNotConfigured string = "not_configured"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// mode
	// Mode
	// not_reachable
	// END DEBUGGING
	// MetroclusterInlineLocalModeNotReachable captures enum value "not_reachable"
	MetroclusterInlineLocalModeNotReachable string = "not_reachable"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// mode
	// Mode
	// partial_switchback
	// END DEBUGGING
	// MetroclusterInlineLocalModePartialSwitchback captures enum value "partial_switchback"
	MetroclusterInlineLocalModePartialSwitchback string = "partial_switchback"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// mode
	// Mode
	// partial_switchover
	// END DEBUGGING
	// MetroclusterInlineLocalModePartialSwitchover captures enum value "partial_switchover"
	MetroclusterInlineLocalModePartialSwitchover string = "partial_switchover"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// mode
	// Mode
	// switchover
	// END DEBUGGING
	// MetroclusterInlineLocalModeSwitchover captures enum value "switchover"
	MetroclusterInlineLocalModeSwitchover string = "switchover"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// mode
	// Mode
	// unknown
	// END DEBUGGING
	// MetroclusterInlineLocalModeUnknown captures enum value "unknown"
	MetroclusterInlineLocalModeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// metrocluster_inline_local
	// MetroclusterInlineLocal
	// mode
	// Mode
	// waiting_for_switchback
	// END DEBUGGING
	// MetroclusterInlineLocalModeWaitingForSwitchback captures enum value "waiting_for_switchback"
	MetroclusterInlineLocalModeWaitingForSwitchback string = "waiting_for_switchback"
)

// prop value enum
func (m *MetroclusterInlineLocal) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInlineLocalTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterInlineLocal) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("local"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster inline local based on the context it is used
func (m *MetroclusterInlineLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfigurationState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartnerClusterReachable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeriodicCheckEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineLocal) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineLocal) contextValidateConfigurationState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local"+"."+"configuration_state", "body", m.ConfigurationState); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineLocal) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local"+"."+"mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineLocal) contextValidatePartnerClusterReachable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local"+"."+"partner_cluster_reachable", "body", m.PartnerClusterReachable); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineLocal) contextValidatePeriodicCheckEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local"+"."+"periodic_check_enabled", "body", m.PeriodicCheckEnabled); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineLocal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineLocal) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineLocalInlineCluster metrocluster inline local inline cluster
//
// swagger:model metrocluster_inline_local_inline_cluster
type MetroclusterInlineLocalInlineCluster struct {

	// links
	Links *MetroclusterInlineLocalInlineClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this metrocluster inline local inline cluster
func (m *MetroclusterInlineLocalInlineCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineLocalInlineCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineLocalInlineCluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("local"+"."+"cluster"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster inline local inline cluster based on the context it is used
func (m *MetroclusterInlineLocalInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineLocalInlineCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineLocalInlineCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineLocalInlineCluster) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineLocalInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineLocalInlineClusterInlineLinks metrocluster inline local inline cluster inline links
//
// swagger:model metrocluster_inline_local_inline_cluster_inline__links
type MetroclusterInlineLocalInlineClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster inline local inline cluster inline links
func (m *MetroclusterInlineLocalInlineClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineLocalInlineClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline local inline cluster inline links based on the context it is used
func (m *MetroclusterInlineLocalInlineClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineLocalInlineClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineLocalInlineClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineLocalInlineClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineLocalInlineClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMccipPortsInlineArrayItem Port configuration specification.
// l3_config information is only needed when configuring a MetroCluster IP for use in a layer 3 network.
//
// swagger:model metrocluster_inline_mccip_ports_inline_array_item
type MetroclusterInlineMccipPortsInlineArrayItem struct {

	// l3 config
	L3Config *MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config `json:"l3_config,omitempty"`

	// Port name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *MetroclusterInlineMccipPortsInlineArrayItemInlineNode `json:"node,omitempty"`

	// Port UUID
	UUID *string `json:"uuid,omitempty"`

	// VLAN ID
	// Example: 200
	// Maximum: 4095
	// Minimum: 101
	VlanID *int64 `json:"vlan_id,omitempty"`
}

// Validate validates this metrocluster inline mccip ports inline array item
func (m *MetroclusterInlineMccipPortsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateL3Config(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVlanID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItem) validateL3Config(formats strfmt.Registry) error {
	if swag.IsZero(m.L3Config) { // not required
		return nil
	}

	if m.L3Config != nil {
		if err := m.L3Config.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItem) validateVlanID(formats strfmt.Registry) error {
	if swag.IsZero(m.VlanID) { // not required
		return nil
	}

	if err := validate.MinimumInt("vlan_id", "body", *m.VlanID, 101, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("vlan_id", "body", *m.VlanID, 4095, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster inline mccip ports inline array item based on the context it is used
func (m *MetroclusterInlineMccipPortsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateL3Config(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItem) contextValidateL3Config(ctx context.Context, formats strfmt.Registry) error {

	if m.L3Config != nil {
		if err := m.L3Config.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMccipPortsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config metrocluster inline mccip ports inline array item inline l3 config
//
// swagger:model metrocluster_inline_mccip_ports_inline_array_item_inline_l3_config
type MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config struct {

	// ipv4 interface
	IPV4Interface *MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface `json:"ipv4_interface,omitempty"`
}

// Validate validates this metrocluster inline mccip ports inline array item inline l3 config
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPV4Interface(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config) validateIPV4Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4Interface) { // not required
		return nil
	}

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline mccip ports inline array item inline l3 config based on the context it is used
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPV4Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config) contextValidateIPV4Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMccipPortsInlineArrayItemInlineL3Config
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface Object to setup an interface along with its default router.
//
// swagger:model metrocluster_inline_mccip_ports_inline_array_item_inline_l3_config_inline_ipv4_interface
type MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface struct {

	// IPv4 or IPv6 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// The IPv4 or IPv6 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`
}

// Validate validates this metrocluster inline mccip ports inline array item inline l3 config inline ipv4 interface
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config" + "." + "ipv4_interface" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline mccip ports inline array item inline l3 config inline ipv4 interface based on the context it is used
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config" + "." + "ipv4_interface" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMccipPortsInlineArrayItemInlineNode Node information
//
// swagger:model metrocluster_inline_mccip_ports_inline_array_item_inline_node
type MetroclusterInlineMccipPortsInlineArrayItemInlineNode struct {

	// links
	Links *MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this metrocluster inline mccip ports inline array item inline node
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline mccip ports inline array item inline node based on the context it is used
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMccipPortsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks metrocluster inline mccip ports inline array item inline node inline links
//
// swagger:model metrocluster_inline_mccip_ports_inline_array_item_inline_node_inline__links
type MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster inline mccip ports inline array item inline node inline links
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline mccip ports inline array item inline node inline links based on the context it is used
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMccipPortsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMediator Mediator information
//
// swagger:model metrocluster_inline_mediator
type MetroclusterInlineMediator struct {

	// BlueXP account token. This field is only applicable to the ONTAP cloud mediator.
	BluexpAccountToken *string `json:"bluexp_account_token,omitempty"`

	// BlueXP organization ID. This field is only applicable to the ONTAP cloud mediator.
	BluexpOrgID *string `json:"bluexp_org_id,omitempty"`

	// CA certificate for ONTAP Mediator. This is optional if the certificate is already installed.
	CaCertificate *string `json:"ca_certificate,omitempty"`

	// dr group
	DrGroup *MetroclusterInlineMediatorInlineDrGroup `json:"dr_group,omitempty"`

	// The IP address of the mediator.
	// Example: 10.10.10.7
	IPAddress *string `json:"ip_address,omitempty"`

	// Indicates the mediator connectivity status of the local cluster. Possible values are connected, unreachable, unusable and down-high-latency. This field is only applicable to the mediators in SnapMirror active sync configuration.
	// Example: connected
	// Read Only: true
	LocalMediatorConnectivity *string `json:"local_mediator_connectivity,omitempty"`

	// The password used to connect to the REST server on the mediator.
	// Example: mypassword
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// peer cluster
	PeerCluster *MetroclusterInlineMediatorInlinePeerCluster `json:"peer_cluster,omitempty"`

	// Indicates the mediator connectivity status of the peer cluster. Possible values are connected, unreachable, unknown and down-high-latency.
	// Example: connected
	// Read Only: true
	PeerMediatorConnectivity *string `json:"peer_mediator_connectivity,omitempty"`

	// The REST server's port number on the mediator.
	// Example: 31784
	Port *int64 `json:"port,omitempty"`

	// Indicates the connectivity status of the mediator.
	// Example: true
	// Read Only: true
	Reachable *bool `json:"reachable,omitempty"`

	// Client ID of the BlueXP service account. This field is only applicable to the ONTAP cloud mediator.
	ServiceAccountClientID *string `json:"service_account_client_id,omitempty"`

	// Client secret token of the BlueXP service account. This field is only applicable to the ONTAP cloud mediator.
	ServiceAccountClientSecret *string `json:"service_account_client_secret,omitempty"`

	// Indicates if strict validation of certificates is performed while making REST API calls to the mediator. This field is only applicable to the ONTAP Cloud Mediator.
	// Example: true
	StrictCertValidation *bool `json:"strict_cert_validation,omitempty"`

	// Mediator type. This field is only applicable to the mediators in SnapMirror active sync configuration.
	// Enum: ["cloud","on_prem"]
	Type *string `json:"type,omitempty"`

	// Indicates if the local cluster should use an http-proxy server while making REST API calls to the mediator. This field is only applicable to the ONTAP cloud mediator.
	// Example: true
	UseHTTPProxyLocal *bool `json:"use_http_proxy_local,omitempty"`

	// Indicates if the remote cluster should use an http-proxy server while making REST API calls to the mediator. This field is only applicable to the ONTAP cloud mediator.
	// Example: true
	UseHTTPProxyRemote *bool `json:"use_http_proxy_remote,omitempty"`

	// The username used to connect to the REST server on the mediator.
	// Example: myusername
	User *string `json:"user,omitempty"`

	// The unique identifier for the mediator service.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this metrocluster inline mediator
func (m *MetroclusterInlineMediator) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDrGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeerCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMediator) validateDrGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.DrGroup) { // not required
		return nil
	}

	if m.DrGroup != nil {
		if err := m.DrGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator" + "." + "dr_group")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineMediator) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("mediator"+"."+"password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineMediator) validatePeerCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerCluster) { // not required
		return nil
	}

	if m.PeerCluster != nil {
		if err := m.PeerCluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator" + "." + "peer_cluster")
			}
			return err
		}
	}

	return nil
}

var metroclusterInlineMediatorTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cloud","on_prem"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInlineMediatorTypeTypePropEnum = append(metroclusterInlineMediatorTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_inline_mediator
	// MetroclusterInlineMediator
	// type
	// Type
	// cloud
	// END DEBUGGING
	// MetroclusterInlineMediatorTypeCloud captures enum value "cloud"
	MetroclusterInlineMediatorTypeCloud string = "cloud"

	// BEGIN DEBUGGING
	// metrocluster_inline_mediator
	// MetroclusterInlineMediator
	// type
	// Type
	// on_prem
	// END DEBUGGING
	// MetroclusterInlineMediatorTypeOnPrem captures enum value "on_prem"
	MetroclusterInlineMediatorTypeOnPrem string = "on_prem"
)

// prop value enum
func (m *MetroclusterInlineMediator) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInlineMediatorTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterInlineMediator) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("mediator"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster inline mediator based on the context it is used
func (m *MetroclusterInlineMediator) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDrGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalMediatorConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeerCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeerMediatorConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReachable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMediator) contextValidateDrGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.DrGroup != nil {
		if err := m.DrGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator" + "." + "dr_group")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineMediator) contextValidateLocalMediatorConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mediator"+"."+"local_mediator_connectivity", "body", m.LocalMediatorConnectivity); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineMediator) contextValidatePeerCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.PeerCluster != nil {
		if err := m.PeerCluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator" + "." + "peer_cluster")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineMediator) contextValidatePeerMediatorConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mediator"+"."+"peer_mediator_connectivity", "body", m.PeerMediatorConnectivity); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineMediator) contextValidateReachable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mediator"+"."+"reachable", "body", m.Reachable); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineMediator) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mediator"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMediator) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMediator) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMediator
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMediatorInlineDrGroup DR group reference.
//
// swagger:model metrocluster_inline_mediator_inline_dr_group
type MetroclusterInlineMediatorInlineDrGroup struct {

	// DR Group ID
	// Read Only: true
	ID *int64 `json:"id,omitempty"`
}

// Validate validates this metrocluster inline mediator inline dr group
func (m *MetroclusterInlineMediatorInlineDrGroup) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster inline mediator inline dr group based on the context it is used
func (m *MetroclusterInlineMediatorInlineDrGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMediatorInlineDrGroup) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "mediator"+"."+"dr_group"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMediatorInlineDrGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMediatorInlineDrGroup) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMediatorInlineDrGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMediatorInlinePeerCluster The peer cluster that the mediator service is used for.
//
// swagger:model metrocluster_inline_mediator_inline_peer_cluster
type MetroclusterInlineMediatorInlinePeerCluster struct {

	// links
	Links *MetroclusterInlineMediatorInlinePeerClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster2
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: ebe27c49-1adf-4496-8335-ab862aebebf2
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this metrocluster inline mediator inline peer cluster
func (m *MetroclusterInlineMediatorInlinePeerCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMediatorInlinePeerCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator" + "." + "peer_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline mediator inline peer cluster based on the context it is used
func (m *MetroclusterInlineMediatorInlinePeerCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMediatorInlinePeerCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator" + "." + "peer_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMediatorInlinePeerCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMediatorInlinePeerCluster) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMediatorInlinePeerCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineMediatorInlinePeerClusterInlineLinks metrocluster inline mediator inline peer cluster inline links
//
// swagger:model metrocluster_inline_mediator_inline_peer_cluster_inline__links
type MetroclusterInlineMediatorInlinePeerClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster inline mediator inline peer cluster inline links
func (m *MetroclusterInlineMediatorInlinePeerClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMediatorInlinePeerClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator" + "." + "peer_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline mediator inline peer cluster inline links based on the context it is used
func (m *MetroclusterInlineMediatorInlinePeerClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineMediatorInlinePeerClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mediator" + "." + "peer_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineMediatorInlinePeerClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineMediatorInlinePeerClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineMediatorInlinePeerClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlinePartnerCluster Partner cluster information.
//
// swagger:model metrocluster_inline_partner_cluster
type MetroclusterInlinePartnerCluster struct {

	// links
	Links *MetroclusterInlinePartnerClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this metrocluster inline partner cluster
func (m *MetroclusterInlinePartnerCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlinePartnerCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlinePartnerCluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("partner_cluster"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster inline partner cluster based on the context it is used
func (m *MetroclusterInlinePartnerCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlinePartnerCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlinePartnerCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlinePartnerCluster) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlinePartnerCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlinePartnerClusterInlineLinks metrocluster inline partner cluster inline links
//
// swagger:model metrocluster_inline_partner_cluster_inline__links
type MetroclusterInlinePartnerClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster inline partner cluster inline links
func (m *MetroclusterInlinePartnerClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlinePartnerClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline partner cluster inline links based on the context it is used
func (m *MetroclusterInlinePartnerClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlinePartnerClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlinePartnerClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlinePartnerClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlinePartnerClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineRemote metrocluster inline remote
//
// swagger:model metrocluster_inline_remote
type MetroclusterInlineRemote struct {

	// This parameter specifies the configuration of automatic switchover.
	// The valid values for the parameter are ':'
	// cluster':' triggers an unplanned switchover if all nodes in a DR cluster are down.
	// dr_group':' triggers an unplanned switchover if both nodes of a DR group are down.
	// disabled':' automatic switchover is disabled.
	// If the cluster is not reachable due to errors, the parameter value will be set to
	// not_reachable. This value is read only.
	// If the cluster configuration is unknown, the parameter value will be set to
	// unknown and the value is read only.
	//
	// Enum: ["dr_group","cluster","disabled","not_reachable","unknown"]
	AutomaticUsoFailureDomain *string `json:"automatic_uso_failure_domain,omitempty"`

	// cluster
	Cluster *MetroclusterInlineRemoteInlineCluster `json:"cluster,omitempty"`

	// Indicates the state of the remote cluster configuration.
	// Read Only: true
	// Enum: ["configuration_error","configured","not_configured","not_reachable","partially_configured","unknown"]
	ConfigurationState *string `json:"configuration_state,omitempty"`

	// Specifies the mode of operation of the remote cluster.
	// Read Only: true
	// Enum: ["normal","not_configured","not_reachable","partial_switchback","partial_switchover","switchover","unknown","waiting_for_switchback"]
	Mode *string `json:"mode,omitempty"`

	// Indicates whether or not a periodic check is enabled on the remote cluster.
	// Read Only: true
	PeriodicCheckEnabled *bool `json:"periodic_check_enabled,omitempty"`
}

// Validate validates this metrocluster inline remote
func (m *MetroclusterInlineRemote) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAutomaticUsoFailureDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigurationState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var metroclusterInlineRemoteTypeAutomaticUsoFailureDomainPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["dr_group","cluster","disabled","not_reachable","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInlineRemoteTypeAutomaticUsoFailureDomainPropEnum = append(metroclusterInlineRemoteTypeAutomaticUsoFailureDomainPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// dr_group
	// END DEBUGGING
	// MetroclusterInlineRemoteAutomaticUsoFailureDomainDrGroup captures enum value "dr_group"
	MetroclusterInlineRemoteAutomaticUsoFailureDomainDrGroup string = "dr_group"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// cluster
	// END DEBUGGING
	// MetroclusterInlineRemoteAutomaticUsoFailureDomainCluster captures enum value "cluster"
	MetroclusterInlineRemoteAutomaticUsoFailureDomainCluster string = "cluster"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// disabled
	// END DEBUGGING
	// MetroclusterInlineRemoteAutomaticUsoFailureDomainDisabled captures enum value "disabled"
	MetroclusterInlineRemoteAutomaticUsoFailureDomainDisabled string = "disabled"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// not_reachable
	// END DEBUGGING
	// MetroclusterInlineRemoteAutomaticUsoFailureDomainNotReachable captures enum value "not_reachable"
	MetroclusterInlineRemoteAutomaticUsoFailureDomainNotReachable string = "not_reachable"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// automatic_uso_failure_domain
	// AutomaticUsoFailureDomain
	// unknown
	// END DEBUGGING
	// MetroclusterInlineRemoteAutomaticUsoFailureDomainUnknown captures enum value "unknown"
	MetroclusterInlineRemoteAutomaticUsoFailureDomainUnknown string = "unknown"
)

// prop value enum
func (m *MetroclusterInlineRemote) validateAutomaticUsoFailureDomainEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInlineRemoteTypeAutomaticUsoFailureDomainPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterInlineRemote) validateAutomaticUsoFailureDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.AutomaticUsoFailureDomain) { // not required
		return nil
	}

	// value enum
	if err := m.validateAutomaticUsoFailureDomainEnum("remote"+"."+"automatic_uso_failure_domain", "body", *m.AutomaticUsoFailureDomain); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineRemote) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

var metroclusterInlineRemoteTypeConfigurationStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["configuration_error","configured","not_configured","not_reachable","partially_configured","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInlineRemoteTypeConfigurationStatePropEnum = append(metroclusterInlineRemoteTypeConfigurationStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// configuration_state
	// ConfigurationState
	// configuration_error
	// END DEBUGGING
	// MetroclusterInlineRemoteConfigurationStateConfigurationError captures enum value "configuration_error"
	MetroclusterInlineRemoteConfigurationStateConfigurationError string = "configuration_error"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// configuration_state
	// ConfigurationState
	// configured
	// END DEBUGGING
	// MetroclusterInlineRemoteConfigurationStateConfigured captures enum value "configured"
	MetroclusterInlineRemoteConfigurationStateConfigured string = "configured"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// configuration_state
	// ConfigurationState
	// not_configured
	// END DEBUGGING
	// MetroclusterInlineRemoteConfigurationStateNotConfigured captures enum value "not_configured"
	MetroclusterInlineRemoteConfigurationStateNotConfigured string = "not_configured"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// configuration_state
	// ConfigurationState
	// not_reachable
	// END DEBUGGING
	// MetroclusterInlineRemoteConfigurationStateNotReachable captures enum value "not_reachable"
	MetroclusterInlineRemoteConfigurationStateNotReachable string = "not_reachable"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// configuration_state
	// ConfigurationState
	// partially_configured
	// END DEBUGGING
	// MetroclusterInlineRemoteConfigurationStatePartiallyConfigured captures enum value "partially_configured"
	MetroclusterInlineRemoteConfigurationStatePartiallyConfigured string = "partially_configured"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// configuration_state
	// ConfigurationState
	// unknown
	// END DEBUGGING
	// MetroclusterInlineRemoteConfigurationStateUnknown captures enum value "unknown"
	MetroclusterInlineRemoteConfigurationStateUnknown string = "unknown"
)

// prop value enum
func (m *MetroclusterInlineRemote) validateConfigurationStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInlineRemoteTypeConfigurationStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterInlineRemote) validateConfigurationState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigurationState) { // not required
		return nil
	}

	// value enum
	if err := m.validateConfigurationStateEnum("remote"+"."+"configuration_state", "body", *m.ConfigurationState); err != nil {
		return err
	}

	return nil
}

var metroclusterInlineRemoteTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","not_configured","not_reachable","partial_switchback","partial_switchover","switchover","unknown","waiting_for_switchback"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterInlineRemoteTypeModePropEnum = append(metroclusterInlineRemoteTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// mode
	// Mode
	// normal
	// END DEBUGGING
	// MetroclusterInlineRemoteModeNormal captures enum value "normal"
	MetroclusterInlineRemoteModeNormal string = "normal"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// mode
	// Mode
	// not_configured
	// END DEBUGGING
	// MetroclusterInlineRemoteModeNotConfigured captures enum value "not_configured"
	MetroclusterInlineRemoteModeNotConfigured string = "not_configured"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// mode
	// Mode
	// not_reachable
	// END DEBUGGING
	// MetroclusterInlineRemoteModeNotReachable captures enum value "not_reachable"
	MetroclusterInlineRemoteModeNotReachable string = "not_reachable"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// mode
	// Mode
	// partial_switchback
	// END DEBUGGING
	// MetroclusterInlineRemoteModePartialSwitchback captures enum value "partial_switchback"
	MetroclusterInlineRemoteModePartialSwitchback string = "partial_switchback"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// mode
	// Mode
	// partial_switchover
	// END DEBUGGING
	// MetroclusterInlineRemoteModePartialSwitchover captures enum value "partial_switchover"
	MetroclusterInlineRemoteModePartialSwitchover string = "partial_switchover"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// mode
	// Mode
	// switchover
	// END DEBUGGING
	// MetroclusterInlineRemoteModeSwitchover captures enum value "switchover"
	MetroclusterInlineRemoteModeSwitchover string = "switchover"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// mode
	// Mode
	// unknown
	// END DEBUGGING
	// MetroclusterInlineRemoteModeUnknown captures enum value "unknown"
	MetroclusterInlineRemoteModeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// metrocluster_inline_remote
	// MetroclusterInlineRemote
	// mode
	// Mode
	// waiting_for_switchback
	// END DEBUGGING
	// MetroclusterInlineRemoteModeWaitingForSwitchback captures enum value "waiting_for_switchback"
	MetroclusterInlineRemoteModeWaitingForSwitchback string = "waiting_for_switchback"
)

// prop value enum
func (m *MetroclusterInlineRemote) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterInlineRemoteTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterInlineRemote) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("remote"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster inline remote based on the context it is used
func (m *MetroclusterInlineRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfigurationState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeriodicCheckEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineRemote) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineRemote) contextValidateConfigurationState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote"+"."+"configuration_state", "body", m.ConfigurationState); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineRemote) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote"+"."+"mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterInlineRemote) contextValidatePeriodicCheckEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote"+"."+"periodic_check_enabled", "body", m.PeriodicCheckEnabled); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineRemote) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineRemote) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineRemoteInlineCluster metrocluster inline remote inline cluster
//
// swagger:model metrocluster_inline_remote_inline_cluster
type MetroclusterInlineRemoteInlineCluster struct {

	// links
	Links *MetroclusterInlineRemoteInlineClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this metrocluster inline remote inline cluster
func (m *MetroclusterInlineRemoteInlineCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineRemoteInlineCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInlineRemoteInlineCluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("remote"+"."+"cluster"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster inline remote inline cluster based on the context it is used
func (m *MetroclusterInlineRemoteInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineRemoteInlineCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineRemoteInlineCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineRemoteInlineCluster) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineRemoteInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterInlineRemoteInlineClusterInlineLinks metrocluster inline remote inline cluster inline links
//
// swagger:model metrocluster_inline_remote_inline_cluster_inline__links
type MetroclusterInlineRemoteInlineClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster inline remote inline cluster inline links
func (m *MetroclusterInlineRemoteInlineClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineRemoteInlineClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster inline remote inline cluster inline links based on the context it is used
func (m *MetroclusterInlineRemoteInlineClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInlineRemoteInlineClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInlineRemoteInlineClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInlineRemoteInlineClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterInlineRemoteInlineClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
