// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MetroclusterDiagCheck Generic object which can be used for various components which holds details of the checks of a component.
//
// swagger:model metrocluster_diag_check
type MetroclusterDiagCheck struct {

	// additional info
	AdditionalInfo *MetroclusterDiagCheckInlineAdditionalInfo `json:"additional_info,omitempty"`

	// Name of type of diagnostic operation run for the component.
	// Example: mirror_status
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Result of the diagnostic operation on this component.
	// Read Only: true
	// Enum: ["ok","warning","not_run","not_applicable"]
	Result *string `json:"result,omitempty"`
}

// Validate validates this metrocluster diag check
func (m *MetroclusterDiagCheck) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAdditionalInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResult(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagCheck) validateAdditionalInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.AdditionalInfo) { // not required
		return nil
	}

	if m.AdditionalInfo != nil {
		if err := m.AdditionalInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("additional_info")
			}
			return err
		}
	}

	return nil
}

var metroclusterDiagCheckTypeResultPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","not_run","not_applicable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterDiagCheckTypeResultPropEnum = append(metroclusterDiagCheckTypeResultPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_diag_check
	// MetroclusterDiagCheck
	// result
	// Result
	// ok
	// END DEBUGGING
	// MetroclusterDiagCheckResultOk captures enum value "ok"
	MetroclusterDiagCheckResultOk string = "ok"

	// BEGIN DEBUGGING
	// metrocluster_diag_check
	// MetroclusterDiagCheck
	// result
	// Result
	// warning
	// END DEBUGGING
	// MetroclusterDiagCheckResultWarning captures enum value "warning"
	MetroclusterDiagCheckResultWarning string = "warning"

	// BEGIN DEBUGGING
	// metrocluster_diag_check
	// MetroclusterDiagCheck
	// result
	// Result
	// not_run
	// END DEBUGGING
	// MetroclusterDiagCheckResultNotRun captures enum value "not_run"
	MetroclusterDiagCheckResultNotRun string = "not_run"

	// BEGIN DEBUGGING
	// metrocluster_diag_check
	// MetroclusterDiagCheck
	// result
	// Result
	// not_applicable
	// END DEBUGGING
	// MetroclusterDiagCheckResultNotApplicable captures enum value "not_applicable"
	MetroclusterDiagCheckResultNotApplicable string = "not_applicable"
)

// prop value enum
func (m *MetroclusterDiagCheck) validateResultEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterDiagCheckTypeResultPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterDiagCheck) validateResult(formats strfmt.Registry) error {
	if swag.IsZero(m.Result) { // not required
		return nil
	}

	// value enum
	if err := m.validateResultEnum("result", "body", *m.Result); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster diag check based on the context it is used
func (m *MetroclusterDiagCheck) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAdditionalInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResult(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagCheck) contextValidateAdditionalInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.AdditionalInfo != nil {
		if err := m.AdditionalInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("additional_info")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagCheck) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagCheck) contextValidateResult(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "result", "body", m.Result); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagCheck) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagCheck) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagCheck
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagCheckInlineAdditionalInfo Additional information or recovery steps to take on this component.
//
// swagger:model metrocluster_diag_check_inline_additional_info
type MetroclusterDiagCheckInlineAdditionalInfo struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this metrocluster diag check inline additional info
func (m *MetroclusterDiagCheckInlineAdditionalInfo) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster diag check inline additional info based on the context it is used
func (m *MetroclusterDiagCheckInlineAdditionalInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagCheckInlineAdditionalInfo) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "additional_info"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagCheckInlineAdditionalInfo) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "additional_info"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagCheckInlineAdditionalInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagCheckInlineAdditionalInfo) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagCheckInlineAdditionalInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
