// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MetroclusterDiagnostics metrocluster diagnostics
//
// swagger:model metrocluster_diagnostics
type MetroclusterDiagnostics struct {

	// aggregate
	Aggregate *MetroclusterDiagnosticsInlineAggregate `json:"aggregate,omitempty"`

	// cluster
	Cluster *MetroclusterDiagnosticsInlineCluster `json:"cluster,omitempty"`

	// config replication
	ConfigReplication *MetroclusterDiagnosticsInlineConfigReplication `json:"config-replication,omitempty"`

	// connection
	Connection *MetroclusterDiagnosticsInlineConnection `json:"connection,omitempty"`

	// interface
	Interface *MetroclusterDiagnosticsInlineInterface `json:"interface,omitempty"`

	// node
	Node *MetroclusterDiagnosticsInlineNode `json:"node,omitempty"`

	// volume
	Volume *MetroclusterDiagnosticsInlineVolume `json:"volume,omitempty"`
}

// Validate validates this metrocluster diagnostics
func (m *MetroclusterDiagnostics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigReplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnostics) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregate) { // not required
		return nil
	}

	if m.Aggregate != nil {
		if err := m.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) validateConfigReplication(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigReplication) { // not required
		return nil
	}

	if m.ConfigReplication != nil {
		if err := m.ConfigReplication.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config-replication")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) validateConnection(formats strfmt.Registry) error {
	if swag.IsZero(m.Connection) { // not required
		return nil
	}

	if m.Connection != nil {
		if err := m.Connection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connection")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.Interface) { // not required
		return nil
	}

	if m.Interface != nil {
		if err := m.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster diagnostics based on the context it is used
func (m *MetroclusterDiagnostics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfigReplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnostics) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.Aggregate != nil {
		if err := m.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) contextValidateConfigReplication(ctx context.Context, formats strfmt.Registry) error {

	if m.ConfigReplication != nil {
		if err := m.ConfigReplication.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config-replication")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) contextValidateConnection(ctx context.Context, formats strfmt.Registry) error {

	if m.Connection != nil {
		if err := m.Connection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connection")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.Interface != nil {
		if err := m.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnostics) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnostics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnostics) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnostics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineAggregate metrocluster diagnostics inline aggregate
//
// swagger:model metrocluster_diagnostics_inline_aggregate
type MetroclusterDiagnosticsInlineAggregate struct {

	// Display details of the MetroCluster check for aggregates.
	// Read Only: true
	Details []*MetroclusterDiagDetails `json:"details,omitempty"`

	// Status of diagnostic operation for this component.
	// Read Only: true
	// Enum: ["ok","warning","not_run","not_applicable"]
	State *string `json:"state,omitempty"`

	// summary
	Summary *MetroclusterDiagnosticsInlineAggregateInlineSummary `json:"summary,omitempty"`

	// Time of the most recent diagnostic operation for this component
	// Example: 2016-03-10 14:35:16-08:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this metrocluster diagnostics inline aggregate
func (m *MetroclusterDiagnosticsInlineAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregate) validateDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.Details) { // not required
		return nil
	}

	for i := 0; i < len(m.Details); i++ {
		if swag.IsZero(m.Details[i]) { // not required
			continue
		}

		if m.Details[i] != nil {
			if err := m.Details[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregate" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var metroclusterDiagnosticsInlineAggregateTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","not_run","not_applicable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterDiagnosticsInlineAggregateTypeStatePropEnum = append(metroclusterDiagnosticsInlineAggregateTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_aggregate
	// MetroclusterDiagnosticsInlineAggregate
	// state
	// State
	// ok
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineAggregateStateOk captures enum value "ok"
	MetroclusterDiagnosticsInlineAggregateStateOk string = "ok"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_aggregate
	// MetroclusterDiagnosticsInlineAggregate
	// state
	// State
	// warning
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineAggregateStateWarning captures enum value "warning"
	MetroclusterDiagnosticsInlineAggregateStateWarning string = "warning"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_aggregate
	// MetroclusterDiagnosticsInlineAggregate
	// state
	// State
	// not_run
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineAggregateStateNotRun captures enum value "not_run"
	MetroclusterDiagnosticsInlineAggregateStateNotRun string = "not_run"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_aggregate
	// MetroclusterDiagnosticsInlineAggregate
	// state
	// State
	// not_applicable
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineAggregateStateNotApplicable captures enum value "not_applicable"
	MetroclusterDiagnosticsInlineAggregateStateNotApplicable string = "not_applicable"
)

// prop value enum
func (m *MetroclusterDiagnosticsInlineAggregate) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterDiagnosticsInlineAggregateTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregate) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("aggregate"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregate) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregate) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("aggregate"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster diagnostics inline aggregate based on the context it is used
func (m *MetroclusterDiagnosticsInlineAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregate) contextValidateDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregate"+"."+"details", "body", []*MetroclusterDiagDetails(m.Details)); err != nil {
		return err
	}

	for i := 0; i < len(m.Details); i++ {

		if m.Details[i] != nil {
			if err := m.Details[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aggregate" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregate) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregate"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregate) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregate) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregate"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineAggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineAggregate) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineAggregateInlineSummary Additional information or recovery steps to take.
//
// swagger:model metrocluster_diagnostics_inline_aggregate_inline_summary
type MetroclusterDiagnosticsInlineAggregateInlineSummary struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this metrocluster diagnostics inline aggregate inline summary
func (m *MetroclusterDiagnosticsInlineAggregateInlineSummary) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster diagnostics inline aggregate inline summary based on the context it is used
func (m *MetroclusterDiagnosticsInlineAggregateInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregateInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregate"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineAggregateInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "aggregate"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineAggregateInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineAggregateInlineSummary) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineAggregateInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineCluster metrocluster diagnostics inline cluster
//
// swagger:model metrocluster_diagnostics_inline_cluster
type MetroclusterDiagnosticsInlineCluster struct {

	// Display details of the MetroCluster check for clusters.
	// Read Only: true
	Details []*MetroclusterDiagDetails `json:"details,omitempty"`

	// Status of diagnostic operation for this component.
	// Read Only: true
	// Enum: ["ok","warning","not_run","not_applicable"]
	State *string `json:"state,omitempty"`

	// summary
	Summary *MetroclusterDiagnosticsInlineClusterInlineSummary `json:"summary,omitempty"`

	// Time of the most recent diagnostic operation for this component
	// Example: 2016-03-10 14:35:16-08:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this metrocluster diagnostics inline cluster
func (m *MetroclusterDiagnosticsInlineCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineCluster) validateDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.Details) { // not required
		return nil
	}

	for i := 0; i < len(m.Details); i++ {
		if swag.IsZero(m.Details[i]) { // not required
			continue
		}

		if m.Details[i] != nil {
			if err := m.Details[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cluster" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var metroclusterDiagnosticsInlineClusterTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","not_run","not_applicable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterDiagnosticsInlineClusterTypeStatePropEnum = append(metroclusterDiagnosticsInlineClusterTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_cluster
	// MetroclusterDiagnosticsInlineCluster
	// state
	// State
	// ok
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineClusterStateOk captures enum value "ok"
	MetroclusterDiagnosticsInlineClusterStateOk string = "ok"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_cluster
	// MetroclusterDiagnosticsInlineCluster
	// state
	// State
	// warning
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineClusterStateWarning captures enum value "warning"
	MetroclusterDiagnosticsInlineClusterStateWarning string = "warning"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_cluster
	// MetroclusterDiagnosticsInlineCluster
	// state
	// State
	// not_run
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineClusterStateNotRun captures enum value "not_run"
	MetroclusterDiagnosticsInlineClusterStateNotRun string = "not_run"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_cluster
	// MetroclusterDiagnosticsInlineCluster
	// state
	// State
	// not_applicable
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineClusterStateNotApplicable captures enum value "not_applicable"
	MetroclusterDiagnosticsInlineClusterStateNotApplicable string = "not_applicable"
)

// prop value enum
func (m *MetroclusterDiagnosticsInlineCluster) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterDiagnosticsInlineClusterTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineCluster) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("cluster"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineCluster) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineCluster) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("cluster"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster diagnostics inline cluster based on the context it is used
func (m *MetroclusterDiagnosticsInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineCluster) contextValidateDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cluster"+"."+"details", "body", []*MetroclusterDiagDetails(m.Details)); err != nil {
		return err
	}

	for i := 0; i < len(m.Details); i++ {

		if m.Details[i] != nil {
			if err := m.Details[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cluster" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineCluster) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cluster"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineCluster) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineCluster) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cluster"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineCluster) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineClusterInlineSummary Additional information or recovery steps to take.
//
// swagger:model metrocluster_diagnostics_inline_cluster_inline_summary
type MetroclusterDiagnosticsInlineClusterInlineSummary struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this metrocluster diagnostics inline cluster inline summary
func (m *MetroclusterDiagnosticsInlineClusterInlineSummary) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster diagnostics inline cluster inline summary based on the context it is used
func (m *MetroclusterDiagnosticsInlineClusterInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineClusterInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cluster"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineClusterInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cluster"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineClusterInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineClusterInlineSummary) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineClusterInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineConfigReplication metrocluster diagnostics inline config replication
//
// swagger:model metrocluster_diagnostics_inline_config-replication
type MetroclusterDiagnosticsInlineConfigReplication struct {

	// Status of diagnostic operation for this component.
	// Read Only: true
	// Enum: ["ok","warning","not_run","not_applicable"]
	State *string `json:"state,omitempty"`

	// summary
	Summary *MetroclusterDiagnosticsInlineConfigReplicationInlineSummary `json:"summary,omitempty"`

	// Time of the most recent diagnostic operation for this component
	// Example: 2016-03-14 14:35:16-08:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this metrocluster diagnostics inline config replication
func (m *MetroclusterDiagnosticsInlineConfigReplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var metroclusterDiagnosticsInlineConfigReplicationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","not_run","not_applicable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterDiagnosticsInlineConfigReplicationTypeStatePropEnum = append(metroclusterDiagnosticsInlineConfigReplicationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_config-replication
	// MetroclusterDiagnosticsInlineConfigReplication
	// state
	// State
	// ok
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineConfigReplicationStateOk captures enum value "ok"
	MetroclusterDiagnosticsInlineConfigReplicationStateOk string = "ok"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_config-replication
	// MetroclusterDiagnosticsInlineConfigReplication
	// state
	// State
	// warning
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineConfigReplicationStateWarning captures enum value "warning"
	MetroclusterDiagnosticsInlineConfigReplicationStateWarning string = "warning"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_config-replication
	// MetroclusterDiagnosticsInlineConfigReplication
	// state
	// State
	// not_run
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineConfigReplicationStateNotRun captures enum value "not_run"
	MetroclusterDiagnosticsInlineConfigReplicationStateNotRun string = "not_run"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_config-replication
	// MetroclusterDiagnosticsInlineConfigReplication
	// state
	// State
	// not_applicable
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineConfigReplicationStateNotApplicable captures enum value "not_applicable"
	MetroclusterDiagnosticsInlineConfigReplicationStateNotApplicable string = "not_applicable"
)

// prop value enum
func (m *MetroclusterDiagnosticsInlineConfigReplication) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterDiagnosticsInlineConfigReplicationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineConfigReplication) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("config-replication"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConfigReplication) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config-replication" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConfigReplication) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("config-replication"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster diagnostics inline config replication based on the context it is used
func (m *MetroclusterDiagnosticsInlineConfigReplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineConfigReplication) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "config-replication"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConfigReplication) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config-replication" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConfigReplication) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "config-replication"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineConfigReplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineConfigReplication) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineConfigReplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineConfigReplicationInlineSummary Additional information or recovery steps to take.
//
// swagger:model metrocluster_diagnostics_inline_config-replication_inline_summary
type MetroclusterDiagnosticsInlineConfigReplicationInlineSummary struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this metrocluster diagnostics inline config replication inline summary
func (m *MetroclusterDiagnosticsInlineConfigReplicationInlineSummary) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster diagnostics inline config replication inline summary based on the context it is used
func (m *MetroclusterDiagnosticsInlineConfigReplicationInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineConfigReplicationInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "config-replication"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConfigReplicationInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "config-replication"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineConfigReplicationInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineConfigReplicationInlineSummary) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineConfigReplicationInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineConnection metrocluster diagnostics inline connection
//
// swagger:model metrocluster_diagnostics_inline_connection
type MetroclusterDiagnosticsInlineConnection struct {

	// Display details of the MetroCluster check for connections.
	// Read Only: true
	Details []*MetroclusterDiagConnectionDetails `json:"details,omitempty"`

	// Status of diagnostic operation for this component.
	// Read Only: true
	// Enum: ["ok","warning","not_run","not_applicable"]
	State *string `json:"state,omitempty"`

	// summary
	Summary *MetroclusterDiagnosticsInlineConnectionInlineSummary `json:"summary,omitempty"`

	// Time of the most recent diagnostic operation for this component
	// Example: 2016-03-10 14:35:16-08:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this metrocluster diagnostics inline connection
func (m *MetroclusterDiagnosticsInlineConnection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineConnection) validateDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.Details) { // not required
		return nil
	}

	for i := 0; i < len(m.Details); i++ {
		if swag.IsZero(m.Details[i]) { // not required
			continue
		}

		if m.Details[i] != nil {
			if err := m.Details[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connection" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var metroclusterDiagnosticsInlineConnectionTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","not_run","not_applicable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterDiagnosticsInlineConnectionTypeStatePropEnum = append(metroclusterDiagnosticsInlineConnectionTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_connection
	// MetroclusterDiagnosticsInlineConnection
	// state
	// State
	// ok
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineConnectionStateOk captures enum value "ok"
	MetroclusterDiagnosticsInlineConnectionStateOk string = "ok"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_connection
	// MetroclusterDiagnosticsInlineConnection
	// state
	// State
	// warning
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineConnectionStateWarning captures enum value "warning"
	MetroclusterDiagnosticsInlineConnectionStateWarning string = "warning"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_connection
	// MetroclusterDiagnosticsInlineConnection
	// state
	// State
	// not_run
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineConnectionStateNotRun captures enum value "not_run"
	MetroclusterDiagnosticsInlineConnectionStateNotRun string = "not_run"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_connection
	// MetroclusterDiagnosticsInlineConnection
	// state
	// State
	// not_applicable
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineConnectionStateNotApplicable captures enum value "not_applicable"
	MetroclusterDiagnosticsInlineConnectionStateNotApplicable string = "not_applicable"
)

// prop value enum
func (m *MetroclusterDiagnosticsInlineConnection) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterDiagnosticsInlineConnectionTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineConnection) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("connection"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConnection) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connection" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConnection) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("connection"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster diagnostics inline connection based on the context it is used
func (m *MetroclusterDiagnosticsInlineConnection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineConnection) contextValidateDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connection"+"."+"details", "body", []*MetroclusterDiagConnectionDetails(m.Details)); err != nil {
		return err
	}

	for i := 0; i < len(m.Details); i++ {

		if m.Details[i] != nil {
			if err := m.Details[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connection" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConnection) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connection"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConnection) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connection" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConnection) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connection"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineConnection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineConnection) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineConnection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineConnectionInlineSummary Additional information or recovery steps to take.
//
// swagger:model metrocluster_diagnostics_inline_connection_inline_summary
type MetroclusterDiagnosticsInlineConnectionInlineSummary struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this metrocluster diagnostics inline connection inline summary
func (m *MetroclusterDiagnosticsInlineConnectionInlineSummary) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster diagnostics inline connection inline summary based on the context it is used
func (m *MetroclusterDiagnosticsInlineConnectionInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineConnectionInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connection"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineConnectionInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connection"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineConnectionInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineConnectionInlineSummary) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineConnectionInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineInterface metrocluster diagnostics inline interface
//
// swagger:model metrocluster_diagnostics_inline_interface
type MetroclusterDiagnosticsInlineInterface struct {

	// Status of diagnostic operation for this component.
	// Read Only: true
	// Enum: ["ok","warning","not_run","not_applicable"]
	State *string `json:"state,omitempty"`

	// summary
	Summary *MetroclusterDiagnosticsInlineInterfaceInlineSummary `json:"summary,omitempty"`

	// Time of the most recent diagnostic operation for this component
	// Example: 2016-03-10 14:35:16-08:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this metrocluster diagnostics inline interface
func (m *MetroclusterDiagnosticsInlineInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var metroclusterDiagnosticsInlineInterfaceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","not_run","not_applicable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterDiagnosticsInlineInterfaceTypeStatePropEnum = append(metroclusterDiagnosticsInlineInterfaceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_interface
	// MetroclusterDiagnosticsInlineInterface
	// state
	// State
	// ok
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineInterfaceStateOk captures enum value "ok"
	MetroclusterDiagnosticsInlineInterfaceStateOk string = "ok"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_interface
	// MetroclusterDiagnosticsInlineInterface
	// state
	// State
	// warning
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineInterfaceStateWarning captures enum value "warning"
	MetroclusterDiagnosticsInlineInterfaceStateWarning string = "warning"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_interface
	// MetroclusterDiagnosticsInlineInterface
	// state
	// State
	// not_run
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineInterfaceStateNotRun captures enum value "not_run"
	MetroclusterDiagnosticsInlineInterfaceStateNotRun string = "not_run"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_interface
	// MetroclusterDiagnosticsInlineInterface
	// state
	// State
	// not_applicable
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineInterfaceStateNotApplicable captures enum value "not_applicable"
	MetroclusterDiagnosticsInlineInterfaceStateNotApplicable string = "not_applicable"
)

// prop value enum
func (m *MetroclusterDiagnosticsInlineInterface) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterDiagnosticsInlineInterfaceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineInterface) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("interface"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineInterface) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineInterface) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("interface"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster diagnostics inline interface based on the context it is used
func (m *MetroclusterDiagnosticsInlineInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineInterface) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineInterface) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineInterface) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineInterface) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineInterfaceInlineSummary Additional information or recovery steps to take.
//
// swagger:model metrocluster_diagnostics_inline_interface_inline_summary
type MetroclusterDiagnosticsInlineInterfaceInlineSummary struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this metrocluster diagnostics inline interface inline summary
func (m *MetroclusterDiagnosticsInlineInterfaceInlineSummary) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster diagnostics inline interface inline summary based on the context it is used
func (m *MetroclusterDiagnosticsInlineInterfaceInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineInterfaceInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineInterfaceInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineInterfaceInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineInterfaceInlineSummary) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineInterfaceInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineNode metrocluster diagnostics inline node
//
// swagger:model metrocluster_diagnostics_inline_node
type MetroclusterDiagnosticsInlineNode struct {

	// Displays details of the MetroCluster check for nodes.
	// Read Only: true
	Details []*MetroclusterDiagDetails `json:"details,omitempty"`

	// Status of diagnostic operation for this component.
	// Read Only: true
	// Enum: ["ok","warning","not_run","not_applicable"]
	State *string `json:"state,omitempty"`

	// summary
	Summary *MetroclusterDiagnosticsInlineNodeInlineSummary `json:"summary,omitempty"`

	// Time of the most recent diagnostic operation for this component
	// Example: 2016-03-10 14:35:16-08:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this metrocluster diagnostics inline node
func (m *MetroclusterDiagnosticsInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineNode) validateDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.Details) { // not required
		return nil
	}

	for i := 0; i < len(m.Details); i++ {
		if swag.IsZero(m.Details[i]) { // not required
			continue
		}

		if m.Details[i] != nil {
			if err := m.Details[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("node" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var metroclusterDiagnosticsInlineNodeTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","not_run","not_applicable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterDiagnosticsInlineNodeTypeStatePropEnum = append(metroclusterDiagnosticsInlineNodeTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_node
	// MetroclusterDiagnosticsInlineNode
	// state
	// State
	// ok
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineNodeStateOk captures enum value "ok"
	MetroclusterDiagnosticsInlineNodeStateOk string = "ok"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_node
	// MetroclusterDiagnosticsInlineNode
	// state
	// State
	// warning
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineNodeStateWarning captures enum value "warning"
	MetroclusterDiagnosticsInlineNodeStateWarning string = "warning"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_node
	// MetroclusterDiagnosticsInlineNode
	// state
	// State
	// not_run
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineNodeStateNotRun captures enum value "not_run"
	MetroclusterDiagnosticsInlineNodeStateNotRun string = "not_run"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_node
	// MetroclusterDiagnosticsInlineNode
	// state
	// State
	// not_applicable
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineNodeStateNotApplicable captures enum value "not_applicable"
	MetroclusterDiagnosticsInlineNodeStateNotApplicable string = "not_applicable"
)

// prop value enum
func (m *MetroclusterDiagnosticsInlineNode) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterDiagnosticsInlineNodeTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineNode) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("node"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineNode) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineNode) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("node"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster diagnostics inline node based on the context it is used
func (m *MetroclusterDiagnosticsInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineNode) contextValidateDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"details", "body", []*MetroclusterDiagDetails(m.Details)); err != nil {
		return err
	}

	for i := 0; i < len(m.Details); i++ {

		if m.Details[i] != nil {
			if err := m.Details[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("node" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineNode) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineNode) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineNode) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineNode) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineNodeInlineSummary Additional information or recovery steps to take.
//
// swagger:model metrocluster_diagnostics_inline_node_inline_summary
type MetroclusterDiagnosticsInlineNodeInlineSummary struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this metrocluster diagnostics inline node inline summary
func (m *MetroclusterDiagnosticsInlineNodeInlineSummary) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster diagnostics inline node inline summary based on the context it is used
func (m *MetroclusterDiagnosticsInlineNodeInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineNodeInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineNodeInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineNodeInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineNodeInlineSummary) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineNodeInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineVolume metrocluster diagnostics inline volume
//
// swagger:model metrocluster_diagnostics_inline_volume
type MetroclusterDiagnosticsInlineVolume struct {

	// Display details of the MetroCluster check for volumes.
	// Read Only: true
	Details []*MetroclusterDiagDetails `json:"details,omitempty"`

	// Status of diagnostic operation for this component.
	// Read Only: true
	// Enum: ["ok","warning","not_run","not_applicable"]
	State *string `json:"state,omitempty"`

	// summary
	Summary *MetroclusterDiagnosticsInlineVolumeInlineSummary `json:"summary,omitempty"`

	// Time of the most recent diagnostic operation for this component
	// Example: 2016-03-10 14:35:16-08:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this metrocluster diagnostics inline volume
func (m *MetroclusterDiagnosticsInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineVolume) validateDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.Details) { // not required
		return nil
	}

	for i := 0; i < len(m.Details); i++ {
		if swag.IsZero(m.Details[i]) { // not required
			continue
		}

		if m.Details[i] != nil {
			if err := m.Details[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volume" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var metroclusterDiagnosticsInlineVolumeTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","warning","not_run","not_applicable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		metroclusterDiagnosticsInlineVolumeTypeStatePropEnum = append(metroclusterDiagnosticsInlineVolumeTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_volume
	// MetroclusterDiagnosticsInlineVolume
	// state
	// State
	// ok
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineVolumeStateOk captures enum value "ok"
	MetroclusterDiagnosticsInlineVolumeStateOk string = "ok"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_volume
	// MetroclusterDiagnosticsInlineVolume
	// state
	// State
	// warning
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineVolumeStateWarning captures enum value "warning"
	MetroclusterDiagnosticsInlineVolumeStateWarning string = "warning"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_volume
	// MetroclusterDiagnosticsInlineVolume
	// state
	// State
	// not_run
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineVolumeStateNotRun captures enum value "not_run"
	MetroclusterDiagnosticsInlineVolumeStateNotRun string = "not_run"

	// BEGIN DEBUGGING
	// metrocluster_diagnostics_inline_volume
	// MetroclusterDiagnosticsInlineVolume
	// state
	// State
	// not_applicable
	// END DEBUGGING
	// MetroclusterDiagnosticsInlineVolumeStateNotApplicable captures enum value "not_applicable"
	MetroclusterDiagnosticsInlineVolumeStateNotApplicable string = "not_applicable"
)

// prop value enum
func (m *MetroclusterDiagnosticsInlineVolume) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, metroclusterDiagnosticsInlineVolumeTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineVolume) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("volume"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineVolume) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineVolume) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("volume"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster diagnostics inline volume based on the context it is used
func (m *MetroclusterDiagnosticsInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineVolume) contextValidateDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "volume"+"."+"details", "body", []*MetroclusterDiagDetails(m.Details)); err != nil {
		return err
	}

	for i := 0; i < len(m.Details); i++ {

		if m.Details[i] != nil {
			if err := m.Details[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volume" + "." + "details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineVolume) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "volume"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineVolume) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineVolume) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "volume"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineVolume) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDiagnosticsInlineVolumeInlineSummary Additional information or recovery steps to take.
//
// swagger:model metrocluster_diagnostics_inline_volume_inline_summary
type MetroclusterDiagnosticsInlineVolumeInlineSummary struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this metrocluster diagnostics inline volume inline summary
func (m *MetroclusterDiagnosticsInlineVolumeInlineSummary) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this metrocluster diagnostics inline volume inline summary based on the context it is used
func (m *MetroclusterDiagnosticsInlineVolumeInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDiagnosticsInlineVolumeInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "volume"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDiagnosticsInlineVolumeInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "volume"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineVolumeInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDiagnosticsInlineVolumeInlineSummary) UnmarshalBinary(b []byte) error {
	var res MetroclusterDiagnosticsInlineVolumeInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
