// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MetroclusterDrGroup DR group information.
//
// swagger:model metrocluster_dr_group
type MetroclusterDrGroup struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// DR Group ID
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// metrocluster dr group inline dr pairs
	MetroclusterDrGroupInlineDrPairs []*DrPair `json:"dr_pairs,omitempty"`

	// List of Port specifications.
	MetroclusterDrGroupInlineMccipPorts []*MetroclusterDrGroupInlineMccipPortsInlineArrayItem `json:"mccip_ports,omitempty"`

	// partner cluster
	PartnerCluster *MetroclusterDrGroupInlinePartnerCluster `json:"partner_cluster,omitempty"`
}

// Validate validates this metrocluster dr group
func (m *MetroclusterDrGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetroclusterDrGroupInlineDrPairs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetroclusterDrGroupInlineMccipPorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartnerCluster(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDrGroup) validateMetroclusterDrGroupInlineDrPairs(formats strfmt.Registry) error {
	if swag.IsZero(m.MetroclusterDrGroupInlineDrPairs) { // not required
		return nil
	}

	for i := 0; i < len(m.MetroclusterDrGroupInlineDrPairs); i++ {
		if swag.IsZero(m.MetroclusterDrGroupInlineDrPairs[i]) { // not required
			continue
		}

		if m.MetroclusterDrGroupInlineDrPairs[i] != nil {
			if err := m.MetroclusterDrGroupInlineDrPairs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dr_pairs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDrGroup) validateMetroclusterDrGroupInlineMccipPorts(formats strfmt.Registry) error {
	if swag.IsZero(m.MetroclusterDrGroupInlineMccipPorts) { // not required
		return nil
	}

	for i := 0; i < len(m.MetroclusterDrGroupInlineMccipPorts); i++ {
		if swag.IsZero(m.MetroclusterDrGroupInlineMccipPorts[i]) { // not required
			continue
		}

		if m.MetroclusterDrGroupInlineMccipPorts[i] != nil {
			if err := m.MetroclusterDrGroupInlineMccipPorts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mccip_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDrGroup) validatePartnerCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.PartnerCluster) { // not required
		return nil
	}

	if m.PartnerCluster != nil {
		if err := m.PartnerCluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster dr group based on the context it is used
func (m *MetroclusterDrGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetroclusterDrGroupInlineDrPairs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetroclusterDrGroupInlineMccipPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartnerCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDrGroup) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *MetroclusterDrGroup) contextValidateMetroclusterDrGroupInlineDrPairs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MetroclusterDrGroupInlineDrPairs); i++ {

		if m.MetroclusterDrGroupInlineDrPairs[i] != nil {
			if err := m.MetroclusterDrGroupInlineDrPairs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dr_pairs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDrGroup) contextValidateMetroclusterDrGroupInlineMccipPorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MetroclusterDrGroupInlineMccipPorts); i++ {

		if m.MetroclusterDrGroupInlineMccipPorts[i] != nil {
			if err := m.MetroclusterDrGroupInlineMccipPorts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mccip_ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MetroclusterDrGroup) contextValidatePartnerCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.PartnerCluster != nil {
		if err := m.PartnerCluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDrGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDrGroup) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDrGroupInlineMccipPortsInlineArrayItem Port configuration specification.
// l3_config information is only needed when configuring a MetroCluster IP for use in a layer 3 network.
//
// swagger:model metrocluster_dr_group_inline_mccip_ports_inline_array_item
type MetroclusterDrGroupInlineMccipPortsInlineArrayItem struct {

	// l3 config
	L3Config *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config `json:"l3_config,omitempty"`

	// Port name
	// Example: e1b
	Name *string `json:"name,omitempty"`

	// node
	Node *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode `json:"node,omitempty"`

	// Port UUID
	UUID *string `json:"uuid,omitempty"`

	// VLAN ID
	// Example: 200
	// Maximum: 4095
	// Minimum: 101
	VlanID *int64 `json:"vlan_id,omitempty"`
}

// Validate validates this metrocluster dr group inline mccip ports inline array item
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateL3Config(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVlanID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) validateL3Config(formats strfmt.Registry) error {
	if swag.IsZero(m.L3Config) { // not required
		return nil
	}

	if m.L3Config != nil {
		if err := m.L3Config.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) validateVlanID(formats strfmt.Registry) error {
	if swag.IsZero(m.VlanID) { // not required
		return nil
	}

	if err := validate.MinimumInt("vlan_id", "body", *m.VlanID, 101, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("vlan_id", "body", *m.VlanID, 4095, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster dr group inline mccip ports inline array item based on the context it is used
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateL3Config(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) contextValidateL3Config(ctx context.Context, formats strfmt.Registry) error {

	if m.L3Config != nil {
		if err := m.L3Config.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroupInlineMccipPortsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config metrocluster dr group inline mccip ports inline array item inline l3 config
//
// swagger:model metrocluster_dr_group_inline_mccip_ports_inline_array_item_inline_l3_config
type MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config struct {

	// ipv4 interface
	IPV4Interface *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface `json:"ipv4_interface,omitempty"`
}

// Validate validates this metrocluster dr group inline mccip ports inline array item inline l3 config
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPV4Interface(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config) validateIPV4Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4Interface) { // not required
		return nil
	}

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster dr group inline mccip ports inline array item inline l3 config based on the context it is used
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPV4Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config) contextValidateIPV4Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3Config
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface Object to setup an interface along with its default router.
//
// swagger:model metrocluster_dr_group_inline_mccip_ports_inline_array_item_inline_l3_config_inline_ipv4_interface
type MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface struct {

	// IPv4 or IPv6 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// The IPv4 or IPv6 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`
}

// Validate validates this metrocluster dr group inline mccip ports inline array item inline l3 config inline ipv4 interface
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config" + "." + "ipv4_interface" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster dr group inline mccip ports inline array item inline l3 config inline ipv4 interface based on the context it is used
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("l3_config" + "." + "ipv4_interface" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineL3ConfigInlineIPV4Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode Node information
//
// swagger:model metrocluster_dr_group_inline_mccip_ports_inline_array_item_inline_node
type MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode struct {

	// links
	Links *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this metrocluster dr group inline mccip ports inline array item inline node
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster dr group inline mccip ports inline array item inline node based on the context it is used
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks metrocluster dr group inline mccip ports inline array item inline node inline links
//
// swagger:model metrocluster_dr_group_inline_mccip_ports_inline_array_item_inline_node_inline__links
type MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster dr group inline mccip ports inline array item inline node inline links
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster dr group inline mccip ports inline array item inline node inline links based on the context it is used
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroupInlineMccipPortsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDrGroupInlinePartnerCluster Partner cluster information.
//
// swagger:model metrocluster_dr_group_inline_partner_cluster
type MetroclusterDrGroupInlinePartnerCluster struct {

	// links
	Links *MetroclusterDrGroupInlinePartnerClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this metrocluster dr group inline partner cluster
func (m *MetroclusterDrGroupInlinePartnerCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlinePartnerCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterDrGroupInlinePartnerCluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("partner_cluster"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this metrocluster dr group inline partner cluster based on the context it is used
func (m *MetroclusterDrGroupInlinePartnerCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlinePartnerCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDrGroupInlinePartnerCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDrGroupInlinePartnerCluster) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroupInlinePartnerCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MetroclusterDrGroupInlinePartnerClusterInlineLinks metrocluster dr group inline partner cluster inline links
//
// swagger:model metrocluster_dr_group_inline_partner_cluster_inline__links
type MetroclusterDrGroupInlinePartnerClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this metrocluster dr group inline partner cluster inline links
func (m *MetroclusterDrGroupInlinePartnerClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlinePartnerClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this metrocluster dr group inline partner cluster inline links based on the context it is used
func (m *MetroclusterDrGroupInlinePartnerClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterDrGroupInlinePartnerClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("partner_cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterDrGroupInlinePartnerClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterDrGroupInlinePartnerClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res MetroclusterDrGroupInlinePartnerClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
