// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// MetroclusterInterconnectResponse metrocluster interconnect response
//
// swagger:model metrocluster_interconnect_response
type MetroclusterInterconnectResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// metrocluster interconnect response inline records
	MetroclusterInterconnectResponseInlineRecords []*MetroclusterInterconnect `json:"records,omitempty"`

	// Number of Records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this metrocluster interconnect response
func (m *MetroclusterInterconnectResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetroclusterInterconnectResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInterconnectResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInterconnectResponse) validateMetroclusterInterconnectResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.MetroclusterInterconnectResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.MetroclusterInterconnectResponseInlineRecords); i++ {
		if swag.IsZero(m.MetroclusterInterconnectResponseInlineRecords[i]) { // not required
			continue
		}

		if m.MetroclusterInterconnectResponseInlineRecords[i] != nil {
			if err := m.MetroclusterInterconnectResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this metrocluster interconnect response based on the context it is used
func (m *MetroclusterInterconnectResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetroclusterInterconnectResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MetroclusterInterconnectResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *MetroclusterInterconnectResponse) contextValidateMetroclusterInterconnectResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MetroclusterInterconnectResponseInlineRecords); i++ {

		if m.MetroclusterInterconnectResponseInlineRecords[i] != nil {
			if err := m.MetroclusterInterconnectResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *MetroclusterInterconnectResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MetroclusterInterconnectResponse) UnmarshalBinary(b []byte) error {
	var res MetroclusterInterconnectResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
