// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MongoDbOnSan MongoDB using SAN.
//
// swagger:model mongo_db_on_san
type MongoDbOnSan struct {

	// dataset
	// Required: true
	Dataset *MongoDbOnSanInlineDataset `json:"dataset"`

	// The list of initiator groups to create.
	// Max Items: 20
	// Min Items: 0
	MongoDbOnSanInlineNewIgroups []*MongoDbOnSanNewIgroups `json:"new_igroups,omitempty"`

	// mongo db on san inline secondary igroups
	// Max Items: 19
	// Min Items: 0
	MongoDbOnSanInlineSecondaryIgroups []*MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem `json:"secondary_igroups,omitempty"`

	// The name of the host OS running the application.
	// Enum: ["hyper_v","linux","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The initiator group for the primary.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	PrimaryIgroupName *string `json:"primary_igroup_name"`

	// protection type
	ProtectionType *MongoDbOnSanInlineProtectionType `json:"protection_type,omitempty"`
}

// Validate validates this mongo db on san
func (m *MongoDbOnSan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDataset(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMongoDbOnSanInlineNewIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMongoDbOnSanInlineSecondaryIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrimaryIgroupName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MongoDbOnSan) validateDataset(formats strfmt.Registry) error {

	if err := validate.Required("dataset", "body", m.Dataset); err != nil {
		return err
	}

	if m.Dataset != nil {
		if err := m.Dataset.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dataset")
			}
			return err
		}
	}

	return nil
}

func (m *MongoDbOnSan) validateMongoDbOnSanInlineNewIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.MongoDbOnSanInlineNewIgroups) { // not required
		return nil
	}

	iMongoDbOnSanInlineNewIgroupsSize := int64(len(m.MongoDbOnSanInlineNewIgroups))

	if err := validate.MinItems("new_igroups", "body", iMongoDbOnSanInlineNewIgroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("new_igroups", "body", iMongoDbOnSanInlineNewIgroupsSize, 20); err != nil {
		return err
	}

	for i := 0; i < len(m.MongoDbOnSanInlineNewIgroups); i++ {
		if swag.IsZero(m.MongoDbOnSanInlineNewIgroups[i]) { // not required
			continue
		}

		if m.MongoDbOnSanInlineNewIgroups[i] != nil {
			if err := m.MongoDbOnSanInlineNewIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MongoDbOnSan) validateMongoDbOnSanInlineSecondaryIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.MongoDbOnSanInlineSecondaryIgroups) { // not required
		return nil
	}

	iMongoDbOnSanInlineSecondaryIgroupsSize := int64(len(m.MongoDbOnSanInlineSecondaryIgroups))

	if err := validate.MinItems("secondary_igroups", "body", iMongoDbOnSanInlineSecondaryIgroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("secondary_igroups", "body", iMongoDbOnSanInlineSecondaryIgroupsSize, 19); err != nil {
		return err
	}

	for i := 0; i < len(m.MongoDbOnSanInlineSecondaryIgroups); i++ {
		if swag.IsZero(m.MongoDbOnSanInlineSecondaryIgroups[i]) { // not required
			continue
		}

		if m.MongoDbOnSanInlineSecondaryIgroups[i] != nil {
			if err := m.MongoDbOnSanInlineSecondaryIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("secondary_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var mongoDbOnSanTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hyper_v","linux","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mongoDbOnSanTypeOsTypePropEnum = append(mongoDbOnSanTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// MongoDbOnSanOsTypeHyperv captures enum value "hyper_v"
	MongoDbOnSanOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// MongoDbOnSanOsTypeLinux captures enum value "linux"
	MongoDbOnSanOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// MongoDbOnSanOsTypeSolaris captures enum value "solaris"
	MongoDbOnSanOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// MongoDbOnSanOsTypeSolarisEfi captures enum value "solaris_efi"
	MongoDbOnSanOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// MongoDbOnSanOsTypeVmware captures enum value "vmware"
	MongoDbOnSanOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// MongoDbOnSanOsTypeWindows captures enum value "windows"
	MongoDbOnSanOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// MongoDbOnSanOsTypeWindows2008 captures enum value "windows_2008"
	MongoDbOnSanOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// MongoDbOnSanOsTypeWindowsGpt captures enum value "windows_gpt"
	MongoDbOnSanOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// mongo_db_on_san
	// MongoDbOnSan
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// MongoDbOnSanOsTypeXen captures enum value "xen"
	MongoDbOnSanOsTypeXen string = "xen"
)

// prop value enum
func (m *MongoDbOnSan) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mongoDbOnSanTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MongoDbOnSan) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *MongoDbOnSan) validatePrimaryIgroupName(formats strfmt.Registry) error {

	if err := validate.Required("primary_igroup_name", "body", m.PrimaryIgroupName); err != nil {
		return err
	}

	if err := validate.MinLength("primary_igroup_name", "body", *m.PrimaryIgroupName, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("primary_igroup_name", "body", *m.PrimaryIgroupName, 96); err != nil {
		return err
	}

	return nil
}

func (m *MongoDbOnSan) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this mongo db on san based on the context it is used
func (m *MongoDbOnSan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDataset(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMongoDbOnSanInlineNewIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMongoDbOnSanInlineSecondaryIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MongoDbOnSan) contextValidateDataset(ctx context.Context, formats strfmt.Registry) error {

	if m.Dataset != nil {
		if err := m.Dataset.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dataset")
			}
			return err
		}
	}

	return nil
}

func (m *MongoDbOnSan) contextValidateMongoDbOnSanInlineNewIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MongoDbOnSanInlineNewIgroups); i++ {

		if m.MongoDbOnSanInlineNewIgroups[i] != nil {
			if err := m.MongoDbOnSanInlineNewIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MongoDbOnSan) contextValidateMongoDbOnSanInlineSecondaryIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MongoDbOnSanInlineSecondaryIgroups); i++ {

		if m.MongoDbOnSanInlineSecondaryIgroups[i] != nil {
			if err := m.MongoDbOnSanInlineSecondaryIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("secondary_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MongoDbOnSan) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MongoDbOnSan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MongoDbOnSan) UnmarshalBinary(b []byte) error {
	var res MongoDbOnSan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MongoDbOnSanInlineDataset mongo db on san inline dataset
//
// swagger:model mongo_db_on_san_inline_dataset
type MongoDbOnSanInlineDataset struct {

	// The number of storage elements (LUNs for SAN) of the database to maintain.  Must be an even number between 2 and 16.  Odd numbers will be rounded up to the next even number within range.
	// Maximum: 16
	// Minimum: 2
	ElementCount *int64 `json:"element_count,omitempty"`

	// The number of data bearing members of the replicaset, including 1 primary and at least 1 secondary.
	// Maximum: 20
	// Minimum: 2
	ReplicationFactor *int64 `json:"replication_factor,omitempty"`

	// The size of the database. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *MongoDbOnSanInlineDatasetInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this mongo db on san inline dataset
func (m *MongoDbOnSanInlineDataset) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateElementCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReplicationFactor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MongoDbOnSanInlineDataset) validateElementCount(formats strfmt.Registry) error {
	if swag.IsZero(m.ElementCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("dataset"+"."+"element_count", "body", *m.ElementCount, 2, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("dataset"+"."+"element_count", "body", *m.ElementCount, 16, false); err != nil {
		return err
	}

	return nil
}

func (m *MongoDbOnSanInlineDataset) validateReplicationFactor(formats strfmt.Registry) error {
	if swag.IsZero(m.ReplicationFactor) { // not required
		return nil
	}

	if err := validate.MinimumInt("dataset"+"."+"replication_factor", "body", *m.ReplicationFactor, 2, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("dataset"+"."+"replication_factor", "body", *m.ReplicationFactor, 20, false); err != nil {
		return err
	}

	return nil
}

func (m *MongoDbOnSanInlineDataset) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("dataset"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *MongoDbOnSanInlineDataset) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dataset" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this mongo db on san inline dataset based on the context it is used
func (m *MongoDbOnSanInlineDataset) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MongoDbOnSanInlineDataset) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dataset" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MongoDbOnSanInlineDataset) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MongoDbOnSanInlineDataset) UnmarshalBinary(b []byte) error {
	var res MongoDbOnSanInlineDataset
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MongoDbOnSanInlineDatasetInlineStorageService mongo db on san inline dataset inline storage service
//
// swagger:model mongo_db_on_san_inline_dataset_inline_storage_service
type MongoDbOnSanInlineDatasetInlineStorageService struct {

	// The storage service of the database.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this mongo db on san inline dataset inline storage service
func (m *MongoDbOnSanInlineDatasetInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var mongoDbOnSanInlineDatasetInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mongoDbOnSanInlineDatasetInlineStorageServiceTypeNamePropEnum = append(mongoDbOnSanInlineDatasetInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// mongo_db_on_san_inline_dataset_inline_storage_service
	// MongoDbOnSanInlineDatasetInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// MongoDbOnSanInlineDatasetInlineStorageServiceNameExtreme captures enum value "extreme"
	MongoDbOnSanInlineDatasetInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// mongo_db_on_san_inline_dataset_inline_storage_service
	// MongoDbOnSanInlineDatasetInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// MongoDbOnSanInlineDatasetInlineStorageServiceNamePerformance captures enum value "performance"
	MongoDbOnSanInlineDatasetInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// mongo_db_on_san_inline_dataset_inline_storage_service
	// MongoDbOnSanInlineDatasetInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// MongoDbOnSanInlineDatasetInlineStorageServiceNameValue captures enum value "value"
	MongoDbOnSanInlineDatasetInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *MongoDbOnSanInlineDatasetInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mongoDbOnSanInlineDatasetInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MongoDbOnSanInlineDatasetInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("dataset"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this mongo db on san inline dataset inline storage service based on context it is used
func (m *MongoDbOnSanInlineDatasetInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *MongoDbOnSanInlineDatasetInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MongoDbOnSanInlineDatasetInlineStorageService) UnmarshalBinary(b []byte) error {
	var res MongoDbOnSanInlineDatasetInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MongoDbOnSanInlineProtectionType mongo db on san inline protection type
//
// swagger:model mongo_db_on_san_inline_protection_type
type MongoDbOnSanInlineProtectionType struct {

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this mongo db on san inline protection type
func (m *MongoDbOnSanInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var mongoDbOnSanInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mongoDbOnSanInlineProtectionTypeTypeLocalRpoPropEnum = append(mongoDbOnSanInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// mongo_db_on_san_inline_protection_type
	// MongoDbOnSanInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// MongoDbOnSanInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	MongoDbOnSanInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// mongo_db_on_san_inline_protection_type
	// MongoDbOnSanInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// MongoDbOnSanInlineProtectionTypeLocalRpoNone captures enum value "none"
	MongoDbOnSanInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *MongoDbOnSanInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mongoDbOnSanInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MongoDbOnSanInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var mongoDbOnSanInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mongoDbOnSanInlineProtectionTypeTypeRemoteRpoPropEnum = append(mongoDbOnSanInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// mongo_db_on_san_inline_protection_type
	// MongoDbOnSanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// MongoDbOnSanInlineProtectionTypeRemoteRpoNone captures enum value "none"
	MongoDbOnSanInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// mongo_db_on_san_inline_protection_type
	// MongoDbOnSanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// MongoDbOnSanInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	MongoDbOnSanInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *MongoDbOnSanInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mongoDbOnSanInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MongoDbOnSanInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this mongo db on san inline protection type based on context it is used
func (m *MongoDbOnSanInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *MongoDbOnSanInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MongoDbOnSanInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res MongoDbOnSanInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem mongo db on san inline secondary igroups inline array item
//
// swagger:model mongo_db_on_san_inline_secondary_igroups_inline_array_item
type MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem struct {

	// The name of the initiator group for each secondary.
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`
}

// Validate validates this mongo db on san inline secondary igroups inline array item
func (m *MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this mongo db on san inline secondary igroups inline array item based on context it is used
func (m *MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res MongoDbOnSanInlineSecondaryIgroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
