// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MultiAdminVerifyRequest multi admin verify request
//
// swagger:model multi_admin_verify_request
type MultiAdminVerifyRequest struct {

	// approve expiry time
	// Read Only: true
	// Format: date-time
	ApproveExpiryTime *strfmt.DateTime `json:"approve_expiry_time,omitempty"`

	// approve time
	// Read Only: true
	// Format: date-time
	ApproveTime *strfmt.DateTime `json:"approve_time,omitempty"`

	// Optional user-provided comment that is sent to the approval-group email indicating why the request was made.
	Comment *string `json:"comment,omitempty"`

	// create time
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Specifies that the operation is executed automatically on final approval.
	ExecuteOnApproval *bool `json:"execute_on_approval,omitempty"`

	// execution expiry time
	// Read Only: true
	// Format: date-time
	ExecutionExpiryTime *strfmt.DateTime `json:"execution_expiry_time,omitempty"`

	// Unique index that represents a request.
	// Read Only: true
	Index *int64 `json:"index,omitempty"`

	// The users that have approved the request.
	// Read Only: true
	MultiAdminVerifyRequestInlineApprovedUsers []*string `json:"approved_users,omitempty"`

	// List of users that can execute the operation once approved. If not set, any authorized user can perform the operation.
	MultiAdminVerifyRequestInlinePermittedUsers []*string `json:"permitted_users,omitempty"`

	// The users that are able to approve the request.
	// Read Only: true
	MultiAdminVerifyRequestInlinePotentialApprovers []*string `json:"potential_approvers,omitempty"`

	// The command to execute.
	Operation *string `json:"operation,omitempty"`

	// owner
	Owner *MultiAdminVerifyRequestInlineOwner `json:"owner,omitempty"`

	// The number of approvers remaining that are required to approve.
	// Read Only: true
	PendingApprovers *int64 `json:"pending_approvers,omitempty"`

	// Identifies the specific entry upon which the user wants to operate.
	Query *string `json:"query,omitempty"`

	// The number of required approvers, excluding the user that made the request.
	// Read Only: true
	RequiredApprovers *int64 `json:"required_approvers,omitempty"`

	// The state of the request. PATCH supports approved and vetoed. The state only changes after setting to approved once no more approvers are required.
	// Enum: ["approved","vetoed","pending","expired","executed"]
	State *string `json:"state,omitempty"`

	// The user that created the request. Automatically set by ONTAP.
	// Read Only: true
	UserRequested *string `json:"user_requested,omitempty"`

	// The user that vetoed the request.
	// Read Only: true
	UserVetoed *string `json:"user_vetoed,omitempty"`
}

// Validate validates this multi admin verify request
func (m *MultiAdminVerifyRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApproveExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApproveTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExecutionExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRequest) validateApproveExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ApproveExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("approve_expiry_time", "body", "date-time", m.ApproveExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) validateApproveTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ApproveTime) { // not required
		return nil
	}

	if err := validate.FormatOf("approve_time", "body", "date-time", m.ApproveTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) validateExecutionExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExecutionExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("execution_expiry_time", "body", "date-time", m.ExecutionExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

var multiAdminVerifyRequestTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["approved","vetoed","pending","expired","executed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		multiAdminVerifyRequestTypeStatePropEnum = append(multiAdminVerifyRequestTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// multi_admin_verify_request
	// MultiAdminVerifyRequest
	// state
	// State
	// approved
	// END DEBUGGING
	// MultiAdminVerifyRequestStateApproved captures enum value "approved"
	MultiAdminVerifyRequestStateApproved string = "approved"

	// BEGIN DEBUGGING
	// multi_admin_verify_request
	// MultiAdminVerifyRequest
	// state
	// State
	// vetoed
	// END DEBUGGING
	// MultiAdminVerifyRequestStateVetoed captures enum value "vetoed"
	MultiAdminVerifyRequestStateVetoed string = "vetoed"

	// BEGIN DEBUGGING
	// multi_admin_verify_request
	// MultiAdminVerifyRequest
	// state
	// State
	// pending
	// END DEBUGGING
	// MultiAdminVerifyRequestStatePending captures enum value "pending"
	MultiAdminVerifyRequestStatePending string = "pending"

	// BEGIN DEBUGGING
	// multi_admin_verify_request
	// MultiAdminVerifyRequest
	// state
	// State
	// expired
	// END DEBUGGING
	// MultiAdminVerifyRequestStateExpired captures enum value "expired"
	MultiAdminVerifyRequestStateExpired string = "expired"

	// BEGIN DEBUGGING
	// multi_admin_verify_request
	// MultiAdminVerifyRequest
	// state
	// State
	// executed
	// END DEBUGGING
	// MultiAdminVerifyRequestStateExecuted captures enum value "executed"
	MultiAdminVerifyRequestStateExecuted string = "executed"
)

// prop value enum
func (m *MultiAdminVerifyRequest) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, multiAdminVerifyRequestTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MultiAdminVerifyRequest) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this multi admin verify request based on the context it is used
func (m *MultiAdminVerifyRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApproveExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApproveTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExecutionExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIndex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMultiAdminVerifyRequestInlineApprovedUsers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMultiAdminVerifyRequestInlinePotentialApprovers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePendingApprovers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRequiredApprovers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserRequested(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserVetoed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateApproveExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "approve_expiry_time", "body", m.ApproveExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateApproveTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "approve_time", "body", m.ApproveTime); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateExecutionExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "execution_expiry_time", "body", m.ExecutionExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateIndex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "index", "body", m.Index); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateMultiAdminVerifyRequestInlineApprovedUsers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "approved_users", "body", []*string(m.MultiAdminVerifyRequestInlineApprovedUsers)); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateMultiAdminVerifyRequestInlinePotentialApprovers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "potential_approvers", "body", []*string(m.MultiAdminVerifyRequestInlinePotentialApprovers)); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidatePendingApprovers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "pending_approvers", "body", m.PendingApprovers); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateRequiredApprovers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "required_approvers", "body", m.RequiredApprovers); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateUserRequested(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "user_requested", "body", m.UserRequested); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRequest) contextValidateUserVetoed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "user_vetoed", "body", m.UserVetoed); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MultiAdminVerifyRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MultiAdminVerifyRequest) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MultiAdminVerifyRequestInlineOwner The owner of the request. This can identify the cluster or an SVM.
//
// swagger:model multi_admin_verify_request_inline_owner
type MultiAdminVerifyRequestInlineOwner struct {

	// links
	Links *MultiAdminVerifyRequestInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this multi admin verify request inline owner
func (m *MultiAdminVerifyRequestInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRequestInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify request inline owner based on the context it is used
func (m *MultiAdminVerifyRequestInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRequestInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MultiAdminVerifyRequestInlineOwner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MultiAdminVerifyRequestInlineOwner) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRequestInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MultiAdminVerifyRequestInlineOwnerInlineLinks multi admin verify request inline owner inline links
//
// swagger:model multi_admin_verify_request_inline_owner_inline__links
type MultiAdminVerifyRequestInlineOwnerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this multi admin verify request inline owner inline links
func (m *MultiAdminVerifyRequestInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRequestInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify request inline owner inline links based on the context it is used
func (m *MultiAdminVerifyRequestInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRequestInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MultiAdminVerifyRequestInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MultiAdminVerifyRequestInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRequestInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
