// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MultiAdminVerifyRule multi admin verify rule
//
// swagger:model multi_admin_verify_rule
type MultiAdminVerifyRule struct {

	// Time for requests to be approved, in ISO-8601 duration format. If not set, the global setting is used.
	ApprovalExpiry *string `json:"approval_expiry,omitempty"`

	// When true, ONTAP automatically creates a request for any failed operation where there is no matching pending request.
	AutoRequestCreate *bool `json:"auto_request_create,omitempty"`

	// create time
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Time for requests to be executed once approved, in ISO-8601 duration format. If not set, the global setting is used.
	ExecutionExpiry *string `json:"execution_expiry,omitempty"`

	// List of approval groups that are allowed to approve requests for rules that don't have approval groups.
	MultiAdminVerifyRuleInlineApprovalGroups []*MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem `json:"approval_groups,omitempty"`

	// Command that requires one or more approvals.
	Operation *string `json:"operation,omitempty"`

	// owner
	Owner *MultiAdminVerifyRuleInlineOwner `json:"owner,omitempty"`

	// When specified, this property limits the entries that require approvals to those that match the specified query.
	Query *string `json:"query,omitempty"`

	// The number of required approvers, excluding the user that made the request.
	RequiredApprovers *int64 `json:"required_approvers,omitempty"`

	// Specifies whether the rule is system-defined or user-defined.
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`
}

// Validate validates this multi admin verify rule
func (m *MultiAdminVerifyRule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMultiAdminVerifyRuleInlineApprovalGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRule) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRule) validateMultiAdminVerifyRuleInlineApprovalGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.MultiAdminVerifyRuleInlineApprovalGroups) { // not required
		return nil
	}

	for i := 0; i < len(m.MultiAdminVerifyRuleInlineApprovalGroups); i++ {
		if swag.IsZero(m.MultiAdminVerifyRuleInlineApprovalGroups[i]) { // not required
			continue
		}

		if m.MultiAdminVerifyRuleInlineApprovalGroups[i] != nil {
			if err := m.MultiAdminVerifyRuleInlineApprovalGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("approval_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MultiAdminVerifyRule) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify rule based on the context it is used
func (m *MultiAdminVerifyRule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMultiAdminVerifyRuleInlineApprovalGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRule) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *MultiAdminVerifyRule) contextValidateMultiAdminVerifyRuleInlineApprovalGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MultiAdminVerifyRuleInlineApprovalGroups); i++ {

		if m.MultiAdminVerifyRuleInlineApprovalGroups[i] != nil {
			if err := m.MultiAdminVerifyRuleInlineApprovalGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("approval_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MultiAdminVerifyRule) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *MultiAdminVerifyRule) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_defined", "body", m.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MultiAdminVerifyRule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MultiAdminVerifyRule) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem multi admin verify rule inline approval groups inline array item
//
// swagger:model multi_admin_verify_rule_inline_approval_groups_inline_array_item
type MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem struct {

	// Name of the approval group.
	Name *string `json:"name,omitempty"`
}

// Validate validates this multi admin verify rule inline approval groups inline array item
func (m *MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this multi admin verify rule inline approval groups inline array item based on context it is used
func (m *MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MultiAdminVerifyRuleInlineOwner The owner of the rule. The only valid owner is currently the cluster.
//
// swagger:model multi_admin_verify_rule_inline_owner
type MultiAdminVerifyRuleInlineOwner struct {

	// links
	Links *MultiAdminVerifyRuleInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a POST or PATCH method.
	//
	// Example: svm1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this multi admin verify rule inline owner
func (m *MultiAdminVerifyRuleInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRuleInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify rule inline owner based on the context it is used
func (m *MultiAdminVerifyRuleInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRuleInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *MultiAdminVerifyRuleInlineOwner) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owner"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MultiAdminVerifyRuleInlineOwner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MultiAdminVerifyRuleInlineOwner) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRuleInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// MultiAdminVerifyRuleInlineOwnerInlineLinks multi admin verify rule inline owner inline links
//
// swagger:model multi_admin_verify_rule_inline_owner_inline__links
type MultiAdminVerifyRuleInlineOwnerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this multi admin verify rule inline owner inline links
func (m *MultiAdminVerifyRuleInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRuleInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify rule inline owner inline links based on the context it is used
func (m *MultiAdminVerifyRuleInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MultiAdminVerifyRuleInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MultiAdminVerifyRuleInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MultiAdminVerifyRuleInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRuleInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
