// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Nas A generic NAS application.
//
// swagger:model nas
type Nas struct {

	// The name of the CIFS share. Usage: &lt;Share&gt;
	CifsShareName *string `json:"cifs_share_name,omitempty"`

	// nas inline application components
	// Required: true
	// Max Items: 10
	// Min Items: 1
	NasInlineApplicationComponents []*NasInlineApplicationComponentsInlineArrayItem `json:"application_components"`

	// The list of CIFS access controls. You must provide either 'user_or_group' or 'access' to enable CIFS access.
	NasInlineCifsAccess []*AppCifsAccess `json:"cifs_access,omitempty"`

	// nas inline exclude aggregates
	NasInlineExcludeAggregates []*NasInlineExcludeAggregatesInlineArrayItem `json:"exclude_aggregates,omitempty"`

	// The list of NFS access controls. You must provide either 'host' or 'access' to enable NFS access.
	NasInlineNfsAccess []*AppNfsAccess `json:"nfs_access,omitempty"`

	// protection type
	ProtectionType *NasInlineProtectionType `json:"protection_type,omitempty"`
}

// Validate validates this nas
func (m *Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNasInlineApplicationComponents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNasInlineCifsAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNasInlineExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNasInlineNfsAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Nas) validateNasInlineApplicationComponents(formats strfmt.Registry) error {

	if err := validate.Required("application_components", "body", m.NasInlineApplicationComponents); err != nil {
		return err
	}

	iNasInlineApplicationComponentsSize := int64(len(m.NasInlineApplicationComponents))

	if err := validate.MinItems("application_components", "body", iNasInlineApplicationComponentsSize, 1); err != nil {
		return err
	}

	if err := validate.MaxItems("application_components", "body", iNasInlineApplicationComponentsSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.NasInlineApplicationComponents); i++ {
		if swag.IsZero(m.NasInlineApplicationComponents[i]) { // not required
			continue
		}

		if m.NasInlineApplicationComponents[i] != nil {
			if err := m.NasInlineApplicationComponents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("application_components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Nas) validateNasInlineCifsAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.NasInlineCifsAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.NasInlineCifsAccess); i++ {
		if swag.IsZero(m.NasInlineCifsAccess[i]) { // not required
			continue
		}

		if m.NasInlineCifsAccess[i] != nil {
			if err := m.NasInlineCifsAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cifs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Nas) validateNasInlineExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.NasInlineExcludeAggregates) { // not required
		return nil
	}

	for i := 0; i < len(m.NasInlineExcludeAggregates); i++ {
		if swag.IsZero(m.NasInlineExcludeAggregates[i]) { // not required
			continue
		}

		if m.NasInlineExcludeAggregates[i] != nil {
			if err := m.NasInlineExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Nas) validateNasInlineNfsAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.NasInlineNfsAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.NasInlineNfsAccess); i++ {
		if swag.IsZero(m.NasInlineNfsAccess[i]) { // not required
			continue
		}

		if m.NasInlineNfsAccess[i] != nil {
			if err := m.NasInlineNfsAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Nas) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nas based on the context it is used
func (m *Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNasInlineApplicationComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNasInlineCifsAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNasInlineExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNasInlineNfsAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Nas) contextValidateNasInlineApplicationComponents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NasInlineApplicationComponents); i++ {

		if m.NasInlineApplicationComponents[i] != nil {
			if err := m.NasInlineApplicationComponents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("application_components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Nas) contextValidateNasInlineCifsAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NasInlineCifsAccess); i++ {

		if m.NasInlineCifsAccess[i] != nil {
			if err := m.NasInlineCifsAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cifs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Nas) contextValidateNasInlineExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NasInlineExcludeAggregates); i++ {

		if m.NasInlineExcludeAggregates[i] != nil {
			if err := m.NasInlineExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Nas) contextValidateNasInlineNfsAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NasInlineNfsAccess); i++ {

		if m.NasInlineNfsAccess[i] != nil {
			if err := m.NasInlineNfsAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Nas) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Nas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Nas) UnmarshalBinary(b []byte) error {
	var res Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItem nas inline application components inline array item
//
// swagger:model nas_inline_application_components_inline_array_item
type NasInlineApplicationComponentsInlineArrayItem struct {

	// export policy
	ExportPolicy *NasInlineApplicationComponentsInlineArrayItemInlineExportPolicy `json:"export_policy,omitempty"`

	// flexcache
	Flexcache *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache `json:"flexcache,omitempty"`

	// The name of the application component.
	// Required: true
	// Max Length: 512
	// Min Length: 1
	Name *string `json:"name"`

	// qos
	Qos *NasInlineApplicationComponentsInlineArrayItemInlineQos `json:"qos,omitempty"`

	// Denotes a Flexgroup.
	// Enum: [false,true]
	ScaleOut *bool `json:"scale_out,omitempty"`

	// The number of shares in the application component.
	// Required: true
	// Maximum: 10
	// Minimum: 1
	ShareCount *int64 `json:"share_count"`

	// snaplock
	Snaplock *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// Indicates whether Snapshot copy locking is enabled on the volume.
	// Enum: [false,true]
	SnapshotLockingEnabled *bool `json:"snapshot_locking_enabled,omitempty"`

	// storage service
	StorageService *NasInlineApplicationComponentsInlineArrayItemInlineStorageService `json:"storage_service,omitempty"`

	// tiering
	Tiering *NasApplicationComponentsTiering `json:"tiering,omitempty"`

	// The total size of the application component, split across the member shares. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	TotalSize *int64 `json:"total_size"`
}

// Validate validates this nas inline application components inline array item
func (m *NasInlineApplicationComponentsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScaleOut(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShareCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotLockingEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTotalSize(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateFlexcache(formats strfmt.Registry) error {
	if swag.IsZero(m.Flexcache) { // not required
		return nil
	}

	if m.Flexcache != nil {
		if err := m.Flexcache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 512); err != nil {
		return err
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

var nasInlineApplicationComponentsInlineArrayItemTypeScaleOutPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasInlineApplicationComponentsInlineArrayItemTypeScaleOutPropEnum = append(nasInlineApplicationComponentsInlineArrayItemTypeScaleOutPropEnum, v)
	}
}

// prop value enum
func (m *NasInlineApplicationComponentsInlineArrayItem) validateScaleOutEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, nasInlineApplicationComponentsInlineArrayItemTypeScaleOutPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateScaleOut(formats strfmt.Registry) error {
	if swag.IsZero(m.ScaleOut) { // not required
		return nil
	}

	// value enum
	if err := m.validateScaleOutEnum("scale_out", "body", *m.ScaleOut); err != nil {
		return err
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateShareCount(formats strfmt.Registry) error {

	if err := validate.Required("share_count", "body", m.ShareCount); err != nil {
		return err
	}

	if err := validate.MinimumInt("share_count", "body", *m.ShareCount, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("share_count", "body", *m.ShareCount, 10, false); err != nil {
		return err
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

var nasInlineApplicationComponentsInlineArrayItemTypeSnapshotLockingEnabledPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasInlineApplicationComponentsInlineArrayItemTypeSnapshotLockingEnabledPropEnum = append(nasInlineApplicationComponentsInlineArrayItemTypeSnapshotLockingEnabledPropEnum, v)
	}
}

// prop value enum
func (m *NasInlineApplicationComponentsInlineArrayItem) validateSnapshotLockingEnabledEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, nasInlineApplicationComponentsInlineArrayItemTypeSnapshotLockingEnabledPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateSnapshotLockingEnabled(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotLockingEnabled) { // not required
		return nil
	}

	// value enum
	if err := m.validateSnapshotLockingEnabledEnum("snapshot_locking_enabled", "body", *m.SnapshotLockingEnabled); err != nil {
		return err
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) validateTotalSize(formats strfmt.Registry) error {

	if err := validate.Required("total_size", "body", m.TotalSize); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nas inline application components inline array item based on the context it is used
func (m *NasInlineApplicationComponentsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) contextValidateFlexcache(ctx context.Context, formats strfmt.Registry) error {

	if m.Flexcache != nil {
		if err := m.Flexcache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItem) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineExportPolicy nas inline application components inline array item inline export policy
//
// swagger:model nas_inline_application_components_inline_array_item_inline_export_policy
type NasInlineApplicationComponentsInlineArrayItemInlineExportPolicy struct {

	// The ID of an existing NFS export policy.
	ID *int64 `json:"id,omitempty"`

	// The name of an existing NFS export policy.
	Name *string `json:"name,omitempty"`
}

// Validate validates this nas inline application components inline array item inline export policy
func (m *NasInlineApplicationComponentsInlineArrayItemInlineExportPolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nas inline application components inline array item inline export policy based on context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineFlexcache nas inline application components inline array item inline flexcache
//
// swagger:model nas_inline_application_components_inline_array_item_inline_flexcache
type NasInlineApplicationComponentsInlineArrayItemInlineFlexcache struct {

	// Dr-cache is a FlexCache volume create time option that has the same flexgroup-msid as that of the origin of a FlexCache volume. By default, dr-cache is disabled. The flexgroup-msid of the FlexCache volume does not need to be same as that of the origin of a FlexCache volume.
	// Enum: [false,true]
	DrCache *bool `json:"dr_cache,omitempty"`

	// origin
	Origin *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin `json:"origin,omitempty"`
}

// Validate validates this nas inline application components inline array item inline flexcache
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDrCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOrigin(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nasInlineApplicationComponentsInlineArrayItemInlineFlexcacheTypeDrCachePropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasInlineApplicationComponentsInlineArrayItemInlineFlexcacheTypeDrCachePropEnum = append(nasInlineApplicationComponentsInlineArrayItemInlineFlexcacheTypeDrCachePropEnum, v)
	}
}

// prop value enum
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache) validateDrCacheEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, nasInlineApplicationComponentsInlineArrayItemInlineFlexcacheTypeDrCachePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache) validateDrCache(formats strfmt.Registry) error {
	if swag.IsZero(m.DrCache) { // not required
		return nil
	}

	// value enum
	if err := m.validateDrCacheEnum("flexcache"+"."+"dr_cache", "body", *m.DrCache); err != nil {
		return err
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache) validateOrigin(formats strfmt.Registry) error {
	if swag.IsZero(m.Origin) { // not required
		return nil
	}

	if m.Origin != nil {
		if err := m.Origin.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "origin")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nas inline application components inline array item inline flexcache based on the context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateOrigin(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache) contextValidateOrigin(ctx context.Context, formats strfmt.Registry) error {

	if m.Origin != nil {
		if err := m.Origin.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "origin")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcache) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineFlexcache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin nas inline application components inline array item inline flexcache inline origin
//
// swagger:model nas_inline_application_components_inline_array_item_inline_flexcache_inline_origin
type NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin struct {

	// component
	// Required: true
	Component *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent `json:"component"`

	// svm
	// Required: true
	Svm *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm `json:"svm"`
}

// Validate validates this nas inline application components inline array item inline flexcache inline origin
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComponent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin) validateComponent(formats strfmt.Registry) error {

	if err := validate.Required("flexcache"+"."+"origin"+"."+"component", "body", m.Component); err != nil {
		return err
	}

	if m.Component != nil {
		if err := m.Component.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "origin" + "." + "component")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin) validateSvm(formats strfmt.Registry) error {

	if err := validate.Required("flexcache"+"."+"origin"+"."+"svm", "body", m.Svm); err != nil {
		return err
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "origin" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nas inline application components inline array item inline flexcache inline origin based on the context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComponent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin) contextValidateComponent(ctx context.Context, formats strfmt.Registry) error {

	if m.Component != nil {
		if err := m.Component.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "origin" + "." + "component")
			}
			return err
		}
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "origin" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOrigin
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent nas inline application components inline array item inline flexcache inline origin inline component
//
// swagger:model nas_inline_application_components_inline_array_item_inline_flexcache_inline_origin_inline_component
type NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent struct {

	// Name of the source component.
	// Required: true
	Name *string `json:"name"`
}

// Validate validates this nas inline application components inline array item inline flexcache inline origin inline component
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent) validateName(formats strfmt.Registry) error {

	if err := validate.Required("flexcache"+"."+"origin"+"."+"component"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nas inline application components inline array item inline flexcache inline origin inline component based on context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineComponent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm nas inline application components inline array item inline flexcache inline origin inline svm
//
// swagger:model nas_inline_application_components_inline_array_item_inline_flexcache_inline_origin_inline_svm
type NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm struct {

	// Name of the source SVM.
	// Required: true
	Name *string `json:"name"`
}

// Validate validates this nas inline application components inline array item inline flexcache inline origin inline svm
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm) validateName(formats strfmt.Registry) error {

	if err := validate.Required("flexcache"+"."+"origin"+"."+"svm"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nas inline application components inline array item inline flexcache inline origin inline svm based on context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineFlexcacheInlineOriginInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineQos nas inline application components inline array item inline qos
//
// swagger:model nas_inline_application_components_inline_array_item_inline_qos
type NasInlineApplicationComponentsInlineArrayItemInlineQos struct {

	// policy
	Policy *NasInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this nas inline application components inline array item inline qos
func (m *NasInlineApplicationComponentsInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nas inline application components inline array item inline qos based on the context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy nas inline application components inline array item inline qos inline policy
//
// swagger:model nas_inline_application_components_inline_array_item_inline_qos_inline_policy
type NasInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy struct {

	// The name of an existing QoS policy.
	Name *string `json:"name,omitempty"`

	// The UUID of an existing QoS policy. Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nas inline application components inline array item inline qos inline policy
func (m *NasInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nas inline application components inline array item inline qos inline policy based on context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineSnaplock nas inline application components inline array item inline snaplock
//
// swagger:model nas_inline_application_components_inline_array_item_inline_snaplock
type NasInlineApplicationComponentsInlineArrayItemInlineSnaplock struct {

	// Specifies if the volume append mode is enabled or disabled. When it is enabled, all the files created with write permissions on the volume are, by default, WORM appendable files. The user can append the data to a WORM appendable file but cannot modify the existing contents of the file nor delete the file until it expires.
	// Enum: [false,true]
	AppendModeEnabled *bool `json:"append_mode_enabled,omitempty"`

	// Specifies the autocommit period for SnapLock volume. All files which are not modified for a period greater than the autocommit period of the volume are committed to the WORM state. The autocommit period value represents a duration and must be specified in the ISO-8601 duration format. The autocommit period can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as &quot;P&lt;num&gt;Y&quot;, &quot;P&lt;num&gt;M&quot;, &quot;P&lt;num&gt;D&quot; respectively, for example &quot;P10Y&quot; represents a duration of 10 years. A duration in hours and minutes is represented by &quot;PT&lt;num&gt;H&quot; and &quot;PT&lt;num&gt;M&quot; respectively. The period string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example &quot;P1Y10M&quot; is not supported. Apart from the duration specified in the ISO-8601 format, the autocommit field also accepts the string &quot;none&quot;.
	AutocommitPeriod *string `json:"autocommit_period,omitempty"`

	// retention
	Retention *NasInlineApplicationComponentsInlineArrayItemInlineSnaplockInlineRetention `json:"retention,omitempty"`

	// The SnapLock type of the smart container.
	// Enum: ["compliance","enterprise","non_snaplock"]
	SnaplockType *string `json:"snaplock_type,omitempty"`
}

// Validate validates this nas inline application components inline array item inline snaplock
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAppendModeEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplockType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nasInlineApplicationComponentsInlineArrayItemInlineSnaplockTypeAppendModeEnabledPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasInlineApplicationComponentsInlineArrayItemInlineSnaplockTypeAppendModeEnabledPropEnum = append(nasInlineApplicationComponentsInlineArrayItemInlineSnaplockTypeAppendModeEnabledPropEnum, v)
	}
}

// prop value enum
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) validateAppendModeEnabledEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, nasInlineApplicationComponentsInlineArrayItemInlineSnaplockTypeAppendModeEnabledPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) validateAppendModeEnabled(formats strfmt.Registry) error {
	if swag.IsZero(m.AppendModeEnabled) { // not required
		return nil
	}

	// value enum
	if err := m.validateAppendModeEnabledEnum("snaplock"+"."+"append_mode_enabled", "body", *m.AppendModeEnabled); err != nil {
		return err
	}

	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var nasInlineApplicationComponentsInlineArrayItemInlineSnaplockTypeSnaplockTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasInlineApplicationComponentsInlineArrayItemInlineSnaplockTypeSnaplockTypePropEnum = append(nasInlineApplicationComponentsInlineArrayItemInlineSnaplockTypeSnaplockTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nas_inline_application_components_inline_array_item_inline_snaplock
	// NasInlineApplicationComponentsInlineArrayItemInlineSnaplock
	// snaplock_type
	// SnaplockType
	// compliance
	// END DEBUGGING
	// NasInlineApplicationComponentsInlineArrayItemInlineSnaplockSnaplockTypeCompliance captures enum value "compliance"
	NasInlineApplicationComponentsInlineArrayItemInlineSnaplockSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// nas_inline_application_components_inline_array_item_inline_snaplock
	// NasInlineApplicationComponentsInlineArrayItemInlineSnaplock
	// snaplock_type
	// SnaplockType
	// enterprise
	// END DEBUGGING
	// NasInlineApplicationComponentsInlineArrayItemInlineSnaplockSnaplockTypeEnterprise captures enum value "enterprise"
	NasInlineApplicationComponentsInlineArrayItemInlineSnaplockSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// nas_inline_application_components_inline_array_item_inline_snaplock
	// NasInlineApplicationComponentsInlineArrayItemInlineSnaplock
	// snaplock_type
	// SnaplockType
	// non_snaplock
	// END DEBUGGING
	// NasInlineApplicationComponentsInlineArrayItemInlineSnaplockSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	NasInlineApplicationComponentsInlineArrayItemInlineSnaplockSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) validateSnaplockTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nasInlineApplicationComponentsInlineArrayItemInlineSnaplockTypeSnaplockTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) validateSnaplockType(formats strfmt.Registry) error {
	if swag.IsZero(m.SnaplockType) { // not required
		return nil
	}

	// value enum
	if err := m.validateSnaplockTypeEnum("snaplock"+"."+"snaplock_type", "body", *m.SnaplockType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nas inline application components inline array item inline snaplock based on the context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineSnaplockInlineRetention nas inline application components inline array item inline snaplock inline retention
//
// swagger:model nas_inline_application_components_inline_array_item_inline_snaplock_inline_retention
type NasInlineApplicationComponentsInlineArrayItemInlineSnaplockInlineRetention struct {

	// Specifies the default retention period that is applied to files while committing them to the WORM state without an associated retention period. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as quot;Plt;num&gt;Y&quot;, &quot;P&lt;num&gt;M&quot;, &quot;P&lt;num&gt;D&quot; respectively, for example &quot;P10Y&quot; represents a duration of 10 years. A duration in hours and minutes is represented by &quot;PT&lt;num&gt;H&quot; and &quot;PT&lt;num&gt;M&quot; respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example &quot;P1Y10M&quot; is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string &quot;infinite&quot; to set an infinite retention period and the string &quot;unspecified&quot; to set an unspecified retention period.
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as &quot;P&lt;num&gt;Y&quot;, &quot;P&lt;num&gt;M&quot;, &quot;P&lt;num&gt;D&quot; respectively, for example &quot;P10Y&quot; represents a duration of 10 years. A duration in hours and minutes is represented by &quot;PT&lt;num&gt;H&quot; and &quot;PT&lt;num&gt;M&quot; respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example &quot;P1Y10M&quot; is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string &quot;infinite&quot; to set an infinite retention period.
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, month,s and days is represented in the ISO-8601 format as &quot;P&lt;num&gt;Y&quot;, &quot;P&lt;num&gt;M&quot;, &quot;P&lt;num&gt;D&quot; respectively, for example &quot;P10Y&quot; represents a duration of 10 years. A duration in hours and minutes is represented by &quot;PT&lt;num&gt;H&quot; and &quot;PT&lt;num&gt;M&quot; respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example &quot;P1Y10M&quot; is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string &quot;infinite&quot; to set an infinite retention period.
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this nas inline application components inline array item inline snaplock inline retention
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplockInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nas inline application components inline array item inline snaplock inline retention based on context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplockInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplockInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineSnaplockInlineRetention) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineSnaplockInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineApplicationComponentsInlineArrayItemInlineStorageService nas inline application components inline array item inline storage service
//
// swagger:model nas_inline_application_components_inline_array_item_inline_storage_service
type NasInlineApplicationComponentsInlineArrayItemInlineStorageService struct {

	// The storage service of the application component.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this nas inline application components inline array item inline storage service
func (m *NasInlineApplicationComponentsInlineArrayItemInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nasInlineApplicationComponentsInlineArrayItemInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasInlineApplicationComponentsInlineArrayItemInlineStorageServiceTypeNamePropEnum = append(nasInlineApplicationComponentsInlineArrayItemInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nas_inline_application_components_inline_array_item_inline_storage_service
	// NasInlineApplicationComponentsInlineArrayItemInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// NasInlineApplicationComponentsInlineArrayItemInlineStorageServiceNameExtreme captures enum value "extreme"
	NasInlineApplicationComponentsInlineArrayItemInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// nas_inline_application_components_inline_array_item_inline_storage_service
	// NasInlineApplicationComponentsInlineArrayItemInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// NasInlineApplicationComponentsInlineArrayItemInlineStorageServiceNamePerformance captures enum value "performance"
	NasInlineApplicationComponentsInlineArrayItemInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// nas_inline_application_components_inline_array_item_inline_storage_service
	// NasInlineApplicationComponentsInlineArrayItemInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// NasInlineApplicationComponentsInlineArrayItemInlineStorageServiceNameValue captures enum value "value"
	NasInlineApplicationComponentsInlineArrayItemInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *NasInlineApplicationComponentsInlineArrayItemInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nasInlineApplicationComponentsInlineArrayItemInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasInlineApplicationComponentsInlineArrayItemInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nas inline application components inline array item inline storage service based on context it is used
func (m *NasInlineApplicationComponentsInlineArrayItemInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineApplicationComponentsInlineArrayItemInlineStorageService) UnmarshalBinary(b []byte) error {
	var res NasInlineApplicationComponentsInlineArrayItemInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineExcludeAggregatesInlineArrayItem nas inline exclude aggregates inline array item
//
// swagger:model nas_inline_exclude_aggregates_inline_array_item
type NasInlineExcludeAggregatesInlineArrayItem struct {

	// The name of the aggregate to exclude. Usage: &lt;aggregate name&gt;
	Name *string `json:"name,omitempty"`

	// The ID of the aggregate to exclude. Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nas inline exclude aggregates inline array item
func (m *NasInlineExcludeAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nas inline exclude aggregates inline array item based on context it is used
func (m *NasInlineExcludeAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineExcludeAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineExcludeAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NasInlineExcludeAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasInlineProtectionType nas inline protection type
//
// swagger:model nas_inline_protection_type
type NasInlineProtectionType struct {

	// The Snapshot copy policy to apply to each volume in the smart container. This property is only supported for smart containers. Usage: &lt;snapshot policy&gt;
	LocalPolicy *string `json:"local_policy,omitempty"`

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this nas inline protection type
func (m *NasInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nasInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasInlineProtectionTypeTypeLocalRpoPropEnum = append(nasInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nas_inline_protection_type
	// NasInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// NasInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	NasInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// nas_inline_protection_type
	// NasInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// NasInlineProtectionTypeLocalRpoNone captures enum value "none"
	NasInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *NasInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nasInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var nasInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasInlineProtectionTypeTypeRemoteRpoPropEnum = append(nasInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nas_inline_protection_type
	// NasInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// NasInlineProtectionTypeRemoteRpoNone captures enum value "none"
	NasInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// nas_inline_protection_type
	// NasInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// NasInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	NasInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *NasInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nasInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nas inline protection type based on context it is used
func (m *NasInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res NasInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
