// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NasApplicationComponentsTiering application-components.tiering
//
// swagger:model nas_application_components_tiering
type NasApplicationComponentsTiering struct {

	// Storage tiering placement rules for the container(s)
	// Enum: ["required","best_effort","disallowed"]
	Control *string `json:"control,omitempty"`

	// nas application components tiering inline object stores
	NasApplicationComponentsTieringInlineObjectStores []*NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem `json:"object_stores,omitempty"`

	// The storage tiering type of the application component.
	// Enum: ["all","auto","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this nas application components tiering
func (m *NasApplicationComponentsTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNasApplicationComponentsTieringInlineObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nasApplicationComponentsTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["required","best_effort","disallowed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasApplicationComponentsTieringTypeControlPropEnum = append(nasApplicationComponentsTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nas_application_components_tiering
	// NasApplicationComponentsTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// NasApplicationComponentsTieringControlRequired captures enum value "required"
	NasApplicationComponentsTieringControlRequired string = "required"

	// BEGIN DEBUGGING
	// nas_application_components_tiering
	// NasApplicationComponentsTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// NasApplicationComponentsTieringControlBestEffort captures enum value "best_effort"
	NasApplicationComponentsTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// nas_application_components_tiering
	// NasApplicationComponentsTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// NasApplicationComponentsTieringControlDisallowed captures enum value "disallowed"
	NasApplicationComponentsTieringControlDisallowed string = "disallowed"
)

// prop value enum
func (m *NasApplicationComponentsTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nasApplicationComponentsTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasApplicationComponentsTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *NasApplicationComponentsTiering) validateNasApplicationComponentsTieringInlineObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.NasApplicationComponentsTieringInlineObjectStores) { // not required
		return nil
	}

	for i := 0; i < len(m.NasApplicationComponentsTieringInlineObjectStores); i++ {
		if swag.IsZero(m.NasApplicationComponentsTieringInlineObjectStores[i]) { // not required
			continue
		}

		if m.NasApplicationComponentsTieringInlineObjectStores[i] != nil {
			if err := m.NasApplicationComponentsTieringInlineObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nasApplicationComponentsTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nasApplicationComponentsTieringTypePolicyPropEnum = append(nasApplicationComponentsTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nas_application_components_tiering
	// NasApplicationComponentsTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// NasApplicationComponentsTieringPolicyAll captures enum value "all"
	NasApplicationComponentsTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// nas_application_components_tiering
	// NasApplicationComponentsTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// NasApplicationComponentsTieringPolicyAuto captures enum value "auto"
	NasApplicationComponentsTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// nas_application_components_tiering
	// NasApplicationComponentsTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// NasApplicationComponentsTieringPolicyNone captures enum value "none"
	NasApplicationComponentsTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// nas_application_components_tiering
	// NasApplicationComponentsTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// NasApplicationComponentsTieringPolicySnapshotOnly captures enum value "snapshot_only"
	NasApplicationComponentsTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *NasApplicationComponentsTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nasApplicationComponentsTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NasApplicationComponentsTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nas application components tiering based on the context it is used
func (m *NasApplicationComponentsTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNasApplicationComponentsTieringInlineObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasApplicationComponentsTiering) contextValidateNasApplicationComponentsTieringInlineObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NasApplicationComponentsTieringInlineObjectStores); i++ {

		if m.NasApplicationComponentsTieringInlineObjectStores[i] != nil {
			if err := m.NasApplicationComponentsTieringInlineObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NasApplicationComponentsTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasApplicationComponentsTiering) UnmarshalBinary(b []byte) error {
	var res NasApplicationComponentsTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem nas application components tiering inline object stores inline array item
//
// swagger:model nas_application_components_tiering_inline_object_stores_inline_array_item
type NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem struct {

	// The name of the object-store to use.
	// Max Length: 512
	// Min Length: 1
	Name *string `json:"name,omitempty"`
}

// Validate validates this nas application components tiering inline object stores inline array item
func (m *NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 512); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nas application components tiering inline object stores inline array item based on context it is used
func (m *NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NasApplicationComponentsTieringInlineObjectStoresInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
