// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NdmpData ndmp data
//
// swagger:model ndmp_data
type NdmpData struct {

	// Indicates the NDMP data bytes processed.
	// Example: 5000
	BytesProcessed *int64 `json:"bytes_processed,omitempty"`

	// Indicates the NDMP connection attributes.
	Connection *NdmpConnect `json:"connection,omitempty"`

	// Indicates the NDMP data server operation.
	// Example: backup
	// Enum: ["backup","restore","none"]
	Operation *string `json:"operation,omitempty"`

	// Indicates the reason for the NDMP data server halt.
	// Example: aborted
	Reason *NdmpReason `json:"reason,omitempty"`

	// Indicates the state of the NDMP data server.
	// Example: halted
	State *NdmpState `json:"state,omitempty"`
}

// Validate validates this ndmp data
func (m *NdmpData) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConnection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReason(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NdmpData) validateConnection(formats strfmt.Registry) error {
	if swag.IsZero(m.Connection) { // not required
		return nil
	}

	if m.Connection != nil {
		if err := m.Connection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connection")
			}
			return err
		}
	}

	return nil
}

var ndmpDataTypeOperationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["backup","restore","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ndmpDataTypeOperationPropEnum = append(ndmpDataTypeOperationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ndmp_data
	// NdmpData
	// operation
	// Operation
	// backup
	// END DEBUGGING
	// NdmpDataOperationBackup captures enum value "backup"
	NdmpDataOperationBackup string = "backup"

	// BEGIN DEBUGGING
	// ndmp_data
	// NdmpData
	// operation
	// Operation
	// restore
	// END DEBUGGING
	// NdmpDataOperationRestore captures enum value "restore"
	NdmpDataOperationRestore string = "restore"

	// BEGIN DEBUGGING
	// ndmp_data
	// NdmpData
	// operation
	// Operation
	// none
	// END DEBUGGING
	// NdmpDataOperationNone captures enum value "none"
	NdmpDataOperationNone string = "none"
)

// prop value enum
func (m *NdmpData) validateOperationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ndmpDataTypeOperationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NdmpData) validateOperation(formats strfmt.Registry) error {
	if swag.IsZero(m.Operation) { // not required
		return nil
	}

	// value enum
	if err := m.validateOperationEnum("operation", "body", *m.Operation); err != nil {
		return err
	}

	return nil
}

func (m *NdmpData) validateReason(formats strfmt.Registry) error {
	if swag.IsZero(m.Reason) { // not required
		return nil
	}

	if m.Reason != nil {
		if err := m.Reason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

func (m *NdmpData) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ndmp data based on the context it is used
func (m *NdmpData) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConnection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NdmpData) contextValidateConnection(ctx context.Context, formats strfmt.Registry) error {

	if m.Connection != nil {
		if err := m.Connection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connection")
			}
			return err
		}
	}

	return nil
}

func (m *NdmpData) contextValidateReason(ctx context.Context, formats strfmt.Registry) error {

	if m.Reason != nil {
		if err := m.Reason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("reason")
			}
			return err
		}
	}

	return nil
}

func (m *NdmpData) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NdmpData) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NdmpData) UnmarshalBinary(b []byte) error {
	var res NdmpData
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
