// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Netbios netbios
//
// swagger:model netbios
type Netbios struct {

	// Specifies the mode in which the NetBIOS name service is configured. The supported values are:
	//   * p - Point to Point
	//   * h - Hybrid
	//   * m - Mixed
	//   * b - Broadcast
	//
	// Enum: ["p","h","m","b"]
	Mode *string `json:"mode,omitempty"`

	// Specifies the NetBIOS name.
	// Example: CLUSTER_1
	Name *string `json:"name,omitempty"`

	// Specifies the name registration type.
	// Enum: ["registered","active","permanent","group",""]
	NameRegistrationType *string `json:"name_registration_type,omitempty"`

	// netbios inline interfaces
	NetbiosInlineInterfaces []*string `json:"interfaces,omitempty"`

	// List of WINS
	NetbiosInlineWinsServers []*Server `json:"wins_servers,omitempty"`

	// node
	Node *NetbiosInlineNode `json:"node,omitempty"`

	// Specifies the NetBIOS name scope. Scope is used as a name for the set of NetBIOS nodes that participate in a NetBIOS over TCP (NBT) virtual LAN.
	Scope *string `json:"scope,omitempty"`

	// Specifies the registration state of the NetBIOS Name.
	// Enum: ["must_register","must_unregister","wins","broadcast","name_released","wins_conflict","broadcast_conflict"]
	State *string `json:"state,omitempty"`

	// Specifies the NetBIOS suffix. A NetBIOS suffix is the 16th character of the 16-character NetBIOS name. The NetBIOS suffix is used by Microsoft Networking software to identify functionality installed on the registered device.
	Suffix *string `json:"suffix,omitempty"`

	// svm
	Svm *NetbiosInlineSvm `json:"svm,omitempty"`

	// Specifies the registration time left with WINS, in minutes.
	// Read Only: true
	TimeLeft *int64 `json:"time_left,omitempty"`
}

// Validate validates this netbios
func (m *Netbios) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNameRegistrationType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetbiosInlineWinsServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var netbiosTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["p","h","m","b"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		netbiosTypeModePropEnum = append(netbiosTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// mode
	// Mode
	// p
	// END DEBUGGING
	// NetbiosModeP captures enum value "p"
	NetbiosModeP string = "p"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// mode
	// Mode
	// h
	// END DEBUGGING
	// NetbiosModeH captures enum value "h"
	NetbiosModeH string = "h"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// mode
	// Mode
	// m
	// END DEBUGGING
	// NetbiosModeM captures enum value "m"
	NetbiosModeM string = "m"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// mode
	// Mode
	// b
	// END DEBUGGING
	// NetbiosModeB captures enum value "b"
	NetbiosModeB string = "b"
)

// prop value enum
func (m *Netbios) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, netbiosTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Netbios) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

var netbiosTypeNameRegistrationTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["registered","active","permanent","group",""]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		netbiosTypeNameRegistrationTypePropEnum = append(netbiosTypeNameRegistrationTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// name_registration_type
	// NameRegistrationType
	// registered
	// END DEBUGGING
	// NetbiosNameRegistrationTypeRegistered captures enum value "registered"
	NetbiosNameRegistrationTypeRegistered string = "registered"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// name_registration_type
	// NameRegistrationType
	// active
	// END DEBUGGING
	// NetbiosNameRegistrationTypeActive captures enum value "active"
	NetbiosNameRegistrationTypeActive string = "active"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// name_registration_type
	// NameRegistrationType
	// permanent
	// END DEBUGGING
	// NetbiosNameRegistrationTypePermanent captures enum value "permanent"
	NetbiosNameRegistrationTypePermanent string = "permanent"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// name_registration_type
	// NameRegistrationType
	// group
	// END DEBUGGING
	// NetbiosNameRegistrationTypeGroup captures enum value "group"
	NetbiosNameRegistrationTypeGroup string = "group"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// name_registration_type
	// NameRegistrationType
	//
	// END DEBUGGING
	// NetbiosNameRegistrationTypeEmpty captures enum value ""
	NetbiosNameRegistrationTypeEmpty string = ""
)

// prop value enum
func (m *Netbios) validateNameRegistrationTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, netbiosTypeNameRegistrationTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Netbios) validateNameRegistrationType(formats strfmt.Registry) error {
	if swag.IsZero(m.NameRegistrationType) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameRegistrationTypeEnum("name_registration_type", "body", *m.NameRegistrationType); err != nil {
		return err
	}

	return nil
}

func (m *Netbios) validateNetbiosInlineWinsServers(formats strfmt.Registry) error {
	if swag.IsZero(m.NetbiosInlineWinsServers) { // not required
		return nil
	}

	for i := 0; i < len(m.NetbiosInlineWinsServers); i++ {
		if swag.IsZero(m.NetbiosInlineWinsServers[i]) { // not required
			continue
		}

		if m.NetbiosInlineWinsServers[i] != nil {
			if err := m.NetbiosInlineWinsServers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("wins_servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Netbios) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var netbiosTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["must_register","must_unregister","wins","broadcast","name_released","wins_conflict","broadcast_conflict"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		netbiosTypeStatePropEnum = append(netbiosTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// state
	// State
	// must_register
	// END DEBUGGING
	// NetbiosStateMustRegister captures enum value "must_register"
	NetbiosStateMustRegister string = "must_register"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// state
	// State
	// must_unregister
	// END DEBUGGING
	// NetbiosStateMustUnregister captures enum value "must_unregister"
	NetbiosStateMustUnregister string = "must_unregister"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// state
	// State
	// wins
	// END DEBUGGING
	// NetbiosStateWins captures enum value "wins"
	NetbiosStateWins string = "wins"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// state
	// State
	// broadcast
	// END DEBUGGING
	// NetbiosStateBroadcast captures enum value "broadcast"
	NetbiosStateBroadcast string = "broadcast"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// state
	// State
	// name_released
	// END DEBUGGING
	// NetbiosStateNameReleased captures enum value "name_released"
	NetbiosStateNameReleased string = "name_released"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// state
	// State
	// wins_conflict
	// END DEBUGGING
	// NetbiosStateWinsConflict captures enum value "wins_conflict"
	NetbiosStateWinsConflict string = "wins_conflict"

	// BEGIN DEBUGGING
	// netbios
	// Netbios
	// state
	// State
	// broadcast_conflict
	// END DEBUGGING
	// NetbiosStateBroadcastConflict captures enum value "broadcast_conflict"
	NetbiosStateBroadcastConflict string = "broadcast_conflict"
)

// prop value enum
func (m *Netbios) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, netbiosTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Netbios) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Netbios) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this netbios based on the context it is used
func (m *Netbios) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNetbiosInlineWinsServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimeLeft(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Netbios) contextValidateNetbiosInlineWinsServers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NetbiosInlineWinsServers); i++ {

		if m.NetbiosInlineWinsServers[i] != nil {
			if err := m.NetbiosInlineWinsServers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("wins_servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Netbios) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *Netbios) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *Netbios) contextValidateTimeLeft(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "time_left", "body", m.TimeLeft); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Netbios) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Netbios) UnmarshalBinary(b []byte) error {
	var res Netbios
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NetbiosInlineNode netbios inline node
//
// swagger:model netbios_inline_node
type NetbiosInlineNode struct {

	// links
	Links *NetbiosInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this netbios inline node
func (m *NetbiosInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetbiosInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this netbios inline node based on the context it is used
func (m *NetbiosInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetbiosInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NetbiosInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NetbiosInlineNode) UnmarshalBinary(b []byte) error {
	var res NetbiosInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NetbiosInlineNodeInlineLinks netbios inline node inline links
//
// swagger:model netbios_inline_node_inline__links
type NetbiosInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this netbios inline node inline links
func (m *NetbiosInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetbiosInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this netbios inline node inline links based on the context it is used
func (m *NetbiosInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetbiosInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NetbiosInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NetbiosInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NetbiosInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NetbiosInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model netbios_inline_svm
type NetbiosInlineSvm struct {

	// links
	Links *NetbiosInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this netbios inline svm
func (m *NetbiosInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetbiosInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this netbios inline svm based on the context it is used
func (m *NetbiosInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetbiosInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NetbiosInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NetbiosInlineSvm) UnmarshalBinary(b []byte) error {
	var res NetbiosInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NetbiosInlineSvmInlineLinks netbios inline svm inline links
//
// swagger:model netbios_inline_svm_inline__links
type NetbiosInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this netbios inline svm inline links
func (m *NetbiosInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetbiosInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this netbios inline svm inline links based on the context it is used
func (m *NetbiosInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NetbiosInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NetbiosInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NetbiosInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NetbiosInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
