// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NfsService nfs service
//
// swagger:model nfs_service
type NfsService struct {

	// links
	Links *NfsServiceInlineLinks `json:"_links,omitempty"`

	// access cache config
	AccessCacheConfig *NfsServiceInlineAccessCacheConfig `json:"access_cache_config,omitempty"`

	// Specifies whether or not extended groups support over AUTH_SYS is enabled.
	AuthSysExtendedGroupsEnabled *bool `json:"auth_sys_extended_groups_enabled,omitempty"`

	// credential cache
	CredentialCache *NfsServiceInlineCredentialCache `json:"credential_cache,omitempty"`

	// Specifies if the NFS service is administratively enabled.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// exports
	Exports *NfsServiceInlineExports `json:"exports,omitempty"`

	// Specifies the maximum auxiliary groups supported over AUTH_SYS and RPCSEC_GSS.
	// Example: 32
	// Maximum: 1024
	// Minimum: 32
	ExtendedGroupsLimit *int64 `json:"extended_groups_limit,omitempty"`

	// Number of I/O operations on a file to be grouped and considered as one session for event generation applications, such as FPolicy.
	// Example: 5000
	// Maximum: 120000
	// Minimum: 1000
	FileSessionIoGroupingCount *int64 `json:"file_session_io_grouping_count,omitempty"`

	// The duration for which I/O operations on a file will be grouped and considered as one session for event generation applications, such as FPolicy.
	// Example: 120
	// Maximum: 3600
	// Minimum: 60
	FileSessionIoGroupingDuration *int64 `json:"file_session_io_grouping_duration,omitempty"`

	// metric
	Metric *NfsServiceInlineMetric `json:"metric,omitempty"`

	// protocol
	Protocol *NfsServiceInlineProtocol `json:"protocol,omitempty"`

	// protocol access rules
	ProtocolAccessRules *NfsServiceInlineProtocolAccessRules `json:"protocol_access_rules,omitempty"`

	// qtree
	Qtree *NfsServiceInlineQtree `json:"qtree,omitempty"`

	// root
	Root *NfsServiceInlineRoot `json:"root,omitempty"`

	// Specifies whether or not the remote quota feature is enabled.
	RquotaEnabled *bool `json:"rquota_enabled,omitempty"`

	// security
	Security *NfsServiceInlineSecurity `json:"security,omitempty"`

	// Specifies whether or not the showmount feature is enabled.
	ShowmountEnabled *bool `json:"showmount_enabled,omitempty"`

	// Specifies the state of the NFS service on the SVM. The following values are supported:
	//           * online - NFS server is ready to accept client requests.
	//           * offline - NFS server is not ready to accept client requests.
	//
	// Read Only: true
	// Enum: ["online","offline"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *NfsServiceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *NfsServiceInlineSvm `json:"svm,omitempty"`

	// transport
	Transport *NfsServiceInlineTransport `json:"transport,omitempty"`

	// Specifies whether or not the VMware vstorage feature is enabled.
	VstorageEnabled *bool `json:"vstorage_enabled,omitempty"`

	// windows
	Windows *NfsServiceInlineWindows `json:"windows,omitempty"`
}

// Validate validates this nfs service
func (m *NfsService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessCacheConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCredentialCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExports(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExtendedGroupsLimit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFileSessionIoGroupingCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFileSessionIoGroupingDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocolAccessRules(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQtree(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRoot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransport(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWindows(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsService) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateAccessCacheConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessCacheConfig) { // not required
		return nil
	}

	if m.AccessCacheConfig != nil {
		if err := m.AccessCacheConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_cache_config")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateCredentialCache(formats strfmt.Registry) error {
	if swag.IsZero(m.CredentialCache) { // not required
		return nil
	}

	if m.CredentialCache != nil {
		if err := m.CredentialCache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("credential_cache")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateExports(formats strfmt.Registry) error {
	if swag.IsZero(m.Exports) { // not required
		return nil
	}

	if m.Exports != nil {
		if err := m.Exports.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("exports")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateExtendedGroupsLimit(formats strfmt.Registry) error {
	if swag.IsZero(m.ExtendedGroupsLimit) { // not required
		return nil
	}

	if err := validate.MinimumInt("extended_groups_limit", "body", *m.ExtendedGroupsLimit, 32, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("extended_groups_limit", "body", *m.ExtendedGroupsLimit, 1024, false); err != nil {
		return err
	}

	return nil
}

func (m *NfsService) validateFileSessionIoGroupingCount(formats strfmt.Registry) error {
	if swag.IsZero(m.FileSessionIoGroupingCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("file_session_io_grouping_count", "body", *m.FileSessionIoGroupingCount, 1000, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("file_session_io_grouping_count", "body", *m.FileSessionIoGroupingCount, 120000, false); err != nil {
		return err
	}

	return nil
}

func (m *NfsService) validateFileSessionIoGroupingDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.FileSessionIoGroupingDuration) { // not required
		return nil
	}

	if err := validate.MinimumInt("file_session_io_grouping_duration", "body", *m.FileSessionIoGroupingDuration, 60, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("file_session_io_grouping_duration", "body", *m.FileSessionIoGroupingDuration, 3600, false); err != nil {
		return err
	}

	return nil
}

func (m *NfsService) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	if m.Protocol != nil {
		if err := m.Protocol.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateProtocolAccessRules(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtocolAccessRules) { // not required
		return nil
	}

	if m.ProtocolAccessRules != nil {
		if err := m.ProtocolAccessRules.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol_access_rules")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateQtree(formats strfmt.Registry) error {
	if swag.IsZero(m.Qtree) { // not required
		return nil
	}

	if m.Qtree != nil {
		if err := m.Qtree.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qtree")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateRoot(formats strfmt.Registry) error {
	if swag.IsZero(m.Root) { // not required
		return nil
	}

	if m.Root != nil {
		if err := m.Root.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("root")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.Security) { // not required
		return nil
	}

	if m.Security != nil {
		if err := m.Security.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security")
			}
			return err
		}
	}

	return nil
}

var nfsServiceTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceTypeStatePropEnum = append(nfsServiceTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service
	// NfsService
	// state
	// State
	// online
	// END DEBUGGING
	// NfsServiceStateOnline captures enum value "online"
	NfsServiceStateOnline string = "online"

	// BEGIN DEBUGGING
	// nfs_service
	// NfsService
	// state
	// State
	// offline
	// END DEBUGGING
	// NfsServiceStateOffline captures enum value "offline"
	NfsServiceStateOffline string = "offline"
)

// prop value enum
func (m *NfsService) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsService) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *NfsService) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateTransport(formats strfmt.Registry) error {
	if swag.IsZero(m.Transport) { // not required
		return nil
	}

	if m.Transport != nil {
		if err := m.Transport.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transport")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) validateWindows(formats strfmt.Registry) error {
	if swag.IsZero(m.Windows) { // not required
		return nil
	}

	if m.Windows != nil {
		if err := m.Windows.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("windows")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service based on the context it is used
func (m *NfsService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessCacheConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCredentialCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtocol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtocolAccessRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQtree(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRoot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransport(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWindows(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsService) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateAccessCacheConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.AccessCacheConfig != nil {
		if err := m.AccessCacheConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_cache_config")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateCredentialCache(ctx context.Context, formats strfmt.Registry) error {

	if m.CredentialCache != nil {
		if err := m.CredentialCache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("credential_cache")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateExports(ctx context.Context, formats strfmt.Registry) error {

	if m.Exports != nil {
		if err := m.Exports.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("exports")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateProtocol(ctx context.Context, formats strfmt.Registry) error {

	if m.Protocol != nil {
		if err := m.Protocol.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateProtocolAccessRules(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtocolAccessRules != nil {
		if err := m.ProtocolAccessRules.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol_access_rules")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateQtree(ctx context.Context, formats strfmt.Registry) error {

	if m.Qtree != nil {
		if err := m.Qtree.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qtree")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateRoot(ctx context.Context, formats strfmt.Registry) error {

	if m.Root != nil {
		if err := m.Root.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("root")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateSecurity(ctx context.Context, formats strfmt.Registry) error {

	if m.Security != nil {
		if err := m.Security.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NfsService) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateTransport(ctx context.Context, formats strfmt.Registry) error {

	if m.Transport != nil {
		if err := m.Transport.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("transport")
			}
			return err
		}
	}

	return nil
}

func (m *NfsService) contextValidateWindows(ctx context.Context, formats strfmt.Registry) error {

	if m.Windows != nil {
		if err := m.Windows.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("windows")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsService) UnmarshalBinary(b []byte) error {
	var res NfsService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineAccessCacheConfig nfs service inline access cache config
//
// swagger:model nfs_service_inline_access_cache_config
type NfsServiceInlineAccessCacheConfig struct {

	// Specifies the time after which an entry is deleted from the access cache, if unused.
	// Example: 3600
	HarvestTimeout *int64 `json:"harvest_timeout,omitempty"`

	// Specifies whether Dns TTL is enabled.
	IsDNSTTLEnabled *bool `json:"isDnsTTLEnabled,omitempty"`

	// Specifies the time to live value for entries for which a failure was encountered, in seconds.
	// Example: 1
	TTLFailure *int64 `json:"ttl_failure,omitempty"`

	// Specifies the time to live value of a negative access cache, in seconds.
	// Example: 30
	TTLNegative *int64 `json:"ttl_negative,omitempty"`

	// Specifies the time to live value of a positive access cache, in seconds.
	// Example: 60
	TTLPositive *int64 `json:"ttl_positive,omitempty"`
}

// Validate validates this nfs service inline access cache config
func (m *NfsServiceInlineAccessCacheConfig) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nfs service inline access cache config based on context it is used
func (m *NfsServiceInlineAccessCacheConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineAccessCacheConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineAccessCacheConfig) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineAccessCacheConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineCredentialCache nfs service inline credential cache
//
// swagger:model nfs_service_inline_credential_cache
type NfsServiceInlineCredentialCache struct {

	// Specifies the age of the unused cached entries, in milliseconds, after which they are cleared from the cache.
	// Example: 86400000
	// Maximum: 6.048e+08
	// Minimum: 60000
	HarvestTimeout *int64 `json:"harvest_timeout,omitempty"`

	// Specifies the age in milliseconds, of the negative cached credentials after which they are cleared from the cache.
	// Example: 3600000
	// Maximum: 6.048e+08
	// Minimum: 60000
	NegativeTTL *int64 `json:"negative_ttl,omitempty"`

	// Specifies the age in milliseconds, of the positive cached credentials after which they are cleared from the cache.
	// Example: 3600000
	// Maximum: 6.048e+08
	// Minimum: 60000
	PositiveTTL *int64 `json:"positive_ttl,omitempty"`

	// Specifies the age in milliseconds, of the cached entries during a transient error situation.
	// Example: 30000
	// Maximum: 300000
	// Minimum: 30000
	TransientErrorTTL *int64 `json:"transient_error_ttl,omitempty"`
}

// Validate validates this nfs service inline credential cache
func (m *NfsServiceInlineCredentialCache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHarvestTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNegativeTTL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePositiveTTL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransientErrorTTL(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineCredentialCache) validateHarvestTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.HarvestTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("credential_cache"+"."+"harvest_timeout", "body", *m.HarvestTimeout, 60000, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("credential_cache"+"."+"harvest_timeout", "body", *m.HarvestTimeout, 6.048e+08, false); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineCredentialCache) validateNegativeTTL(formats strfmt.Registry) error {
	if swag.IsZero(m.NegativeTTL) { // not required
		return nil
	}

	if err := validate.MinimumInt("credential_cache"+"."+"negative_ttl", "body", *m.NegativeTTL, 60000, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("credential_cache"+"."+"negative_ttl", "body", *m.NegativeTTL, 6.048e+08, false); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineCredentialCache) validatePositiveTTL(formats strfmt.Registry) error {
	if swag.IsZero(m.PositiveTTL) { // not required
		return nil
	}

	if err := validate.MinimumInt("credential_cache"+"."+"positive_ttl", "body", *m.PositiveTTL, 60000, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("credential_cache"+"."+"positive_ttl", "body", *m.PositiveTTL, 6.048e+08, false); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineCredentialCache) validateTransientErrorTTL(formats strfmt.Registry) error {
	if swag.IsZero(m.TransientErrorTTL) { // not required
		return nil
	}

	if err := validate.MinimumInt("credential_cache"+"."+"transient_error_ttl", "body", *m.TransientErrorTTL, 30000, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("credential_cache"+"."+"transient_error_ttl", "body", *m.TransientErrorTTL, 300000, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nfs service inline credential cache based on context it is used
func (m *NfsServiceInlineCredentialCache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineCredentialCache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineCredentialCache) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineCredentialCache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineExports nfs service inline exports
//
// swagger:model nfs_service_inline_exports
type NfsServiceInlineExports struct {

	// Specifies the protocol to use for doing name service lookups.
	// Enum: ["tcp","udp"]
	NameServiceLookupProtocol *string `json:"name_service_lookup_protocol,omitempty"`

	// Specifies if you can consider a no-match result from any of the netgroup ns-switch sources to be authoritative. If this option is enabled, then a no-match response from any of the netgroup ns-switch sources is deemed conclusive even if other sources could not be searched.
	NetgroupTrustAnyNsswitchNoMatch *bool `json:"netgroup_trust_any_nsswitch_no_match,omitempty"`
}

// Validate validates this nfs service inline exports
func (m *NfsServiceInlineExports) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNameServiceLookupProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nfsServiceInlineExportsTypeNameServiceLookupProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["tcp","udp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineExportsTypeNameServiceLookupProtocolPropEnum = append(nfsServiceInlineExportsTypeNameServiceLookupProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_exports
	// NfsServiceInlineExports
	// name_service_lookup_protocol
	// NameServiceLookupProtocol
	// tcp
	// END DEBUGGING
	// NfsServiceInlineExportsNameServiceLookupProtocolTCP captures enum value "tcp"
	NfsServiceInlineExportsNameServiceLookupProtocolTCP string = "tcp"

	// BEGIN DEBUGGING
	// nfs_service_inline_exports
	// NfsServiceInlineExports
	// name_service_lookup_protocol
	// NameServiceLookupProtocol
	// udp
	// END DEBUGGING
	// NfsServiceInlineExportsNameServiceLookupProtocolUDP captures enum value "udp"
	NfsServiceInlineExportsNameServiceLookupProtocolUDP string = "udp"
)

// prop value enum
func (m *NfsServiceInlineExports) validateNameServiceLookupProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineExportsTypeNameServiceLookupProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineExports) validateNameServiceLookupProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.NameServiceLookupProtocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameServiceLookupProtocolEnum("exports"+"."+"name_service_lookup_protocol", "body", *m.NameServiceLookupProtocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nfs service inline exports based on context it is used
func (m *NfsServiceInlineExports) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineExports) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineExports) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineExports
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineLinks nfs service inline links
//
// swagger:model nfs_service_inline__links
type NfsServiceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nfs service inline links
func (m *NfsServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service inline links based on the context it is used
func (m *NfsServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetric Historical performance numbers, such as IOPS latency and throughput, for SVM-NFS protocol.
//
// swagger:model nfs_service_inline_metric
type NfsServiceInlineMetric struct {

	// v3
	V3 *NfsServiceInlineMetricInlineV3 `json:"v3,omitempty"`

	// v4
	V4 *NfsServiceInlineMetricInlineV4 `json:"v4,omitempty"`

	// v41
	V41 *NfsServiceInlineMetricInlineV41 `json:"v41,omitempty"`
}

// Validate validates this nfs service inline metric
func (m *NfsServiceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateV3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV41(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetric) validateV3(formats strfmt.Registry) error {
	if swag.IsZero(m.V3) { // not required
		return nil
	}

	if m.V3 != nil {
		if err := m.V3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetric) validateV4(formats strfmt.Registry) error {
	if swag.IsZero(m.V4) { // not required
		return nil
	}

	if m.V4 != nil {
		if err := m.V4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetric) validateV41(formats strfmt.Registry) error {
	if swag.IsZero(m.V41) { // not required
		return nil
	}

	if m.V41 != nil {
		if err := m.V41.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service inline metric based on the context it is used
func (m *NfsServiceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateV3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV41(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetric) contextValidateV3(ctx context.Context, formats strfmt.Registry) error {

	if m.V3 != nil {
		if err := m.V3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetric) contextValidateV4(ctx context.Context, formats strfmt.Registry) error {

	if m.V4 != nil {
		if err := m.V4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetric) contextValidateV41(ctx context.Context, formats strfmt.Registry) error {

	if m.V41 != nil {
		if err := m.V41.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetric) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV3 The NFSv3 operations
//
// swagger:model nfs_service_inline_metric_inline_v3
type NfsServiceInlineMetricInlineV3 struct {

	// links
	Links *NfsServiceInlineMetricInlineV3InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NfsServiceInlineMetricInlineV3InlineIops `json:"iops,omitempty"`

	// latency
	Latency *NfsServiceInlineMetricInlineV3InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NfsServiceInlineMetricInlineV3InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nfs service inline metric inline v3
func (m *NfsServiceInlineMetricInlineV3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV3) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineMetricInlineV3TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineMetricInlineV3TypeDurationPropEnum = append(nfsServiceInlineMetricInlineV3TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3DurationPT15S captures enum value "PT15S"
	NfsServiceInlineMetricInlineV3DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3DurationPT4M captures enum value "PT4M"
	NfsServiceInlineMetricInlineV3DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3DurationPT30M captures enum value "PT30M"
	NfsServiceInlineMetricInlineV3DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3DurationPT2H captures enum value "PT2H"
	NfsServiceInlineMetricInlineV3DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3DurationP1D captures enum value "P1D"
	NfsServiceInlineMetricInlineV3DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3DurationPT5M captures enum value "PT5M"
	NfsServiceInlineMetricInlineV3DurationPT5M string = "PT5M"
)

// prop value enum
func (m *NfsServiceInlineMetricInlineV3) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineMetricInlineV3TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV3) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"v3"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineMetricInlineV3TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineMetricInlineV3TypeStatusPropEnum = append(nfsServiceInlineMetricInlineV3TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// ok
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusOk captures enum value "ok"
	NfsServiceInlineMetricInlineV3StatusOk string = "ok"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// error
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusError captures enum value "error"
	NfsServiceInlineMetricInlineV3StatusError string = "error"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusPartialNoData captures enum value "partial_no_data"
	NfsServiceInlineMetricInlineV3StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusPartialNoResponse captures enum value "partial_no_response"
	NfsServiceInlineMetricInlineV3StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusPartialOtherError captures enum value "partial_other_error"
	NfsServiceInlineMetricInlineV3StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusNegativeDelta captures enum value "negative_delta"
	NfsServiceInlineMetricInlineV3StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusNotFound captures enum value "not_found"
	NfsServiceInlineMetricInlineV3StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusBackfilledData captures enum value "backfilled_data"
	NfsServiceInlineMetricInlineV3StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NfsServiceInlineMetricInlineV3StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusInconsistentOldData captures enum value "inconsistent_old_data"
	NfsServiceInlineMetricInlineV3StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v3
	// NfsServiceInlineMetricInlineV3
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV3StatusPartialNoUUID captures enum value "partial_no_uuid"
	NfsServiceInlineMetricInlineV3StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NfsServiceInlineMetricInlineV3) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineMetricInlineV3TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV3) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"v3"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"v3"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nfs service inline metric inline v3 based on the context it is used
func (m *NfsServiceInlineMetricInlineV3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV3) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v3"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v3"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV3) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v3"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV3InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v3_inline_iops
type NfsServiceInlineMetricInlineV3InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v3 inline iops
func (m *NfsServiceInlineMetricInlineV3InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v3 inline iops based on the context it is used
func (m *NfsServiceInlineMetricInlineV3InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3InlineIops) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV3InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV3InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v3_inline_latency
type NfsServiceInlineMetricInlineV3InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v3 inline latency
func (m *NfsServiceInlineMetricInlineV3InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v3 inline latency based on the context it is used
func (m *NfsServiceInlineMetricInlineV3InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3InlineLatency) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV3InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV3InlineLinks nfs service inline metric inline v3 inline links
//
// swagger:model nfs_service_inline_metric_inline_v3_inline__links
type NfsServiceInlineMetricInlineV3InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nfs service inline metric inline v3 inline links
func (m *NfsServiceInlineMetricInlineV3InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV3InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service inline metric inline v3 inline links based on the context it is used
func (m *NfsServiceInlineMetricInlineV3InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV3InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3InlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV3InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV3InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v3_inline_throughput
type NfsServiceInlineMetricInlineV3InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v3 inline throughput
func (m *NfsServiceInlineMetricInlineV3InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v3 inline throughput based on the context it is used
func (m *NfsServiceInlineMetricInlineV3InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV3InlineThroughput) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV3InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV4 The NFSv4 operations
//
// swagger:model nfs_service_inline_metric_inline_v4
type NfsServiceInlineMetricInlineV4 struct {

	// links
	Links *NfsServiceInlineMetricInlineV4InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NfsServiceInlineMetricInlineV4InlineIops `json:"iops,omitempty"`

	// latency
	Latency *NfsServiceInlineMetricInlineV4InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NfsServiceInlineMetricInlineV4InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nfs service inline metric inline v4
func (m *NfsServiceInlineMetricInlineV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV4) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineMetricInlineV4TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineMetricInlineV4TypeDurationPropEnum = append(nfsServiceInlineMetricInlineV4TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4DurationPT15S captures enum value "PT15S"
	NfsServiceInlineMetricInlineV4DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4DurationPT4M captures enum value "PT4M"
	NfsServiceInlineMetricInlineV4DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4DurationPT30M captures enum value "PT30M"
	NfsServiceInlineMetricInlineV4DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4DurationPT2H captures enum value "PT2H"
	NfsServiceInlineMetricInlineV4DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4DurationP1D captures enum value "P1D"
	NfsServiceInlineMetricInlineV4DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4DurationPT5M captures enum value "PT5M"
	NfsServiceInlineMetricInlineV4DurationPT5M string = "PT5M"
)

// prop value enum
func (m *NfsServiceInlineMetricInlineV4) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineMetricInlineV4TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV4) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"v4"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineMetricInlineV4TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineMetricInlineV4TypeStatusPropEnum = append(nfsServiceInlineMetricInlineV4TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// ok
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusOk captures enum value "ok"
	NfsServiceInlineMetricInlineV4StatusOk string = "ok"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// error
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusError captures enum value "error"
	NfsServiceInlineMetricInlineV4StatusError string = "error"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusPartialNoData captures enum value "partial_no_data"
	NfsServiceInlineMetricInlineV4StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusPartialNoResponse captures enum value "partial_no_response"
	NfsServiceInlineMetricInlineV4StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusPartialOtherError captures enum value "partial_other_error"
	NfsServiceInlineMetricInlineV4StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusNegativeDelta captures enum value "negative_delta"
	NfsServiceInlineMetricInlineV4StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusNotFound captures enum value "not_found"
	NfsServiceInlineMetricInlineV4StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusBackfilledData captures enum value "backfilled_data"
	NfsServiceInlineMetricInlineV4StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NfsServiceInlineMetricInlineV4StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusInconsistentOldData captures enum value "inconsistent_old_data"
	NfsServiceInlineMetricInlineV4StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v4
	// NfsServiceInlineMetricInlineV4
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV4StatusPartialNoUUID captures enum value "partial_no_uuid"
	NfsServiceInlineMetricInlineV4StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NfsServiceInlineMetricInlineV4) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineMetricInlineV4TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV4) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"v4"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"v4"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nfs service inline metric inline v4 based on the context it is used
func (m *NfsServiceInlineMetricInlineV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV4) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v4"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v4"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV4) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v4"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV41 The NFSv4.1 operations
//
// swagger:model nfs_service_inline_metric_inline_v41
type NfsServiceInlineMetricInlineV41 struct {

	// links
	Links *NfsServiceInlineMetricInlineV41InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NfsServiceInlineMetricInlineV41InlineIops `json:"iops,omitempty"`

	// latency
	Latency *NfsServiceInlineMetricInlineV41InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NfsServiceInlineMetricInlineV41InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nfs service inline metric inline v41
func (m *NfsServiceInlineMetricInlineV41) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV41) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineMetricInlineV41TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineMetricInlineV41TypeDurationPropEnum = append(nfsServiceInlineMetricInlineV41TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41DurationPT15S captures enum value "PT15S"
	NfsServiceInlineMetricInlineV41DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41DurationPT4M captures enum value "PT4M"
	NfsServiceInlineMetricInlineV41DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41DurationPT30M captures enum value "PT30M"
	NfsServiceInlineMetricInlineV41DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41DurationPT2H captures enum value "PT2H"
	NfsServiceInlineMetricInlineV41DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41DurationP1D captures enum value "P1D"
	NfsServiceInlineMetricInlineV41DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41DurationPT5M captures enum value "PT5M"
	NfsServiceInlineMetricInlineV41DurationPT5M string = "PT5M"
)

// prop value enum
func (m *NfsServiceInlineMetricInlineV41) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineMetricInlineV41TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV41) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"v41"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineMetricInlineV41TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineMetricInlineV41TypeStatusPropEnum = append(nfsServiceInlineMetricInlineV41TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// ok
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusOk captures enum value "ok"
	NfsServiceInlineMetricInlineV41StatusOk string = "ok"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// error
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusError captures enum value "error"
	NfsServiceInlineMetricInlineV41StatusError string = "error"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusPartialNoData captures enum value "partial_no_data"
	NfsServiceInlineMetricInlineV41StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusPartialNoResponse captures enum value "partial_no_response"
	NfsServiceInlineMetricInlineV41StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusPartialOtherError captures enum value "partial_other_error"
	NfsServiceInlineMetricInlineV41StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusNegativeDelta captures enum value "negative_delta"
	NfsServiceInlineMetricInlineV41StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusNotFound captures enum value "not_found"
	NfsServiceInlineMetricInlineV41StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusBackfilledData captures enum value "backfilled_data"
	NfsServiceInlineMetricInlineV41StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NfsServiceInlineMetricInlineV41StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusInconsistentOldData captures enum value "inconsistent_old_data"
	NfsServiceInlineMetricInlineV41StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_metric_inline_v41
	// NfsServiceInlineMetricInlineV41
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NfsServiceInlineMetricInlineV41StatusPartialNoUUID captures enum value "partial_no_uuid"
	NfsServiceInlineMetricInlineV41StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NfsServiceInlineMetricInlineV41) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineMetricInlineV41TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV41) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"v41"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"v41"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nfs service inline metric inline v41 based on the context it is used
func (m *NfsServiceInlineMetricInlineV41) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV41) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v41"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v41"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineMetricInlineV41) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"v41"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV41
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV41InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v41_inline_iops
type NfsServiceInlineMetricInlineV41InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v41 inline iops
func (m *NfsServiceInlineMetricInlineV41InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v41 inline iops based on the context it is used
func (m *NfsServiceInlineMetricInlineV41InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41InlineIops) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV41InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV41InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v41_inline_latency
type NfsServiceInlineMetricInlineV41InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v41 inline latency
func (m *NfsServiceInlineMetricInlineV41InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v41 inline latency based on the context it is used
func (m *NfsServiceInlineMetricInlineV41InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41InlineLatency) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV41InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV41InlineLinks nfs service inline metric inline v41 inline links
//
// swagger:model nfs_service_inline_metric_inline_v41_inline__links
type NfsServiceInlineMetricInlineV41InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nfs service inline metric inline v41 inline links
func (m *NfsServiceInlineMetricInlineV41InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV41InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service inline metric inline v41 inline links based on the context it is used
func (m *NfsServiceInlineMetricInlineV41InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV41InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v41" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41InlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV41InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV41InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v41_inline_throughput
type NfsServiceInlineMetricInlineV41InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v41 inline throughput
func (m *NfsServiceInlineMetricInlineV41InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v41 inline throughput based on the context it is used
func (m *NfsServiceInlineMetricInlineV41InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV41InlineThroughput) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV41InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV4InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v4_inline_iops
type NfsServiceInlineMetricInlineV4InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v4 inline iops
func (m *NfsServiceInlineMetricInlineV4InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v4 inline iops based on the context it is used
func (m *NfsServiceInlineMetricInlineV4InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4InlineIops) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV4InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV4InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v4_inline_latency
type NfsServiceInlineMetricInlineV4InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v4 inline latency
func (m *NfsServiceInlineMetricInlineV4InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v4 inline latency based on the context it is used
func (m *NfsServiceInlineMetricInlineV4InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4InlineLatency) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV4InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV4InlineLinks nfs service inline metric inline v4 inline links
//
// swagger:model nfs_service_inline_metric_inline_v4_inline__links
type NfsServiceInlineMetricInlineV4InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nfs service inline metric inline v4 inline links
func (m *NfsServiceInlineMetricInlineV4InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV4InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service inline metric inline v4 inline links based on the context it is used
func (m *NfsServiceInlineMetricInlineV4InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineMetricInlineV4InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "v4" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4InlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV4InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineMetricInlineV4InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nfs_service_inline_metric_inline_v4_inline_throughput
type NfsServiceInlineMetricInlineV4InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline metric inline v4 inline throughput
func (m *NfsServiceInlineMetricInlineV4InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline metric inline v4 inline throughput based on the context it is used
func (m *NfsServiceInlineMetricInlineV4InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineMetricInlineV4InlineThroughput) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineMetricInlineV4InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineProtocol nfs service inline protocol
//
// swagger:model nfs_service_inline_protocol
type NfsServiceInlineProtocol struct {

	// Specifies whether 64-bit support for NFSv3 FSIDs and file IDs is enabled.
	V364bitIdentifiersEnabled *bool `json:"v3_64bit_identifiers_enabled,omitempty"`

	// Specifies whether NFSv3 protocol is enabled.
	V3Enabled *bool `json:"v3_enabled,omitempty"`

	// v3 features
	V3Features *NfsServiceInlineProtocolInlineV3Features `json:"v3_features,omitempty"`

	// Specifies whether NFSv4.0 protocol is enabled.
	V40Enabled *bool `json:"v40_enabled,omitempty"`

	// v40 features
	V40Features *NfsServiceInlineProtocolInlineV40Features `json:"v40_features,omitempty"`

	// Specifies whether NFSv4.1 or later protocol is enabled.
	V41Enabled *bool `json:"v41_enabled,omitempty"`

	// v41 features
	V41Features *NfsServiceInlineProtocolInlineV41Features `json:"v41_features,omitempty"`

	// v42 features
	V42Features *NfsServiceInlineProtocolInlineV42Features `json:"v42_features,omitempty"`

	// Specifies whether 64-bit support for NFSv4.x FSIDs and file IDs is enabled.
	V464bitIdentifiersEnabled *bool `json:"v4_64bit_identifiers_enabled,omitempty"`

	// Specifies whether the change in FSID when NFSv4 clients traverse file systems is displayed.
	V4FsidChange *bool `json:"v4_fsid_change,omitempty"`

	// Specifies the grace period for clients to reclaim file locks after a server failure.
	V4GraceSeconds *int64 `json:"v4_grace_seconds,omitempty"`

	// Specifies the domain portion of the string form of user and group
	// names as defined by the NFSv4 protocol.
	//
	V4IDDomain *string `json:"v4_id_domain,omitempty"`

	// Specifies the lease seconds of the NFSv4 clients. If it is inactive for more than the time displayed, all of the file lock states on a node might be lost.
	V4LeaseSeconds *int64 `json:"v4_lease_seconds,omitempty"`

	// Specifies the number of bytes of the reply that is cached in each NFSv4.x session slot.
	// Maximum: 4096
	// Minimum: 512
	V4SessionSlotReplyCacheSize *int64 `json:"v4_session_slot_reply_cache_size,omitempty"`

	// Specifies the number of entries in NFSv4.x session slot table.
	// Maximum: 2000
	// Minimum: 1
	V4SessionSlots *int64 `json:"v4_session_slots,omitempty"`

	// Specifies whether NFSv4 subnet filtering is enabled.
	V4SubnetFilterEnabled *bool `json:"v4_subnet_filter_enabled,omitempty"`
}

// Validate validates this nfs service inline protocol
func (m *NfsServiceInlineProtocol) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateV3Features(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV40Features(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV41Features(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV42Features(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV4SessionSlotReplyCacheSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV4SessionSlots(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineProtocol) validateV3Features(formats strfmt.Registry) error {
	if swag.IsZero(m.V3Features) { // not required
		return nil
	}

	if m.V3Features != nil {
		if err := m.V3Features.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol" + "." + "v3_features")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineProtocol) validateV40Features(formats strfmt.Registry) error {
	if swag.IsZero(m.V40Features) { // not required
		return nil
	}

	if m.V40Features != nil {
		if err := m.V40Features.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol" + "." + "v40_features")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineProtocol) validateV41Features(formats strfmt.Registry) error {
	if swag.IsZero(m.V41Features) { // not required
		return nil
	}

	if m.V41Features != nil {
		if err := m.V41Features.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol" + "." + "v41_features")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineProtocol) validateV42Features(formats strfmt.Registry) error {
	if swag.IsZero(m.V42Features) { // not required
		return nil
	}

	if m.V42Features != nil {
		if err := m.V42Features.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol" + "." + "v42_features")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineProtocol) validateV4SessionSlotReplyCacheSize(formats strfmt.Registry) error {
	if swag.IsZero(m.V4SessionSlotReplyCacheSize) { // not required
		return nil
	}

	if err := validate.MinimumInt("protocol"+"."+"v4_session_slot_reply_cache_size", "body", *m.V4SessionSlotReplyCacheSize, 512, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("protocol"+"."+"v4_session_slot_reply_cache_size", "body", *m.V4SessionSlotReplyCacheSize, 4096, false); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineProtocol) validateV4SessionSlots(formats strfmt.Registry) error {
	if swag.IsZero(m.V4SessionSlots) { // not required
		return nil
	}

	if err := validate.MinimumInt("protocol"+"."+"v4_session_slots", "body", *m.V4SessionSlots, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("protocol"+"."+"v4_session_slots", "body", *m.V4SessionSlots, 2000, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nfs service inline protocol based on the context it is used
func (m *NfsServiceInlineProtocol) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateV3Features(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV40Features(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV41Features(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV42Features(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineProtocol) contextValidateV3Features(ctx context.Context, formats strfmt.Registry) error {

	if m.V3Features != nil {
		if err := m.V3Features.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol" + "." + "v3_features")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineProtocol) contextValidateV40Features(ctx context.Context, formats strfmt.Registry) error {

	if m.V40Features != nil {
		if err := m.V40Features.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol" + "." + "v40_features")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineProtocol) contextValidateV41Features(ctx context.Context, formats strfmt.Registry) error {

	if m.V41Features != nil {
		if err := m.V41Features.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol" + "." + "v41_features")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineProtocol) contextValidateV42Features(ctx context.Context, formats strfmt.Registry) error {

	if m.V42Features != nil {
		if err := m.V42Features.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protocol" + "." + "v42_features")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineProtocol) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineProtocol) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineProtocol
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineProtocolAccessRules nfs service inline protocol access rules
//
// swagger:model nfs_service_inline_protocol_access_rules
type NfsServiceInlineProtocolAccessRules struct {

	// Access available for the CIFS protocol.
	// Read Only: true
	// Enum: ["read","read_write","denied"]
	CifsAccessType *string `json:"cifs_access_type,omitempty"`

	// Access available for the NFSv3 protocol.
	// Read Only: true
	// Enum: ["read","read_write","denied"]
	Nfs3AccessType *string `json:"nfs3_access_type,omitempty"`

	// Access available for the NFSv4 protocol.
	// Read Only: true
	// Enum: ["read","read_write","denied"]
	Nfs4AccessType *string `json:"nfs4_access_type,omitempty"`
}

// Validate validates this nfs service inline protocol access rules
func (m *NfsServiceInlineProtocolAccessRules) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifsAccessType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNfs3AccessType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNfs4AccessType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nfsServiceInlineProtocolAccessRulesTypeCifsAccessTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","read_write","denied"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineProtocolAccessRulesTypeCifsAccessTypePropEnum = append(nfsServiceInlineProtocolAccessRulesTypeCifsAccessTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// cifs_access_type
	// CifsAccessType
	// read
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesCifsAccessTypeRead captures enum value "read"
	NfsServiceInlineProtocolAccessRulesCifsAccessTypeRead string = "read"

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// cifs_access_type
	// CifsAccessType
	// read_write
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesCifsAccessTypeReadWrite captures enum value "read_write"
	NfsServiceInlineProtocolAccessRulesCifsAccessTypeReadWrite string = "read_write"

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// cifs_access_type
	// CifsAccessType
	// denied
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesCifsAccessTypeDenied captures enum value "denied"
	NfsServiceInlineProtocolAccessRulesCifsAccessTypeDenied string = "denied"
)

// prop value enum
func (m *NfsServiceInlineProtocolAccessRules) validateCifsAccessTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineProtocolAccessRulesTypeCifsAccessTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineProtocolAccessRules) validateCifsAccessType(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsAccessType) { // not required
		return nil
	}

	// value enum
	if err := m.validateCifsAccessTypeEnum("protocol_access_rules"+"."+"cifs_access_type", "body", *m.CifsAccessType); err != nil {
		return err
	}

	return nil
}

var nfsServiceInlineProtocolAccessRulesTypeNfs3AccessTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","read_write","denied"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineProtocolAccessRulesTypeNfs3AccessTypePropEnum = append(nfsServiceInlineProtocolAccessRulesTypeNfs3AccessTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// nfs3_access_type
	// Nfs3AccessType
	// read
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesNfs3AccessTypeRead captures enum value "read"
	NfsServiceInlineProtocolAccessRulesNfs3AccessTypeRead string = "read"

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// nfs3_access_type
	// Nfs3AccessType
	// read_write
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesNfs3AccessTypeReadWrite captures enum value "read_write"
	NfsServiceInlineProtocolAccessRulesNfs3AccessTypeReadWrite string = "read_write"

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// nfs3_access_type
	// Nfs3AccessType
	// denied
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesNfs3AccessTypeDenied captures enum value "denied"
	NfsServiceInlineProtocolAccessRulesNfs3AccessTypeDenied string = "denied"
)

// prop value enum
func (m *NfsServiceInlineProtocolAccessRules) validateNfs3AccessTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineProtocolAccessRulesTypeNfs3AccessTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineProtocolAccessRules) validateNfs3AccessType(formats strfmt.Registry) error {
	if swag.IsZero(m.Nfs3AccessType) { // not required
		return nil
	}

	// value enum
	if err := m.validateNfs3AccessTypeEnum("protocol_access_rules"+"."+"nfs3_access_type", "body", *m.Nfs3AccessType); err != nil {
		return err
	}

	return nil
}

var nfsServiceInlineProtocolAccessRulesTypeNfs4AccessTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","read_write","denied"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineProtocolAccessRulesTypeNfs4AccessTypePropEnum = append(nfsServiceInlineProtocolAccessRulesTypeNfs4AccessTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// nfs4_access_type
	// Nfs4AccessType
	// read
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesNfs4AccessTypeRead captures enum value "read"
	NfsServiceInlineProtocolAccessRulesNfs4AccessTypeRead string = "read"

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// nfs4_access_type
	// Nfs4AccessType
	// read_write
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesNfs4AccessTypeReadWrite captures enum value "read_write"
	NfsServiceInlineProtocolAccessRulesNfs4AccessTypeReadWrite string = "read_write"

	// BEGIN DEBUGGING
	// nfs_service_inline_protocol_access_rules
	// NfsServiceInlineProtocolAccessRules
	// nfs4_access_type
	// Nfs4AccessType
	// denied
	// END DEBUGGING
	// NfsServiceInlineProtocolAccessRulesNfs4AccessTypeDenied captures enum value "denied"
	NfsServiceInlineProtocolAccessRulesNfs4AccessTypeDenied string = "denied"
)

// prop value enum
func (m *NfsServiceInlineProtocolAccessRules) validateNfs4AccessTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineProtocolAccessRulesTypeNfs4AccessTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineProtocolAccessRules) validateNfs4AccessType(formats strfmt.Registry) error {
	if swag.IsZero(m.Nfs4AccessType) { // not required
		return nil
	}

	// value enum
	if err := m.validateNfs4AccessTypeEnum("protocol_access_rules"+"."+"nfs4_access_type", "body", *m.Nfs4AccessType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nfs service inline protocol access rules based on the context it is used
func (m *NfsServiceInlineProtocolAccessRules) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifsAccessType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNfs3AccessType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNfs4AccessType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineProtocolAccessRules) contextValidateCifsAccessType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protocol_access_rules"+"."+"cifs_access_type", "body", m.CifsAccessType); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineProtocolAccessRules) contextValidateNfs3AccessType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protocol_access_rules"+"."+"nfs3_access_type", "body", m.Nfs3AccessType); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineProtocolAccessRules) contextValidateNfs4AccessType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "protocol_access_rules"+"."+"nfs4_access_type", "body", m.Nfs4AccessType); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineProtocolAccessRules) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineProtocolAccessRules) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineProtocolAccessRules
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineProtocolInlineV3Features nfs service inline protocol inline v3 features
//
// swagger:model nfs_service_inline_protocol_inline_v3_features
type NfsServiceInlineProtocolInlineV3Features struct {

	// Specifies whether the dropping of a connection when an NFSv3 request is dropped is enabled.
	ConnectionDrop *bool `json:"connection_drop,omitempty"`

	// Specifies whether NFSv3 EJUKEBOX error is enabled.
	EjukeboxEnabled *bool `json:"ejukebox_enabled,omitempty"`

	// Specifies whether the change in FSID as NFSv3 clients traverse filesystems should be shown.
	FsidChange *bool `json:"fsid_change,omitempty"`

	// Specifies whether hiding a snapshot directory under a NFSv3 mount point is enabled.
	HideSnapshotEnabled *bool `json:"hide_snapshot_enabled,omitempty"`

	// Specifies which port the NFS mount daemon (mountd) uses.
	MountDaemonPort *int64 `json:"mount_daemon_port,omitempty"`

	// Specifies whether the SVM allows MOUNT protocol calls only from privileged ports (port numbers less than 1024).
	MountRootOnly *bool `json:"mount_root_only,omitempty"`

	// Specifies which port the Network lock manager uses.
	NetworkLockManagerPort *int64 `json:"network_lock_manager_port,omitempty"`

	// Specifies which port the Network status monitor port uses.
	NetworkStatusMonitorPort *int64 `json:"network_status_monitor_port,omitempty"`

	// Specifies which port the NFS quota daemon port uses.
	RquotaDaemonPort *int64 `json:"rquota_daemon_port,omitempty"`
}

// Validate validates this nfs service inline protocol inline v3 features
func (m *NfsServiceInlineProtocolInlineV3Features) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nfs service inline protocol inline v3 features based on context it is used
func (m *NfsServiceInlineProtocolInlineV3Features) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineProtocolInlineV3Features) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineProtocolInlineV3Features) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineProtocolInlineV3Features
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineProtocolInlineV40Features nfs service inline protocol inline v40 features
//
// swagger:model nfs_service_inline_protocol_inline_v40_features
type NfsServiceInlineProtocolInlineV40Features struct {

	// Specifies whether NFSv4.0 ACLs is enabled.
	ACLEnabled *bool `json:"acl_enabled,omitempty"`

	// Specifies the maximum number of aces in a NFSv4.0 ACL.
	// Example: 500
	// Maximum: 1024
	// Minimum: 192
	ACLMaxAces *int64 `json:"acl_max_aces,omitempty"`

	// Specifies if the NFSv4 ACL is preserved or dropped when chmod is performed. In unified security style, this parameter also specifies if NTFS file permissions are preserved or dropped when chmod, chgrp, or chown are performed.
	ACLPreserve *bool `json:"acl_preserve,omitempty"`

	// Specifies whether NFSv4.0 Read Delegation is enabled.
	ReadDelegationEnabled *bool `json:"read_delegation_enabled,omitempty"`

	// Specifies whether NFSv4.0 referrals is enabled.
	ReferralsEnabled *bool `json:"referrals_enabled,omitempty"`

	// Specifies whether NFSv4.0 Write Delegation is enabled.
	WriteDelegationEnabled *bool `json:"write_delegation_enabled,omitempty"`
}

// Validate validates this nfs service inline protocol inline v40 features
func (m *NfsServiceInlineProtocolInlineV40Features) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateACLMaxAces(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineProtocolInlineV40Features) validateACLMaxAces(formats strfmt.Registry) error {
	if swag.IsZero(m.ACLMaxAces) { // not required
		return nil
	}

	if err := validate.MinimumInt("protocol"+"."+"v40_features"+"."+"acl_max_aces", "body", *m.ACLMaxAces, 192, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("protocol"+"."+"v40_features"+"."+"acl_max_aces", "body", *m.ACLMaxAces, 1024, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nfs service inline protocol inline v40 features based on context it is used
func (m *NfsServiceInlineProtocolInlineV40Features) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineProtocolInlineV40Features) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineProtocolInlineV40Features) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineProtocolInlineV40Features
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineProtocolInlineV41Features nfs service inline protocol inline v41 features
//
// swagger:model nfs_service_inline_protocol_inline_v41_features
type NfsServiceInlineProtocolInlineV41Features struct {

	// Specifies whether NFSv4.1 or later ACLs is enabled.
	ACLEnabled *bool `json:"acl_enabled,omitempty"`

	// Specifies the NFSv4.1 or later implementation ID domain.
	ImplementationDomain *string `json:"implementation_domain,omitempty"`

	// Specifies the NFSv4.1 or later implementation ID name.
	ImplementationName *string `json:"implementation_name,omitempty"`

	// Specifies whether NFSv4.1 or later Parallel NFS is enabled.
	PnfsEnabled *bool `json:"pnfs_enabled,omitempty"`

	// Specifies whether NFSv4.1 or later Read Delegation is enabled.
	ReadDelegationEnabled *bool `json:"read_delegation_enabled,omitempty"`

	// Specifies whether NFSv4.1 referrals is enabled.
	ReferralsEnabled *bool `json:"referrals_enabled,omitempty"`

	// Specifies whether NFSv4.1 or later trunking is enabled.
	TrunkingEnabled *bool `json:"trunking_enabled,omitempty"`

	// Specifies whether NFSv4.1 or later Write Delegation is enabled.
	WriteDelegationEnabled *bool `json:"write_delegation_enabled,omitempty"`
}

// Validate validates this nfs service inline protocol inline v41 features
func (m *NfsServiceInlineProtocolInlineV41Features) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nfs service inline protocol inline v41 features based on context it is used
func (m *NfsServiceInlineProtocolInlineV41Features) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineProtocolInlineV41Features) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineProtocolInlineV41Features) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineProtocolInlineV41Features
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineProtocolInlineV42Features nfs service inline protocol inline v42 features
//
// swagger:model nfs_service_inline_protocol_inline_v42_features
type NfsServiceInlineProtocolInlineV42Features struct {

	// Specifies whether NFSv4.2 or later security label is enabled.
	SeclabelEnabled *bool `json:"seclabel_enabled,omitempty"`

	// Specifies whether NFSv4.2 or later sparsefile operation is enabled.
	SparsefileOpsEnabled *bool `json:"sparsefile_ops_enabled,omitempty"`

	// Specifies whether NFSv4.2 or later extended attributes is enabled.
	XattrsEnabled *bool `json:"xattrs_enabled,omitempty"`
}

// Validate validates this nfs service inline protocol inline v42 features
func (m *NfsServiceInlineProtocolInlineV42Features) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nfs service inline protocol inline v42 features based on context it is used
func (m *NfsServiceInlineProtocolInlineV42Features) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineProtocolInlineV42Features) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineProtocolInlineV42Features) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineProtocolInlineV42Features
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineQtree nfs service inline qtree
//
// swagger:model nfs_service_inline_qtree
type NfsServiceInlineQtree struct {

	// Specifies whether qtree export is enabled.
	// Read Only: true
	ExportEnabled *bool `json:"export_enabled,omitempty"`

	// Specifies whether qtree export validation is enabled.
	ValidateExport *bool `json:"validate_export,omitempty"`
}

// Validate validates this nfs service inline qtree
func (m *NfsServiceInlineQtree) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline qtree based on the context it is used
func (m *NfsServiceInlineQtree) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExportEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineQtree) contextValidateExportEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qtree"+"."+"export_enabled", "body", m.ExportEnabled); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineQtree) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineQtree) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineQtree
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineRoot nfs service inline root
//
// swagger:model nfs_service_inline_root
type NfsServiceInlineRoot struct {

	// Specifies whether Windows ACLs affect root access from NFS. If this option is enabled, root access from NFS ignores the NT ACL set on the file or directory.
	IgnoreNtACL *bool `json:"ignore_nt_acl,omitempty"`

	// Specifies if permission checks are to be skipped for NFS WRITE calls from root/owner. For copying read-only files to a destination folder which has inheritable ACLs, this option must be enabled.
	SkipWritePermissionCheck *bool `json:"skip_write_permission_check,omitempty"`
}

// Validate validates this nfs service inline root
func (m *NfsServiceInlineRoot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nfs service inline root based on context it is used
func (m *NfsServiceInlineRoot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineRoot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineRoot) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineRoot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineSecurity nfs service inline security
//
// swagger:model nfs_service_inline_security
type NfsServiceInlineSecurity struct {

	// Specifies whether file ownership can be changed only by the superuser, or if a non-root user can also change file ownership. If you set this parameter to restricted, file ownership can be changed only by the superuser, even though the on-disk permissions allow a non-root user to change file ownership. If you set this parameter to unrestricted, file ownership can be changed by the superuser and by the non-root user, depending upon the access granted by on-disk permissions. If you set this parameter to use_export_policy, file ownership can be changed in accordance with the relevant export rules.
	// Enum: ["restricted","unrestricted","use_export_policy"]
	ChownMode *string `json:"chown_mode,omitempty"`

	// Controls the permissions that are displayed to NFSv3 and NFSv4 clients on a file or directory that has an NT ACL set. When true, the displayed permissions are based on the maximum access granted by the NT ACL to any user. When false, the displayed permissions are based on the minimum access granted by the NT ACL to any user.
	NtACLDisplayPermission *bool `json:"nt_acl_display_permission,omitempty"`

	// Specifies how NFSv3 security changes affect NTFS volumes. If you set this parameter to ignore, ONTAP ignores NFSv3 security changes. If you set this parameter to fail, this overrides the UNIX security options set in the relevant export rules. If you set this parameter to use_export_policy, ONTAP processes NFSv3 security changes in accordance with the relevant export rules.
	// Enum: ["ignore","fail","use_export_policy"]
	NtfsUnixSecurity *string `json:"ntfs_unix_security,omitempty"`

	// Specifies the permitted encryption types for Kerberos over NFS.
	PermittedEncryptionTypes []*string `json:"permitted_encryption_types,omitempty"`

	// Specifies, in seconds, the amount of time a RPCSEC_GSS context is permitted to remain unused before it is deleted.
	RpcsecContextIdle *int64 `json:"rpcsec_context_idle,omitempty"`
}

// Validate validates this nfs service inline security
func (m *NfsServiceInlineSecurity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChownMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNtfsUnixSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermittedEncryptionTypes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nfsServiceInlineSecurityTypeChownModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["restricted","unrestricted","use_export_policy"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineSecurityTypeChownModePropEnum = append(nfsServiceInlineSecurityTypeChownModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_security
	// NfsServiceInlineSecurity
	// chown_mode
	// ChownMode
	// restricted
	// END DEBUGGING
	// NfsServiceInlineSecurityChownModeRestricted captures enum value "restricted"
	NfsServiceInlineSecurityChownModeRestricted string = "restricted"

	// BEGIN DEBUGGING
	// nfs_service_inline_security
	// NfsServiceInlineSecurity
	// chown_mode
	// ChownMode
	// unrestricted
	// END DEBUGGING
	// NfsServiceInlineSecurityChownModeUnrestricted captures enum value "unrestricted"
	NfsServiceInlineSecurityChownModeUnrestricted string = "unrestricted"

	// BEGIN DEBUGGING
	// nfs_service_inline_security
	// NfsServiceInlineSecurity
	// chown_mode
	// ChownMode
	// use_export_policy
	// END DEBUGGING
	// NfsServiceInlineSecurityChownModeUseExportPolicy captures enum value "use_export_policy"
	NfsServiceInlineSecurityChownModeUseExportPolicy string = "use_export_policy"
)

// prop value enum
func (m *NfsServiceInlineSecurity) validateChownModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineSecurityTypeChownModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineSecurity) validateChownMode(formats strfmt.Registry) error {
	if swag.IsZero(m.ChownMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateChownModeEnum("security"+"."+"chown_mode", "body", *m.ChownMode); err != nil {
		return err
	}

	return nil
}

var nfsServiceInlineSecurityTypeNtfsUnixSecurityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ignore","fail","use_export_policy"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineSecurityTypeNtfsUnixSecurityPropEnum = append(nfsServiceInlineSecurityTypeNtfsUnixSecurityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_security
	// NfsServiceInlineSecurity
	// ntfs_unix_security
	// NtfsUnixSecurity
	// ignore
	// END DEBUGGING
	// NfsServiceInlineSecurityNtfsUnixSecurityIgnore captures enum value "ignore"
	NfsServiceInlineSecurityNtfsUnixSecurityIgnore string = "ignore"

	// BEGIN DEBUGGING
	// nfs_service_inline_security
	// NfsServiceInlineSecurity
	// ntfs_unix_security
	// NtfsUnixSecurity
	// fail
	// END DEBUGGING
	// NfsServiceInlineSecurityNtfsUnixSecurityFail captures enum value "fail"
	NfsServiceInlineSecurityNtfsUnixSecurityFail string = "fail"

	// BEGIN DEBUGGING
	// nfs_service_inline_security
	// NfsServiceInlineSecurity
	// ntfs_unix_security
	// NtfsUnixSecurity
	// use_export_policy
	// END DEBUGGING
	// NfsServiceInlineSecurityNtfsUnixSecurityUseExportPolicy captures enum value "use_export_policy"
	NfsServiceInlineSecurityNtfsUnixSecurityUseExportPolicy string = "use_export_policy"
)

// prop value enum
func (m *NfsServiceInlineSecurity) validateNtfsUnixSecurityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineSecurityTypeNtfsUnixSecurityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineSecurity) validateNtfsUnixSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.NtfsUnixSecurity) { // not required
		return nil
	}

	// value enum
	if err := m.validateNtfsUnixSecurityEnum("security"+"."+"ntfs_unix_security", "body", *m.NtfsUnixSecurity); err != nil {
		return err
	}

	return nil
}

var nfsServiceInlineSecurityPermittedEncryptionTypesItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aes_256","aes_128","des3","des"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineSecurityPermittedEncryptionTypesItemsEnum = append(nfsServiceInlineSecurityPermittedEncryptionTypesItemsEnum, v)
	}
}

func (m *NfsServiceInlineSecurity) validatePermittedEncryptionTypesItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineSecurityPermittedEncryptionTypesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineSecurity) validatePermittedEncryptionTypes(formats strfmt.Registry) error {
	if swag.IsZero(m.PermittedEncryptionTypes) { // not required
		return nil
	}

	for i := 0; i < len(m.PermittedEncryptionTypes); i++ {
		if swag.IsZero(m.PermittedEncryptionTypes[i]) { // not required
			continue
		}

		// value enum
		if err := m.validatePermittedEncryptionTypesItemsEnum("security"+"."+"permitted_encryption_types"+"."+strconv.Itoa(i), "body", *m.PermittedEncryptionTypes[i]); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validates this nfs service inline security based on context it is used
func (m *NfsServiceInlineSecurity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineSecurity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineSecurity) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineSecurity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatistics Realtime performance numbers, such as IOPS latency and throughput, for SVM-NFS protocol.
//
// swagger:model nfs_service_inline_statistics
type NfsServiceInlineStatistics struct {

	// v3
	V3 *NfsServiceInlineStatisticsInlineV3 `json:"v3,omitempty"`

	// v4
	V4 *NfsServiceInlineStatisticsInlineV4 `json:"v4,omitempty"`

	// v41
	V41 *NfsServiceInlineStatisticsInlineV41 `json:"v41,omitempty"`
}

// Validate validates this nfs service inline statistics
func (m *NfsServiceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateV3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV41(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineStatistics) validateV3(formats strfmt.Registry) error {
	if swag.IsZero(m.V3) { // not required
		return nil
	}

	if m.V3 != nil {
		if err := m.V3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v3")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatistics) validateV4(formats strfmt.Registry) error {
	if swag.IsZero(m.V4) { // not required
		return nil
	}

	if m.V4 != nil {
		if err := m.V4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v4")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatistics) validateV41(formats strfmt.Registry) error {
	if swag.IsZero(m.V41) { // not required
		return nil
	}

	if m.V41 != nil {
		if err := m.V41.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v41")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service inline statistics based on the context it is used
func (m *NfsServiceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateV3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV41(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineStatistics) contextValidateV3(ctx context.Context, formats strfmt.Registry) error {

	if m.V3 != nil {
		if err := m.V3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v3")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatistics) contextValidateV4(ctx context.Context, formats strfmt.Registry) error {

	if m.V4 != nil {
		if err := m.V4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v4")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatistics) contextValidateV41(ctx context.Context, formats strfmt.Registry) error {

	if m.V41 != nil {
		if err := m.V41.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v41")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV3 The NFSv3 operations
//
// swagger:model nfs_service_inline_statistics_inline_v3
type NfsServiceInlineStatisticsInlineV3 struct {

	// iops raw
	IopsRaw *NfsServiceInlineStatisticsInlineV3InlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NfsServiceInlineStatisticsInlineV3InlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *NfsServiceInlineStatisticsInlineV3InlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nfs service inline statistics inline v3
func (m *NfsServiceInlineStatisticsInlineV3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v3" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v3" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineStatisticsInlineV3TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineStatisticsInlineV3TypeStatusPropEnum = append(nfsServiceInlineStatisticsInlineV3TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// ok
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusOk captures enum value "ok"
	NfsServiceInlineStatisticsInlineV3StatusOk string = "ok"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// error
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusError captures enum value "error"
	NfsServiceInlineStatisticsInlineV3StatusError string = "error"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusPartialNoData captures enum value "partial_no_data"
	NfsServiceInlineStatisticsInlineV3StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusPartialNoResponse captures enum value "partial_no_response"
	NfsServiceInlineStatisticsInlineV3StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusPartialOtherError captures enum value "partial_other_error"
	NfsServiceInlineStatisticsInlineV3StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusNegativeDelta captures enum value "negative_delta"
	NfsServiceInlineStatisticsInlineV3StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusNotFound captures enum value "not_found"
	NfsServiceInlineStatisticsInlineV3StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusBackfilledData captures enum value "backfilled_data"
	NfsServiceInlineStatisticsInlineV3StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NfsServiceInlineStatisticsInlineV3StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusInconsistentOldData captures enum value "inconsistent_old_data"
	NfsServiceInlineStatisticsInlineV3StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v3
	// NfsServiceInlineStatisticsInlineV3
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV3StatusPartialNoUUID captures enum value "partial_no_uuid"
	NfsServiceInlineStatisticsInlineV3StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NfsServiceInlineStatisticsInlineV3) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineStatisticsInlineV3TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"v3"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v3" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"v3"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nfs service inline statistics inline v3 based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v3" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v3" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"v3"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v3" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV3) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"v3"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV3) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV3InlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nfs_service_inline_statistics_inline_v3_inline_iops_raw
type NfsServiceInlineStatisticsInlineV3InlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v3 inline iops raw
func (m *NfsServiceInlineStatisticsInlineV3InlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v3 inline iops raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV3InlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV3InlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV3InlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV3InlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV3InlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nfs_service_inline_statistics_inline_v3_inline_latency_raw
type NfsServiceInlineStatisticsInlineV3InlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v3 inline latency raw
func (m *NfsServiceInlineStatisticsInlineV3InlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v3 inline latency raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV3InlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV3InlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV3InlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV3InlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV3InlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nfs_service_inline_statistics_inline_v3_inline_throughput_raw
type NfsServiceInlineStatisticsInlineV3InlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v3 inline throughput raw
func (m *NfsServiceInlineStatisticsInlineV3InlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v3 inline throughput raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV3InlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV3InlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV3InlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV3InlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV4 The NFSv4 operations
//
// swagger:model nfs_service_inline_statistics_inline_v4
type NfsServiceInlineStatisticsInlineV4 struct {

	// iops raw
	IopsRaw *NfsServiceInlineStatisticsInlineV4InlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NfsServiceInlineStatisticsInlineV4InlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *NfsServiceInlineStatisticsInlineV4InlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nfs service inline statistics inline v4
func (m *NfsServiceInlineStatisticsInlineV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v4" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v4" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineStatisticsInlineV4TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineStatisticsInlineV4TypeStatusPropEnum = append(nfsServiceInlineStatisticsInlineV4TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// ok
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusOk captures enum value "ok"
	NfsServiceInlineStatisticsInlineV4StatusOk string = "ok"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// error
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusError captures enum value "error"
	NfsServiceInlineStatisticsInlineV4StatusError string = "error"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusPartialNoData captures enum value "partial_no_data"
	NfsServiceInlineStatisticsInlineV4StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusPartialNoResponse captures enum value "partial_no_response"
	NfsServiceInlineStatisticsInlineV4StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusPartialOtherError captures enum value "partial_other_error"
	NfsServiceInlineStatisticsInlineV4StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusNegativeDelta captures enum value "negative_delta"
	NfsServiceInlineStatisticsInlineV4StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusNotFound captures enum value "not_found"
	NfsServiceInlineStatisticsInlineV4StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusBackfilledData captures enum value "backfilled_data"
	NfsServiceInlineStatisticsInlineV4StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NfsServiceInlineStatisticsInlineV4StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusInconsistentOldData captures enum value "inconsistent_old_data"
	NfsServiceInlineStatisticsInlineV4StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v4
	// NfsServiceInlineStatisticsInlineV4
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV4StatusPartialNoUUID captures enum value "partial_no_uuid"
	NfsServiceInlineStatisticsInlineV4StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NfsServiceInlineStatisticsInlineV4) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineStatisticsInlineV4TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"v4"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v4" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"v4"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nfs service inline statistics inline v4 based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v4" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v4" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"v4"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v4" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV4) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"v4"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV4) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV41 The NFSv4.1 operations
//
// swagger:model nfs_service_inline_statistics_inline_v41
type NfsServiceInlineStatisticsInlineV41 struct {

	// iops raw
	IopsRaw *NfsServiceInlineStatisticsInlineV41InlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NfsServiceInlineStatisticsInlineV41InlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *NfsServiceInlineStatisticsInlineV41InlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nfs service inline statistics inline v41
func (m *NfsServiceInlineStatisticsInlineV41) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v41" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v41" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nfsServiceInlineStatisticsInlineV41TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nfsServiceInlineStatisticsInlineV41TypeStatusPropEnum = append(nfsServiceInlineStatisticsInlineV41TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// ok
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusOk captures enum value "ok"
	NfsServiceInlineStatisticsInlineV41StatusOk string = "ok"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// error
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusError captures enum value "error"
	NfsServiceInlineStatisticsInlineV41StatusError string = "error"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusPartialNoData captures enum value "partial_no_data"
	NfsServiceInlineStatisticsInlineV41StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusPartialNoResponse captures enum value "partial_no_response"
	NfsServiceInlineStatisticsInlineV41StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusPartialOtherError captures enum value "partial_other_error"
	NfsServiceInlineStatisticsInlineV41StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusNegativeDelta captures enum value "negative_delta"
	NfsServiceInlineStatisticsInlineV41StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusNotFound captures enum value "not_found"
	NfsServiceInlineStatisticsInlineV41StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusBackfilledData captures enum value "backfilled_data"
	NfsServiceInlineStatisticsInlineV41StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NfsServiceInlineStatisticsInlineV41StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusInconsistentOldData captures enum value "inconsistent_old_data"
	NfsServiceInlineStatisticsInlineV41StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nfs_service_inline_statistics_inline_v41
	// NfsServiceInlineStatisticsInlineV41
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NfsServiceInlineStatisticsInlineV41StatusPartialNoUUID captures enum value "partial_no_uuid"
	NfsServiceInlineStatisticsInlineV41StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NfsServiceInlineStatisticsInlineV41) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nfsServiceInlineStatisticsInlineV41TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"v41"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v41" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"v41"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nfs service inline statistics inline v41 based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV41) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v41" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v41" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"v41"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "v41" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NfsServiceInlineStatisticsInlineV41) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"v41"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV41) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV41) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV41
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV41InlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nfs_service_inline_statistics_inline_v41_inline_iops_raw
type NfsServiceInlineStatisticsInlineV41InlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v41 inline iops raw
func (m *NfsServiceInlineStatisticsInlineV41InlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v41 inline iops raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV41InlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV41InlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV41InlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV41InlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV41InlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nfs_service_inline_statistics_inline_v41_inline_latency_raw
type NfsServiceInlineStatisticsInlineV41InlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v41 inline latency raw
func (m *NfsServiceInlineStatisticsInlineV41InlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v41 inline latency raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV41InlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV41InlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV41InlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV41InlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV41InlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nfs_service_inline_statistics_inline_v41_inline_throughput_raw
type NfsServiceInlineStatisticsInlineV41InlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v41 inline throughput raw
func (m *NfsServiceInlineStatisticsInlineV41InlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v41 inline throughput raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV41InlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV41InlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV41InlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV41InlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV4InlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nfs_service_inline_statistics_inline_v4_inline_iops_raw
type NfsServiceInlineStatisticsInlineV4InlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v4 inline iops raw
func (m *NfsServiceInlineStatisticsInlineV4InlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v4 inline iops raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV4InlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV4InlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV4InlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV4InlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV4InlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nfs_service_inline_statistics_inline_v4_inline_latency_raw
type NfsServiceInlineStatisticsInlineV4InlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v4 inline latency raw
func (m *NfsServiceInlineStatisticsInlineV4InlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v4 inline latency raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV4InlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV4InlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV4InlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV4InlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineStatisticsInlineV4InlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nfs_service_inline_statistics_inline_v4_inline_throughput_raw
type NfsServiceInlineStatisticsInlineV4InlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nfs service inline statistics inline v4 inline throughput raw
func (m *NfsServiceInlineStatisticsInlineV4InlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nfs service inline statistics inline v4 inline throughput raw based on the context it is used
func (m *NfsServiceInlineStatisticsInlineV4InlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV4InlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineStatisticsInlineV4InlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineStatisticsInlineV4InlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model nfs_service_inline_svm
type NfsServiceInlineSvm struct {

	// links
	Links *NfsServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nfs service inline svm
func (m *NfsServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service inline svm based on the context it is used
func (m *NfsServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineSvmInlineLinks nfs service inline svm inline links
//
// swagger:model nfs_service_inline_svm_inline__links
type NfsServiceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nfs service inline svm inline links
func (m *NfsServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs service inline svm inline links based on the context it is used
func (m *NfsServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineTransport nfs service inline transport
//
// swagger:model nfs_service_inline_transport
type NfsServiceInlineTransport struct {

	// Specifies whether RDMA transport is enabled for the NFS server.
	//
	RdmaEnabled *bool `json:"rdma_enabled,omitempty"`

	// Specifies whether TCP transports are enabled on the server.
	//
	TCPEnabled *bool `json:"tcp_enabled,omitempty"`

	// Specifies the maximum transfer size in bytes, that the storage system negotiates with the client for TCP transport of data for NFSv3 and NFSv4.x protocols. The range is 8192 to 1048576.
	// Example: 16384
	// Maximum: 1.048576e+06
	// Minimum: 8192
	TCPMaxTransferSize *int64 `json:"tcp_max_transfer_size,omitempty"`

	// Specifies whether UDP transports are enabled on the server.
	//
	UDPEnabled *bool `json:"udp_enabled,omitempty"`
}

// Validate validates this nfs service inline transport
func (m *NfsServiceInlineTransport) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTCPMaxTransferSize(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NfsServiceInlineTransport) validateTCPMaxTransferSize(formats strfmt.Registry) error {
	if swag.IsZero(m.TCPMaxTransferSize) { // not required
		return nil
	}

	if err := validate.MinimumInt("transport"+"."+"tcp_max_transfer_size", "body", *m.TCPMaxTransferSize, 8192, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("transport"+"."+"tcp_max_transfer_size", "body", *m.TCPMaxTransferSize, 1.048576e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nfs service inline transport based on context it is used
func (m *NfsServiceInlineTransport) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineTransport) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineTransport) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineTransport
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NfsServiceInlineWindows nfs service inline windows
//
// swagger:model nfs_service_inline_windows
type NfsServiceInlineWindows struct {

	// Specifies the default Windows user for the NFS server.
	DefaultUser *string `json:"default_user,omitempty"`

	// Specifies whether or not the mapping of an unknown UID to the default Windows user is enabled.
	MapUnknownUIDToDefaultUser *bool `json:"map_unknown_uid_to_default_user,omitempty"`

	// Specifies whether NFSv3 MS-DOS client support is enabled.
	V3MsDosClientEnabled *bool `json:"v3_ms_dos_client_enabled,omitempty"`
}

// Validate validates this nfs service inline windows
func (m *NfsServiceInlineWindows) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nfs service inline windows based on context it is used
func (m *NfsServiceInlineWindows) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NfsServiceInlineWindows) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NfsServiceInlineWindows) UnmarshalBinary(b []byte) error {
	var res NfsServiceInlineWindows
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
