// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NisService nis service
//
// swagger:model nis_service
type NisService struct {

	// links
	Links *NisServiceInlineLinks `json:"_links,omitempty"`

	// The NIS domain to which this configuration belongs.
	//
	// Example: domainA.example.com
	// Max Length: 64
	// Min Length: 1
	Domain *string `json:"domain,omitempty"`

	// An array of objects where each object represents the NIS server and it's status for a given NIS domain. It is an advanced field.
	// Read Only: true
	NisServiceInlineBindingDetails []*NisServiceInlineBindingDetailsInlineArrayItem `json:"binding_details,omitempty"`

	// nis service inline bound servers
	// Read Only: true
	NisServiceInlineBoundServers []*string `json:"bound_servers,omitempty"`

	// A list of hostnames or IP addresses of NIS servers used
	// by the NIS domain configuration.
	//
	// Example: ["10.10.10.10","example.com"]
	// Max Items: 10
	NisServiceInlineServers []*string `json:"servers,omitempty"`

	// svm
	Svm *NisServiceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this nis service
func (m *NisService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNisServiceInlineBindingDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNisServiceInlineBoundServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNisServiceInlineServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisService) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NisService) validateDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.Domain) { // not required
		return nil
	}

	if err := validate.MinLength("domain", "body", *m.Domain, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("domain", "body", *m.Domain, 64); err != nil {
		return err
	}

	return nil
}

func (m *NisService) validateNisServiceInlineBindingDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.NisServiceInlineBindingDetails) { // not required
		return nil
	}

	for i := 0; i < len(m.NisServiceInlineBindingDetails); i++ {
		if swag.IsZero(m.NisServiceInlineBindingDetails[i]) { // not required
			continue
		}

		if m.NisServiceInlineBindingDetails[i] != nil {
			if err := m.NisServiceInlineBindingDetails[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("binding_details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NisService) validateNisServiceInlineBoundServers(formats strfmt.Registry) error {
	if swag.IsZero(m.NisServiceInlineBoundServers) { // not required
		return nil
	}

	for i := 0; i < len(m.NisServiceInlineBoundServers); i++ {
		if swag.IsZero(m.NisServiceInlineBoundServers[i]) { // not required
			continue
		}

		if err := validate.MinLength("bound_servers"+"."+strconv.Itoa(i), "body", *m.NisServiceInlineBoundServers[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength("bound_servers"+"."+strconv.Itoa(i), "body", *m.NisServiceInlineBoundServers[i], 255); err != nil {
			return err
		}

	}

	return nil
}

func (m *NisService) validateNisServiceInlineServers(formats strfmt.Registry) error {
	if swag.IsZero(m.NisServiceInlineServers) { // not required
		return nil
	}

	iNisServiceInlineServersSize := int64(len(m.NisServiceInlineServers))

	if err := validate.MaxItems("servers", "body", iNisServiceInlineServersSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.NisServiceInlineServers); i++ {
		if swag.IsZero(m.NisServiceInlineServers[i]) { // not required
			continue
		}

		if err := validate.MinLength("servers"+"."+strconv.Itoa(i), "body", *m.NisServiceInlineServers[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength("servers"+"."+strconv.Itoa(i), "body", *m.NisServiceInlineServers[i], 255); err != nil {
			return err
		}

	}

	return nil
}

func (m *NisService) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service based on the context it is used
func (m *NisService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNisServiceInlineBindingDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNisServiceInlineBoundServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisService) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NisService) contextValidateNisServiceInlineBindingDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "binding_details", "body", []*NisServiceInlineBindingDetailsInlineArrayItem(m.NisServiceInlineBindingDetails)); err != nil {
		return err
	}

	for i := 0; i < len(m.NisServiceInlineBindingDetails); i++ {

		if m.NisServiceInlineBindingDetails[i] != nil {
			if err := m.NisServiceInlineBindingDetails[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("binding_details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NisService) contextValidateNisServiceInlineBoundServers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "bound_servers", "body", []*string(m.NisServiceInlineBoundServers)); err != nil {
		return err
	}

	return nil
}

func (m *NisService) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NisService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NisService) UnmarshalBinary(b []byte) error {
	var res NisService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NisServiceInlineBindingDetailsInlineArrayItem nis service inline binding details inline array item
//
// swagger:model nis_service_inline_binding_details_inline_array_item
type NisServiceInlineBindingDetailsInlineArrayItem struct {

	// Hostname/IP address of the NIS server in the domain.
	// Max Length: 255
	// Min Length: 1
	Server *string `json:"server,omitempty"`

	// status
	Status *BindingStatus `json:"status,omitempty"`
}

// Validate validates this nis service inline binding details inline array item
func (m *NisServiceInlineBindingDetailsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisServiceInlineBindingDetailsInlineArrayItem) validateServer(formats strfmt.Registry) error {
	if swag.IsZero(m.Server) { // not required
		return nil
	}

	if err := validate.MinLength("server", "body", *m.Server, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("server", "body", *m.Server, 255); err != nil {
		return err
	}

	return nil
}

func (m *NisServiceInlineBindingDetailsInlineArrayItem) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service inline binding details inline array item based on the context it is used
func (m *NisServiceInlineBindingDetailsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisServiceInlineBindingDetailsInlineArrayItem) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NisServiceInlineBindingDetailsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NisServiceInlineBindingDetailsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NisServiceInlineBindingDetailsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NisServiceInlineLinks nis service inline links
//
// swagger:model nis_service_inline__links
type NisServiceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nis service inline links
func (m *NisServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service inline links based on the context it is used
func (m *NisServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NisServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NisServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NisServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NisServiceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model nis_service_inline_svm
type NisServiceInlineSvm struct {

	// links
	Links *NisServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nis service inline svm
func (m *NisServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service inline svm based on the context it is used
func (m *NisServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NisServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NisServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NisServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NisServiceInlineSvmInlineLinks nis service inline svm inline links
//
// swagger:model nis_service_inline_svm_inline__links
type NisServiceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nis service inline svm inline links
func (m *NisServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nis service inline svm inline links based on the context it is used
func (m *NisServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NisServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NisServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NisServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NisServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
