// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Node Complete node information
//
// swagger:model node
type Node struct {

	// links
	Links *NodeInlineLinks `json:"_links,omitempty"`

	// Anti ransomware version.
	// Example: 1.0
	// Read Only: true
	AntiRansomwareVersion *string `json:"anti_ransomware_version,omitempty"`

	// cluster interface
	ClusterInterface *NodeInlineClusterInterface `json:"cluster_interface,omitempty"`

	// controller
	Controller *NodeInlineController `json:"controller,omitempty"`

	// The current or "wall clock" time of the node in ISO-8601 date, time, and time zone format.
	// The ISO-8601 date and time are localized based on the ONTAP cluster's timezone setting.
	//
	// Example: 2019-04-17 11:49:26-04:00
	// Read Only: true
	// Format: date-time
	Date *strfmt.DateTime `json:"date,omitempty"`

	// external cache
	ExternalCache *NodeInlineExternalCache `json:"external_cache,omitempty"`

	// external cache bypass
	ExternalCacheBypass *NodeInlineExternalCacheBypass `json:"external_cache_bypass,omitempty"`

	// ha
	Ha *NodeInlineHa `json:"ha,omitempty"`

	// hw assist
	HwAssist *NodeInlineHwAssist `json:"hw_assist,omitempty"`

	// Specifies whether or not the node is in spares low condition.
	// Read Only: true
	IsSparesLow *bool `json:"is_spares_low,omitempty"`

	// location
	// Example: rack 2 row 5
	Location *string `json:"location,omitempty"`

	// management interface
	ManagementInterface *NodeInlineManagementInterface `json:"management_interface,omitempty"`

	// Possible values:
	// * <i>available</i> - A node is detected on the internal cluster network and can be added to the cluster.  Nodes that have a membership of "available" are not returned when a GET request is called when the cluster exists. Provide a query on the "membership" property for <i>available</i> to scan for nodes on the cluster network. Nodes that have a membership of "available" are returned automatically before a cluster is created.
	// * <i>joining</i> - Joining nodes are in the process of being added to the cluster. The node might be progressing through the steps to become a member or might have failed. The job to add the node or create the cluster provides details on the current progress of the node.
	// * <i>member</i> - Nodes that are members have successfully joined the cluster.
	//
	// Read Only: true
	// Enum: ["available","joining","member"]
	Membership *string `json:"membership,omitempty"`

	// metric
	Metric *NodeInlineMetric `json:"metric,omitempty"`

	// metrocluster
	Metrocluster *NodeInlineMetrocluster `json:"metrocluster,omitempty"`

	// model
	// Example: FAS3070
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// name
	// Example: node-01
	Name *string `json:"name,omitempty"`

	// node inline cluster interfaces
	// Read Only: true
	NodeInlineClusterInterfaces []*NodeInlineClusterInterfacesInlineArrayItem `json:"cluster_interfaces,omitempty"`

	// node inline management interfaces
	// Read Only: true
	NodeInlineManagementInterfaces []*NodeInlineManagementInterfacesInlineArrayItem `json:"management_interfaces,omitempty"`

	// Storage availability zones associated with the node.
	// Read Only: true
	NodeInlineStorageAvailabilityZones []*StorageAvailabilityZoneReference `json:"storage_availability_zones,omitempty"`

	// nvlog
	Nvlog *NodeInlineNvlog `json:"nvlog,omitempty"`

	// nvram
	Nvram *NodeInlineNvram `json:"nvram,omitempty"`

	// Owner of the node.
	// Example: Example Corp
	Owner *string `json:"owner,omitempty"`

	// serial number
	// Example: 4048820-60-9
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// service processor
	ServiceProcessor *NodeInlineServiceProcessor `json:"service_processor,omitempty"`

	// snaplock
	Snaplock *NodeInlineSnaplock `json:"snaplock,omitempty"`

	// State of the node:
	// * <i>up</i> - Node is up and operational.
	// * <i>booting</i> - Node is booting up.
	// * <i>down</i> - Node has stopped or is dumping core.
	// * <i>taken_over</i> - Node has been taken over by its HA partner and is not yet waiting for giveback.
	// * <i>waiting_for_giveback</i> - Node has been taken over by its HA partner and is waiting for the HA partner to giveback disks.
	// * <i>degraded</i> - Node has one or more critical services offline.
	// * <i>unknown</i> - Node or its HA partner cannot be contacted and there is no information on the node's state.
	//
	// Read Only: true
	// Enum: ["up","booting","down","taken_over","waiting_for_giveback","degraded","unknown"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *NodeInlineStatistics `json:"statistics,omitempty"`

	// The storage configuration in the system. Possible values:
	// * <i>mixed_path</i>
	// * <i>single_path</i>
	// * <i>multi_path</i>
	// * <i>tri_path</i>
	// * <i>quad_path</i>
	// * <i>mixed_path_ha</i>
	// * <i>single_path_ha</i>
	// * <i>multi_path_ha</i>
	// * <i>tri_path_ha</i>
	// * <i>quad_path_ha</i>
	// * <i>unknown</i>
	// * <i>virtual</i>
	//
	// Read Only: true
	// Enum: ["unknown","single_path","multi_path","mixed_path","quad_path","single_path_ha","multi_path_ha","mixed_path_ha","quad_path_ha","tri_path","tri_path_ha","virtual"]
	StorageConfiguration *string `json:"storage_configuration,omitempty"`

	// system aggregate
	SystemAggregate *NodeInlineSystemAggregate `json:"system_aggregate,omitempty"`

	// system id
	// Example: 92027651
	// Read Only: true
	SystemID *string `json:"system_id,omitempty"`

	// OEM system machine type.
	// Example: 7Y56-CTOWW1
	// Read Only: true
	SystemMachineType *string `json:"system_machine_type,omitempty"`

	// The total time, in seconds, that the node has been up.
	// Example: 300536
	// Read Only: true
	Uptime *int64 `json:"uptime,omitempty"`

	// uuid
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// OEM vendor serial number.
	// Example: 791603000068
	// Read Only: true
	VendorSerialNumber *string `json:"vendor_serial_number,omitempty"`

	// version
	Version *NodeInlineVersion `json:"version,omitempty"`

	// vm
	VM *NodeInlineVM `json:"vm,omitempty"`
}

// Validate validates this node
func (m *Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateController(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCacheBypass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHa(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHwAssist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateManagementInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMembership(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetrocluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNodeInlineClusterInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNodeInlineManagementInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNodeInlineStorageAvailabilityZones(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvlog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvram(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceProcessor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSystemAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVM(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Node) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateClusterInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInterface) { // not required
		return nil
	}

	if m.ClusterInterface != nil {
		if err := m.ClusterInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateController(formats strfmt.Registry) error {
	if swag.IsZero(m.Controller) { // not required
		return nil
	}

	if m.Controller != nil {
		if err := m.Controller.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateDate(formats strfmt.Registry) error {
	if swag.IsZero(m.Date) { // not required
		return nil
	}

	if err := validate.FormatOf("date", "body", "date-time", m.Date.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Node) validateExternalCache(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCache) { // not required
		return nil
	}

	if m.ExternalCache != nil {
		if err := m.ExternalCache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateExternalCacheBypass(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCacheBypass) { // not required
		return nil
	}

	if m.ExternalCacheBypass != nil {
		if err := m.ExternalCacheBypass.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache_bypass")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateHa(formats strfmt.Registry) error {
	if swag.IsZero(m.Ha) { // not required
		return nil
	}

	if m.Ha != nil {
		if err := m.Ha.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateHwAssist(formats strfmt.Registry) error {
	if swag.IsZero(m.HwAssist) { // not required
		return nil
	}

	if m.HwAssist != nil {
		if err := m.HwAssist.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateManagementInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.ManagementInterface) { // not required
		return nil
	}

	if m.ManagementInterface != nil {
		if err := m.ManagementInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface")
			}
			return err
		}
	}

	return nil
}

var nodeTypeMembershipPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","joining","member"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeTypeMembershipPropEnum = append(nodeTypeMembershipPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node
	// Node
	// membership
	// Membership
	// available
	// END DEBUGGING
	// NodeMembershipAvailable captures enum value "available"
	NodeMembershipAvailable string = "available"

	// BEGIN DEBUGGING
	// node
	// Node
	// membership
	// Membership
	// joining
	// END DEBUGGING
	// NodeMembershipJoining captures enum value "joining"
	NodeMembershipJoining string = "joining"

	// BEGIN DEBUGGING
	// node
	// Node
	// membership
	// Membership
	// member
	// END DEBUGGING
	// NodeMembershipMember captures enum value "member"
	NodeMembershipMember string = "member"
)

// prop value enum
func (m *Node) validateMembershipEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeTypeMembershipPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Node) validateMembership(formats strfmt.Registry) error {
	if swag.IsZero(m.Membership) { // not required
		return nil
	}

	// value enum
	if err := m.validateMembershipEnum("membership", "body", *m.Membership); err != nil {
		return err
	}

	return nil
}

func (m *Node) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateMetrocluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Metrocluster) { // not required
		return nil
	}

	if m.Metrocluster != nil {
		if err := m.Metrocluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metrocluster")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateNodeInlineClusterInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeInlineClusterInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.NodeInlineClusterInterfaces); i++ {
		if swag.IsZero(m.NodeInlineClusterInterfaces[i]) { // not required
			continue
		}

		if m.NodeInlineClusterInterfaces[i] != nil {
			if err := m.NodeInlineClusterInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cluster_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Node) validateNodeInlineManagementInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeInlineManagementInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.NodeInlineManagementInterfaces); i++ {
		if swag.IsZero(m.NodeInlineManagementInterfaces[i]) { // not required
			continue
		}

		if m.NodeInlineManagementInterfaces[i] != nil {
			if err := m.NodeInlineManagementInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Node) validateNodeInlineStorageAvailabilityZones(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeInlineStorageAvailabilityZones) { // not required
		return nil
	}

	for i := 0; i < len(m.NodeInlineStorageAvailabilityZones); i++ {
		if swag.IsZero(m.NodeInlineStorageAvailabilityZones[i]) { // not required
			continue
		}

		if m.NodeInlineStorageAvailabilityZones[i] != nil {
			if err := m.NodeInlineStorageAvailabilityZones[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("storage_availability_zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Node) validateNvlog(formats strfmt.Registry) error {
	if swag.IsZero(m.Nvlog) { // not required
		return nil
	}

	if m.Nvlog != nil {
		if err := m.Nvlog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvlog")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateNvram(formats strfmt.Registry) error {
	if swag.IsZero(m.Nvram) { // not required
		return nil
	}

	if m.Nvram != nil {
		if err := m.Nvram.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvram")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateServiceProcessor(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceProcessor) { // not required
		return nil
	}

	if m.ServiceProcessor != nil {
		if err := m.ServiceProcessor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

var nodeTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","booting","down","taken_over","waiting_for_giveback","degraded","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeTypeStatePropEnum = append(nodeTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node
	// Node
	// state
	// State
	// up
	// END DEBUGGING
	// NodeStateUp captures enum value "up"
	NodeStateUp string = "up"

	// BEGIN DEBUGGING
	// node
	// Node
	// state
	// State
	// booting
	// END DEBUGGING
	// NodeStateBooting captures enum value "booting"
	NodeStateBooting string = "booting"

	// BEGIN DEBUGGING
	// node
	// Node
	// state
	// State
	// down
	// END DEBUGGING
	// NodeStateDown captures enum value "down"
	NodeStateDown string = "down"

	// BEGIN DEBUGGING
	// node
	// Node
	// state
	// State
	// taken_over
	// END DEBUGGING
	// NodeStateTakenOver captures enum value "taken_over"
	NodeStateTakenOver string = "taken_over"

	// BEGIN DEBUGGING
	// node
	// Node
	// state
	// State
	// waiting_for_giveback
	// END DEBUGGING
	// NodeStateWaitingForGiveback captures enum value "waiting_for_giveback"
	NodeStateWaitingForGiveback string = "waiting_for_giveback"

	// BEGIN DEBUGGING
	// node
	// Node
	// state
	// State
	// degraded
	// END DEBUGGING
	// NodeStateDegraded captures enum value "degraded"
	NodeStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// node
	// Node
	// state
	// State
	// unknown
	// END DEBUGGING
	// NodeStateUnknown captures enum value "unknown"
	NodeStateUnknown string = "unknown"
)

// prop value enum
func (m *Node) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Node) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *Node) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

var nodeTypeStorageConfigurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","single_path","multi_path","mixed_path","quad_path","single_path_ha","multi_path_ha","mixed_path_ha","quad_path_ha","tri_path","tri_path_ha","virtual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeTypeStorageConfigurationPropEnum = append(nodeTypeStorageConfigurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// unknown
	// END DEBUGGING
	// NodeStorageConfigurationUnknown captures enum value "unknown"
	NodeStorageConfigurationUnknown string = "unknown"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// single_path
	// END DEBUGGING
	// NodeStorageConfigurationSinglePath captures enum value "single_path"
	NodeStorageConfigurationSinglePath string = "single_path"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// multi_path
	// END DEBUGGING
	// NodeStorageConfigurationMultiPath captures enum value "multi_path"
	NodeStorageConfigurationMultiPath string = "multi_path"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// mixed_path
	// END DEBUGGING
	// NodeStorageConfigurationMixedPath captures enum value "mixed_path"
	NodeStorageConfigurationMixedPath string = "mixed_path"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// quad_path
	// END DEBUGGING
	// NodeStorageConfigurationQuadPath captures enum value "quad_path"
	NodeStorageConfigurationQuadPath string = "quad_path"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// single_path_ha
	// END DEBUGGING
	// NodeStorageConfigurationSinglePathHa captures enum value "single_path_ha"
	NodeStorageConfigurationSinglePathHa string = "single_path_ha"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// multi_path_ha
	// END DEBUGGING
	// NodeStorageConfigurationMultiPathHa captures enum value "multi_path_ha"
	NodeStorageConfigurationMultiPathHa string = "multi_path_ha"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// mixed_path_ha
	// END DEBUGGING
	// NodeStorageConfigurationMixedPathHa captures enum value "mixed_path_ha"
	NodeStorageConfigurationMixedPathHa string = "mixed_path_ha"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// quad_path_ha
	// END DEBUGGING
	// NodeStorageConfigurationQuadPathHa captures enum value "quad_path_ha"
	NodeStorageConfigurationQuadPathHa string = "quad_path_ha"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// tri_path
	// END DEBUGGING
	// NodeStorageConfigurationTriPath captures enum value "tri_path"
	NodeStorageConfigurationTriPath string = "tri_path"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// tri_path_ha
	// END DEBUGGING
	// NodeStorageConfigurationTriPathHa captures enum value "tri_path_ha"
	NodeStorageConfigurationTriPathHa string = "tri_path_ha"

	// BEGIN DEBUGGING
	// node
	// Node
	// storage_configuration
	// StorageConfiguration
	// virtual
	// END DEBUGGING
	// NodeStorageConfigurationVirtual captures enum value "virtual"
	NodeStorageConfigurationVirtual string = "virtual"
)

// prop value enum
func (m *Node) validateStorageConfigurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeTypeStorageConfigurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Node) validateStorageConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageConfiguration) { // not required
		return nil
	}

	// value enum
	if err := m.validateStorageConfigurationEnum("storage_configuration", "body", *m.StorageConfiguration); err != nil {
		return err
	}

	return nil
}

func (m *Node) validateSystemAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.SystemAggregate) { // not required
		return nil
	}

	if m.SystemAggregate != nil {
		if err := m.SystemAggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Node) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *Node) validateVM(formats strfmt.Registry) error {
	if swag.IsZero(m.VM) { // not required
		return nil
	}

	if m.VM != nil {
		if err := m.VM.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node based on the context it is used
func (m *Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAntiRansomwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateController(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExternalCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExternalCacheBypass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHa(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHwAssist(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSparesLow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateManagementInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMembership(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetrocluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeInlineClusterInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeInlineManagementInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeInlineStorageAvailabilityZones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvlog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvram(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServiceProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemMachineType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUptime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVendorSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVM(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Node) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateAntiRansomwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware_version", "body", m.AntiRansomwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateClusterInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.ClusterInterface != nil {
		if err := m.ClusterInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateController(ctx context.Context, formats strfmt.Registry) error {

	if m.Controller != nil {
		if err := m.Controller.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateDate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "date", "body", m.Date); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateExternalCache(ctx context.Context, formats strfmt.Registry) error {

	if m.ExternalCache != nil {
		if err := m.ExternalCache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateExternalCacheBypass(ctx context.Context, formats strfmt.Registry) error {

	if m.ExternalCacheBypass != nil {
		if err := m.ExternalCacheBypass.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache_bypass")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateHa(ctx context.Context, formats strfmt.Registry) error {

	if m.Ha != nil {
		if err := m.Ha.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateHwAssist(ctx context.Context, formats strfmt.Registry) error {

	if m.HwAssist != nil {
		if err := m.HwAssist.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateIsSparesLow(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_spares_low", "body", m.IsSparesLow); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateManagementInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.ManagementInterface != nil {
		if err := m.ManagementInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateMembership(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "membership", "body", m.Membership); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateMetrocluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Metrocluster != nil {
		if err := m.Metrocluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metrocluster")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateNodeInlineClusterInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cluster_interfaces", "body", []*NodeInlineClusterInterfacesInlineArrayItem(m.NodeInlineClusterInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.NodeInlineClusterInterfaces); i++ {

		if m.NodeInlineClusterInterfaces[i] != nil {
			if err := m.NodeInlineClusterInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cluster_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Node) contextValidateNodeInlineManagementInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "management_interfaces", "body", []*NodeInlineManagementInterfacesInlineArrayItem(m.NodeInlineManagementInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.NodeInlineManagementInterfaces); i++ {

		if m.NodeInlineManagementInterfaces[i] != nil {
			if err := m.NodeInlineManagementInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Node) contextValidateNodeInlineStorageAvailabilityZones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_availability_zones", "body", []*StorageAvailabilityZoneReference(m.NodeInlineStorageAvailabilityZones)); err != nil {
		return err
	}

	for i := 0; i < len(m.NodeInlineStorageAvailabilityZones); i++ {

		if m.NodeInlineStorageAvailabilityZones[i] != nil {
			if err := m.NodeInlineStorageAvailabilityZones[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("storage_availability_zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Node) contextValidateNvlog(ctx context.Context, formats strfmt.Registry) error {

	if m.Nvlog != nil {
		if err := m.Nvlog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvlog")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateNvram(ctx context.Context, formats strfmt.Registry) error {

	if m.Nvram != nil {
		if err := m.Nvram.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvram")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateServiceProcessor(ctx context.Context, formats strfmt.Registry) error {

	if m.ServiceProcessor != nil {
		if err := m.ServiceProcessor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateStorageConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_configuration", "body", m.StorageConfiguration); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateSystemAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.SystemAggregate != nil {
		if err := m.SystemAggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateSystemID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_id", "body", m.SystemID); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateSystemMachineType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_machine_type", "body", m.SystemMachineType); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateUptime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uptime", "body", m.Uptime); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateVendorSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vendor_serial_number", "body", m.VendorSerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *Node) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *Node) contextValidateVM(ctx context.Context, formats strfmt.Registry) error {

	if m.VM != nil {
		if err := m.VM.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Node) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Node) UnmarshalBinary(b []byte) error {
	var res Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineClusterInterface The cluster network IP address of the node to be added.
//
// swagger:model node_inline_cluster_interface
type NodeInlineClusterInterface struct {

	// ip
	IP *NodeSetupIP `json:"ip,omitempty"`
}

// Validate validates this node inline cluster interface
func (m *NodeInlineClusterInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineClusterInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline cluster interface based on the context it is used
func (m *NodeInlineClusterInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineClusterInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineClusterInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineClusterInterface) UnmarshalBinary(b []byte) error {
	var res NodeInlineClusterInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineClusterInterfacesInlineArrayItem Network interface
//
// swagger:model node_inline_cluster_interfaces_inline_array_item
type NodeInlineClusterInterfacesInlineArrayItem struct {

	// links
	Links *NodeInlineClusterInterfacesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// ip
	IP *NodeInlineClusterInterfacesInlineArrayItemInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node inline cluster interfaces inline array item
func (m *NodeInlineClusterInterfacesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineClusterInterfacesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineClusterInterfacesInlineArrayItem) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline cluster interfaces inline array item based on the context it is used
func (m *NodeInlineClusterInterfacesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineClusterInterfacesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineClusterInterfacesInlineArrayItem) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineClusterInterfacesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineClusterInterfacesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NodeInlineClusterInterfacesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineClusterInterfacesInlineArrayItemInlineIP IP information
//
// swagger:model node_inline_cluster_interfaces_inline_array_item_inline_ip
type NodeInlineClusterInterfacesInlineArrayItemInlineIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this node inline cluster interfaces inline array item inline ip
func (m *NodeInlineClusterInterfacesInlineArrayItemInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineClusterInterfacesInlineArrayItemInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline cluster interfaces inline array item inline ip based on the context it is used
func (m *NodeInlineClusterInterfacesInlineArrayItemInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineClusterInterfacesInlineArrayItemInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineClusterInterfacesInlineArrayItemInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineClusterInterfacesInlineArrayItemInlineIP) UnmarshalBinary(b []byte) error {
	var res NodeInlineClusterInterfacesInlineArrayItemInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineClusterInterfacesInlineArrayItemInlineLinks node inline cluster interfaces inline array item inline links
//
// swagger:model node_inline_cluster_interfaces_inline_array_item_inline__links
type NodeInlineClusterInterfacesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node inline cluster interfaces inline array item inline links
func (m *NodeInlineClusterInterfacesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineClusterInterfacesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline cluster interfaces inline array item inline links based on the context it is used
func (m *NodeInlineClusterInterfacesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineClusterInterfacesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineClusterInterfacesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineClusterInterfacesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeInlineClusterInterfacesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineController Controller information
//
// swagger:model node_inline_controller
type NodeInlineController struct {

	// Type of the system board. This is defined by vendor.
	// Example: System Board XXVIII
	// Read Only: true
	Board *string `json:"board,omitempty"`

	// cpu
	CPU *NodeInlineControllerInlineCPU `json:"cpu,omitempty"`

	// failed fan
	FailedFan *NodeInlineControllerInlineFailedFan `json:"failed_fan,omitempty"`

	// failed power supply
	FailedPowerSupply *NodeInlineControllerInlineFailedPowerSupply `json:"failed_power_supply,omitempty"`

	// A list of Flash-Cache devices. Only returned when requested by name.
	// Read Only: true
	FlashCache []*NodeControllerFlashCacheItems0 `json:"flash_cache,omitempty"`

	// List of FRUs on the node. Only returned when requested by name.
	Frus []*NodeControllerFrusItems0 `json:"frus,omitempty"`

	// Memory available on the node, in bytes.
	// Example: 1024000000
	// Read Only: true
	MemorySize *int64 `json:"memory_size,omitempty"`

	// Specifies whether the hardware is currently operating outside of its recommended temperature range. The hardware shuts down if the temperature exceeds critical thresholds.
	// Read Only: true
	// Enum: ["over","normal"]
	OverTemperature *string `json:"over_temperature,omitempty"`
}

// Validate validates this node inline controller
func (m *NodeInlineController) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPU(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFailedFan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFailedPowerSupply(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlashCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOverTemperature(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineController) validateCPU(formats strfmt.Registry) error {
	if swag.IsZero(m.CPU) { // not required
		return nil
	}

	if m.CPU != nil {
		if err := m.CPU.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "cpu")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineController) validateFailedFan(formats strfmt.Registry) error {
	if swag.IsZero(m.FailedFan) { // not required
		return nil
	}

	if m.FailedFan != nil {
		if err := m.FailedFan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineController) validateFailedPowerSupply(formats strfmt.Registry) error {
	if swag.IsZero(m.FailedPowerSupply) { // not required
		return nil
	}

	if m.FailedPowerSupply != nil {
		if err := m.FailedPowerSupply.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineController) validateFlashCache(formats strfmt.Registry) error {
	if swag.IsZero(m.FlashCache) { // not required
		return nil
	}

	for i := 0; i < len(m.FlashCache); i++ {
		if swag.IsZero(m.FlashCache[i]) { // not required
			continue
		}

		if m.FlashCache[i] != nil {
			if err := m.FlashCache[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "flash_cache" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeInlineController) validateFrus(formats strfmt.Registry) error {
	if swag.IsZero(m.Frus) { // not required
		return nil
	}

	for i := 0; i < len(m.Frus); i++ {
		if swag.IsZero(m.Frus[i]) { // not required
			continue
		}

		if m.Frus[i] != nil {
			if err := m.Frus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nodeInlineControllerTypeOverTemperaturePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["over","normal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineControllerTypeOverTemperaturePropEnum = append(nodeInlineControllerTypeOverTemperaturePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_controller
	// NodeInlineController
	// over_temperature
	// OverTemperature
	// over
	// END DEBUGGING
	// NodeInlineControllerOverTemperatureOver captures enum value "over"
	NodeInlineControllerOverTemperatureOver string = "over"

	// BEGIN DEBUGGING
	// node_inline_controller
	// NodeInlineController
	// over_temperature
	// OverTemperature
	// normal
	// END DEBUGGING
	// NodeInlineControllerOverTemperatureNormal captures enum value "normal"
	NodeInlineControllerOverTemperatureNormal string = "normal"
)

// prop value enum
func (m *NodeInlineController) validateOverTemperatureEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineControllerTypeOverTemperaturePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineController) validateOverTemperature(formats strfmt.Registry) error {
	if swag.IsZero(m.OverTemperature) { // not required
		return nil
	}

	// value enum
	if err := m.validateOverTemperatureEnum("controller"+"."+"over_temperature", "body", *m.OverTemperature); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline controller based on the context it is used
func (m *NodeInlineController) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBoard(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCPU(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailedFan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailedPowerSupply(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlashCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFrus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMemorySize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverTemperature(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineController) contextValidateBoard(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"board", "body", m.Board); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineController) contextValidateCPU(ctx context.Context, formats strfmt.Registry) error {

	if m.CPU != nil {
		if err := m.CPU.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "cpu")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineController) contextValidateFailedFan(ctx context.Context, formats strfmt.Registry) error {

	if m.FailedFan != nil {
		if err := m.FailedFan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineController) contextValidateFailedPowerSupply(ctx context.Context, formats strfmt.Registry) error {

	if m.FailedPowerSupply != nil {
		if err := m.FailedPowerSupply.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineController) contextValidateFlashCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"flash_cache", "body", []*NodeControllerFlashCacheItems0(m.FlashCache)); err != nil {
		return err
	}

	for i := 0; i < len(m.FlashCache); i++ {

		if m.FlashCache[i] != nil {
			if err := m.FlashCache[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "flash_cache" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeInlineController) contextValidateFrus(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Frus); i++ {

		if m.Frus[i] != nil {
			if err := m.Frus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeInlineController) contextValidateMemorySize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"memory_size", "body", m.MemorySize); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineController) contextValidateOverTemperature(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"over_temperature", "body", m.OverTemperature); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineController) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineController) UnmarshalBinary(b []byte) error {
	var res NodeInlineController
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineControllerInlineCPU CPU information.
//
// swagger:model node_inline_controller_inline_cpu
type NodeInlineControllerInlineCPU struct {

	// Number of CPUs on the node.
	// Example: 20
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// Firmware release number. Defined by the CPU manufacturer.
	// Read Only: true
	FirmwareRelease *string `json:"firmware_release,omitempty"`

	// CPU type on the node.
	// Read Only: true
	Processor *string `json:"processor,omitempty"`
}

// Validate validates this node inline controller inline cpu
func (m *NodeInlineControllerInlineCPU) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline controller inline cpu based on the context it is used
func (m *NodeInlineControllerInlineCPU) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineControllerInlineCPU) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineControllerInlineCPU) contextValidateFirmwareRelease(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"firmware_release", "body", m.FirmwareRelease); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineControllerInlineCPU) contextValidateProcessor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"processor", "body", m.Processor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineControllerInlineCPU) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineControllerInlineCPU) UnmarshalBinary(b []byte) error {
	var res NodeInlineControllerInlineCPU
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineControllerInlineFailedFan node inline controller inline failed fan
//
// swagger:model node_inline_controller_inline_failed_fan
type NodeInlineControllerInlineFailedFan struct {

	// Specifies a count of the number of chassis fans that are not operating within the recommended RPM range.
	// Example: 1
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// message
	Message *NodeInlineControllerInlineFailedFanInlineMessage `json:"message,omitempty"`
}

// Validate validates this node inline controller inline failed fan
func (m *NodeInlineControllerInlineFailedFan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineControllerInlineFailedFan) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if m.Message != nil {
		if err := m.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline controller inline failed fan based on the context it is used
func (m *NodeInlineControllerInlineFailedFan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineControllerInlineFailedFan) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineControllerInlineFailedFan) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.Message != nil {
		if err := m.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineControllerInlineFailedFan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineControllerInlineFailedFan) UnmarshalBinary(b []byte) error {
	var res NodeInlineControllerInlineFailedFan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineControllerInlineFailedFanInlineMessage node inline controller inline failed fan inline message
//
// swagger:model node_inline_controller_inline_failed_fan_inline_message
type NodeInlineControllerInlineFailedFanInlineMessage struct {

	// Error code describing the current condition of chassis fans.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message describing the current condition of chassis fans. It is only of use when `failed_fan.count` is not zero.
	// Example: There are no failed fans.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this node inline controller inline failed fan inline message
func (m *NodeInlineControllerInlineFailedFanInlineMessage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline controller inline failed fan inline message based on the context it is used
func (m *NodeInlineControllerInlineFailedFanInlineMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineControllerInlineFailedFanInlineMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineControllerInlineFailedFanInlineMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineControllerInlineFailedFanInlineMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineControllerInlineFailedFanInlineMessage) UnmarshalBinary(b []byte) error {
	var res NodeInlineControllerInlineFailedFanInlineMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineControllerInlineFailedPowerSupply node inline controller inline failed power supply
//
// swagger:model node_inline_controller_inline_failed_power_supply
type NodeInlineControllerInlineFailedPowerSupply struct {

	// Number of failed power supply units.
	// Example: 1
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// message
	Message *NodeInlineControllerInlineFailedPowerSupplyInlineMessage `json:"message,omitempty"`
}

// Validate validates this node inline controller inline failed power supply
func (m *NodeInlineControllerInlineFailedPowerSupply) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineControllerInlineFailedPowerSupply) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if m.Message != nil {
		if err := m.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline controller inline failed power supply based on the context it is used
func (m *NodeInlineControllerInlineFailedPowerSupply) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineControllerInlineFailedPowerSupply) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineControllerInlineFailedPowerSupply) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.Message != nil {
		if err := m.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineControllerInlineFailedPowerSupply) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineControllerInlineFailedPowerSupply) UnmarshalBinary(b []byte) error {
	var res NodeInlineControllerInlineFailedPowerSupply
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineControllerInlineFailedPowerSupplyInlineMessage node inline controller inline failed power supply inline message
//
// swagger:model node_inline_controller_inline_failed_power_supply_inline_message
type NodeInlineControllerInlineFailedPowerSupplyInlineMessage struct {

	// Error code describing the current condition of power supply.
	// Example: 111411208
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message describing the state of any power supplies that are currently degraded. It is only of use when `failed_power_supply.count` is not zero.
	// Example: There are no failed power supplies.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this node inline controller inline failed power supply inline message
func (m *NodeInlineControllerInlineFailedPowerSupplyInlineMessage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline controller inline failed power supply inline message based on the context it is used
func (m *NodeInlineControllerInlineFailedPowerSupplyInlineMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineControllerInlineFailedPowerSupplyInlineMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineControllerInlineFailedPowerSupplyInlineMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineControllerInlineFailedPowerSupplyInlineMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineControllerInlineFailedPowerSupplyInlineMessage) UnmarshalBinary(b []byte) error {
	var res NodeInlineControllerInlineFailedPowerSupplyInlineMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeControllerFlashCacheItems0 node controller flash cache items0
//
// swagger:model NodeControllerFlashCacheItems0
type NodeControllerFlashCacheItems0 struct {

	// Size in bytes
	// Example: 1024000000000
	// Read Only: true
	Capacity *int64 `json:"capacity,omitempty"`

	// device id
	// Example: 0
	// Read Only: true
	DeviceID *int64 `json:"device_id,omitempty"`

	// firmware file
	// Example: X9170_O000Z6300NVM
	// Read Only: true
	FirmwareFile *string `json:"firmware_file,omitempty"`

	// firmware version
	// Example: NA05
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// hardware revision
	// Example: A1
	// Read Only: true
	HardwareRevision *string `json:"hardware_revision,omitempty"`

	// model
	// Example: X1970A
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// part number
	// Example: 119-00207
	// Read Only: true
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: A22P5061550000187
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// slot
	// Example: 6-1
	// Read Only: true
	Slot *string `json:"slot,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","erasing","erased","failed","removed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node controller flash cache items0
func (m *NodeControllerFlashCacheItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeControllerFlashCacheItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","erasing","erased","failed","removed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeControllerFlashCacheItems0TypeStatePropEnum = append(nodeControllerFlashCacheItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeControllerFlashCacheItems0
	// NodeControllerFlashCacheItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// NodeControllerFlashCacheItems0StateOk captures enum value "ok"
	NodeControllerFlashCacheItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// NodeControllerFlashCacheItems0
	// NodeControllerFlashCacheItems0
	// state
	// State
	// erasing
	// END DEBUGGING
	// NodeControllerFlashCacheItems0StateErasing captures enum value "erasing"
	NodeControllerFlashCacheItems0StateErasing string = "erasing"

	// BEGIN DEBUGGING
	// NodeControllerFlashCacheItems0
	// NodeControllerFlashCacheItems0
	// state
	// State
	// erased
	// END DEBUGGING
	// NodeControllerFlashCacheItems0StateErased captures enum value "erased"
	NodeControllerFlashCacheItems0StateErased string = "erased"

	// BEGIN DEBUGGING
	// NodeControllerFlashCacheItems0
	// NodeControllerFlashCacheItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeControllerFlashCacheItems0StateFailed captures enum value "failed"
	NodeControllerFlashCacheItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// NodeControllerFlashCacheItems0
	// NodeControllerFlashCacheItems0
	// state
	// State
	// removed
	// END DEBUGGING
	// NodeControllerFlashCacheItems0StateRemoved captures enum value "removed"
	NodeControllerFlashCacheItems0StateRemoved string = "removed"
)

// prop value enum
func (m *NodeControllerFlashCacheItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeControllerFlashCacheItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeControllerFlashCacheItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node controller flash cache items0 based on the context it is used
func (m *NodeControllerFlashCacheItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeviceID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHardwareRevision(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSlot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity", "body", m.Capacity); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateDeviceID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "device_id", "body", m.DeviceID); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateFirmwareFile(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_file", "body", m.FirmwareFile); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateHardwareRevision(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "hardware_revision", "body", m.HardwareRevision); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidatePartNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "part_number", "body", m.PartNumber); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateSlot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "slot", "body", m.Slot); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFlashCacheItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeControllerFlashCacheItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeControllerFlashCacheItems0) UnmarshalBinary(b []byte) error {
	var res NodeControllerFlashCacheItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeControllerFrusItems0 node controller frus items0
//
// swagger:model NodeControllerFrusItems0
type NodeControllerFrusItems0 struct {

	// id
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["fan","psu","pcie","disk","nvs","dimm","controller"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this node controller frus items0
func (m *NodeControllerFrusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeControllerFrusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeControllerFrusItems0TypeStatePropEnum = append(nodeControllerFrusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// NodeControllerFrusItems0StateOk captures enum value "ok"
	NodeControllerFrusItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// state
	// State
	// error
	// END DEBUGGING
	// NodeControllerFrusItems0StateError captures enum value "error"
	NodeControllerFrusItems0StateError string = "error"
)

// prop value enum
func (m *NodeControllerFrusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeControllerFrusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeControllerFrusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var nodeControllerFrusItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fan","psu","pcie","disk","nvs","dimm","controller"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeControllerFrusItems0TypeTypePropEnum = append(nodeControllerFrusItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// type
	// Type
	// fan
	// END DEBUGGING
	// NodeControllerFrusItems0TypeFan captures enum value "fan"
	NodeControllerFrusItems0TypeFan string = "fan"

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// type
	// Type
	// psu
	// END DEBUGGING
	// NodeControllerFrusItems0TypePsu captures enum value "psu"
	NodeControllerFrusItems0TypePsu string = "psu"

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// type
	// Type
	// pcie
	// END DEBUGGING
	// NodeControllerFrusItems0TypePcie captures enum value "pcie"
	NodeControllerFrusItems0TypePcie string = "pcie"

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// type
	// Type
	// disk
	// END DEBUGGING
	// NodeControllerFrusItems0TypeDisk captures enum value "disk"
	NodeControllerFrusItems0TypeDisk string = "disk"

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// type
	// Type
	// nvs
	// END DEBUGGING
	// NodeControllerFrusItems0TypeNvs captures enum value "nvs"
	NodeControllerFrusItems0TypeNvs string = "nvs"

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// type
	// Type
	// dimm
	// END DEBUGGING
	// NodeControllerFrusItems0TypeDimm captures enum value "dimm"
	NodeControllerFrusItems0TypeDimm string = "dimm"

	// BEGIN DEBUGGING
	// NodeControllerFrusItems0
	// NodeControllerFrusItems0
	// type
	// Type
	// controller
	// END DEBUGGING
	// NodeControllerFrusItems0TypeController captures enum value "controller"
	NodeControllerFrusItems0TypeController string = "controller"
)

// prop value enum
func (m *NodeControllerFrusItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeControllerFrusItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeControllerFrusItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node controller frus items0 based on the context it is used
func (m *NodeControllerFrusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeControllerFrusItems0) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFrusItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeControllerFrusItems0) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeControllerFrusItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeControllerFrusItems0) UnmarshalBinary(b []byte) error {
	var res NodeControllerFrusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineExternalCache Cache used for buffer management.
//
// swagger:model node_inline_external_cache
type NodeInlineExternalCache struct {

	// Indicates whether the external cache is enabled.
	// Example: true
	IsEnabled *bool `json:"is_enabled,omitempty"`

	// Indicates whether HyA caching is enabled.
	// Example: true
	IsHyaEnabled *bool `json:"is_hya_enabled,omitempty"`

	// Indicates whether rewarm is enabled.
	// Example: true
	IsRewarmEnabled *bool `json:"is_rewarm_enabled,omitempty"`

	// PCS size in gigabytes.
	PcsSize *int64 `json:"pcs_size,omitempty"`
}

// Validate validates this node inline external cache
func (m *NodeInlineExternalCache) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline external cache based on the context it is used
func (m *NodeInlineExternalCache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineExternalCache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineExternalCache) UnmarshalBinary(b []byte) error {
	var res NodeInlineExternalCache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineExternalCacheBypass External cache bypass management.
//
// swagger:model node_inline_external_cache_bypass
type NodeInlineExternalCacheBypass struct {

	// Indicates whether external cache bypass is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// External cache bypass allowed operations percentage for large reads.
	// Example: 100
	LargeReadOpsAllowPercent *int64 `json:"large_read_ops_allow_percent,omitempty"`

	// Initiates an external cache bypass threshold reset action.
	// Example: true
	Reset *bool `json:"reset,omitempty"`
}

// Validate validates this node inline external cache bypass
func (m *NodeInlineExternalCacheBypass) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this node inline external cache bypass based on context it is used
func (m *NodeInlineExternalCacheBypass) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineExternalCacheBypass) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineExternalCacheBypass) UnmarshalBinary(b []byte) error {
	var res NodeInlineExternalCacheBypass
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHa node inline ha
//
// swagger:model node_inline_ha
type NodeInlineHa struct {

	// Specifies whether giveback is automatically initiated when the node that owns the storage is ready.
	AutoGiveback *bool `json:"auto_giveback,omitempty"`

	// Specifies whether giveback is automatically initiated when the node that owns the storage is ready.
	AutoGivebackOf *bool `json:"auto_giveback_of,omitempty"`

	// Specifies whether or not storage failover is enabled.
	// Read Only: true
	EnableTakeoverOf *bool `json:"enable_takeover_of,omitempty"`

	// Specifies whether or not storage failover is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// giveback
	Giveback *NodeInlineHaInlineGiveback `json:"giveback,omitempty"`

	// interconnect
	Interconnect *NodeInlineHaInlineInterconnect `json:"interconnect,omitempty"`

	// Nodes in this node's High Availability (HA) group.
	// Read Only: true
	Partners []*NodeHaPartnersItems0 `json:"partners,omitempty"`

	// ports
	// Read Only: true
	Ports []*NodeHaPortsItems0 `json:"ports,omitempty"`

	// takeover
	Takeover *NodeInlineHaInlineTakeover `json:"takeover,omitempty"`

	// takeover check
	TakeoverCheck *NodeInlineHaInlineTakeoverCheck `json:"takeover_check,omitempty"`

	// Type of storage.
	// Read Only: true
	// Enum: ["shared_storage","non_shared_storage"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this node inline ha
func (m *NodeInlineHa) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGiveback(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterconnect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartners(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTakeover(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTakeoverCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHa) validateGiveback(formats strfmt.Registry) error {
	if swag.IsZero(m.Giveback) { // not required
		return nil
	}

	if m.Giveback != nil {
		if err := m.Giveback.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHa) validateInterconnect(formats strfmt.Registry) error {
	if swag.IsZero(m.Interconnect) { // not required
		return nil
	}

	if m.Interconnect != nil {
		if err := m.Interconnect.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "interconnect")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHa) validatePartners(formats strfmt.Registry) error {
	if swag.IsZero(m.Partners) { // not required
		return nil
	}

	for i := 0; i < len(m.Partners); i++ {
		if swag.IsZero(m.Partners[i]) { // not required
			continue
		}

		if m.Partners[i] != nil {
			if err := m.Partners[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "partners" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeInlineHa) validatePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.Ports) { // not required
		return nil
	}

	for i := 0; i < len(m.Ports); i++ {
		if swag.IsZero(m.Ports[i]) { // not required
			continue
		}

		if m.Ports[i] != nil {
			if err := m.Ports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeInlineHa) validateTakeover(formats strfmt.Registry) error {
	if swag.IsZero(m.Takeover) { // not required
		return nil
	}

	if m.Takeover != nil {
		if err := m.Takeover.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHa) validateTakeoverCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.TakeoverCheck) { // not required
		return nil
	}

	if m.TakeoverCheck != nil {
		if err := m.TakeoverCheck.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover_check")
			}
			return err
		}
	}

	return nil
}

var nodeInlineHaTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shared_storage","non_shared_storage"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineHaTypeTypePropEnum = append(nodeInlineHaTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_ha
	// NodeInlineHa
	// type
	// Type
	// shared_storage
	// END DEBUGGING
	// NodeInlineHaTypeSharedStorage captures enum value "shared_storage"
	NodeInlineHaTypeSharedStorage string = "shared_storage"

	// BEGIN DEBUGGING
	// node_inline_ha
	// NodeInlineHa
	// type
	// Type
	// non_shared_storage
	// END DEBUGGING
	// NodeInlineHaTypeNonSharedStorage captures enum value "non_shared_storage"
	NodeInlineHaTypeNonSharedStorage string = "non_shared_storage"
)

// prop value enum
func (m *NodeInlineHa) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineHaTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineHa) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("ha"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline ha based on the context it is used
func (m *NodeInlineHa) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEnableTakeoverOf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGiveback(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterconnect(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartners(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeover(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeoverCheck(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHa) contextValidateEnableTakeoverOf(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"enable_takeover_of", "body", m.EnableTakeoverOf); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineHa) contextValidateGiveback(ctx context.Context, formats strfmt.Registry) error {

	if m.Giveback != nil {
		if err := m.Giveback.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHa) contextValidateInterconnect(ctx context.Context, formats strfmt.Registry) error {

	if m.Interconnect != nil {
		if err := m.Interconnect.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "interconnect")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHa) contextValidatePartners(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"partners", "body", []*NodeHaPartnersItems0(m.Partners)); err != nil {
		return err
	}

	for i := 0; i < len(m.Partners); i++ {

		if m.Partners[i] != nil {
			if err := m.Partners[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "partners" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeInlineHa) contextValidatePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"ports", "body", []*NodeHaPortsItems0(m.Ports)); err != nil {
		return err
	}

	for i := 0; i < len(m.Ports); i++ {

		if m.Ports[i] != nil {
			if err := m.Ports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeInlineHa) contextValidateTakeover(ctx context.Context, formats strfmt.Registry) error {

	if m.Takeover != nil {
		if err := m.Takeover.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHa) contextValidateTakeoverCheck(ctx context.Context, formats strfmt.Registry) error {

	if m.TakeoverCheck != nil {
		if err := m.TakeoverCheck.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover_check")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHa) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHa) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHa) UnmarshalBinary(b []byte) error {
	var res NodeInlineHa
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHaInlineGiveback Represents the state of the node that is giving storage back to its HA partner.
//
// swagger:model node_inline_ha_inline_giveback
type NodeInlineHaInlineGiveback struct {

	// failure
	Failure *NodeInlineHaInlineGivebackInlineFailure `json:"failure,omitempty"`

	// state
	// Example: failed
	// Enum: ["nothing_to_giveback","not_attempted","in_progress","failed"]
	State *string `json:"state,omitempty"`

	// Giveback status of each aggregate. This property is not supported on the ASA r2 platform.
	// Read Only: true
	Status []*NodeHaGivebackStatusItems0 `json:"status,omitempty"`
}

// Validate validates this node inline ha inline giveback
func (m *NodeInlineHaInlineGiveback) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHaInlineGiveback) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

var nodeInlineHaInlineGivebackTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nothing_to_giveback","not_attempted","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineHaInlineGivebackTypeStatePropEnum = append(nodeInlineHaInlineGivebackTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_ha_inline_giveback
	// NodeInlineHaInlineGiveback
	// state
	// State
	// nothing_to_giveback
	// END DEBUGGING
	// NodeInlineHaInlineGivebackStateNothingToGiveback captures enum value "nothing_to_giveback"
	NodeInlineHaInlineGivebackStateNothingToGiveback string = "nothing_to_giveback"

	// BEGIN DEBUGGING
	// node_inline_ha_inline_giveback
	// NodeInlineHaInlineGiveback
	// state
	// State
	// not_attempted
	// END DEBUGGING
	// NodeInlineHaInlineGivebackStateNotAttempted captures enum value "not_attempted"
	NodeInlineHaInlineGivebackStateNotAttempted string = "not_attempted"

	// BEGIN DEBUGGING
	// node_inline_ha_inline_giveback
	// NodeInlineHaInlineGiveback
	// state
	// State
	// in_progress
	// END DEBUGGING
	// NodeInlineHaInlineGivebackStateInProgress captures enum value "in_progress"
	NodeInlineHaInlineGivebackStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// node_inline_ha_inline_giveback
	// NodeInlineHaInlineGiveback
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeInlineHaInlineGivebackStateFailed captures enum value "failed"
	NodeInlineHaInlineGivebackStateFailed string = "failed"
)

// prop value enum
func (m *NodeInlineHaInlineGiveback) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineHaInlineGivebackTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineHaInlineGiveback) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"giveback"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineHaInlineGiveback) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	for i := 0; i < len(m.Status); i++ {
		if swag.IsZero(m.Status[i]) { // not required
			continue
		}

		if m.Status[i] != nil {
			if err := m.Status[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "giveback" + "." + "status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this node inline ha inline giveback based on the context it is used
func (m *NodeInlineHaInlineGiveback) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHaInlineGiveback) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHaInlineGiveback) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"giveback"+"."+"status", "body", []*NodeHaGivebackStatusItems0(m.Status)); err != nil {
		return err
	}

	for i := 0; i < len(m.Status); i++ {

		if m.Status[i] != nil {
			if err := m.Status[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "giveback" + "." + "status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHaInlineGiveback) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHaInlineGiveback) UnmarshalBinary(b []byte) error {
	var res NodeInlineHaInlineGiveback
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHaInlineGivebackInlineFailure Indicates the failure code and message. This property is not supported on the ASA r2 platform.
//
// swagger:model node_inline_ha_inline_giveback_inline_failure
type NodeInlineHaInlineGivebackInlineFailure struct {

	// Message code
	// Example: 852126
	Code *int64 `json:"code,omitempty"`

	// Detailed message based on the state.
	// Example: Failed to initiate giveback. Run the \"storage failover show-giveback\" command for more information.
	Message *string `json:"message,omitempty"`
}

// Validate validates this node inline ha inline giveback inline failure
func (m *NodeInlineHaInlineGivebackInlineFailure) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline ha inline giveback inline failure based on the context it is used
func (m *NodeInlineHaInlineGivebackInlineFailure) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHaInlineGivebackInlineFailure) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHaInlineGivebackInlineFailure) UnmarshalBinary(b []byte) error {
	var res NodeInlineHaInlineGivebackInlineFailure
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeHaGivebackStatusItems0 node ha giveback status items0
//
// swagger:model NodeHaGivebackStatusItems0
type NodeHaGivebackStatusItems0 struct {

	// aggregate
	Aggregate *NodeHaGivebackStatusItems0Aggregate `json:"aggregate,omitempty"`

	// error
	Error *NodeHaGivebackStatusItems0Error `json:"error,omitempty"`

	// Giveback state of the aggregate. <br/>
	// Possible values include no aggregates to giveback(nothing_to_giveback), failed to disable background disk firmware update(BDFU) on source node(failed_bdfu_source), <br/>
	// giveback delayed as disk firmware update is in progress on source node(delayed_bdfu_source), performing veto checks(running_checks). <br/>
	//
	// Enum: ["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node ha giveback status items0
func (m *NodeHaGivebackStatusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregate) { // not required
		return nil
	}

	if m.Aggregate != nil {
		if err := m.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *NodeHaGivebackStatusItems0) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

var nodeHaGivebackStatusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeHaGivebackStatusItems0TypeStatePropEnum = append(nodeHaGivebackStatusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// done
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateDone captures enum value "done"
	NodeHaGivebackStatusItems0StateDone string = "done"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateFailed captures enum value "failed"
	NodeHaGivebackStatusItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// in_progress
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateInProgress captures enum value "in_progress"
	NodeHaGivebackStatusItems0StateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// not_started
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateNotStarted captures enum value "not_started"
	NodeHaGivebackStatusItems0StateNotStarted string = "not_started"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// nothing_to_giveback
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateNothingToGiveback captures enum value "nothing_to_giveback"
	NodeHaGivebackStatusItems0StateNothingToGiveback string = "nothing_to_giveback"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_source
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateFailedBdfuSource captures enum value "failed_bdfu_source"
	NodeHaGivebackStatusItems0StateFailedBdfuSource string = "failed_bdfu_source"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_dest
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateFailedBdfuDest captures enum value "failed_bdfu_dest"
	NodeHaGivebackStatusItems0StateFailedBdfuDest string = "failed_bdfu_dest"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_source
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateDelayedBdfuSource captures enum value "delayed_bdfu_source"
	NodeHaGivebackStatusItems0StateDelayedBdfuSource string = "delayed_bdfu_source"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_dest
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateDelayedBdfuDest captures enum value "delayed_bdfu_dest"
	NodeHaGivebackStatusItems0StateDelayedBdfuDest string = "delayed_bdfu_dest"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0
	// NodeHaGivebackStatusItems0
	// state
	// State
	// running_checks
	// END DEBUGGING
	// NodeHaGivebackStatusItems0StateRunningChecks captures enum value "running_checks"
	NodeHaGivebackStatusItems0StateRunningChecks string = "running_checks"
)

// prop value enum
func (m *NodeHaGivebackStatusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeHaGivebackStatusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node ha giveback status items0 based on the context it is used
func (m *NodeHaGivebackStatusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.Aggregate != nil {
		if err := m.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *NodeHaGivebackStatusItems0) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeHaGivebackStatusItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeHaGivebackStatusItems0) UnmarshalBinary(b []byte) error {
	var res NodeHaGivebackStatusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeHaGivebackStatusItems0Aggregate Aggregate name and UUID.
//
// swagger:model NodeHaGivebackStatusItems0Aggregate
type NodeHaGivebackStatusItems0Aggregate struct {

	// links
	Links *NodeHaGivebackStatusItems0AggregateLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node ha giveback status items0 aggregate
func (m *NodeHaGivebackStatusItems0Aggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0Aggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node ha giveback status items0 aggregate based on the context it is used
func (m *NodeHaGivebackStatusItems0Aggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0Aggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeHaGivebackStatusItems0Aggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeHaGivebackStatusItems0Aggregate) UnmarshalBinary(b []byte) error {
	var res NodeHaGivebackStatusItems0Aggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeHaGivebackStatusItems0AggregateLinks node ha giveback status items0 aggregate links
//
// swagger:model NodeHaGivebackStatusItems0AggregateLinks
type NodeHaGivebackStatusItems0AggregateLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node ha giveback status items0 aggregate links
func (m *NodeHaGivebackStatusItems0AggregateLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0AggregateLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node ha giveback status items0 aggregate links based on the context it is used
func (m *NodeHaGivebackStatusItems0AggregateLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0AggregateLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeHaGivebackStatusItems0AggregateLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeHaGivebackStatusItems0AggregateLinks) UnmarshalBinary(b []byte) error {
	var res NodeHaGivebackStatusItems0AggregateLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeHaGivebackStatusItems0Error Indicates the failed aggregate giveback code and message.
//
// swagger:model NodeHaGivebackStatusItems0Error
type NodeHaGivebackStatusItems0Error struct {

	// Message code.
	// Example: 852126
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Detailed message based on the state.
	// Read Only: true
	// Enum: ["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]
	Message *string `json:"message,omitempty"`
}

// Validate validates this node ha giveback status items0 error
func (m *NodeHaGivebackStatusItems0Error) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeHaGivebackStatusItems0ErrorTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeHaGivebackStatusItems0ErrorTypeMessagePropEnum = append(nodeHaGivebackStatusItems0ErrorTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// shutdown
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageShutdown captures enum value "shutdown"
	NodeHaGivebackStatusItems0ErrorMessageShutdown string = "shutdown"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// not_homes_partner
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageNotHomesPartner captures enum value "not_homes_partner"
	NodeHaGivebackStatusItems0ErrorMessageNotHomesPartner string = "not_homes_partner"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// not_sfo
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageNotSfo captures enum value "not_sfo"
	NodeHaGivebackStatusItems0ErrorMessageNotSfo string = "not_sfo"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// failed_limbo
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageFailedLimbo captures enum value "failed_limbo"
	NodeHaGivebackStatusItems0ErrorMessageFailedLimbo string = "failed_limbo"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// offline_failed
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageOfflineFailed captures enum value "offline_failed"
	NodeHaGivebackStatusItems0ErrorMessageOfflineFailed string = "offline_failed"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// migrating
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageMigrating captures enum value "migrating"
	NodeHaGivebackStatusItems0ErrorMessageMigrating string = "migrating"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// veto
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageVeto captures enum value "veto"
	NodeHaGivebackStatusItems0ErrorMessageVeto string = "veto"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// communication_err
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageCommunicationErr captures enum value "communication_err"
	NodeHaGivebackStatusItems0ErrorMessageCommunicationErr string = "communication_err"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// online_timeout
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageOnlineTimeout captures enum value "online_timeout"
	NodeHaGivebackStatusItems0ErrorMessageOnlineTimeout string = "online_timeout"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// online_failed
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageOnlineFailed captures enum value "online_failed"
	NodeHaGivebackStatusItems0ErrorMessageOnlineFailed string = "online_failed"

	// BEGIN DEBUGGING
	// NodeHaGivebackStatusItems0Error
	// NodeHaGivebackStatusItems0Error
	// message
	// Message
	// hdd_to_aff_dest
	// END DEBUGGING
	// NodeHaGivebackStatusItems0ErrorMessageHddToAffDest captures enum value "hdd_to_aff_dest"
	NodeHaGivebackStatusItems0ErrorMessageHddToAffDest string = "hdd_to_aff_dest"
)

// prop value enum
func (m *NodeHaGivebackStatusItems0Error) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeHaGivebackStatusItems0ErrorTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0Error) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	// value enum
	if err := m.validateMessageEnum("error"+"."+"message", "body", *m.Message); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node ha giveback status items0 error based on the context it is used
func (m *NodeHaGivebackStatusItems0Error) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaGivebackStatusItems0Error) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *NodeHaGivebackStatusItems0Error) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeHaGivebackStatusItems0Error) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeHaGivebackStatusItems0Error) UnmarshalBinary(b []byte) error {
	var res NodeHaGivebackStatusItems0Error
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHaInlineInterconnect node inline ha inline interconnect
//
// swagger:model node_inline_ha_inline_interconnect
type NodeInlineHaInlineInterconnect struct {

	// HA interconnect device name.
	// Example: MVIA-RDMA
	// Read Only: true
	Adapter *string `json:"adapter,omitempty"`

	// Indicates the HA interconnect status.
	// Read Only: true
	// Enum: ["down","up"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node inline ha inline interconnect
func (m *NodeInlineHaInlineInterconnect) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineHaInlineInterconnectTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","up"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineHaInlineInterconnectTypeStatePropEnum = append(nodeInlineHaInlineInterconnectTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_ha_inline_interconnect
	// NodeInlineHaInlineInterconnect
	// state
	// State
	// down
	// END DEBUGGING
	// NodeInlineHaInlineInterconnectStateDown captures enum value "down"
	NodeInlineHaInlineInterconnectStateDown string = "down"

	// BEGIN DEBUGGING
	// node_inline_ha_inline_interconnect
	// NodeInlineHaInlineInterconnect
	// state
	// State
	// up
	// END DEBUGGING
	// NodeInlineHaInlineInterconnectStateUp captures enum value "up"
	NodeInlineHaInlineInterconnectStateUp string = "up"
)

// prop value enum
func (m *NodeInlineHaInlineInterconnect) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineHaInlineInterconnectTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineHaInlineInterconnect) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"interconnect"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline ha inline interconnect based on the context it is used
func (m *NodeInlineHaInlineInterconnect) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAdapter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHaInlineInterconnect) contextValidateAdapter(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"interconnect"+"."+"adapter", "body", m.Adapter); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineHaInlineInterconnect) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"interconnect"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHaInlineInterconnect) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHaInlineInterconnect) UnmarshalBinary(b []byte) error {
	var res NodeInlineHaInlineInterconnect
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeHaPartnersItems0 node ha partners items0
//
// swagger:model NodeHaPartnersItems0
type NodeHaPartnersItems0 struct {

	// links
	Links *NodeHaPartnersItems0Links `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node ha partners items0
func (m *NodeHaPartnersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaPartnersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node ha partners items0 based on the context it is used
func (m *NodeHaPartnersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaPartnersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeHaPartnersItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeHaPartnersItems0) UnmarshalBinary(b []byte) error {
	var res NodeHaPartnersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeHaPartnersItems0Links node ha partners items0 links
//
// swagger:model NodeHaPartnersItems0Links
type NodeHaPartnersItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node ha partners items0 links
func (m *NodeHaPartnersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaPartnersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node ha partners items0 links based on the context it is used
func (m *NodeHaPartnersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaPartnersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeHaPartnersItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeHaPartnersItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeHaPartnersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeHaPortsItems0 node ha ports items0
//
// swagger:model NodeHaPortsItems0
type NodeHaPortsItems0 struct {

	// HA port number
	// Example: 0
	// Read Only: true
	Number *int64 `json:"number,omitempty"`

	// HA port state:
	// * <i>down</i> - Logical HA link is down.
	// * <i>initialized</i> - Logical HA link is initialized. The physical link is up, but the subnet manager hasn't started to configure the port.
	// * <i>armed</i> - Logical HA link is armed. The physical link is up and the subnet manager started but did not yet complete configuring the port.
	// * <i>active</i> - Logical HA link is active.
	// * <i>reserved</i> - Logical HA link is active, but the physical link is down.
	//
	// Example: active
	// Read Only: true
	// Enum: ["down","initialized","armed","active","reserved"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node ha ports items0
func (m *NodeHaPortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeHaPortsItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","initialized","armed","active","reserved"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeHaPortsItems0TypeStatePropEnum = append(nodeHaPortsItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeHaPortsItems0
	// NodeHaPortsItems0
	// state
	// State
	// down
	// END DEBUGGING
	// NodeHaPortsItems0StateDown captures enum value "down"
	NodeHaPortsItems0StateDown string = "down"

	// BEGIN DEBUGGING
	// NodeHaPortsItems0
	// NodeHaPortsItems0
	// state
	// State
	// initialized
	// END DEBUGGING
	// NodeHaPortsItems0StateInitialized captures enum value "initialized"
	NodeHaPortsItems0StateInitialized string = "initialized"

	// BEGIN DEBUGGING
	// NodeHaPortsItems0
	// NodeHaPortsItems0
	// state
	// State
	// armed
	// END DEBUGGING
	// NodeHaPortsItems0StateArmed captures enum value "armed"
	NodeHaPortsItems0StateArmed string = "armed"

	// BEGIN DEBUGGING
	// NodeHaPortsItems0
	// NodeHaPortsItems0
	// state
	// State
	// active
	// END DEBUGGING
	// NodeHaPortsItems0StateActive captures enum value "active"
	NodeHaPortsItems0StateActive string = "active"

	// BEGIN DEBUGGING
	// NodeHaPortsItems0
	// NodeHaPortsItems0
	// state
	// State
	// reserved
	// END DEBUGGING
	// NodeHaPortsItems0StateReserved captures enum value "reserved"
	NodeHaPortsItems0StateReserved string = "reserved"
)

// prop value enum
func (m *NodeHaPortsItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeHaPortsItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeHaPortsItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node ha ports items0 based on the context it is used
func (m *NodeHaPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeHaPortsItems0) contextValidateNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "number", "body", m.Number); err != nil {
		return err
	}

	return nil
}

func (m *NodeHaPortsItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeHaPortsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeHaPortsItems0) UnmarshalBinary(b []byte) error {
	var res NodeHaPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHaInlineTakeover This represents the state of the node that is taking over storage from its HA partner.
//
// swagger:model node_inline_ha_inline_takeover
type NodeInlineHaInlineTakeover struct {

	// failure
	Failure *NodeInlineHaInlineTakeoverInlineFailure `json:"failure,omitempty"`

	// state
	// Example: failed
	// Enum: ["not_possible","not_attempted","in_takeover","in_progress","failed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node inline ha inline takeover
func (m *NodeInlineHaInlineTakeover) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHaInlineTakeover) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

var nodeInlineHaInlineTakeoverTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_possible","not_attempted","in_takeover","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineHaInlineTakeoverTypeStatePropEnum = append(nodeInlineHaInlineTakeoverTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_ha_inline_takeover
	// NodeInlineHaInlineTakeover
	// state
	// State
	// not_possible
	// END DEBUGGING
	// NodeInlineHaInlineTakeoverStateNotPossible captures enum value "not_possible"
	NodeInlineHaInlineTakeoverStateNotPossible string = "not_possible"

	// BEGIN DEBUGGING
	// node_inline_ha_inline_takeover
	// NodeInlineHaInlineTakeover
	// state
	// State
	// not_attempted
	// END DEBUGGING
	// NodeInlineHaInlineTakeoverStateNotAttempted captures enum value "not_attempted"
	NodeInlineHaInlineTakeoverStateNotAttempted string = "not_attempted"

	// BEGIN DEBUGGING
	// node_inline_ha_inline_takeover
	// NodeInlineHaInlineTakeover
	// state
	// State
	// in_takeover
	// END DEBUGGING
	// NodeInlineHaInlineTakeoverStateInTakeover captures enum value "in_takeover"
	NodeInlineHaInlineTakeoverStateInTakeover string = "in_takeover"

	// BEGIN DEBUGGING
	// node_inline_ha_inline_takeover
	// NodeInlineHaInlineTakeover
	// state
	// State
	// in_progress
	// END DEBUGGING
	// NodeInlineHaInlineTakeoverStateInProgress captures enum value "in_progress"
	NodeInlineHaInlineTakeoverStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// node_inline_ha_inline_takeover
	// NodeInlineHaInlineTakeover
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeInlineHaInlineTakeoverStateFailed captures enum value "failed"
	NodeInlineHaInlineTakeoverStateFailed string = "failed"
)

// prop value enum
func (m *NodeInlineHaInlineTakeover) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineHaInlineTakeoverTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineHaInlineTakeover) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"takeover"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline ha inline takeover based on the context it is used
func (m *NodeInlineHaInlineTakeover) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHaInlineTakeover) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHaInlineTakeover) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHaInlineTakeover) UnmarshalBinary(b []byte) error {
	var res NodeInlineHaInlineTakeover
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHaInlineTakeoverCheck The takeover check response.
//
// swagger:model node_inline_ha_inline_takeover_check
type NodeInlineHaInlineTakeoverCheck struct {

	// Reasons why the takeover is not possible.
	// Read Only: true
	Reasons []*string `json:"reasons,omitempty"`

	// Indicates whether the takeover is possible.
	// Read Only: true
	TakeoverPossible *bool `json:"takeover_possible,omitempty"`
}

// Validate validates this node inline ha inline takeover check
func (m *NodeInlineHaInlineTakeoverCheck) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline ha inline takeover check based on the context it is used
func (m *NodeInlineHaInlineTakeoverCheck) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReasons(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeoverPossible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHaInlineTakeoverCheck) contextValidateReasons(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"reasons", "body", []*string(m.Reasons)); err != nil {
		return err
	}

	for i := 0; i < len(m.Reasons); i++ {

		if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"reasons"+"."+strconv.Itoa(i), "body", m.Reasons[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *NodeInlineHaInlineTakeoverCheck) contextValidateTakeoverPossible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"takeover_possible", "body", m.TakeoverPossible); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHaInlineTakeoverCheck) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHaInlineTakeoverCheck) UnmarshalBinary(b []byte) error {
	var res NodeInlineHaInlineTakeoverCheck
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHaInlineTakeoverInlineFailure Indicates the failure code and message. This property is not supported on the ASA r2 platform.
//
// swagger:model node_inline_ha_inline_takeover_inline_failure
type NodeInlineHaInlineTakeoverInlineFailure struct {

	// Message code
	// Example: 852130
	Code *int64 `json:"code,omitempty"`

	// Detailed message based on the state.
	// Example: Failed to initiate takeover. Run the \"storage failover show-takeover\" command for more information.
	Message *string `json:"message,omitempty"`
}

// Validate validates this node inline ha inline takeover inline failure
func (m *NodeInlineHaInlineTakeoverInlineFailure) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline ha inline takeover inline failure based on the context it is used
func (m *NodeInlineHaInlineTakeoverInlineFailure) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHaInlineTakeoverInlineFailure) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHaInlineTakeoverInlineFailure) UnmarshalBinary(b []byte) error {
	var res NodeInlineHaInlineTakeoverInlineFailure
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHwAssist The hardware assist information.
//
// swagger:model node_inline_hw_assist
type NodeInlineHwAssist struct {

	// status
	Status *NodeInlineHwAssistInlineStatus `json:"status,omitempty"`
}

// Validate validates this node inline hw assist
func (m *NodeInlineHwAssist) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHwAssist) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline hw assist based on the context it is used
func (m *NodeInlineHwAssist) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHwAssist) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHwAssist) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHwAssist) UnmarshalBinary(b []byte) error {
	var res NodeInlineHwAssist
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHwAssistInlineStatus node inline hw assist inline status
//
// swagger:model node_inline_hw_assist_inline_status
type NodeInlineHwAssistInlineStatus struct {

	// Indicates whether hardware assist is enabled on the node.
	Enabled *bool `json:"enabled,omitempty"`

	// local
	Local *NodeInlineHwAssistInlineStatusInlineLocal `json:"local,omitempty"`

	// partner
	Partner *NodeInlineHwAssistInlineStatusInlinePartner `json:"partner,omitempty"`
}

// Validate validates this node inline hw assist inline status
func (m *NodeInlineHwAssistInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHwAssistInlineStatus) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(m.Local) { // not required
		return nil
	}

	if m.Local != nil {
		if err := m.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHwAssistInlineStatus) validatePartner(formats strfmt.Registry) error {
	if swag.IsZero(m.Partner) { // not required
		return nil
	}

	if m.Partner != nil {
		if err := m.Partner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "partner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline hw assist inline status based on the context it is used
func (m *NodeInlineHwAssistInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineHwAssistInlineStatus) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if m.Local != nil {
		if err := m.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineHwAssistInlineStatus) contextValidatePartner(ctx context.Context, formats strfmt.Registry) error {

	if m.Partner != nil {
		if err := m.Partner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "partner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHwAssistInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHwAssistInlineStatus) UnmarshalBinary(b []byte) error {
	var res NodeInlineHwAssistInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHwAssistInlineStatusInlineLocal node inline hw assist inline status inline local
//
// swagger:model node_inline_hw_assist_inline_status_inline_local
type NodeInlineHwAssistInlineStatusInlineLocal struct {

	// The hardware assist IP address.
	IP *string `json:"ip,omitempty"`

	// The hardware assist port.
	Port *int64 `json:"port,omitempty"`

	// The hardware assist monitor status.
	// Enum: ["active","inactive"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node inline hw assist inline status inline local
func (m *NodeInlineHwAssistInlineStatusInlineLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","inactive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum = append(nodeInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_hw_assist_inline_status_inline_local
	// NodeInlineHwAssistInlineStatusInlineLocal
	// state
	// State
	// active
	// END DEBUGGING
	// NodeInlineHwAssistInlineStatusInlineLocalStateActive captures enum value "active"
	NodeInlineHwAssistInlineStatusInlineLocalStateActive string = "active"

	// BEGIN DEBUGGING
	// node_inline_hw_assist_inline_status_inline_local
	// NodeInlineHwAssistInlineStatusInlineLocal
	// state
	// State
	// inactive
	// END DEBUGGING
	// NodeInlineHwAssistInlineStatusInlineLocalStateInactive captures enum value "inactive"
	NodeInlineHwAssistInlineStatusInlineLocalStateInactive string = "inactive"
)

// prop value enum
func (m *NodeInlineHwAssistInlineStatusInlineLocal) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineHwAssistInlineStatusInlineLocal) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("hw_assist"+"."+"status"+"."+"local"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node inline hw assist inline status inline local based on context it is used
func (m *NodeInlineHwAssistInlineStatusInlineLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHwAssistInlineStatusInlineLocal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHwAssistInlineStatusInlineLocal) UnmarshalBinary(b []byte) error {
	var res NodeInlineHwAssistInlineStatusInlineLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineHwAssistInlineStatusInlinePartner node inline hw assist inline status inline partner
//
// swagger:model node_inline_hw_assist_inline_status_inline_partner
type NodeInlineHwAssistInlineStatusInlinePartner struct {

	// The hardware assist IP address.
	IP *string `json:"ip,omitempty"`

	// The hardware assist port.
	Port *int64 `json:"port,omitempty"`

	// The hardware assist monitor status.
	// Enum: ["active","inactive"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node inline hw assist inline status inline partner
func (m *NodeInlineHwAssistInlineStatusInlinePartner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","inactive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum = append(nodeInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_hw_assist_inline_status_inline_partner
	// NodeInlineHwAssistInlineStatusInlinePartner
	// state
	// State
	// active
	// END DEBUGGING
	// NodeInlineHwAssistInlineStatusInlinePartnerStateActive captures enum value "active"
	NodeInlineHwAssistInlineStatusInlinePartnerStateActive string = "active"

	// BEGIN DEBUGGING
	// node_inline_hw_assist_inline_status_inline_partner
	// NodeInlineHwAssistInlineStatusInlinePartner
	// state
	// State
	// inactive
	// END DEBUGGING
	// NodeInlineHwAssistInlineStatusInlinePartnerStateInactive captures enum value "inactive"
	NodeInlineHwAssistInlineStatusInlinePartnerStateInactive string = "inactive"
)

// prop value enum
func (m *NodeInlineHwAssistInlineStatusInlinePartner) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineHwAssistInlineStatusInlinePartner) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("hw_assist"+"."+"status"+"."+"partner"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node inline hw assist inline status inline partner based on context it is used
func (m *NodeInlineHwAssistInlineStatusInlinePartner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineHwAssistInlineStatusInlinePartner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineHwAssistInlineStatusInlinePartner) UnmarshalBinary(b []byte) error {
	var res NodeInlineHwAssistInlineStatusInlinePartner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineLinks node inline links
//
// swagger:model node_inline__links
type NodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node inline links
func (m *NodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline links based on the context it is used
func (m *NodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineManagementInterface The management interface of the node to be added. The subnet mask is set based on the management interface of the cluster or the management interfaces of other nodes.
//
// swagger:model node_inline_management_interface
type NodeInlineManagementInterface struct {

	// ip
	IP *NodeSetupIP `json:"ip,omitempty"`
}

// Validate validates this node inline management interface
func (m *NodeInlineManagementInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineManagementInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline management interface based on the context it is used
func (m *NodeInlineManagementInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineManagementInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineManagementInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineManagementInterface) UnmarshalBinary(b []byte) error {
	var res NodeInlineManagementInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineManagementInterfacesInlineArrayItem Network interface
//
// swagger:model node_inline_management_interfaces_inline_array_item
type NodeInlineManagementInterfacesInlineArrayItem struct {

	// links
	Links *NodeInlineManagementInterfacesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// ip
	IP *NodeInlineManagementInterfacesInlineArrayItemInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node inline management interfaces inline array item
func (m *NodeInlineManagementInterfacesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineManagementInterfacesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineManagementInterfacesInlineArrayItem) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline management interfaces inline array item based on the context it is used
func (m *NodeInlineManagementInterfacesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineManagementInterfacesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineManagementInterfacesInlineArrayItem) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineManagementInterfacesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineManagementInterfacesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NodeInlineManagementInterfacesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineManagementInterfacesInlineArrayItemInlineIP IP information
//
// swagger:model node_inline_management_interfaces_inline_array_item_inline_ip
type NodeInlineManagementInterfacesInlineArrayItemInlineIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this node inline management interfaces inline array item inline ip
func (m *NodeInlineManagementInterfacesInlineArrayItemInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineManagementInterfacesInlineArrayItemInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline management interfaces inline array item inline ip based on the context it is used
func (m *NodeInlineManagementInterfacesInlineArrayItemInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineManagementInterfacesInlineArrayItemInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineManagementInterfacesInlineArrayItemInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineManagementInterfacesInlineArrayItemInlineIP) UnmarshalBinary(b []byte) error {
	var res NodeInlineManagementInterfacesInlineArrayItemInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineManagementInterfacesInlineArrayItemInlineLinks node inline management interfaces inline array item inline links
//
// swagger:model node_inline_management_interfaces_inline_array_item_inline__links
type NodeInlineManagementInterfacesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node inline management interfaces inline array item inline links
func (m *NodeInlineManagementInterfacesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineManagementInterfacesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline management interfaces inline array item inline links based on the context it is used
func (m *NodeInlineManagementInterfacesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineManagementInterfacesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineManagementInterfacesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineManagementInterfacesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeInlineManagementInterfacesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineMetric CPU performance for the nodes.
//
// swagger:model node_inline_metric
type NodeInlineMetric struct {

	// links
	Links *NodeInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT5M","PT30M","PT2H","P1D"]
	Duration *string `json:"duration,omitempty"`

	// Average CPU Utilization for the node
	// Example: 13
	ProcessorUtilization *int64 `json:"processor_utilization,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node inline metric
func (m *NodeInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nodeInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","P1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineMetricTypeDurationPropEnum = append(nodeInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NodeInlineMetricDurationPT15S captures enum value "PT15S"
	NodeInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NodeInlineMetricDurationPT5M captures enum value "PT5M"
	NodeInlineMetricDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NodeInlineMetricDurationPT30M captures enum value "PT30M"
	NodeInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NodeInlineMetricDurationPT2H captures enum value "PT2H"
	NodeInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NodeInlineMetricDurationP1D captures enum value "P1D"
	NodeInlineMetricDurationP1D string = "P1D"
)

// prop value enum
func (m *NodeInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var nodeInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineMetricTypeStatusPropEnum = append(nodeInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// NodeInlineMetricStatusOk captures enum value "ok"
	NodeInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// NodeInlineMetricStatusError captures enum value "error"
	NodeInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NodeInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	NodeInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NodeInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	NodeInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NodeInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	NodeInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NodeInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	NodeInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NodeInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	NodeInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NodeInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	NodeInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NodeInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NodeInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// node_inline_metric
	// NodeInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NodeInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NodeInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *NodeInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline metric based on the context it is used
func (m *NodeInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineMetric) UnmarshalBinary(b []byte) error {
	var res NodeInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineMetricInlineLinks node inline metric inline links
//
// swagger:model node_inline_metric_inline__links
type NodeInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node inline metric inline links
func (m *NodeInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline metric inline links based on the context it is used
func (m *NodeInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineMetrocluster Metrocluster
//
// swagger:model node_inline_metrocluster
type NodeInlineMetrocluster struct {

	// Indicates whether the MetroCluster over IP platform supports custom VLAN IDs.
	// Read Only: true
	CustomVlanCapable *bool `json:"custom_vlan_capable,omitempty"`

	// MetroCluster over IP ports.
	// Read Only: true
	Ports []*NodeMetroclusterPortsItems0 `json:"ports,omitempty"`

	// The Metrocluster configuration type
	// Read Only: true
	// Enum: ["fc","fc_2_node","ip"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this node inline metrocluster
func (m *NodeInlineMetrocluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineMetrocluster) validatePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.Ports) { // not required
		return nil
	}

	for i := 0; i < len(m.Ports); i++ {
		if swag.IsZero(m.Ports[i]) { // not required
			continue
		}

		if m.Ports[i] != nil {
			if err := m.Ports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrocluster" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nodeInlineMetroclusterTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc","fc_2_node","ip"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineMetroclusterTypeTypePropEnum = append(nodeInlineMetroclusterTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_metrocluster
	// NodeInlineMetrocluster
	// type
	// Type
	// fc
	// END DEBUGGING
	// NodeInlineMetroclusterTypeFc captures enum value "fc"
	NodeInlineMetroclusterTypeFc string = "fc"

	// BEGIN DEBUGGING
	// node_inline_metrocluster
	// NodeInlineMetrocluster
	// type
	// Type
	// fc_2_node
	// END DEBUGGING
	// NodeInlineMetroclusterTypeFc2Node captures enum value "fc_2_node"
	NodeInlineMetroclusterTypeFc2Node string = "fc_2_node"

	// BEGIN DEBUGGING
	// node_inline_metrocluster
	// NodeInlineMetrocluster
	// type
	// Type
	// ip
	// END DEBUGGING
	// NodeInlineMetroclusterTypeIP captures enum value "ip"
	NodeInlineMetroclusterTypeIP string = "ip"
)

// prop value enum
func (m *NodeInlineMetrocluster) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineMetroclusterTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineMetrocluster) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("metrocluster"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline metrocluster based on the context it is used
func (m *NodeInlineMetrocluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCustomVlanCapable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineMetrocluster) contextValidateCustomVlanCapable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"custom_vlan_capable", "body", m.CustomVlanCapable); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineMetrocluster) contextValidatePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"ports", "body", []*NodeMetroclusterPortsItems0(m.Ports)); err != nil {
		return err
	}

	for i := 0; i < len(m.Ports); i++ {

		if m.Ports[i] != nil {
			if err := m.Ports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrocluster" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeInlineMetrocluster) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineMetrocluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineMetrocluster) UnmarshalBinary(b []byte) error {
	var res NodeInlineMetrocluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeMetroclusterPortsItems0 node metrocluster ports items0
//
// swagger:model NodeMetroclusterPortsItems0
type NodeMetroclusterPortsItems0 struct {

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`
}

// Validate validates this node metrocluster ports items0
func (m *NodeMetroclusterPortsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this node metrocluster ports items0 based on context it is used
func (m *NodeMetroclusterPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeMetroclusterPortsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeMetroclusterPortsItems0) UnmarshalBinary(b []byte) error {
	var res NodeMetroclusterPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineNvlog Non-volatile write log settings.
//
// swagger:model node_inline_nvlog
type NodeInlineNvlog struct {

	// Indicates the current NVLog journal backing type.
	// Enum: ["ephemeral_memory","ephemeral_disk"]
	BackingType *string `json:"backing_type,omitempty"`

	// Indicates the current NVLog journal swap mode.
	// Enum: ["dynamic","manual"]
	SwapMode *string `json:"swap_mode,omitempty"`
}

// Validate validates this node inline nvlog
func (m *NodeInlineNvlog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBackingType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSwapMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineNvlogTypeBackingTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ephemeral_memory","ephemeral_disk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineNvlogTypeBackingTypePropEnum = append(nodeInlineNvlogTypeBackingTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_nvlog
	// NodeInlineNvlog
	// backing_type
	// BackingType
	// ephemeral_memory
	// END DEBUGGING
	// NodeInlineNvlogBackingTypeEphemeralMemory captures enum value "ephemeral_memory"
	NodeInlineNvlogBackingTypeEphemeralMemory string = "ephemeral_memory"

	// BEGIN DEBUGGING
	// node_inline_nvlog
	// NodeInlineNvlog
	// backing_type
	// BackingType
	// ephemeral_disk
	// END DEBUGGING
	// NodeInlineNvlogBackingTypeEphemeralDisk captures enum value "ephemeral_disk"
	NodeInlineNvlogBackingTypeEphemeralDisk string = "ephemeral_disk"
)

// prop value enum
func (m *NodeInlineNvlog) validateBackingTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineNvlogTypeBackingTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineNvlog) validateBackingType(formats strfmt.Registry) error {
	if swag.IsZero(m.BackingType) { // not required
		return nil
	}

	// value enum
	if err := m.validateBackingTypeEnum("nvlog"+"."+"backing_type", "body", *m.BackingType); err != nil {
		return err
	}

	return nil
}

var nodeInlineNvlogTypeSwapModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["dynamic","manual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineNvlogTypeSwapModePropEnum = append(nodeInlineNvlogTypeSwapModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_nvlog
	// NodeInlineNvlog
	// swap_mode
	// SwapMode
	// dynamic
	// END DEBUGGING
	// NodeInlineNvlogSwapModeDynamic captures enum value "dynamic"
	NodeInlineNvlogSwapModeDynamic string = "dynamic"

	// BEGIN DEBUGGING
	// node_inline_nvlog
	// NodeInlineNvlog
	// swap_mode
	// SwapMode
	// manual
	// END DEBUGGING
	// NodeInlineNvlogSwapModeManual captures enum value "manual"
	NodeInlineNvlogSwapModeManual string = "manual"
)

// prop value enum
func (m *NodeInlineNvlog) validateSwapModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineNvlogTypeSwapModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineNvlog) validateSwapMode(formats strfmt.Registry) error {
	if swag.IsZero(m.SwapMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateSwapModeEnum("nvlog"+"."+"swap_mode", "body", *m.SwapMode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node inline nvlog based on context it is used
func (m *NodeInlineNvlog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineNvlog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineNvlog) UnmarshalBinary(b []byte) error {
	var res NodeInlineNvlog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineNvram node inline nvram
//
// swagger:model node_inline_nvram
type NodeInlineNvram struct {

	// Specifies status of the NVRAM battery. Possible values:
	// * <i>battery_ok</i>
	// * <i>battery_partially_discharged</i>
	// * <i>battery_fully_discharged</i>
	// * <i>battery_not_present</i>
	// * <i>battery_near_end_of_life</i>
	// * <i>battery_at_end_of_life</i>
	// * <i>battery_unknown</i>
	// * <i>battery_over_charged</i>
	// * <i>battery_fully_charged</i>
	//
	// Read Only: true
	// Enum: ["battery_ok","battery_partially_discharged","battery_fully_discharged","battery_not_present","battery_near_end_of_life","battery_at_end_of_life","battery_unknown","battery_over_charged","battery_fully_charged"]
	BatteryState *string `json:"battery_state,omitempty"`

	// Vendor specific NVRAM ID of the node.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`
}

// Validate validates this node inline nvram
func (m *NodeInlineNvram) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBatteryState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineNvramTypeBatteryStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["battery_ok","battery_partially_discharged","battery_fully_discharged","battery_not_present","battery_near_end_of_life","battery_at_end_of_life","battery_unknown","battery_over_charged","battery_fully_charged"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineNvramTypeBatteryStatePropEnum = append(nodeInlineNvramTypeBatteryStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_ok
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryOk captures enum value "battery_ok"
	NodeInlineNvramBatteryStateBatteryOk string = "battery_ok"

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_partially_discharged
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryPartiallyDischarged captures enum value "battery_partially_discharged"
	NodeInlineNvramBatteryStateBatteryPartiallyDischarged string = "battery_partially_discharged"

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_fully_discharged
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryFullyDischarged captures enum value "battery_fully_discharged"
	NodeInlineNvramBatteryStateBatteryFullyDischarged string = "battery_fully_discharged"

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_not_present
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryNotPresent captures enum value "battery_not_present"
	NodeInlineNvramBatteryStateBatteryNotPresent string = "battery_not_present"

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_near_end_of_life
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryNearEndOfLife captures enum value "battery_near_end_of_life"
	NodeInlineNvramBatteryStateBatteryNearEndOfLife string = "battery_near_end_of_life"

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_at_end_of_life
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryAtEndOfLife captures enum value "battery_at_end_of_life"
	NodeInlineNvramBatteryStateBatteryAtEndOfLife string = "battery_at_end_of_life"

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_unknown
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryUnknown captures enum value "battery_unknown"
	NodeInlineNvramBatteryStateBatteryUnknown string = "battery_unknown"

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_over_charged
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryOverCharged captures enum value "battery_over_charged"
	NodeInlineNvramBatteryStateBatteryOverCharged string = "battery_over_charged"

	// BEGIN DEBUGGING
	// node_inline_nvram
	// NodeInlineNvram
	// battery_state
	// BatteryState
	// battery_fully_charged
	// END DEBUGGING
	// NodeInlineNvramBatteryStateBatteryFullyCharged captures enum value "battery_fully_charged"
	NodeInlineNvramBatteryStateBatteryFullyCharged string = "battery_fully_charged"
)

// prop value enum
func (m *NodeInlineNvram) validateBatteryStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineNvramTypeBatteryStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineNvram) validateBatteryState(formats strfmt.Registry) error {
	if swag.IsZero(m.BatteryState) { // not required
		return nil
	}

	// value enum
	if err := m.validateBatteryStateEnum("nvram"+"."+"battery_state", "body", *m.BatteryState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline nvram based on the context it is used
func (m *NodeInlineNvram) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBatteryState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineNvram) contextValidateBatteryState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nvram"+"."+"battery_state", "body", m.BatteryState); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineNvram) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nvram"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineNvram) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineNvram) UnmarshalBinary(b []byte) error {
	var res NodeInlineNvram
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessor node inline service processor
//
// swagger:model node_inline_service_processor
type NodeInlineServiceProcessor struct {

	// api service
	APIService *NodeInlineServiceProcessorInlineAPIService `json:"api_service,omitempty"`

	// auto config
	AutoConfig *NodeInlineServiceProcessorInlineAutoConfig `json:"auto_config,omitempty"`

	// Indicates whether the service processor can be automatically updated from ONTAP.
	AutoupdateEnabled *bool `json:"autoupdate_enabled,omitempty"`

	// backup
	Backup *NodeInlineServiceProcessorInlineBackup `json:"backup,omitempty"`

	// Set to "true" to use DHCP to configure an IPv4 interface. Do not provide values for address, netmask and gateway when set to "true".
	DhcpEnabled *bool `json:"dhcp_enabled,omitempty"`

	// The version of firmware installed.
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// ipv4 interface
	IPV4Interface *NodeInlineServiceProcessorInlineIPV4Interface `json:"ipv4_interface,omitempty"`

	// ipv6 interface
	IPV6Interface *NodeInlineServiceProcessorInlineIPV6Interface `json:"ipv6_interface,omitempty"`

	// Indicates whether the service processor network is configured.
	// Read Only: true
	IsIPConfigured *bool `json:"is_ip_configured,omitempty"`

	// Provides the "update status" of the last service processor update.
	// Read Only: true
	// Enum: ["failed","passed"]
	LastUpdateState *string `json:"last_update_state,omitempty"`

	// link status
	// Read Only: true
	// Enum: ["up","down","disabled","unknown"]
	LinkStatus *string `json:"link_status,omitempty"`

	// mac address
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// primary
	Primary *NodeInlineServiceProcessorInlinePrimary `json:"primary,omitempty"`

	// ssh info
	SSHInfo *NodeInlineServiceProcessorInlineSSHInfo `json:"ssh_info,omitempty"`

	// state
	// Read Only: true
	// Enum: ["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["sp","none","bmc"]
	Type *string `json:"type,omitempty"`

	// web service
	WebService *NodeInlineServiceProcessorInlineWebService `json:"web_service,omitempty"`
}

// Validate validates this node inline service processor
func (m *NodeInlineServiceProcessor) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPIService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutoConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV4Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLinkStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrimary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSSHInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWebService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineServiceProcessor) validateAPIService(formats strfmt.Registry) error {
	if swag.IsZero(m.APIService) { // not required
		return nil
	}

	if m.APIService != nil {
		if err := m.APIService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "api_service")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) validateAutoConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.AutoConfig) { // not required
		return nil
	}

	if m.AutoConfig != nil {
		if err := m.AutoConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "auto_config")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) validateBackup(formats strfmt.Registry) error {
	if swag.IsZero(m.Backup) { // not required
		return nil
	}

	if m.Backup != nil {
		if err := m.Backup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "backup")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) validateIPV4Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4Interface) { // not required
		return nil
	}

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) validateIPV6Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6Interface) { // not required
		return nil
	}

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv6_interface")
			}
			return err
		}
	}

	return nil
}

var nodeInlineServiceProcessorTypeLastUpdateStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["failed","passed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineServiceProcessorTypeLastUpdateStatePropEnum = append(nodeInlineServiceProcessorTypeLastUpdateStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// last_update_state
	// LastUpdateState
	// failed
	// END DEBUGGING
	// NodeInlineServiceProcessorLastUpdateStateFailed captures enum value "failed"
	NodeInlineServiceProcessorLastUpdateStateFailed string = "failed"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// last_update_state
	// LastUpdateState
	// passed
	// END DEBUGGING
	// NodeInlineServiceProcessorLastUpdateStatePassed captures enum value "passed"
	NodeInlineServiceProcessorLastUpdateStatePassed string = "passed"
)

// prop value enum
func (m *NodeInlineServiceProcessor) validateLastUpdateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineServiceProcessorTypeLastUpdateStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineServiceProcessor) validateLastUpdateState(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdateState) { // not required
		return nil
	}

	// value enum
	if err := m.validateLastUpdateStateEnum("service_processor"+"."+"last_update_state", "body", *m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

var nodeInlineServiceProcessorTypeLinkStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","disabled","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineServiceProcessorTypeLinkStatusPropEnum = append(nodeInlineServiceProcessorTypeLinkStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// link_status
	// LinkStatus
	// up
	// END DEBUGGING
	// NodeInlineServiceProcessorLinkStatusUp captures enum value "up"
	NodeInlineServiceProcessorLinkStatusUp string = "up"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// link_status
	// LinkStatus
	// down
	// END DEBUGGING
	// NodeInlineServiceProcessorLinkStatusDown captures enum value "down"
	NodeInlineServiceProcessorLinkStatusDown string = "down"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// link_status
	// LinkStatus
	// disabled
	// END DEBUGGING
	// NodeInlineServiceProcessorLinkStatusDisabled captures enum value "disabled"
	NodeInlineServiceProcessorLinkStatusDisabled string = "disabled"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// link_status
	// LinkStatus
	// unknown
	// END DEBUGGING
	// NodeInlineServiceProcessorLinkStatusUnknown captures enum value "unknown"
	NodeInlineServiceProcessorLinkStatusUnknown string = "unknown"
)

// prop value enum
func (m *NodeInlineServiceProcessor) validateLinkStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineServiceProcessorTypeLinkStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineServiceProcessor) validateLinkStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.LinkStatus) { // not required
		return nil
	}

	// value enum
	if err := m.validateLinkStatusEnum("service_processor"+"."+"link_status", "body", *m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) validatePrimary(formats strfmt.Registry) error {
	if swag.IsZero(m.Primary) { // not required
		return nil
	}

	if m.Primary != nil {
		if err := m.Primary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) validateSSHInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.SSHInfo) { // not required
		return nil
	}

	if m.SSHInfo != nil {
		if err := m.SSHInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ssh_info")
			}
			return err
		}
	}

	return nil
}

var nodeInlineServiceProcessorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineServiceProcessorTypeStatePropEnum = append(nodeInlineServiceProcessorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// state
	// State
	// online
	// END DEBUGGING
	// NodeInlineServiceProcessorStateOnline captures enum value "online"
	NodeInlineServiceProcessorStateOnline string = "online"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// state
	// State
	// offline
	// END DEBUGGING
	// NodeInlineServiceProcessorStateOffline captures enum value "offline"
	NodeInlineServiceProcessorStateOffline string = "offline"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// state
	// State
	// degraded
	// END DEBUGGING
	// NodeInlineServiceProcessorStateDegraded captures enum value "degraded"
	NodeInlineServiceProcessorStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// state
	// State
	// rebooting
	// END DEBUGGING
	// NodeInlineServiceProcessorStateRebooting captures enum value "rebooting"
	NodeInlineServiceProcessorStateRebooting string = "rebooting"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// state
	// State
	// unknown
	// END DEBUGGING
	// NodeInlineServiceProcessorStateUnknown captures enum value "unknown"
	NodeInlineServiceProcessorStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// state
	// State
	// updating
	// END DEBUGGING
	// NodeInlineServiceProcessorStateUpdating captures enum value "updating"
	NodeInlineServiceProcessorStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// state
	// State
	// node_offline
	// END DEBUGGING
	// NodeInlineServiceProcessorStateNodeOffline captures enum value "node_offline"
	NodeInlineServiceProcessorStateNodeOffline string = "node_offline"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// state
	// State
	// sp_daemon_offline
	// END DEBUGGING
	// NodeInlineServiceProcessorStateSpDaemonOffline captures enum value "sp_daemon_offline"
	NodeInlineServiceProcessorStateSpDaemonOffline string = "sp_daemon_offline"
)

// prop value enum
func (m *NodeInlineServiceProcessor) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineServiceProcessorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineServiceProcessor) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var nodeInlineServiceProcessorTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sp","none","bmc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineServiceProcessorTypeTypePropEnum = append(nodeInlineServiceProcessorTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// type
	// Type
	// sp
	// END DEBUGGING
	// NodeInlineServiceProcessorTypeSp captures enum value "sp"
	NodeInlineServiceProcessorTypeSp string = "sp"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// type
	// Type
	// none
	// END DEBUGGING
	// NodeInlineServiceProcessorTypeNone captures enum value "none"
	NodeInlineServiceProcessorTypeNone string = "none"

	// BEGIN DEBUGGING
	// node_inline_service_processor
	// NodeInlineServiceProcessor
	// type
	// Type
	// bmc
	// END DEBUGGING
	// NodeInlineServiceProcessorTypeBmc captures enum value "bmc"
	NodeInlineServiceProcessorTypeBmc string = "bmc"
)

// prop value enum
func (m *NodeInlineServiceProcessor) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineServiceProcessorTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineServiceProcessor) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("service_processor"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) validateWebService(formats strfmt.Registry) error {
	if swag.IsZero(m.WebService) { // not required
		return nil
	}

	if m.WebService != nil {
		if err := m.WebService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "web_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline service processor based on the context it is used
func (m *NodeInlineServiceProcessor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAPIService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAutoConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBackup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV4Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV6Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsIPConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUpdateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLinkStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePrimary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSSHInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWebService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateAPIService(ctx context.Context, formats strfmt.Registry) error {

	if m.APIService != nil {
		if err := m.APIService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "api_service")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateAutoConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.AutoConfig != nil {
		if err := m.AutoConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "auto_config")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateBackup(ctx context.Context, formats strfmt.Registry) error {

	if m.Backup != nil {
		if err := m.Backup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "backup")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateIPV4Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateIPV6Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv6_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateIsIPConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"is_ip_configured", "body", m.IsIPConfigured); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateLastUpdateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"last_update_state", "body", m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateLinkStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"link_status", "body", m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"mac_address", "body", m.MacAddress); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidatePrimary(ctx context.Context, formats strfmt.Registry) error {

	if m.Primary != nil {
		if err := m.Primary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateSSHInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.SSHInfo != nil {
		if err := m.SSHInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ssh_info")
			}
			return err
		}
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessor) contextValidateWebService(ctx context.Context, formats strfmt.Registry) error {

	if m.WebService != nil {
		if err := m.WebService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "web_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessor) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessorInlineAPIService Provides the properties of the service processor (SP) or baseboard management controller (BMC) API service.
//
// swagger:model node_inline_service_processor_inline_api_service
type NodeInlineServiceProcessorInlineAPIService struct {

	// Indicates whether the SP API service of the SP or BMC is enabled or disabled. When the SP API service is disabled, features such as network-based firmware updates and network-based down node log collection are not available, and the slower serial-interface is used for firmware updates and down node log collection.
	Enabled *bool `json:"enabled,omitempty"`

	// Restricts SP API service access to cluster nodes only. By default, limit_access is set to true.
	LimitAccess *bool `json:"limit_access,omitempty"`

	// Specifies the port number on the SP or BMC used for the SP API service. By default, port 50000 is used.
	Port *int64 `json:"port,omitempty"`
}

// Validate validates this node inline service processor inline api service
func (m *NodeInlineServiceProcessorInlineAPIService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline service processor inline api service based on the context it is used
func (m *NodeInlineServiceProcessorInlineAPIService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineAPIService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineAPIService) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessorInlineAPIService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessorInlineAutoConfig Provides the properties of the service processor auto configuration.
//
// swagger:model node_inline_service_processor_inline_auto_config
type NodeInlineServiceProcessorInlineAutoConfig struct {

	// Indicates the service processor auto configuration IPv4 subnet name. To enable IPv4 auto-config give the subnet name, give the value as null or an empty string "" to disable auto-config.
	// Example: ipv4_mgmt
	IPV4Subnet *string `json:"ipv4_subnet,omitempty"`

	// Indicates the service processor auto configuration IPv6 subnet name. To enable IPv6 auto-config give the subnet name, give the value as null or an empty string "" to disable auto-config.
	// Example: ipv6_mgmt
	IPV6Subnet *string `json:"ipv6_subnet,omitempty"`
}

// Validate validates this node inline service processor inline auto config
func (m *NodeInlineServiceProcessorInlineAutoConfig) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline service processor inline auto config based on the context it is used
func (m *NodeInlineServiceProcessorInlineAutoConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineAutoConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineAutoConfig) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessorInlineAutoConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessorInlineBackup Provides the properties of the service processor backup partition.
//
// swagger:model node_inline_service_processor_inline_backup
type NodeInlineServiceProcessorInlineBackup struct {

	// Indicates whether the service processor is currently booted from the backup partition.
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// Status of the backup partition.
	// Read Only: true
	// Enum: ["installed","corrupt","updating","auto_updating","none"]
	State *string `json:"state,omitempty"`

	// Firmware version of the backup partition.
	// Example: 11.6
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this node inline service processor inline backup
func (m *NodeInlineServiceProcessorInlineBackup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineServiceProcessorInlineBackupTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","auto_updating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineServiceProcessorInlineBackupTypeStatePropEnum = append(nodeInlineServiceProcessorInlineBackupTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_backup
	// NodeInlineServiceProcessorInlineBackup
	// state
	// State
	// installed
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineBackupStateInstalled captures enum value "installed"
	NodeInlineServiceProcessorInlineBackupStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_backup
	// NodeInlineServiceProcessorInlineBackup
	// state
	// State
	// corrupt
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineBackupStateCorrupt captures enum value "corrupt"
	NodeInlineServiceProcessorInlineBackupStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_backup
	// NodeInlineServiceProcessorInlineBackup
	// state
	// State
	// updating
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineBackupStateUpdating captures enum value "updating"
	NodeInlineServiceProcessorInlineBackupStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_backup
	// NodeInlineServiceProcessorInlineBackup
	// state
	// State
	// auto_updating
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineBackupStateAutoUpdating captures enum value "auto_updating"
	NodeInlineServiceProcessorInlineBackupStateAutoUpdating string = "auto_updating"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_backup
	// NodeInlineServiceProcessorInlineBackup
	// state
	// State
	// none
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineBackupStateNone captures enum value "none"
	NodeInlineServiceProcessorInlineBackupStateNone string = "none"
)

// prop value enum
func (m *NodeInlineServiceProcessorInlineBackup) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineServiceProcessorInlineBackupTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlineBackup) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"backup"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline service processor inline backup based on the context it is used
func (m *NodeInlineServiceProcessorInlineBackup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlineBackup) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessorInlineBackup) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessorInlineBackup) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineBackup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineBackup) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessorInlineBackup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessorInlineIPV4Interface Object to set up an interface along with its default router.
//
// swagger:model node_inline_service_processor_inline_ipv4_interface
type NodeInlineServiceProcessorInlineIPV4Interface struct {

	// IPv4 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv4 interfaces is enabled. It expects dhcp_enabled as "true" or values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv4 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// Input as IPv4 mask (255.255.0.0). Output is always the netmask length.
	// Example: 255.255.0.0
	Netmask *string `json:"netmask,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this node inline service processor inline ipv4 interface
func (m *NodeInlineServiceProcessorInlineIPV4Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum = append(nodeInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_ipv4_interface
	// NodeInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineIPV4InterfaceSetupStateNotSetup captures enum value "not_setup"
	NodeInlineServiceProcessorInlineIPV4InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_ipv4_interface
	// NodeInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineIPV4InterfaceSetupStateSucceeded captures enum value "succeeded"
	NodeInlineServiceProcessorInlineIPV4InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_ipv4_interface
	// NodeInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineIPV4InterfaceSetupStateInProgress captures enum value "in_progress"
	NodeInlineServiceProcessorInlineIPV4InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_ipv4_interface
	// NodeInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineIPV4InterfaceSetupStateFailed captures enum value "failed"
	NodeInlineServiceProcessorInlineIPV4InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *NodeInlineServiceProcessorInlineIPV4Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlineIPV4Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("service_processor"+"."+"ipv4_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline service processor inline ipv4 interface based on the context it is used
func (m *NodeInlineServiceProcessorInlineIPV4Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlineIPV4Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"ipv4_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineIPV4Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineIPV4Interface) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessorInlineIPV4Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessorInlineIPV6Interface Object to setup an interface along with its default router.
//
// swagger:model node_inline_service_processor_inline_ipv6_interface
type NodeInlineServiceProcessorInlineIPV6Interface struct {

	// IPv6 address
	// Example: fd20:8b1e:b255:5011:10:141:4:97
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv6 interfaces is enabled. It expects values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv6 address of the default router.
	// Example: fd20:8b1e:b255:5011:10::1
	Gateway *string `json:"gateway,omitempty"`

	// Indicates whether IPv6 RA is enabled.
	IsIPV6RaEnabled *bool `json:"is_ipv6_ra_enabled,omitempty"`

	// Link local IP address.
	// Example: FE80::/10
	LinkLocalIP *string `json:"link_local_ip,omitempty"`

	// The IPv6 netmask/prefix length. The default value is 64 with a valid range of 1 to 127.
	// Example: 64
	Netmask *int64 `json:"netmask,omitempty"`

	// Router assigned IP address.
	// Example: 2001:0db8:85a3:0000:0000:8a2e:0370:7334
	RouterIP *string `json:"router_ip,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this node inline service processor inline ipv6 interface
func (m *NodeInlineServiceProcessorInlineIPV6Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum = append(nodeInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_ipv6_interface
	// NodeInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineIPV6InterfaceSetupStateNotSetup captures enum value "not_setup"
	NodeInlineServiceProcessorInlineIPV6InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_ipv6_interface
	// NodeInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineIPV6InterfaceSetupStateSucceeded captures enum value "succeeded"
	NodeInlineServiceProcessorInlineIPV6InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_ipv6_interface
	// NodeInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineIPV6InterfaceSetupStateInProgress captures enum value "in_progress"
	NodeInlineServiceProcessorInlineIPV6InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_ipv6_interface
	// NodeInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// NodeInlineServiceProcessorInlineIPV6InterfaceSetupStateFailed captures enum value "failed"
	NodeInlineServiceProcessorInlineIPV6InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *NodeInlineServiceProcessorInlineIPV6Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlineIPV6Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("service_processor"+"."+"ipv6_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline service processor inline ipv6 interface based on the context it is used
func (m *NodeInlineServiceProcessorInlineIPV6Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlineIPV6Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"ipv6_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineIPV6Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineIPV6Interface) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessorInlineIPV6Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessorInlinePrimary Provides the properties of the service processor primary partition.
//
// swagger:model node_inline_service_processor_inline_primary
type NodeInlineServiceProcessorInlinePrimary struct {

	// Indicates whether the service processor is currently booted from the primary partition.
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// Status of the primary partition.
	// Read Only: true
	// Enum: ["installed","corrupt","updating","auto_updating","none"]
	State *string `json:"state,omitempty"`

	// Firmware version of the primary partition.
	// Example: 11.6
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this node inline service processor inline primary
func (m *NodeInlineServiceProcessorInlinePrimary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineServiceProcessorInlinePrimaryTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","auto_updating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineServiceProcessorInlinePrimaryTypeStatePropEnum = append(nodeInlineServiceProcessorInlinePrimaryTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_primary
	// NodeInlineServiceProcessorInlinePrimary
	// state
	// State
	// installed
	// END DEBUGGING
	// NodeInlineServiceProcessorInlinePrimaryStateInstalled captures enum value "installed"
	NodeInlineServiceProcessorInlinePrimaryStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_primary
	// NodeInlineServiceProcessorInlinePrimary
	// state
	// State
	// corrupt
	// END DEBUGGING
	// NodeInlineServiceProcessorInlinePrimaryStateCorrupt captures enum value "corrupt"
	NodeInlineServiceProcessorInlinePrimaryStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_primary
	// NodeInlineServiceProcessorInlinePrimary
	// state
	// State
	// updating
	// END DEBUGGING
	// NodeInlineServiceProcessorInlinePrimaryStateUpdating captures enum value "updating"
	NodeInlineServiceProcessorInlinePrimaryStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_primary
	// NodeInlineServiceProcessorInlinePrimary
	// state
	// State
	// auto_updating
	// END DEBUGGING
	// NodeInlineServiceProcessorInlinePrimaryStateAutoUpdating captures enum value "auto_updating"
	NodeInlineServiceProcessorInlinePrimaryStateAutoUpdating string = "auto_updating"

	// BEGIN DEBUGGING
	// node_inline_service_processor_inline_primary
	// NodeInlineServiceProcessorInlinePrimary
	// state
	// State
	// none
	// END DEBUGGING
	// NodeInlineServiceProcessorInlinePrimaryStateNone captures enum value "none"
	NodeInlineServiceProcessorInlinePrimaryStateNone string = "none"
)

// prop value enum
func (m *NodeInlineServiceProcessorInlinePrimary) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineServiceProcessorInlinePrimaryTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlinePrimary) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"primary"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline service processor inline primary based on the context it is used
func (m *NodeInlineServiceProcessorInlinePrimary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlinePrimary) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessorInlinePrimary) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineServiceProcessorInlinePrimary) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlinePrimary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlinePrimary) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessorInlinePrimary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessorInlineSSHInfo Service processor SSH allowed IP address configuration applied across the cluster.
//
// swagger:model node_inline_service_processor_inline_ssh_info
type NodeInlineServiceProcessorInlineSSHInfo struct {

	// Allowed IP addresses
	AllowedAddresses []*IPAddressAndNetmask `json:"allowed_addresses,omitempty"`
}

// Validate validates this node inline service processor inline ssh info
func (m *NodeInlineServiceProcessorInlineSSHInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAllowedAddresses(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlineSSHInfo) validateAllowedAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.AllowedAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.AllowedAddresses); i++ {
		if swag.IsZero(m.AllowedAddresses[i]) { // not required
			continue
		}

		if m.AllowedAddresses[i] != nil {
			if err := m.AllowedAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("service_processor" + "." + "ssh_info" + "." + "allowed_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this node inline service processor inline ssh info based on the context it is used
func (m *NodeInlineServiceProcessorInlineSSHInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAllowedAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineServiceProcessorInlineSSHInfo) contextValidateAllowedAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AllowedAddresses); i++ {

		if m.AllowedAddresses[i] != nil {
			if err := m.AllowedAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("service_processor" + "." + "ssh_info" + "." + "allowed_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineSSHInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineSSHInfo) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessorInlineSSHInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineServiceProcessorInlineWebService Provides the properties of SP or BMC web service.
//
// swagger:model node_inline_service_processor_inline_web_service
type NodeInlineServiceProcessorInlineWebService struct {

	// Indicates whether the web service of the SP or BMC is enabled or disabled. When the web service is disabled, features such as network-based firmware updates and network-based down node log collection are not available, and the slower serial-interface is used for firmware updates and down node log collection.
	Enabled *bool `json:"enabled,omitempty"`

	// Restricts web service access to cluster nodes only. By default, limit_access is set to true.
	LimitAccess *bool `json:"limit_access,omitempty"`
}

// Validate validates this node inline service processor inline web service
func (m *NodeInlineServiceProcessorInlineWebService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline service processor inline web service based on the context it is used
func (m *NodeInlineServiceProcessorInlineWebService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineWebService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineServiceProcessorInlineWebService) UnmarshalBinary(b []byte) error {
	var res NodeInlineServiceProcessorInlineWebService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineSnaplock SnapLock-related properties.
//
// swagger:model node_inline_snaplock
type NodeInlineSnaplock struct {

	// SnapLock compliance clock time.
	// Example: 2018-06-04 19:00:00+00:00
	// Format: date-time
	ComplianceClockTime *strfmt.DateTime `json:"compliance_clock_time,omitempty"`
}

// Validate validates this node inline snaplock
func (m *NodeInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComplianceClockTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineSnaplock) validateComplianceClockTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ComplianceClockTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"compliance_clock_time", "body", "date-time", m.ComplianceClockTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline snaplock based on the context it is used
func (m *NodeInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res NodeInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineStatistics Raw CPU performance for the nodes.
//
// swagger:model node_inline_statistics
type NodeInlineStatistics struct {

	// Base counter for CPU Utilization.
	// Example: 12345123
	ProcessorUtilizationBase *int64 `json:"processor_utilization_base,omitempty"`

	// Raw CPU utilization for the node. The change in this value over time should be divided by corresponding change in processor_utilization_base, then multiplied by 100 to calculate the percentage CPU utilization for the node. For example: ((processor_utilization_raw_t2 - processor_utilization_raw_t1) / (processor_utilization_base_t2 - processor_utilization_base_t1)) * 100.
	//
	// Example: 13
	ProcessorUtilizationRaw *int64 `json:"processor_utilization_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this node inline statistics
func (m *NodeInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineStatisticsTypeStatusPropEnum = append(nodeInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NodeInlineStatisticsStatusOk captures enum value "ok"
	NodeInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// NodeInlineStatisticsStatusError captures enum value "error"
	NodeInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NodeInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	NodeInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NodeInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NodeInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NodeInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	NodeInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NodeInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	NodeInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NodeInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	NodeInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NodeInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	NodeInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NodeInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NodeInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// node_inline_statistics
	// NodeInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NodeInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NodeInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *NodeInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node inline statistics based on context it is used
func (m *NodeInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineStatistics) UnmarshalBinary(b []byte) error {
	var res NodeInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineSystemAggregate Aggregate
//
// swagger:model node_inline_system_aggregate
type NodeInlineSystemAggregate struct {

	// links
	Links *NodeInlineSystemAggregateInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node inline system aggregate
func (m *NodeInlineSystemAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineSystemAggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline system aggregate based on the context it is used
func (m *NodeInlineSystemAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineSystemAggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineSystemAggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineSystemAggregate) UnmarshalBinary(b []byte) error {
	var res NodeInlineSystemAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineSystemAggregateInlineLinks node inline system aggregate inline links
//
// swagger:model node_inline_system_aggregate_inline__links
type NodeInlineSystemAggregateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node inline system aggregate inline links
func (m *NodeInlineSystemAggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineSystemAggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node inline system aggregate inline links based on the context it is used
func (m *NodeInlineSystemAggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineSystemAggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineSystemAggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineSystemAggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeInlineSystemAggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineVM node inline vm
//
// swagger:model node_inline_vm
type NodeInlineVM struct {

	// Cloud provider where the VM is hosted.
	// Read Only: true
	// Enum: ["GoogleCloud","AWS_S3","Azure_Cloud"]
	ProviderType *string `json:"provider_type,omitempty"`
}

// Validate validates this node inline vm
func (m *NodeInlineVM) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProviderType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeInlineVmTypeProviderTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["GoogleCloud","AWS_S3","Azure_Cloud"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeInlineVmTypeProviderTypePropEnum = append(nodeInlineVmTypeProviderTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_inline_vm
	// NodeInlineVM
	// provider_type
	// ProviderType
	// GoogleCloud
	// END DEBUGGING
	// NodeInlineVMProviderTypeGoogleCloud captures enum value "GoogleCloud"
	NodeInlineVMProviderTypeGoogleCloud string = "GoogleCloud"

	// BEGIN DEBUGGING
	// node_inline_vm
	// NodeInlineVM
	// provider_type
	// ProviderType
	// AWS_S3
	// END DEBUGGING
	// NodeInlineVMProviderTypeAWSS3 captures enum value "AWS_S3"
	NodeInlineVMProviderTypeAWSS3 string = "AWS_S3"

	// BEGIN DEBUGGING
	// node_inline_vm
	// NodeInlineVM
	// provider_type
	// ProviderType
	// Azure_Cloud
	// END DEBUGGING
	// NodeInlineVMProviderTypeAzureCloud captures enum value "Azure_Cloud"
	NodeInlineVMProviderTypeAzureCloud string = "Azure_Cloud"
)

// prop value enum
func (m *NodeInlineVM) validateProviderTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeInlineVmTypeProviderTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeInlineVM) validateProviderType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProviderType) { // not required
		return nil
	}

	// value enum
	if err := m.validateProviderTypeEnum("vm"+"."+"provider_type", "body", *m.ProviderType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node inline vm based on the context it is used
func (m *NodeInlineVM) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProviderType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineVM) contextValidateProviderType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vm"+"."+"provider_type", "body", m.ProviderType); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineVM) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineVM) UnmarshalBinary(b []byte) error {
	var res NodeInlineVM
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeInlineVersion This returns the cluster version information.  When the cluster has more than one node, the cluster version is equivalent to the lowest of generation, major, and minor versions on all nodes.
//
// swagger:model node_inline_version
type NodeInlineVersion struct {

	// The full cluster version string.
	// Example: NetApp Release 9.4.0: Sun Nov 05 18:20:57 UTC 2017
	// Read Only: true
	Full *string `json:"full,omitempty"`

	// The generation portion of the version.
	// Example: 9
	// Read Only: true
	Generation *int64 `json:"generation"`

	// The major portion of the version.
	// Example: 4
	// Read Only: true
	Major *int64 `json:"major"`

	// The minor portion of the version.
	// Example: 0
	// Read Only: true
	Minor *int64 `json:"minor"`
}

// Validate validates this node inline version
func (m *NodeInlineVersion) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node inline version based on the context it is used
func (m *NodeInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFull(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMajor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeInlineVersion) contextValidateFull(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"full", "body", m.Full); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineVersion) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"generation", "body", m.Generation); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineVersion) contextValidateMajor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"major", "body", m.Major); err != nil {
		return err
	}

	return nil
}

func (m *NodeInlineVersion) contextValidateMinor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"minor", "body", m.Minor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeInlineVersion) UnmarshalBinary(b []byte) error {
	var res NodeInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
