// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NodeMetrics CPU performance for the nodes.
//
// swagger:model node_metrics
type NodeMetrics struct {

	// links
	Links *NodeMetricsInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT5M","PT30M","PT2H","P1D"]
	Duration *string `json:"duration,omitempty"`

	// Average CPU Utilization for the node
	// Example: 13
	ProcessorUtilization *int64 `json:"processor_utilization,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node metrics
func (m *NodeMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeMetrics) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var nodeMetricsTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","P1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeMetricsTypeDurationPropEnum = append(nodeMetricsTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NodeMetricsDurationPT15S captures enum value "PT15S"
	NodeMetricsDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NodeMetricsDurationPT5M captures enum value "PT5M"
	NodeMetricsDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NodeMetricsDurationPT30M captures enum value "PT30M"
	NodeMetricsDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NodeMetricsDurationPT2H captures enum value "PT2H"
	NodeMetricsDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NodeMetricsDurationP1D captures enum value "P1D"
	NodeMetricsDurationP1D string = "P1D"
)

// prop value enum
func (m *NodeMetrics) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeMetricsTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeMetrics) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var nodeMetricsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeMetricsTypeStatusPropEnum = append(nodeMetricsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NodeMetricsStatusOk captures enum value "ok"
	NodeMetricsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// error
	// END DEBUGGING
	// NodeMetricsStatusError captures enum value "error"
	NodeMetricsStatusError string = "error"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NodeMetricsStatusPartialNoData captures enum value "partial_no_data"
	NodeMetricsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NodeMetricsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NodeMetricsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NodeMetricsStatusPartialNoResponse captures enum value "partial_no_response"
	NodeMetricsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NodeMetricsStatusPartialOtherError captures enum value "partial_other_error"
	NodeMetricsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NodeMetricsStatusNegativeDelta captures enum value "negative_delta"
	NodeMetricsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NodeMetricsStatusBackfilledData captures enum value "backfilled_data"
	NodeMetricsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NodeMetricsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NodeMetricsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// node_metrics
	// NodeMetrics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NodeMetricsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NodeMetricsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *NodeMetrics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeMetricsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeMetrics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NodeMetrics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node metrics based on the context it is used
func (m *NodeMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeMetrics) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeMetrics) UnmarshalBinary(b []byte) error {
	var res NodeMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeMetricsInlineLinks node metrics inline links
//
// swagger:model node_metrics_inline__links
type NodeMetricsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node metrics inline links
func (m *NodeMetricsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeMetricsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node metrics inline links based on the context it is used
func (m *NodeMetricsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeMetricsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeMetricsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeMetricsInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeMetricsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
