// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NodeResponse node response
//
// swagger:model node_response
type NodeResponse struct {

	// links
	Links *NodeResponseInlineLinks `json:"_links,omitempty"`

	// node response inline records
	NodeResponseInlineRecords []*NodeResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this node response
func (m *NodeResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNodeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponse) validateNodeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.NodeResponseInlineRecords); i++ {
		if swag.IsZero(m.NodeResponseInlineRecords[i]) { // not required
			continue
		}

		if m.NodeResponseInlineRecords[i] != nil {
			if err := m.NodeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this node response based on the context it is used
func (m *NodeResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponse) contextValidateNodeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NodeResponseInlineRecords); i++ {

		if m.NodeResponseInlineRecords[i] != nil {
			if err := m.NodeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponse) UnmarshalBinary(b []byte) error {
	var res NodeResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineLinks node response inline links
//
// swagger:model node_response_inline__links
type NodeResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node response inline links
func (m *NodeResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline links based on the context it is used
func (m *NodeResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItem Complete node information
//
// swagger:model node_response_inline_records_inline_array_item
type NodeResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *NodeResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Anti ransomware version.
	// Example: 1.0
	// Read Only: true
	AntiRansomwareVersion *string `json:"anti_ransomware_version,omitempty"`

	// cluster interface
	ClusterInterface *NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface `json:"cluster_interface,omitempty"`

	// cluster interfaces
	// Read Only: true
	ClusterInterfaces []*NodeResponseRecordsItems0ClusterInterfacesItems0 `json:"cluster_interfaces"`

	// controller
	Controller *NodeResponseInlineRecordsInlineArrayItemInlineController `json:"controller,omitempty"`

	// The current or "wall clock" time of the node in ISO-8601 date, time, and time zone format.
	// The ISO-8601 date and time are localized based on the ONTAP cluster's timezone setting.
	//
	// Example: 2019-04-17 11:49:26-04:00
	// Read Only: true
	// Format: date-time
	Date *strfmt.DateTime `json:"date,omitempty"`

	// external cache
	ExternalCache *NodeResponseInlineRecordsInlineArrayItemInlineExternalCache `json:"external_cache,omitempty"`

	// external cache bypass
	ExternalCacheBypass *NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass `json:"external_cache_bypass,omitempty"`

	// ha
	Ha *NodeResponseInlineRecordsInlineArrayItemInlineHa `json:"ha,omitempty"`

	// hw assist
	HwAssist *NodeResponseInlineRecordsInlineArrayItemInlineHwAssist `json:"hw_assist,omitempty"`

	// Specifies whether or not the node is in spares low condition.
	// Read Only: true
	IsSparesLow *bool `json:"is_spares_low,omitempty"`

	// location
	// Example: rack 2 row 5
	Location *string `json:"location,omitempty"`

	// management interface
	ManagementInterface *NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface `json:"management_interface,omitempty"`

	// management interfaces
	// Read Only: true
	ManagementInterfaces []*NodeResponseRecordsItems0ManagementInterfacesItems0 `json:"management_interfaces"`

	// Possible values:
	// * <i>available</i> - A node is detected on the internal cluster network and can be added to the cluster.  Nodes that have a membership of "available" are not returned when a GET request is called when the cluster exists. Provide a query on the "membership" property for <i>available</i> to scan for nodes on the cluster network. Nodes that have a membership of "available" are returned automatically before a cluster is created.
	// * <i>joining</i> - Joining nodes are in the process of being added to the cluster. The node might be progressing through the steps to become a member or might have failed. The job to add the node or create the cluster provides details on the current progress of the node.
	// * <i>member</i> - Nodes that are members have successfully joined the cluster.
	//
	// Read Only: true
	// Enum: ["available","joining","member"]
	Membership *string `json:"membership,omitempty"`

	// metric
	Metric *NodeResponseInlineRecordsInlineArrayItemInlineMetric `json:"metric,omitempty"`

	// metrocluster
	Metrocluster *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster `json:"metrocluster,omitempty"`

	// model
	// Example: FAS3070
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// name
	// Example: node-01
	Name *string `json:"name,omitempty"`

	// nvlog
	Nvlog *NodeResponseInlineRecordsInlineArrayItemInlineNvlog `json:"nvlog,omitempty"`

	// nvram
	Nvram *NodeResponseInlineRecordsInlineArrayItemInlineNvram `json:"nvram,omitempty"`

	// Owner of the node.
	// Example: Example Corp
	Owner *string `json:"owner,omitempty"`

	// serial number
	// Example: 4048820-60-9
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// service processor
	ServiceProcessor *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor `json:"service_processor,omitempty"`

	// snaplock
	Snaplock *NodeResponseInlineRecordsInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// State of the node:
	// * <i>up</i> - Node is up and operational.
	// * <i>booting</i> - Node is booting up.
	// * <i>down</i> - Node has stopped or is dumping core.
	// * <i>taken_over</i> - Node has been taken over by its HA partner and is not yet waiting for giveback.
	// * <i>waiting_for_giveback</i> - Node has been taken over by its HA partner and is waiting for the HA partner to giveback disks.
	// * <i>degraded</i> - Node has one or more critical services offline.
	// * <i>unknown</i> - Node or its HA partner cannot be contacted and there is no information on the node's state.
	//
	// Read Only: true
	// Enum: ["up","booting","down","taken_over","waiting_for_giveback","degraded","unknown"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *NodeResponseInlineRecordsInlineArrayItemInlineStatistics `json:"statistics,omitempty"`

	// Storage availability zones associated with the node.
	// Read Only: true
	StorageAvailabilityZones []*StorageAvailabilityZoneReference `json:"storage_availability_zones"`

	// The storage configuration in the system. Possible values:
	// * <i>mixed_path</i>
	// * <i>single_path</i>
	// * <i>multi_path</i>
	// * <i>tri_path</i>
	// * <i>quad_path</i>
	// * <i>mixed_path_ha</i>
	// * <i>single_path_ha</i>
	// * <i>multi_path_ha</i>
	// * <i>tri_path_ha</i>
	// * <i>quad_path_ha</i>
	// * <i>unknown</i>
	// * <i>virtual</i>
	//
	// Read Only: true
	// Enum: ["unknown","single_path","multi_path","mixed_path","quad_path","single_path_ha","multi_path_ha","mixed_path_ha","quad_path_ha","tri_path","tri_path_ha","virtual"]
	StorageConfiguration *string `json:"storage_configuration,omitempty"`

	// system aggregate
	SystemAggregate *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate `json:"system_aggregate,omitempty"`

	// system id
	// Example: 92027651
	// Read Only: true
	SystemID *string `json:"system_id,omitempty"`

	// OEM system machine type.
	// Example: 7Y56-CTOWW1
	// Read Only: true
	SystemMachineType *string `json:"system_machine_type,omitempty"`

	// The total time, in seconds, that the node has been up.
	// Example: 300536
	// Read Only: true
	Uptime *int64 `json:"uptime,omitempty"`

	// uuid
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// OEM vendor serial number.
	// Example: 791603000068
	// Read Only: true
	VendorSerialNumber *string `json:"vendor_serial_number,omitempty"`

	// version
	Version *NodeResponseInlineRecordsInlineArrayItemInlineVersion `json:"version,omitempty"`

	// vm
	VM *NodeResponseInlineRecordsInlineArrayItemInlineVM `json:"vm,omitempty"`
}

// Validate validates this node response inline records inline array item
func (m *NodeResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateController(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCacheBypass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHa(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHwAssist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateManagementInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateManagementInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMembership(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetrocluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvlog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvram(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceProcessor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageAvailabilityZones(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSystemAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVM(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateClusterInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInterface) { // not required
		return nil
	}

	if m.ClusterInterface != nil {
		if err := m.ClusterInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateClusterInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.ClusterInterfaces); i++ {
		if swag.IsZero(m.ClusterInterfaces[i]) { // not required
			continue
		}

		if m.ClusterInterfaces[i] != nil {
			if err := m.ClusterInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cluster_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateController(formats strfmt.Registry) error {
	if swag.IsZero(m.Controller) { // not required
		return nil
	}

	if m.Controller != nil {
		if err := m.Controller.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateDate(formats strfmt.Registry) error {
	if swag.IsZero(m.Date) { // not required
		return nil
	}

	if err := validate.FormatOf("date", "body", "date-time", m.Date.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateExternalCache(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCache) { // not required
		return nil
	}

	if m.ExternalCache != nil {
		if err := m.ExternalCache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateExternalCacheBypass(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCacheBypass) { // not required
		return nil
	}

	if m.ExternalCacheBypass != nil {
		if err := m.ExternalCacheBypass.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache_bypass")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateHa(formats strfmt.Registry) error {
	if swag.IsZero(m.Ha) { // not required
		return nil
	}

	if m.Ha != nil {
		if err := m.Ha.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateHwAssist(formats strfmt.Registry) error {
	if swag.IsZero(m.HwAssist) { // not required
		return nil
	}

	if m.HwAssist != nil {
		if err := m.HwAssist.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateManagementInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.ManagementInterface) { // not required
		return nil
	}

	if m.ManagementInterface != nil {
		if err := m.ManagementInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateManagementInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.ManagementInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.ManagementInterfaces); i++ {
		if swag.IsZero(m.ManagementInterfaces[i]) { // not required
			continue
		}

		if m.ManagementInterfaces[i] != nil {
			if err := m.ManagementInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemTypeMembershipPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","joining","member"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemTypeMembershipPropEnum = append(nodeResponseInlineRecordsInlineArrayItemTypeMembershipPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// membership
	// Membership
	// available
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemMembershipAvailable captures enum value "available"
	NodeResponseInlineRecordsInlineArrayItemMembershipAvailable string = "available"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// membership
	// Membership
	// joining
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemMembershipJoining captures enum value "joining"
	NodeResponseInlineRecordsInlineArrayItemMembershipJoining string = "joining"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// membership
	// Membership
	// member
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemMembershipMember captures enum value "member"
	NodeResponseInlineRecordsInlineArrayItemMembershipMember string = "member"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItem) validateMembershipEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemTypeMembershipPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateMembership(formats strfmt.Registry) error {
	if swag.IsZero(m.Membership) { // not required
		return nil
	}

	// value enum
	if err := m.validateMembershipEnum("membership", "body", *m.Membership); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateMetrocluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Metrocluster) { // not required
		return nil
	}

	if m.Metrocluster != nil {
		if err := m.Metrocluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metrocluster")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateNvlog(formats strfmt.Registry) error {
	if swag.IsZero(m.Nvlog) { // not required
		return nil
	}

	if m.Nvlog != nil {
		if err := m.Nvlog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvlog")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateNvram(formats strfmt.Registry) error {
	if swag.IsZero(m.Nvram) { // not required
		return nil
	}

	if m.Nvram != nil {
		if err := m.Nvram.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvram")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateServiceProcessor(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceProcessor) { // not required
		return nil
	}

	if m.ServiceProcessor != nil {
		if err := m.ServiceProcessor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","booting","down","taken_over","waiting_for_giveback","degraded","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// state
	// State
	// up
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStateUp captures enum value "up"
	NodeResponseInlineRecordsInlineArrayItemStateUp string = "up"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// state
	// State
	// booting
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStateBooting captures enum value "booting"
	NodeResponseInlineRecordsInlineArrayItemStateBooting string = "booting"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// state
	// State
	// down
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStateDown captures enum value "down"
	NodeResponseInlineRecordsInlineArrayItemStateDown string = "down"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// state
	// State
	// taken_over
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStateTakenOver captures enum value "taken_over"
	NodeResponseInlineRecordsInlineArrayItemStateTakenOver string = "taken_over"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// state
	// State
	// waiting_for_giveback
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStateWaitingForGiveback captures enum value "waiting_for_giveback"
	NodeResponseInlineRecordsInlineArrayItemStateWaitingForGiveback string = "waiting_for_giveback"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// state
	// State
	// degraded
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStateDegraded captures enum value "degraded"
	NodeResponseInlineRecordsInlineArrayItemStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// state
	// State
	// unknown
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStateUnknown captures enum value "unknown"
	NodeResponseInlineRecordsInlineArrayItemStateUnknown string = "unknown"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateStorageAvailabilityZones(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZones) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageAvailabilityZones); i++ {
		if swag.IsZero(m.StorageAvailabilityZones[i]) { // not required
			continue
		}

		if m.StorageAvailabilityZones[i] != nil {
			if err := m.StorageAvailabilityZones[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("storage_availability_zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemTypeStorageConfigurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","single_path","multi_path","mixed_path","quad_path","single_path_ha","multi_path_ha","mixed_path_ha","quad_path_ha","tri_path","tri_path_ha","virtual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemTypeStorageConfigurationPropEnum = append(nodeResponseInlineRecordsInlineArrayItemTypeStorageConfigurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// unknown
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationUnknown captures enum value "unknown"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationUnknown string = "unknown"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// single_path
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationSinglePath captures enum value "single_path"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationSinglePath string = "single_path"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// multi_path
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationMultiPath captures enum value "multi_path"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationMultiPath string = "multi_path"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// mixed_path
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationMixedPath captures enum value "mixed_path"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationMixedPath string = "mixed_path"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// quad_path
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationQuadPath captures enum value "quad_path"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationQuadPath string = "quad_path"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// single_path_ha
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationSinglePathHa captures enum value "single_path_ha"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationSinglePathHa string = "single_path_ha"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// multi_path_ha
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationMultiPathHa captures enum value "multi_path_ha"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationMultiPathHa string = "multi_path_ha"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// mixed_path_ha
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationMixedPathHa captures enum value "mixed_path_ha"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationMixedPathHa string = "mixed_path_ha"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// quad_path_ha
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationQuadPathHa captures enum value "quad_path_ha"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationQuadPathHa string = "quad_path_ha"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// tri_path
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationTriPath captures enum value "tri_path"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationTriPath string = "tri_path"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// tri_path_ha
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationTriPathHa captures enum value "tri_path_ha"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationTriPathHa string = "tri_path_ha"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item
	// NodeResponseInlineRecordsInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// virtual
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemStorageConfigurationVirtual captures enum value "virtual"
	NodeResponseInlineRecordsInlineArrayItemStorageConfigurationVirtual string = "virtual"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItem) validateStorageConfigurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemTypeStorageConfigurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateStorageConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageConfiguration) { // not required
		return nil
	}

	// value enum
	if err := m.validateStorageConfigurationEnum("storage_configuration", "body", *m.StorageConfiguration); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateSystemAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.SystemAggregate) { // not required
		return nil
	}

	if m.SystemAggregate != nil {
		if err := m.SystemAggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) validateVM(formats strfmt.Registry) error {
	if swag.IsZero(m.VM) { // not required
		return nil
	}

	if m.VM != nil {
		if err := m.VM.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAntiRansomwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateController(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExternalCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExternalCacheBypass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHa(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHwAssist(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSparesLow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateManagementInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateManagementInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMembership(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetrocluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvlog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvram(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServiceProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageAvailabilityZones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemMachineType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUptime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVendorSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVM(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateAntiRansomwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware_version", "body", m.AntiRansomwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateClusterInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.ClusterInterface != nil {
		if err := m.ClusterInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateClusterInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cluster_interfaces", "body", []*NodeResponseRecordsItems0ClusterInterfacesItems0(m.ClusterInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.ClusterInterfaces); i++ {

		if m.ClusterInterfaces[i] != nil {
			if err := m.ClusterInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cluster_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateController(ctx context.Context, formats strfmt.Registry) error {

	if m.Controller != nil {
		if err := m.Controller.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateDate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "date", "body", m.Date); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateExternalCache(ctx context.Context, formats strfmt.Registry) error {

	if m.ExternalCache != nil {
		if err := m.ExternalCache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateExternalCacheBypass(ctx context.Context, formats strfmt.Registry) error {

	if m.ExternalCacheBypass != nil {
		if err := m.ExternalCacheBypass.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache_bypass")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateHa(ctx context.Context, formats strfmt.Registry) error {

	if m.Ha != nil {
		if err := m.Ha.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateHwAssist(ctx context.Context, formats strfmt.Registry) error {

	if m.HwAssist != nil {
		if err := m.HwAssist.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateIsSparesLow(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_spares_low", "body", m.IsSparesLow); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateManagementInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.ManagementInterface != nil {
		if err := m.ManagementInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateManagementInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "management_interfaces", "body", []*NodeResponseRecordsItems0ManagementInterfacesItems0(m.ManagementInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.ManagementInterfaces); i++ {

		if m.ManagementInterfaces[i] != nil {
			if err := m.ManagementInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateMembership(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "membership", "body", m.Membership); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateMetrocluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Metrocluster != nil {
		if err := m.Metrocluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metrocluster")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateNvlog(ctx context.Context, formats strfmt.Registry) error {

	if m.Nvlog != nil {
		if err := m.Nvlog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvlog")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateNvram(ctx context.Context, formats strfmt.Registry) error {

	if m.Nvram != nil {
		if err := m.Nvram.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvram")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateServiceProcessor(ctx context.Context, formats strfmt.Registry) error {

	if m.ServiceProcessor != nil {
		if err := m.ServiceProcessor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateStorageAvailabilityZones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_availability_zones", "body", []*StorageAvailabilityZoneReference(m.StorageAvailabilityZones)); err != nil {
		return err
	}

	for i := 0; i < len(m.StorageAvailabilityZones); i++ {

		if m.StorageAvailabilityZones[i] != nil {
			if err := m.StorageAvailabilityZones[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("storage_availability_zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateStorageConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_configuration", "body", m.StorageConfiguration); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateSystemAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.SystemAggregate != nil {
		if err := m.SystemAggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateSystemID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_id", "body", m.SystemID); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateSystemMachineType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_machine_type", "body", m.SystemMachineType); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateUptime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uptime", "body", m.Uptime); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateVendorSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vendor_serial_number", "body", m.VendorSerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItem) contextValidateVM(ctx context.Context, formats strfmt.Registry) error {

	if m.VM != nil {
		if err := m.VM.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface The cluster network IP address of the node to be added.
//
// swagger:model node_response_inline_records_inline_array_item_inline_cluster_interface
type NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface struct {

	// ip
	IP *NodeSetupIP `json:"ip,omitempty"`
}

// Validate validates this node response inline records inline array item inline cluster interface
func (m *NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline cluster interface based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineClusterInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0ClusterInterfacesItems0 Network interface
//
// swagger:model NodeResponseRecordsItems0ClusterInterfacesItems0
type NodeResponseRecordsItems0ClusterInterfacesItems0 struct {

	// links
	Links *NodeResponseRecordsItems0ClusterInterfacesItems0Links `json:"_links,omitempty"`

	// ip
	IP *NodeResponseRecordsItems0ClusterInterfacesItems0IP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node response records items0 cluster interfaces items0
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ClusterInterfacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseRecordsItems0ClusterInterfacesItems0) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 cluster interfaces items0 based on the context it is used
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ClusterInterfacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseRecordsItems0ClusterInterfacesItems0) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0ClusterInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0ClusterInterfacesItems0IP IP information
//
// swagger:model NodeResponseRecordsItems0ClusterInterfacesItems0IP
type NodeResponseRecordsItems0ClusterInterfacesItems0IP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this node response records items0 cluster interfaces items0 IP
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0IP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ClusterInterfacesItems0IP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 cluster interfaces items0 IP based on the context it is used
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0IP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ClusterInterfacesItems0IP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0IP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0IP) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0ClusterInterfacesItems0IP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0ClusterInterfacesItems0Links node response records items0 cluster interfaces items0 links
//
// swagger:model NodeResponseRecordsItems0ClusterInterfacesItems0Links
type NodeResponseRecordsItems0ClusterInterfacesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node response records items0 cluster interfaces items0 links
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ClusterInterfacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 cluster interfaces items0 links based on the context it is used
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ClusterInterfacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ClusterInterfacesItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0ClusterInterfacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineController Controller information
//
// swagger:model node_response_inline_records_inline_array_item_inline_controller
type NodeResponseInlineRecordsInlineArrayItemInlineController struct {

	// Type of the system board. This is defined by vendor.
	// Example: System Board XXVIII
	// Read Only: true
	Board *string `json:"board,omitempty"`

	// cpu
	CPU *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU `json:"cpu,omitempty"`

	// failed fan
	FailedFan *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan `json:"failed_fan,omitempty"`

	// failed power supply
	FailedPowerSupply *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply `json:"failed_power_supply,omitempty"`

	// A list of Flash-Cache devices. Only returned when requested by name.
	// Read Only: true
	FlashCache []*NodeResponseRecordsItems0ControllerFlashCacheItems0 `json:"flash_cache"`

	// List of FRUs on the node. Only returned when requested by name.
	Frus []*NodeResponseRecordsItems0ControllerFrusItems0 `json:"frus"`

	// Memory available on the node, in bytes.
	// Example: 1024000000
	// Read Only: true
	MemorySize *int64 `json:"memory_size,omitempty"`

	// Specifies whether the hardware is currently operating outside of its recommended temperature range. The hardware shuts down if the temperature exceeds critical thresholds.
	// Read Only: true
	// Enum: ["over","normal"]
	OverTemperature *string `json:"over_temperature,omitempty"`
}

// Validate validates this node response inline records inline array item inline controller
func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPU(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFailedFan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFailedPowerSupply(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlashCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOverTemperature(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) validateCPU(formats strfmt.Registry) error {
	if swag.IsZero(m.CPU) { // not required
		return nil
	}

	if m.CPU != nil {
		if err := m.CPU.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "cpu")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) validateFailedFan(formats strfmt.Registry) error {
	if swag.IsZero(m.FailedFan) { // not required
		return nil
	}

	if m.FailedFan != nil {
		if err := m.FailedFan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) validateFailedPowerSupply(formats strfmt.Registry) error {
	if swag.IsZero(m.FailedPowerSupply) { // not required
		return nil
	}

	if m.FailedPowerSupply != nil {
		if err := m.FailedPowerSupply.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) validateFlashCache(formats strfmt.Registry) error {
	if swag.IsZero(m.FlashCache) { // not required
		return nil
	}

	for i := 0; i < len(m.FlashCache); i++ {
		if swag.IsZero(m.FlashCache[i]) { // not required
			continue
		}

		if m.FlashCache[i] != nil {
			if err := m.FlashCache[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "flash_cache" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) validateFrus(formats strfmt.Registry) error {
	if swag.IsZero(m.Frus) { // not required
		return nil
	}

	for i := 0; i < len(m.Frus); i++ {
		if swag.IsZero(m.Frus[i]) { // not required
			continue
		}

		if m.Frus[i] != nil {
			if err := m.Frus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineControllerTypeOverTemperaturePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["over","normal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineControllerTypeOverTemperaturePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineControllerTypeOverTemperaturePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_controller
	// NodeResponseInlineRecordsInlineArrayItemInlineController
	// over_temperature
	// OverTemperature
	// over
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineControllerOverTemperatureOver captures enum value "over"
	NodeResponseInlineRecordsInlineArrayItemInlineControllerOverTemperatureOver string = "over"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_controller
	// NodeResponseInlineRecordsInlineArrayItemInlineController
	// over_temperature
	// OverTemperature
	// normal
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineControllerOverTemperatureNormal captures enum value "normal"
	NodeResponseInlineRecordsInlineArrayItemInlineControllerOverTemperatureNormal string = "normal"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) validateOverTemperatureEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineControllerTypeOverTemperaturePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) validateOverTemperature(formats strfmt.Registry) error {
	if swag.IsZero(m.OverTemperature) { // not required
		return nil
	}

	// value enum
	if err := m.validateOverTemperatureEnum("controller"+"."+"over_temperature", "body", *m.OverTemperature); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline controller based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBoard(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCPU(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailedFan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailedPowerSupply(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlashCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFrus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMemorySize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverTemperature(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) contextValidateBoard(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"board", "body", m.Board); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) contextValidateCPU(ctx context.Context, formats strfmt.Registry) error {

	if m.CPU != nil {
		if err := m.CPU.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "cpu")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) contextValidateFailedFan(ctx context.Context, formats strfmt.Registry) error {

	if m.FailedFan != nil {
		if err := m.FailedFan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) contextValidateFailedPowerSupply(ctx context.Context, formats strfmt.Registry) error {

	if m.FailedPowerSupply != nil {
		if err := m.FailedPowerSupply.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) contextValidateFlashCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"flash_cache", "body", []*NodeResponseRecordsItems0ControllerFlashCacheItems0(m.FlashCache)); err != nil {
		return err
	}

	for i := 0; i < len(m.FlashCache); i++ {

		if m.FlashCache[i] != nil {
			if err := m.FlashCache[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "flash_cache" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) contextValidateFrus(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Frus); i++ {

		if m.Frus[i] != nil {
			if err := m.Frus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) contextValidateMemorySize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"memory_size", "body", m.MemorySize); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) contextValidateOverTemperature(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"over_temperature", "body", m.OverTemperature); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineController) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineController
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU CPU information.
//
// swagger:model node_response_inline_records_inline_array_item_inline_controller_inline_cpu
type NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU struct {

	// Number of CPUs on the node.
	// Example: 20
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// Firmware release number. Defined by the CPU manufacturer.
	// Read Only: true
	FirmwareRelease *string `json:"firmware_release,omitempty"`

	// CPU type on the node.
	// Read Only: true
	Processor *string `json:"processor,omitempty"`
}

// Validate validates this node response inline records inline array item inline controller inline cpu
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline controller inline cpu based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU) contextValidateFirmwareRelease(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"firmware_release", "body", m.FirmwareRelease); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU) contextValidateProcessor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"processor", "body", m.Processor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineCPU
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan node response inline records inline array item inline controller inline failed fan
//
// swagger:model node_response_inline_records_inline_array_item_inline_controller_inline_failed_fan
type NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan struct {

	// Specifies a count of the number of chassis fans that are not operating within the recommended RPM range.
	// Example: 1
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// message
	Message *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage `json:"message,omitempty"`
}

// Validate validates this node response inline records inline array item inline controller inline failed fan
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if m.Message != nil {
		if err := m.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline controller inline failed fan based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.Message != nil {
		if err := m.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage node response inline records inline array item inline controller inline failed fan inline message
//
// swagger:model node_response_inline_records_inline_array_item_inline_controller_inline_failed_fan_inline_message
type NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage struct {

	// Error code describing the current condition of chassis fans.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message describing the current condition of chassis fans. It is only of use when `failed_fan.count` is not zero.
	// Example: There are no failed fans.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this node response inline records inline array item inline controller inline failed fan inline message
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline controller inline failed fan inline message based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedFanInlineMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply node response inline records inline array item inline controller inline failed power supply
//
// swagger:model node_response_inline_records_inline_array_item_inline_controller_inline_failed_power_supply
type NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply struct {

	// Number of failed power supply units.
	// Example: 1
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// message
	Message *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage `json:"message,omitempty"`
}

// Validate validates this node response inline records inline array item inline controller inline failed power supply
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if m.Message != nil {
		if err := m.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline controller inline failed power supply based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.Message != nil {
		if err := m.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupply
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage node response inline records inline array item inline controller inline failed power supply inline message
//
// swagger:model node_response_inline_records_inline_array_item_inline_controller_inline_failed_power_supply_inline_message
type NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage struct {

	// Error code describing the current condition of power supply.
	// Example: 111411208
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message describing the state of any power supplies that are currently degraded. It is only of use when `failed_power_supply.count` is not zero.
	// Example: There are no failed power supplies.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this node response inline records inline array item inline controller inline failed power supply inline message
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline controller inline failed power supply inline message based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0ControllerFlashCacheItems0 node response records items0 controller flash cache items0
//
// swagger:model NodeResponseRecordsItems0ControllerFlashCacheItems0
type NodeResponseRecordsItems0ControllerFlashCacheItems0 struct {

	// Size in bytes
	// Example: 1024000000000
	// Read Only: true
	Capacity *int64 `json:"capacity,omitempty"`

	// device id
	// Example: 0
	// Read Only: true
	DeviceID *int64 `json:"device_id,omitempty"`

	// firmware file
	// Example: X9170_O000Z6300NVM
	// Read Only: true
	FirmwareFile *string `json:"firmware_file,omitempty"`

	// firmware version
	// Example: NA05
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// hardware revision
	// Example: A1
	// Read Only: true
	HardwareRevision *string `json:"hardware_revision,omitempty"`

	// model
	// Example: X1970A
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// part number
	// Example: 119-00207
	// Read Only: true
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: A22P5061550000187
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// slot
	// Example: 6-1
	// Read Only: true
	Slot *string `json:"slot,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","erasing","erased","failed","removed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node response records items0 controller flash cache items0
func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseRecordsItems0ControllerFlashCacheItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","erasing","erased","failed","removed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseRecordsItems0ControllerFlashCacheItems0TypeStatePropEnum = append(nodeResponseRecordsItems0ControllerFlashCacheItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0StateOk captures enum value "ok"
	NodeResponseRecordsItems0ControllerFlashCacheItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// erasing
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0StateErasing captures enum value "erasing"
	NodeResponseRecordsItems0ControllerFlashCacheItems0StateErasing string = "erasing"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// erased
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0StateErased captures enum value "erased"
	NodeResponseRecordsItems0ControllerFlashCacheItems0StateErased string = "erased"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0StateFailed captures enum value "failed"
	NodeResponseRecordsItems0ControllerFlashCacheItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// NodeResponseRecordsItems0ControllerFlashCacheItems0
	// state
	// State
	// removed
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFlashCacheItems0StateRemoved captures enum value "removed"
	NodeResponseRecordsItems0ControllerFlashCacheItems0StateRemoved string = "removed"
)

// prop value enum
func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseRecordsItems0ControllerFlashCacheItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response records items0 controller flash cache items0 based on the context it is used
func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeviceID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHardwareRevision(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSlot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity", "body", m.Capacity); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateDeviceID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "device_id", "body", m.DeviceID); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateFirmwareFile(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_file", "body", m.FirmwareFile); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateHardwareRevision(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "hardware_revision", "body", m.HardwareRevision); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidatePartNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "part_number", "body", m.PartNumber); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateSlot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "slot", "body", m.Slot); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ControllerFlashCacheItems0) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0ControllerFlashCacheItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0ControllerFrusItems0 node response records items0 controller frus items0
//
// swagger:model NodeResponseRecordsItems0ControllerFrusItems0
type NodeResponseRecordsItems0ControllerFrusItems0 struct {

	// id
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["fan","psu","pcie","disk","nvs","dimm","controller"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this node response records items0 controller frus items0
func (m *NodeResponseRecordsItems0ControllerFrusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseRecordsItems0ControllerFrusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseRecordsItems0ControllerFrusItems0TypeStatePropEnum = append(nodeResponseRecordsItems0ControllerFrusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0StateOk captures enum value "ok"
	NodeResponseRecordsItems0ControllerFrusItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// state
	// State
	// error
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0StateError captures enum value "error"
	NodeResponseRecordsItems0ControllerFrusItems0StateError string = "error"
)

// prop value enum
func (m *NodeResponseRecordsItems0ControllerFrusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseRecordsItems0ControllerFrusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseRecordsItems0ControllerFrusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var nodeResponseRecordsItems0ControllerFrusItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fan","psu","pcie","disk","nvs","dimm","controller"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseRecordsItems0ControllerFrusItems0TypeTypePropEnum = append(nodeResponseRecordsItems0ControllerFrusItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// type
	// Type
	// fan
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0TypeFan captures enum value "fan"
	NodeResponseRecordsItems0ControllerFrusItems0TypeFan string = "fan"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// type
	// Type
	// psu
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0TypePsu captures enum value "psu"
	NodeResponseRecordsItems0ControllerFrusItems0TypePsu string = "psu"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// type
	// Type
	// pcie
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0TypePcie captures enum value "pcie"
	NodeResponseRecordsItems0ControllerFrusItems0TypePcie string = "pcie"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// type
	// Type
	// disk
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0TypeDisk captures enum value "disk"
	NodeResponseRecordsItems0ControllerFrusItems0TypeDisk string = "disk"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// type
	// Type
	// nvs
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0TypeNvs captures enum value "nvs"
	NodeResponseRecordsItems0ControllerFrusItems0TypeNvs string = "nvs"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// type
	// Type
	// dimm
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0TypeDimm captures enum value "dimm"
	NodeResponseRecordsItems0ControllerFrusItems0TypeDimm string = "dimm"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0
	// NodeResponseRecordsItems0ControllerFrusItems0
	// type
	// Type
	// controller
	// END DEBUGGING
	// NodeResponseRecordsItems0ControllerFrusItems0TypeController captures enum value "controller"
	NodeResponseRecordsItems0ControllerFrusItems0TypeController string = "controller"
)

// prop value enum
func (m *NodeResponseRecordsItems0ControllerFrusItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseRecordsItems0ControllerFrusItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseRecordsItems0ControllerFrusItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response records items0 controller frus items0 based on the context it is used
func (m *NodeResponseRecordsItems0ControllerFrusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ControllerFrusItems0) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFrusItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0ControllerFrusItems0) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ControllerFrusItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ControllerFrusItems0) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0ControllerFrusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineExternalCache Cache used for buffer management.
//
// swagger:model node_response_inline_records_inline_array_item_inline_external_cache
type NodeResponseInlineRecordsInlineArrayItemInlineExternalCache struct {

	// Indicates whether the external cache is enabled.
	// Example: true
	IsEnabled *bool `json:"is_enabled,omitempty"`

	// Indicates whether HyA caching is enabled.
	// Example: true
	IsHyaEnabled *bool `json:"is_hya_enabled,omitempty"`

	// Indicates whether rewarm is enabled.
	// Example: true
	IsRewarmEnabled *bool `json:"is_rewarm_enabled,omitempty"`

	// PCS size in gigabytes.
	PcsSize *int64 `json:"pcs_size,omitempty"`
}

// Validate validates this node response inline records inline array item inline external cache
func (m *NodeResponseInlineRecordsInlineArrayItemInlineExternalCache) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline external cache based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineExternalCache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineExternalCache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineExternalCache) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineExternalCache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass External cache bypass management.
//
// swagger:model node_response_inline_records_inline_array_item_inline_external_cache_bypass
type NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass struct {

	// Indicates whether external cache bypass is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// External cache bypass allowed operations percentage for large reads.
	// Example: 100
	LargeReadOpsAllowPercent *int64 `json:"large_read_ops_allow_percent,omitempty"`

	// Initiates an external cache bypass threshold reset action.
	// Example: true
	Reset *bool `json:"reset,omitempty"`
}

// Validate validates this node response inline records inline array item inline external cache bypass
func (m *NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this node response inline records inline array item inline external cache bypass based on context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineExternalCacheBypass
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHa node response inline records inline array item inline ha
//
// swagger:model node_response_inline_records_inline_array_item_inline_ha
type NodeResponseInlineRecordsInlineArrayItemInlineHa struct {

	// Specifies whether giveback is automatically initiated when the node that owns the storage is ready.
	AutoGiveback *bool `json:"auto_giveback,omitempty"`

	// Specifies whether giveback is automatically initiated when the node that owns the storage is ready.
	AutoGivebackOf *bool `json:"auto_giveback_of,omitempty"`

	// Specifies whether or not storage failover is enabled.
	// Read Only: true
	EnableTakeoverOf *bool `json:"enable_takeover_of,omitempty"`

	// Specifies whether or not storage failover is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// giveback
	Giveback *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback `json:"giveback,omitempty"`

	// interconnect
	Interconnect *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect `json:"interconnect,omitempty"`

	// Nodes in this node's High Availability (HA) group.
	// Read Only: true
	Partners []*NodeResponseRecordsItems0HaPartnersItems0 `json:"partners"`

	// ports
	// Read Only: true
	Ports []*NodeResponseRecordsItems0HaPortsItems0 `json:"ports"`

	// takeover
	Takeover *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover `json:"takeover,omitempty"`

	// takeover check
	TakeoverCheck *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck `json:"takeover_check,omitempty"`

	// Type of storage.
	// Read Only: true
	// Enum: ["shared_storage","non_shared_storage"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this node response inline records inline array item inline ha
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGiveback(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterconnect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartners(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTakeover(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTakeoverCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) validateGiveback(formats strfmt.Registry) error {
	if swag.IsZero(m.Giveback) { // not required
		return nil
	}

	if m.Giveback != nil {
		if err := m.Giveback.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) validateInterconnect(formats strfmt.Registry) error {
	if swag.IsZero(m.Interconnect) { // not required
		return nil
	}

	if m.Interconnect != nil {
		if err := m.Interconnect.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "interconnect")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) validatePartners(formats strfmt.Registry) error {
	if swag.IsZero(m.Partners) { // not required
		return nil
	}

	for i := 0; i < len(m.Partners); i++ {
		if swag.IsZero(m.Partners[i]) { // not required
			continue
		}

		if m.Partners[i] != nil {
			if err := m.Partners[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "partners" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) validatePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.Ports) { // not required
		return nil
	}

	for i := 0; i < len(m.Ports); i++ {
		if swag.IsZero(m.Ports[i]) { // not required
			continue
		}

		if m.Ports[i] != nil {
			if err := m.Ports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) validateTakeover(formats strfmt.Registry) error {
	if swag.IsZero(m.Takeover) { // not required
		return nil
	}

	if m.Takeover != nil {
		if err := m.Takeover.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) validateTakeoverCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.TakeoverCheck) { // not required
		return nil
	}

	if m.TakeoverCheck != nil {
		if err := m.TakeoverCheck.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover_check")
			}
			return err
		}
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineHaTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shared_storage","non_shared_storage"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineHaTypeTypePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineHaTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha
	// NodeResponseInlineRecordsInlineArrayItemInlineHa
	// type
	// Type
	// shared_storage
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaTypeSharedStorage captures enum value "shared_storage"
	NodeResponseInlineRecordsInlineArrayItemInlineHaTypeSharedStorage string = "shared_storage"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha
	// NodeResponseInlineRecordsInlineArrayItemInlineHa
	// type
	// Type
	// non_shared_storage
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaTypeNonSharedStorage captures enum value "non_shared_storage"
	NodeResponseInlineRecordsInlineArrayItemInlineHaTypeNonSharedStorage string = "non_shared_storage"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineHaTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("ha"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline ha based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEnableTakeoverOf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGiveback(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterconnect(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartners(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeover(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeoverCheck(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) contextValidateEnableTakeoverOf(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"enable_takeover_of", "body", m.EnableTakeoverOf); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) contextValidateGiveback(ctx context.Context, formats strfmt.Registry) error {

	if m.Giveback != nil {
		if err := m.Giveback.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) contextValidateInterconnect(ctx context.Context, formats strfmt.Registry) error {

	if m.Interconnect != nil {
		if err := m.Interconnect.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "interconnect")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) contextValidatePartners(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"partners", "body", []*NodeResponseRecordsItems0HaPartnersItems0(m.Partners)); err != nil {
		return err
	}

	for i := 0; i < len(m.Partners); i++ {

		if m.Partners[i] != nil {
			if err := m.Partners[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "partners" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) contextValidatePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"ports", "body", []*NodeResponseRecordsItems0HaPortsItems0(m.Ports)); err != nil {
		return err
	}

	for i := 0; i < len(m.Ports); i++ {

		if m.Ports[i] != nil {
			if err := m.Ports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) contextValidateTakeover(ctx context.Context, formats strfmt.Registry) error {

	if m.Takeover != nil {
		if err := m.Takeover.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) contextValidateTakeoverCheck(ctx context.Context, formats strfmt.Registry) error {

	if m.TakeoverCheck != nil {
		if err := m.TakeoverCheck.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover_check")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHa) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHa
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback Represents the state of the node that is giving storage back to its HA partner.
//
// swagger:model node_response_inline_records_inline_array_item_inline_ha_inline_giveback
type NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback struct {

	// failure
	Failure *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackInlineFailure `json:"failure,omitempty"`

	// state
	// Example: failed
	// Enum: ["nothing_to_giveback","not_attempted","in_progress","failed"]
	State *string `json:"state,omitempty"`

	// Giveback status of each aggregate. This property is not supported on the ASA r2 platform.
	// Read Only: true
	Status []*NodeResponseRecordsItems0HaGivebackStatusItems0 `json:"status"`
}

// Validate validates this node response inline records inline array item inline ha inline giveback
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nothing_to_giveback","not_attempted","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_giveback
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback
	// state
	// State
	// nothing_to_giveback
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackStateNothingToGiveback captures enum value "nothing_to_giveback"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackStateNothingToGiveback string = "nothing_to_giveback"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_giveback
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback
	// state
	// State
	// not_attempted
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackStateNotAttempted captures enum value "not_attempted"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackStateNotAttempted string = "not_attempted"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_giveback
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback
	// state
	// State
	// in_progress
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackStateInProgress captures enum value "in_progress"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_giveback
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackStateFailed captures enum value "failed"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackStateFailed string = "failed"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"giveback"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	for i := 0; i < len(m.Status); i++ {
		if swag.IsZero(m.Status[i]) { // not required
			continue
		}

		if m.Status[i] != nil {
			if err := m.Status[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "giveback" + "." + "status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline ha inline giveback based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"giveback"+"."+"status", "body", []*NodeResponseRecordsItems0HaGivebackStatusItems0(m.Status)); err != nil {
		return err
	}

	for i := 0; i < len(m.Status); i++ {

		if m.Status[i] != nil {
			if err := m.Status[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "giveback" + "." + "status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGiveback
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackInlineFailure Indicates the failure code and message. This property is not supported on the ASA r2 platform.
//
// swagger:model node_response_inline_records_inline_array_item_inline_ha_inline_giveback_inline_failure
type NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackInlineFailure struct {

	// Message code
	// Example: 852126
	Code *int64 `json:"code,omitempty"`

	// Detailed message based on the state.
	// Example: Failed to initiate giveback. Run the \"storage failover show-giveback\" command for more information.
	Message *string `json:"message,omitempty"`
}

// Validate validates this node response inline records inline array item inline ha inline giveback inline failure
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackInlineFailure) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline ha inline giveback inline failure based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackInlineFailure) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackInlineFailure) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackInlineFailure) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHaInlineGivebackInlineFailure
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0HaGivebackStatusItems0 node response records items0 ha giveback status items0
//
// swagger:model NodeResponseRecordsItems0HaGivebackStatusItems0
type NodeResponseRecordsItems0HaGivebackStatusItems0 struct {

	// aggregate
	Aggregate *NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate `json:"aggregate,omitempty"`

	// error
	Error *NodeResponseRecordsItems0HaGivebackStatusItems0Error `json:"error,omitempty"`

	// Giveback state of the aggregate. <br/>
	// Possible values include no aggregates to giveback(nothing_to_giveback), failed to disable background disk firmware update(BDFU) on source node(failed_bdfu_source), <br/>
	// giveback delayed as disk firmware update is in progress on source node(delayed_bdfu_source), performing veto checks(running_checks). <br/>
	//
	// Enum: ["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node response records items0 ha giveback status items0
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregate) { // not required
		return nil
	}

	if m.Aggregate != nil {
		if err := m.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

var nodeResponseRecordsItems0HaGivebackStatusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseRecordsItems0HaGivebackStatusItems0TypeStatePropEnum = append(nodeResponseRecordsItems0HaGivebackStatusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// done
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateDone captures enum value "done"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateDone string = "done"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateFailed captures enum value "failed"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// in_progress
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateInProgress captures enum value "in_progress"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// not_started
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateNotStarted captures enum value "not_started"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateNotStarted string = "not_started"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// nothing_to_giveback
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateNothingToGiveback captures enum value "nothing_to_giveback"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateNothingToGiveback string = "nothing_to_giveback"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_source
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateFailedBdfuSource captures enum value "failed_bdfu_source"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateFailedBdfuSource string = "failed_bdfu_source"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_dest
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateFailedBdfuDest captures enum value "failed_bdfu_dest"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateFailedBdfuDest string = "failed_bdfu_dest"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_source
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateDelayedBdfuSource captures enum value "delayed_bdfu_source"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateDelayedBdfuSource string = "delayed_bdfu_source"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_dest
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateDelayedBdfuDest captures enum value "delayed_bdfu_dest"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateDelayedBdfuDest string = "delayed_bdfu_dest"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// NodeResponseRecordsItems0HaGivebackStatusItems0
	// state
	// State
	// running_checks
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0StateRunningChecks captures enum value "running_checks"
	NodeResponseRecordsItems0HaGivebackStatusItems0StateRunningChecks string = "running_checks"
)

// prop value enum
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseRecordsItems0HaGivebackStatusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response records items0 ha giveback status items0 based on the context it is used
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.Aggregate != nil {
		if err := m.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0HaGivebackStatusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate Aggregate name and UUID.
//
// swagger:model NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate
type NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate struct {

	// links
	Links *NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node response records items0 ha giveback status items0 aggregate
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 ha giveback status items0 aggregate based on the context it is used
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0HaGivebackStatusItems0Aggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks node response records items0 ha giveback status items0 aggregate links
//
// swagger:model NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks
type NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node response records items0 ha giveback status items0 aggregate links
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 ha giveback status items0 aggregate links based on the context it is used
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0HaGivebackStatusItems0AggregateLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0HaGivebackStatusItems0Error Indicates the failed aggregate giveback code and message.
//
// swagger:model NodeResponseRecordsItems0HaGivebackStatusItems0Error
type NodeResponseRecordsItems0HaGivebackStatusItems0Error struct {

	// Message code.
	// Example: 852126
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Detailed message based on the state.
	// Read Only: true
	// Enum: ["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]
	Message *string `json:"message,omitempty"`
}

// Validate validates this node response records items0 ha giveback status items0 error
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Error) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseRecordsItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseRecordsItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum = append(nodeResponseRecordsItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// shutdown
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageShutdown captures enum value "shutdown"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageShutdown string = "shutdown"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// not_homes_partner
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageNotHomesPartner captures enum value "not_homes_partner"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageNotHomesPartner string = "not_homes_partner"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// not_sfo
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageNotSfo captures enum value "not_sfo"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageNotSfo string = "not_sfo"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// failed_limbo
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageFailedLimbo captures enum value "failed_limbo"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageFailedLimbo string = "failed_limbo"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// offline_failed
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageOfflineFailed captures enum value "offline_failed"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageOfflineFailed string = "offline_failed"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// migrating
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageMigrating captures enum value "migrating"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageMigrating string = "migrating"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// veto
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageVeto captures enum value "veto"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageVeto string = "veto"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// communication_err
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageCommunicationErr captures enum value "communication_err"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageCommunicationErr string = "communication_err"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// online_timeout
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageOnlineTimeout captures enum value "online_timeout"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageOnlineTimeout string = "online_timeout"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// online_failed
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageOnlineFailed captures enum value "online_failed"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageOnlineFailed string = "online_failed"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// NodeResponseRecordsItems0HaGivebackStatusItems0Error
	// message
	// Message
	// hdd_to_aff_dest
	// END DEBUGGING
	// NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageHddToAffDest captures enum value "hdd_to_aff_dest"
	NodeResponseRecordsItems0HaGivebackStatusItems0ErrorMessageHddToAffDest string = "hdd_to_aff_dest"
)

// prop value enum
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Error) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseRecordsItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Error) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	// value enum
	if err := m.validateMessageEnum("error"+"."+"message", "body", *m.Message); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response records items0 ha giveback status items0 error based on the context it is used
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Error) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Error) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Error) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Error) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaGivebackStatusItems0Error) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0HaGivebackStatusItems0Error
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect node response inline records inline array item inline ha inline interconnect
//
// swagger:model node_response_inline_records_inline_array_item_inline_ha_inline_interconnect
type NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect struct {

	// HA interconnect device name.
	// Example: MVIA-RDMA
	// Read Only: true
	Adapter *string `json:"adapter,omitempty"`

	// Indicates the HA interconnect status.
	// Read Only: true
	// Enum: ["down","up"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node response inline records inline array item inline ha inline interconnect
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnectTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","up"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnectTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnectTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_interconnect
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect
	// state
	// State
	// down
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnectStateDown captures enum value "down"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnectStateDown string = "down"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_interconnect
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect
	// state
	// State
	// up
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnectStateUp captures enum value "up"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnectStateUp string = "up"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnectTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"interconnect"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline ha inline interconnect based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAdapter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect) contextValidateAdapter(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"interconnect"+"."+"adapter", "body", m.Adapter); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"interconnect"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHaInlineInterconnect
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0HaPartnersItems0 node response records items0 ha partners items0
//
// swagger:model NodeResponseRecordsItems0HaPartnersItems0
type NodeResponseRecordsItems0HaPartnersItems0 struct {

	// links
	Links *NodeResponseRecordsItems0HaPartnersItems0Links `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node response records items0 ha partners items0
func (m *NodeResponseRecordsItems0HaPartnersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaPartnersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 ha partners items0 based on the context it is used
func (m *NodeResponseRecordsItems0HaPartnersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaPartnersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaPartnersItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaPartnersItems0) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0HaPartnersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0HaPartnersItems0Links node response records items0 ha partners items0 links
//
// swagger:model NodeResponseRecordsItems0HaPartnersItems0Links
type NodeResponseRecordsItems0HaPartnersItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node response records items0 ha partners items0 links
func (m *NodeResponseRecordsItems0HaPartnersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaPartnersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 ha partners items0 links based on the context it is used
func (m *NodeResponseRecordsItems0HaPartnersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaPartnersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaPartnersItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaPartnersItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0HaPartnersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0HaPortsItems0 node response records items0 ha ports items0
//
// swagger:model NodeResponseRecordsItems0HaPortsItems0
type NodeResponseRecordsItems0HaPortsItems0 struct {

	// HA port number
	// Example: 0
	// Read Only: true
	Number *int64 `json:"number,omitempty"`

	// HA port state:
	// * <i>down</i> - Logical HA link is down.
	// * <i>initialized</i> - Logical HA link is initialized. The physical link is up, but the subnet manager hasn't started to configure the port.
	// * <i>armed</i> - Logical HA link is armed. The physical link is up and the subnet manager started but did not yet complete configuring the port.
	// * <i>active</i> - Logical HA link is active.
	// * <i>reserved</i> - Logical HA link is active, but the physical link is down.
	//
	// Example: active
	// Read Only: true
	// Enum: ["down","initialized","armed","active","reserved"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node response records items0 ha ports items0
func (m *NodeResponseRecordsItems0HaPortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseRecordsItems0HaPortsItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","initialized","armed","active","reserved"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseRecordsItems0HaPortsItems0TypeStatePropEnum = append(nodeResponseRecordsItems0HaPortsItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0
	// NodeResponseRecordsItems0HaPortsItems0
	// state
	// State
	// down
	// END DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0StateDown captures enum value "down"
	NodeResponseRecordsItems0HaPortsItems0StateDown string = "down"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0
	// NodeResponseRecordsItems0HaPortsItems0
	// state
	// State
	// initialized
	// END DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0StateInitialized captures enum value "initialized"
	NodeResponseRecordsItems0HaPortsItems0StateInitialized string = "initialized"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0
	// NodeResponseRecordsItems0HaPortsItems0
	// state
	// State
	// armed
	// END DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0StateArmed captures enum value "armed"
	NodeResponseRecordsItems0HaPortsItems0StateArmed string = "armed"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0
	// NodeResponseRecordsItems0HaPortsItems0
	// state
	// State
	// active
	// END DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0StateActive captures enum value "active"
	NodeResponseRecordsItems0HaPortsItems0StateActive string = "active"

	// BEGIN DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0
	// NodeResponseRecordsItems0HaPortsItems0
	// state
	// State
	// reserved
	// END DEBUGGING
	// NodeResponseRecordsItems0HaPortsItems0StateReserved captures enum value "reserved"
	NodeResponseRecordsItems0HaPortsItems0StateReserved string = "reserved"
)

// prop value enum
func (m *NodeResponseRecordsItems0HaPortsItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseRecordsItems0HaPortsItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaPortsItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response records items0 ha ports items0 based on the context it is used
func (m *NodeResponseRecordsItems0HaPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0HaPortsItems0) contextValidateNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "number", "body", m.Number); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseRecordsItems0HaPortsItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaPortsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0HaPortsItems0) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0HaPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover This represents the state of the node that is taking over storage from its HA partner.
//
// swagger:model node_response_inline_records_inline_array_item_inline_ha_inline_takeover
type NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover struct {

	// failure
	Failure *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverInlineFailure `json:"failure,omitempty"`

	// state
	// Example: failed
	// Enum: ["not_possible","not_attempted","in_takeover","in_progress","failed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node response inline records inline array item inline ha inline takeover
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_possible","not_attempted","in_takeover","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_takeover
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// not_possible
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateNotPossible captures enum value "not_possible"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateNotPossible string = "not_possible"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_takeover
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// not_attempted
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateNotAttempted captures enum value "not_attempted"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateNotAttempted string = "not_attempted"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_takeover
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// in_takeover
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateInTakeover captures enum value "in_takeover"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateInTakeover string = "in_takeover"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_takeover
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// in_progress
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateInProgress captures enum value "in_progress"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_ha_inline_takeover
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// failed
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateFailed captures enum value "failed"
	NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverStateFailed string = "failed"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"takeover"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline ha inline takeover based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeover
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck The takeover check response.
//
// swagger:model node_response_inline_records_inline_array_item_inline_ha_inline_takeover_check
type NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck struct {

	// Reasons why the takeover is not possible.
	// Read Only: true
	Reasons []*string `json:"reasons"`

	// Indicates whether the takeover is possible.
	// Read Only: true
	TakeoverPossible *bool `json:"takeover_possible,omitempty"`
}

// Validate validates this node response inline records inline array item inline ha inline takeover check
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline ha inline takeover check based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReasons(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeoverPossible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck) contextValidateReasons(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"reasons", "body", []*string(m.Reasons)); err != nil {
		return err
	}

	for i := 0; i < len(m.Reasons); i++ {

		if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"reasons"+"."+strconv.Itoa(i), "body", m.Reasons[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck) contextValidateTakeoverPossible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"takeover_possible", "body", m.TakeoverPossible); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverCheck
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverInlineFailure Indicates the failure code and message. This property is not supported on the ASA r2 platform.
//
// swagger:model node_response_inline_records_inline_array_item_inline_ha_inline_takeover_inline_failure
type NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverInlineFailure struct {

	// Message code
	// Example: 852130
	Code *int64 `json:"code,omitempty"`

	// Detailed message based on the state.
	// Example: Failed to initiate takeover. Run the \"storage failover show-takeover\" command for more information.
	Message *string `json:"message,omitempty"`
}

// Validate validates this node response inline records inline array item inline ha inline takeover inline failure
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverInlineFailure) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline ha inline takeover inline failure based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverInlineFailure) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverInlineFailure) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverInlineFailure) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHaInlineTakeoverInlineFailure
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHwAssist The hardware assist information.
//
// swagger:model node_response_inline_records_inline_array_item_inline_hw_assist
type NodeResponseInlineRecordsInlineArrayItemInlineHwAssist struct {

	// status
	Status *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus `json:"status,omitempty"`
}

// Validate validates this node response inline records inline array item inline hw assist
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssist) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssist) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline hw assist based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssist) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssist) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssist) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssist) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHwAssist
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus node response inline records inline array item inline hw assist inline status
//
// swagger:model node_response_inline_records_inline_array_item_inline_hw_assist_inline_status
type NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus struct {

	// Indicates whether hardware assist is enabled on the node.
	Enabled *bool `json:"enabled,omitempty"`

	// local
	Local *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal `json:"local,omitempty"`

	// partner
	Partner *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner `json:"partner,omitempty"`
}

// Validate validates this node response inline records inline array item inline hw assist inline status
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(m.Local) { // not required
		return nil
	}

	if m.Local != nil {
		if err := m.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus) validatePartner(formats strfmt.Registry) error {
	if swag.IsZero(m.Partner) { // not required
		return nil
	}

	if m.Partner != nil {
		if err := m.Partner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "partner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline hw assist inline status based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if m.Local != nil {
		if err := m.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus) contextValidatePartner(ctx context.Context, formats strfmt.Registry) error {

	if m.Partner != nil {
		if err := m.Partner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "partner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal node response inline records inline array item inline hw assist inline status inline local
//
// swagger:model node_response_inline_records_inline_array_item_inline_hw_assist_inline_status_inline_local
type NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal struct {

	// The hardware assist IP address.
	IP *string `json:"ip,omitempty"`

	// The hardware assist port.
	Port *int64 `json:"port,omitempty"`

	// The hardware assist monitor status.
	// Enum: ["active","inactive"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node response inline records inline array item inline hw assist inline status inline local
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","inactive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_hw_assist_inline_status_inline_local
	// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal
	// state
	// State
	// active
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocalStateActive captures enum value "active"
	NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocalStateActive string = "active"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_hw_assist_inline_status_inline_local
	// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal
	// state
	// State
	// inactive
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocalStateInactive captures enum value "inactive"
	NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocalStateInactive string = "inactive"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("hw_assist"+"."+"status"+"."+"local"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node response inline records inline array item inline hw assist inline status inline local based on context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlineLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner node response inline records inline array item inline hw assist inline status inline partner
//
// swagger:model node_response_inline_records_inline_array_item_inline_hw_assist_inline_status_inline_partner
type NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner struct {

	// The hardware assist IP address.
	IP *string `json:"ip,omitempty"`

	// The hardware assist port.
	Port *int64 `json:"port,omitempty"`

	// The hardware assist monitor status.
	// Enum: ["active","inactive"]
	State *string `json:"state,omitempty"`
}

// Validate validates this node response inline records inline array item inline hw assist inline status inline partner
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","inactive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_hw_assist_inline_status_inline_partner
	// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner
	// state
	// State
	// active
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartnerStateActive captures enum value "active"
	NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartnerStateActive string = "active"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_hw_assist_inline_status_inline_partner
	// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner
	// state
	// State
	// inactive
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartnerStateInactive captures enum value "inactive"
	NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartnerStateInactive string = "inactive"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("hw_assist"+"."+"status"+"."+"partner"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node response inline records inline array item inline hw assist inline status inline partner based on context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineHwAssistInlineStatusInlinePartner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineLinks node response inline records inline array item inline links
//
// swagger:model node_response_inline_records_inline_array_item_inline__links
type NodeResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node response inline records inline array item inline links
func (m *NodeResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline links based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface The management interface of the node to be added. The subnet mask is set based on the management interface of the cluster or the management interfaces of other nodes.
//
// swagger:model node_response_inline_records_inline_array_item_inline_management_interface
type NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface struct {

	// ip
	IP *NodeSetupIP `json:"ip,omitempty"`
}

// Validate validates this node response inline records inline array item inline management interface
func (m *NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline management interface based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineManagementInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0ManagementInterfacesItems0 Network interface
//
// swagger:model NodeResponseRecordsItems0ManagementInterfacesItems0
type NodeResponseRecordsItems0ManagementInterfacesItems0 struct {

	// links
	Links *NodeResponseRecordsItems0ManagementInterfacesItems0Links `json:"_links,omitempty"`

	// ip
	IP *NodeResponseRecordsItems0ManagementInterfacesItems0IP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node response records items0 management interfaces items0
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ManagementInterfacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseRecordsItems0ManagementInterfacesItems0) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 management interfaces items0 based on the context it is used
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ManagementInterfacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseRecordsItems0ManagementInterfacesItems0) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0ManagementInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0ManagementInterfacesItems0IP IP information
//
// swagger:model NodeResponseRecordsItems0ManagementInterfacesItems0IP
type NodeResponseRecordsItems0ManagementInterfacesItems0IP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this node response records items0 management interfaces items0 IP
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0IP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ManagementInterfacesItems0IP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 management interfaces items0 IP based on the context it is used
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0IP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ManagementInterfacesItems0IP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0IP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0IP) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0ManagementInterfacesItems0IP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0ManagementInterfacesItems0Links node response records items0 management interfaces items0 links
//
// swagger:model NodeResponseRecordsItems0ManagementInterfacesItems0Links
type NodeResponseRecordsItems0ManagementInterfacesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node response records items0 management interfaces items0 links
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ManagementInterfacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response records items0 management interfaces items0 links based on the context it is used
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseRecordsItems0ManagementInterfacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0ManagementInterfacesItems0Links) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0ManagementInterfacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineMetric CPU performance for the nodes.
//
// swagger:model node_response_inline_records_inline_array_item_inline_metric
type NodeResponseInlineRecordsInlineArrayItemInlineMetric struct {

	// links
	Links *NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT5M","PT30M","PT2H","P1D"]
	Duration *string `json:"duration,omitempty"`

	// Average CPU Utilization for the node
	// Example: 13
	ProcessorUtilization *int64 `json:"processor_utilization,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node response inline records inline array item inline metric
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","P1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineMetricTypeDurationPropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationPT15S captures enum value "PT15S"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationPT5M captures enum value "PT5M"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationPT30M captures enum value "PT30M"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationPT2H captures enum value "PT2H"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationP1D captures enum value "P1D"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricDurationP1D string = "P1D"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineMetricTypeStatusPropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusOk captures enum value "ok"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusError captures enum value "error"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metric
	// NodeResponseInlineRecordsInlineArrayItemInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NodeResponseInlineRecordsInlineArrayItemInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline metric based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetric) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks node response inline records inline array item inline metric inline links
//
// swagger:model node_response_inline_records_inline_array_item_inline_metric_inline__links
type NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node response inline records inline array item inline metric inline links
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline metric inline links based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster Metrocluster
//
// swagger:model node_response_inline_records_inline_array_item_inline_metrocluster
type NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster struct {

	// Indicates whether the MetroCluster over IP platform supports custom VLAN IDs.
	// Read Only: true
	CustomVlanCapable *bool `json:"custom_vlan_capable,omitempty"`

	// MetroCluster over IP ports.
	// Read Only: true
	Ports []*NodeResponseRecordsItems0MetroclusterPortsItems0 `json:"ports"`

	// The Metrocluster configuration type
	// Read Only: true
	// Enum: ["fc","fc_2_node","ip"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this node response inline records inline array item inline metrocluster
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) validatePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.Ports) { // not required
		return nil
	}

	for i := 0; i < len(m.Ports); i++ {
		if swag.IsZero(m.Ports[i]) { // not required
			continue
		}

		if m.Ports[i] != nil {
			if err := m.Ports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrocluster" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc","fc_2_node","ip"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeTypePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metrocluster
	// NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster
	// type
	// Type
	// fc
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeFc captures enum value "fc"
	NodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeFc string = "fc"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metrocluster
	// NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster
	// type
	// Type
	// fc_2_node
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeFc2Node captures enum value "fc_2_node"
	NodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeFc2Node string = "fc_2_node"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_metrocluster
	// NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster
	// type
	// Type
	// ip
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeIP captures enum value "ip"
	NodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeIP string = "ip"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineMetroclusterTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("metrocluster"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline metrocluster based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCustomVlanCapable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) contextValidateCustomVlanCapable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"custom_vlan_capable", "body", m.CustomVlanCapable); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) contextValidatePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"ports", "body", []*NodeResponseRecordsItems0MetroclusterPortsItems0(m.Ports)); err != nil {
		return err
	}

	for i := 0; i < len(m.Ports); i++ {

		if m.Ports[i] != nil {
			if err := m.Ports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrocluster" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineMetrocluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseRecordsItems0MetroclusterPortsItems0 node response records items0 metrocluster ports items0
//
// swagger:model NodeResponseRecordsItems0MetroclusterPortsItems0
type NodeResponseRecordsItems0MetroclusterPortsItems0 struct {

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`
}

// Validate validates this node response records items0 metrocluster ports items0
func (m *NodeResponseRecordsItems0MetroclusterPortsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this node response records items0 metrocluster ports items0 based on context it is used
func (m *NodeResponseRecordsItems0MetroclusterPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseRecordsItems0MetroclusterPortsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseRecordsItems0MetroclusterPortsItems0) UnmarshalBinary(b []byte) error {
	var res NodeResponseRecordsItems0MetroclusterPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineNvlog Non-volatile write log settings.
//
// swagger:model node_response_inline_records_inline_array_item_inline_nvlog
type NodeResponseInlineRecordsInlineArrayItemInlineNvlog struct {

	// Indicates the current NVLog journal backing type.
	// Enum: ["ephemeral_memory","ephemeral_disk"]
	BackingType *string `json:"backing_type,omitempty"`

	// Indicates the current NVLog journal swap mode.
	// Enum: ["dynamic","manual"]
	SwapMode *string `json:"swap_mode,omitempty"`
}

// Validate validates this node response inline records inline array item inline nvlog
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvlog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBackingType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSwapMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineNvlogTypeBackingTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ephemeral_memory","ephemeral_disk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineNvlogTypeBackingTypePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineNvlogTypeBackingTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvlog
	// NodeResponseInlineRecordsInlineArrayItemInlineNvlog
	// backing_type
	// BackingType
	// ephemeral_memory
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvlogBackingTypeEphemeralMemory captures enum value "ephemeral_memory"
	NodeResponseInlineRecordsInlineArrayItemInlineNvlogBackingTypeEphemeralMemory string = "ephemeral_memory"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvlog
	// NodeResponseInlineRecordsInlineArrayItemInlineNvlog
	// backing_type
	// BackingType
	// ephemeral_disk
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvlogBackingTypeEphemeralDisk captures enum value "ephemeral_disk"
	NodeResponseInlineRecordsInlineArrayItemInlineNvlogBackingTypeEphemeralDisk string = "ephemeral_disk"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvlog) validateBackingTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineNvlogTypeBackingTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvlog) validateBackingType(formats strfmt.Registry) error {
	if swag.IsZero(m.BackingType) { // not required
		return nil
	}

	// value enum
	if err := m.validateBackingTypeEnum("nvlog"+"."+"backing_type", "body", *m.BackingType); err != nil {
		return err
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineNvlogTypeSwapModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["dynamic","manual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineNvlogTypeSwapModePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineNvlogTypeSwapModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvlog
	// NodeResponseInlineRecordsInlineArrayItemInlineNvlog
	// swap_mode
	// SwapMode
	// dynamic
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvlogSwapModeDynamic captures enum value "dynamic"
	NodeResponseInlineRecordsInlineArrayItemInlineNvlogSwapModeDynamic string = "dynamic"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvlog
	// NodeResponseInlineRecordsInlineArrayItemInlineNvlog
	// swap_mode
	// SwapMode
	// manual
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvlogSwapModeManual captures enum value "manual"
	NodeResponseInlineRecordsInlineArrayItemInlineNvlogSwapModeManual string = "manual"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvlog) validateSwapModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineNvlogTypeSwapModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvlog) validateSwapMode(formats strfmt.Registry) error {
	if swag.IsZero(m.SwapMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateSwapModeEnum("nvlog"+"."+"swap_mode", "body", *m.SwapMode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node response inline records inline array item inline nvlog based on context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvlog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvlog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvlog) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineNvlog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineNvram node response inline records inline array item inline nvram
//
// swagger:model node_response_inline_records_inline_array_item_inline_nvram
type NodeResponseInlineRecordsInlineArrayItemInlineNvram struct {

	// Specifies status of the NVRAM battery. Possible values:
	// * <i>battery_ok</i>
	// * <i>battery_partially_discharged</i>
	// * <i>battery_fully_discharged</i>
	// * <i>battery_not_present</i>
	// * <i>battery_near_end_of_life</i>
	// * <i>battery_at_end_of_life</i>
	// * <i>battery_unknown</i>
	// * <i>battery_over_charged</i>
	// * <i>battery_fully_charged</i>
	//
	// Read Only: true
	// Enum: ["battery_ok","battery_partially_discharged","battery_fully_discharged","battery_not_present","battery_near_end_of_life","battery_at_end_of_life","battery_unknown","battery_over_charged","battery_fully_charged"]
	BatteryState *string `json:"battery_state,omitempty"`

	// Vendor specific NVRAM ID of the node.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`
}

// Validate validates this node response inline records inline array item inline nvram
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvram) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBatteryState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineNvramTypeBatteryStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["battery_ok","battery_partially_discharged","battery_fully_discharged","battery_not_present","battery_near_end_of_life","battery_at_end_of_life","battery_unknown","battery_over_charged","battery_fully_charged"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineNvramTypeBatteryStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineNvramTypeBatteryStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_ok
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryOk captures enum value "battery_ok"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryOk string = "battery_ok"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_partially_discharged
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryPartiallyDischarged captures enum value "battery_partially_discharged"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryPartiallyDischarged string = "battery_partially_discharged"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_fully_discharged
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryFullyDischarged captures enum value "battery_fully_discharged"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryFullyDischarged string = "battery_fully_discharged"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_not_present
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryNotPresent captures enum value "battery_not_present"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryNotPresent string = "battery_not_present"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_near_end_of_life
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryNearEndOfLife captures enum value "battery_near_end_of_life"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryNearEndOfLife string = "battery_near_end_of_life"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_at_end_of_life
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryAtEndOfLife captures enum value "battery_at_end_of_life"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryAtEndOfLife string = "battery_at_end_of_life"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_unknown
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryUnknown captures enum value "battery_unknown"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryUnknown string = "battery_unknown"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_over_charged
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryOverCharged captures enum value "battery_over_charged"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryOverCharged string = "battery_over_charged"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_nvram
	// NodeResponseInlineRecordsInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_fully_charged
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryFullyCharged captures enum value "battery_fully_charged"
	NodeResponseInlineRecordsInlineArrayItemInlineNvramBatteryStateBatteryFullyCharged string = "battery_fully_charged"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvram) validateBatteryStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineNvramTypeBatteryStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvram) validateBatteryState(formats strfmt.Registry) error {
	if swag.IsZero(m.BatteryState) { // not required
		return nil
	}

	// value enum
	if err := m.validateBatteryStateEnum("nvram"+"."+"battery_state", "body", *m.BatteryState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline nvram based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvram) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBatteryState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvram) contextValidateBatteryState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nvram"+"."+"battery_state", "body", m.BatteryState); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvram) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nvram"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvram) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineNvram) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineNvram
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor node response inline records inline array item inline service processor
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor struct {

	// api service
	APIService *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAPIService `json:"api_service,omitempty"`

	// auto config
	AutoConfig *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAutoConfig `json:"auto_config,omitempty"`

	// Indicates whether the service processor can be automatically updated from ONTAP.
	AutoupdateEnabled *bool `json:"autoupdate_enabled,omitempty"`

	// backup
	Backup *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup `json:"backup,omitempty"`

	// Set to "true" to use DHCP to configure an IPv4 interface. Do not provide values for address, netmask and gateway when set to "true".
	DhcpEnabled *bool `json:"dhcp_enabled,omitempty"`

	// The version of firmware installed.
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// ipv4 interface
	IPV4Interface *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface `json:"ipv4_interface,omitempty"`

	// ipv6 interface
	IPV6Interface *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface `json:"ipv6_interface,omitempty"`

	// Indicates whether the service processor network is configured.
	// Read Only: true
	IsIPConfigured *bool `json:"is_ip_configured,omitempty"`

	// Provides the "update status" of the last service processor update.
	// Read Only: true
	// Enum: ["failed","passed"]
	LastUpdateState *string `json:"last_update_state,omitempty"`

	// link status
	// Read Only: true
	// Enum: ["up","down","disabled","unknown"]
	LinkStatus *string `json:"link_status,omitempty"`

	// mac address
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// primary
	Primary *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary `json:"primary,omitempty"`

	// ssh info
	SSHInfo *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo `json:"ssh_info,omitempty"`

	// state
	// Read Only: true
	// Enum: ["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["sp","none","bmc"]
	Type *string `json:"type,omitempty"`

	// web service
	WebService *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineWebService `json:"web_service,omitempty"`
}

// Validate validates this node response inline records inline array item inline service processor
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPIService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutoConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV4Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLinkStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrimary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSSHInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWebService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateAPIService(formats strfmt.Registry) error {
	if swag.IsZero(m.APIService) { // not required
		return nil
	}

	if m.APIService != nil {
		if err := m.APIService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "api_service")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateAutoConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.AutoConfig) { // not required
		return nil
	}

	if m.AutoConfig != nil {
		if err := m.AutoConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "auto_config")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateBackup(formats strfmt.Registry) error {
	if swag.IsZero(m.Backup) { // not required
		return nil
	}

	if m.Backup != nil {
		if err := m.Backup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "backup")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateIPV4Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4Interface) { // not required
		return nil
	}

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateIPV6Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6Interface) { // not required
		return nil
	}

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv6_interface")
			}
			return err
		}
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeLastUpdateStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["failed","passed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeLastUpdateStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeLastUpdateStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// last_update_state
	// LastUpdateState
	// failed
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLastUpdateStateFailed captures enum value "failed"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLastUpdateStateFailed string = "failed"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// last_update_state
	// LastUpdateState
	// passed
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLastUpdateStatePassed captures enum value "passed"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLastUpdateStatePassed string = "passed"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateLastUpdateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeLastUpdateStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateLastUpdateState(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdateState) { // not required
		return nil
	}

	// value enum
	if err := m.validateLastUpdateStateEnum("service_processor"+"."+"last_update_state", "body", *m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeLinkStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","disabled","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeLinkStatusPropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeLinkStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// link_status
	// LinkStatus
	// up
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLinkStatusUp captures enum value "up"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLinkStatusUp string = "up"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// link_status
	// LinkStatus
	// down
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLinkStatusDown captures enum value "down"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLinkStatusDown string = "down"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// link_status
	// LinkStatus
	// disabled
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLinkStatusDisabled captures enum value "disabled"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLinkStatusDisabled string = "disabled"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// link_status
	// LinkStatus
	// unknown
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLinkStatusUnknown captures enum value "unknown"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorLinkStatusUnknown string = "unknown"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateLinkStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeLinkStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateLinkStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.LinkStatus) { // not required
		return nil
	}

	// value enum
	if err := m.validateLinkStatusEnum("service_processor"+"."+"link_status", "body", *m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validatePrimary(formats strfmt.Registry) error {
	if swag.IsZero(m.Primary) { // not required
		return nil
	}

	if m.Primary != nil {
		if err := m.Primary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateSSHInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.SSHInfo) { // not required
		return nil
	}

	if m.SSHInfo != nil {
		if err := m.SSHInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ssh_info")
			}
			return err
		}
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// state
	// State
	// online
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateOnline captures enum value "online"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateOnline string = "online"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// state
	// State
	// offline
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateOffline captures enum value "offline"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateOffline string = "offline"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// state
	// State
	// degraded
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateDegraded captures enum value "degraded"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// state
	// State
	// rebooting
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateRebooting captures enum value "rebooting"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateRebooting string = "rebooting"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// state
	// State
	// unknown
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateUnknown captures enum value "unknown"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// state
	// State
	// updating
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateUpdating captures enum value "updating"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// state
	// State
	// node_offline
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateNodeOffline captures enum value "node_offline"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateNodeOffline string = "node_offline"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// state
	// State
	// sp_daemon_offline
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateSpDaemonOffline captures enum value "sp_daemon_offline"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorStateSpDaemonOffline string = "sp_daemon_offline"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sp","none","bmc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeTypePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// type
	// Type
	// sp
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeSp captures enum value "sp"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeSp string = "sp"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// type
	// Type
	// none
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeNone captures enum value "none"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeNone string = "none"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	// type
	// Type
	// bmc
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeBmc captures enum value "bmc"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeBmc string = "bmc"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("service_processor"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) validateWebService(formats strfmt.Registry) error {
	if swag.IsZero(m.WebService) { // not required
		return nil
	}

	if m.WebService != nil {
		if err := m.WebService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "web_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAPIService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAutoConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBackup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV4Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV6Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsIPConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUpdateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLinkStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePrimary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSSHInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWebService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateAPIService(ctx context.Context, formats strfmt.Registry) error {

	if m.APIService != nil {
		if err := m.APIService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "api_service")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateAutoConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.AutoConfig != nil {
		if err := m.AutoConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "auto_config")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateBackup(ctx context.Context, formats strfmt.Registry) error {

	if m.Backup != nil {
		if err := m.Backup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "backup")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateIPV4Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateIPV6Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv6_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateIsIPConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"is_ip_configured", "body", m.IsIPConfigured); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateLastUpdateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"last_update_state", "body", m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateLinkStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"link_status", "body", m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"mac_address", "body", m.MacAddress); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidatePrimary(ctx context.Context, formats strfmt.Registry) error {

	if m.Primary != nil {
		if err := m.Primary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateSSHInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.SSHInfo != nil {
		if err := m.SSHInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ssh_info")
			}
			return err
		}
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) contextValidateWebService(ctx context.Context, formats strfmt.Registry) error {

	if m.WebService != nil {
		if err := m.WebService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "web_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAPIService Provides the properties of the service processor (SP) or baseboard management controller (BMC) API service.
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor_inline_api_service
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAPIService struct {

	// Indicates whether the SP API service of the SP or BMC is enabled or disabled. When the SP API service is disabled, features such as network-based firmware updates and network-based down node log collection are not available, and the slower serial-interface is used for firmware updates and down node log collection.
	Enabled *bool `json:"enabled,omitempty"`

	// Restricts SP API service access to cluster nodes only. By default, limit_access is set to true.
	LimitAccess *bool `json:"limit_access,omitempty"`

	// Specifies the port number on the SP or BMC used for the SP API service. By default, port 50000 is used.
	Port *int64 `json:"port,omitempty"`
}

// Validate validates this node response inline records inline array item inline service processor inline api service
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAPIService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor inline api service based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAPIService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAPIService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAPIService) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAPIService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAutoConfig Provides the properties of the service processor auto configuration.
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor_inline_auto_config
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAutoConfig struct {

	// Indicates the service processor auto configuration IPv4 subnet name. To enable IPv4 auto-config give the subnet name, give the value as null or an empty string "" to disable auto-config.
	// Example: ipv4_mgmt
	IPV4Subnet *string `json:"ipv4_subnet,omitempty"`

	// Indicates the service processor auto configuration IPv6 subnet name. To enable IPv6 auto-config give the subnet name, give the value as null or an empty string "" to disable auto-config.
	// Example: ipv6_mgmt
	IPV6Subnet *string `json:"ipv6_subnet,omitempty"`
}

// Validate validates this node response inline records inline array item inline service processor inline auto config
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAutoConfig) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor inline auto config based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAutoConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAutoConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAutoConfig) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineAutoConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup Provides the properties of the service processor backup partition.
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor_inline_backup
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup struct {

	// Indicates whether the service processor is currently booted from the backup partition.
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// Status of the backup partition.
	// Read Only: true
	// Enum: ["installed","corrupt","updating","auto_updating","none"]
	State *string `json:"state,omitempty"`

	// Firmware version of the backup partition.
	// Example: 11.6
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this node response inline records inline array item inline service processor inline backup
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","auto_updating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_backup
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// installed
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateInstalled captures enum value "installed"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_backup
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// corrupt
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateCorrupt captures enum value "corrupt"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_backup
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// updating
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateUpdating captures enum value "updating"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_backup
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// auto_updating
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateAutoUpdating captures enum value "auto_updating"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateAutoUpdating string = "auto_updating"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_backup
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// none
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateNone captures enum value "none"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupStateNone string = "none"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackupTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"backup"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor inline backup based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineBackup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface Object to set up an interface along with its default router.
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv4_interface
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface struct {

	// IPv4 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv4 interfaces is enabled. It expects dhcp_enabled as "true" or values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv4 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// Input as IPv4 mask (255.255.0.0). Output is always the netmask length.
	// Example: 255.255.0.0
	Netmask *string `json:"netmask,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this node response inline records inline array item inline service processor inline ipv4 interface
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv4_interface
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateNotSetup captures enum value "not_setup"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv4_interface
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateSucceeded captures enum value "succeeded"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv4_interface
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateInProgress captures enum value "in_progress"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv4_interface
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateFailed captures enum value "failed"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("service_processor"+"."+"ipv4_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor inline ipv4 interface based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"ipv4_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface Object to setup an interface along with its default router.
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv6_interface
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface struct {

	// IPv6 address
	// Example: fd20:8b1e:b255:5011:10:141:4:97
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv6 interfaces is enabled. It expects values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv6 address of the default router.
	// Example: fd20:8b1e:b255:5011:10::1
	Gateway *string `json:"gateway,omitempty"`

	// Indicates whether IPv6 RA is enabled.
	IsIPV6RaEnabled *bool `json:"is_ipv6_ra_enabled,omitempty"`

	// Link local IP address.
	// Example: FE80::/10
	LinkLocalIP *string `json:"link_local_ip,omitempty"`

	// The IPv6 netmask/prefix length. The default value is 64 with a valid range of 1 to 127.
	// Example: 64
	Netmask *int64 `json:"netmask,omitempty"`

	// Router assigned IP address.
	// Example: 2001:0db8:85a3:0000:0000:8a2e:0370:7334
	RouterIP *string `json:"router_ip,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this node response inline records inline array item inline service processor inline ipv6 interface
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv6_interface
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateNotSetup captures enum value "not_setup"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv6_interface
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateSucceeded captures enum value "succeeded"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv6_interface
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateInProgress captures enum value "in_progress"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_ipv6_interface
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateFailed captures enum value "failed"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("service_processor"+"."+"ipv6_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor inline ipv6 interface based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"ipv6_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary Provides the properties of the service processor primary partition.
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor_inline_primary
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary struct {

	// Indicates whether the service processor is currently booted from the primary partition.
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// Status of the primary partition.
	// Read Only: true
	// Enum: ["installed","corrupt","updating","auto_updating","none"]
	State *string `json:"state,omitempty"`

	// Firmware version of the primary partition.
	// Example: 11.6
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this node response inline records inline array item inline service processor inline primary
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","auto_updating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryTypeStatePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_primary
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// installed
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateInstalled captures enum value "installed"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_primary
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// corrupt
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateCorrupt captures enum value "corrupt"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_primary
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// updating
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateUpdating captures enum value "updating"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_primary
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// auto_updating
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateAutoUpdating captures enum value "auto_updating"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateAutoUpdating string = "auto_updating"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_service_processor_inline_primary
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// none
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateNone captures enum value "none"
	NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryStateNone string = "none"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimaryTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"primary"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor inline primary based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlinePrimary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo Service processor SSH allowed IP address configuration applied across the cluster.
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor_inline_ssh_info
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo struct {

	// Allowed IP addresses
	AllowedAddresses []*IPAddressAndNetmask `json:"allowed_addresses"`
}

// Validate validates this node response inline records inline array item inline service processor inline ssh info
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAllowedAddresses(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo) validateAllowedAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.AllowedAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.AllowedAddresses); i++ {
		if swag.IsZero(m.AllowedAddresses[i]) { // not required
			continue
		}

		if m.AllowedAddresses[i] != nil {
			if err := m.AllowedAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("service_processor" + "." + "ssh_info" + "." + "allowed_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor inline ssh info based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAllowedAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo) contextValidateAllowedAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AllowedAddresses); i++ {

		if m.AllowedAddresses[i] != nil {
			if err := m.AllowedAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("service_processor" + "." + "ssh_info" + "." + "allowed_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineSSHInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineWebService Provides the properties of SP or BMC web service.
//
// swagger:model node_response_inline_records_inline_array_item_inline_service_processor_inline_web_service
type NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineWebService struct {

	// Indicates whether the web service of the SP or BMC is enabled or disabled. When the web service is disabled, features such as network-based firmware updates and network-based down node log collection are not available, and the slower serial-interface is used for firmware updates and down node log collection.
	Enabled *bool `json:"enabled,omitempty"`

	// Restricts web service access to cluster nodes only. By default, limit_access is set to true.
	LimitAccess *bool `json:"limit_access,omitempty"`
}

// Validate validates this node response inline records inline array item inline service processor inline web service
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineWebService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline service processor inline web service based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineWebService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineWebService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineWebService) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineServiceProcessorInlineWebService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineSnaplock SnapLock-related properties.
//
// swagger:model node_response_inline_records_inline_array_item_inline_snaplock
type NodeResponseInlineRecordsInlineArrayItemInlineSnaplock struct {

	// SnapLock compliance clock time.
	// Example: 2018-06-04 19:00:00+00:00
	// Format: date-time
	ComplianceClockTime *strfmt.DateTime `json:"compliance_clock_time,omitempty"`
}

// Validate validates this node response inline records inline array item inline snaplock
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComplianceClockTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineSnaplock) validateComplianceClockTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ComplianceClockTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"compliance_clock_time", "body", "date-time", m.ComplianceClockTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline snaplock based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineStatistics Raw CPU performance for the nodes.
//
// swagger:model node_response_inline_records_inline_array_item_inline_statistics
type NodeResponseInlineRecordsInlineArrayItemInlineStatistics struct {

	// Base counter for CPU Utilization.
	// Example: 12345123
	ProcessorUtilizationBase *int64 `json:"processor_utilization_base,omitempty"`

	// Raw CPU utilization for the node. The change in this value over time should be divided by corresponding change in processor_utilization_base, then multiplied by 100 to calculate the percentage CPU utilization for the node. For example: ((processor_utilization_raw_t2 - processor_utilization_raw_t1) / (processor_utilization_base_t2 - processor_utilization_base_t1)) * 100.
	//
	// Example: 13
	ProcessorUtilizationRaw *int64 `json:"processor_utilization_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this node response inline records inline array item inline statistics
func (m *NodeResponseInlineRecordsInlineArrayItemInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineStatisticsTypeStatusPropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusOk captures enum value "ok"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusError captures enum value "error"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_statistics
	// NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NodeResponseInlineRecordsInlineArrayItemInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node response inline records inline array item inline statistics based on context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineStatistics) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate Aggregate
//
// swagger:model node_response_inline_records_inline_array_item_inline_system_aggregate
type NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate struct {

	// links
	Links *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this node response inline records inline array item inline system aggregate
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline system aggregate based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks node response inline records inline array item inline system aggregate inline links
//
// swagger:model node_response_inline_records_inline_array_item_inline_system_aggregate_inline__links
type NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this node response inline records inline array item inline system aggregate inline links
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline system aggregate inline links based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineSystemAggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineVM node response inline records inline array item inline vm
//
// swagger:model node_response_inline_records_inline_array_item_inline_vm
type NodeResponseInlineRecordsInlineArrayItemInlineVM struct {

	// Cloud provider where the VM is hosted.
	// Read Only: true
	// Enum: ["GoogleCloud","AWS_S3","Azure_Cloud"]
	ProviderType *string `json:"provider_type,omitempty"`
}

// Validate validates this node response inline records inline array item inline vm
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVM) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProviderType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeResponseInlineRecordsInlineArrayItemInlineVmTypeProviderTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["GoogleCloud","AWS_S3","Azure_Cloud"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeResponseInlineRecordsInlineArrayItemInlineVmTypeProviderTypePropEnum = append(nodeResponseInlineRecordsInlineArrayItemInlineVmTypeProviderTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_vm
	// NodeResponseInlineRecordsInlineArrayItemInlineVM
	// provider_type
	// ProviderType
	// GoogleCloud
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineVMProviderTypeGoogleCloud captures enum value "GoogleCloud"
	NodeResponseInlineRecordsInlineArrayItemInlineVMProviderTypeGoogleCloud string = "GoogleCloud"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_vm
	// NodeResponseInlineRecordsInlineArrayItemInlineVM
	// provider_type
	// ProviderType
	// AWS_S3
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineVMProviderTypeAWSS3 captures enum value "AWS_S3"
	NodeResponseInlineRecordsInlineArrayItemInlineVMProviderTypeAWSS3 string = "AWS_S3"

	// BEGIN DEBUGGING
	// node_response_inline_records_inline_array_item_inline_vm
	// NodeResponseInlineRecordsInlineArrayItemInlineVM
	// provider_type
	// ProviderType
	// Azure_Cloud
	// END DEBUGGING
	// NodeResponseInlineRecordsInlineArrayItemInlineVMProviderTypeAzureCloud captures enum value "Azure_Cloud"
	NodeResponseInlineRecordsInlineArrayItemInlineVMProviderTypeAzureCloud string = "Azure_Cloud"
)

// prop value enum
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVM) validateProviderTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeResponseInlineRecordsInlineArrayItemInlineVmTypeProviderTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineVM) validateProviderType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProviderType) { // not required
		return nil
	}

	// value enum
	if err := m.validateProviderTypeEnum("vm"+"."+"provider_type", "body", *m.ProviderType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this node response inline records inline array item inline vm based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVM) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProviderType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineVM) contextValidateProviderType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vm"+"."+"provider_type", "body", m.ProviderType); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVM) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVM) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineVM
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeResponseInlineRecordsInlineArrayItemInlineVersion This returns the cluster version information.  When the cluster has more than one node, the cluster version is equivalent to the lowest of generation, major, and minor versions on all nodes.
//
// swagger:model node_response_inline_records_inline_array_item_inline_version
type NodeResponseInlineRecordsInlineArrayItemInlineVersion struct {

	// The full cluster version string.
	// Example: NetApp Release 9.4.0: Sun Nov 05 18:20:57 UTC 2017
	// Read Only: true
	Full *string `json:"full,omitempty"`

	// The generation portion of the version.
	// Example: 9
	// Read Only: true
	Generation *int64 `json:"generation"`

	// The major portion of the version.
	// Example: 4
	// Read Only: true
	Major *int64 `json:"major"`

	// The minor portion of the version.
	// Example: 0
	// Read Only: true
	Minor *int64 `json:"minor"`
}

// Validate validates this node response inline records inline array item inline version
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVersion) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this node response inline records inline array item inline version based on the context it is used
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFull(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMajor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineVersion) contextValidateFull(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"full", "body", m.Full); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineVersion) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"generation", "body", m.Generation); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineVersion) contextValidateMajor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"major", "body", m.Major); err != nil {
		return err
	}

	return nil
}

func (m *NodeResponseInlineRecordsInlineArrayItemInlineVersion) contextValidateMinor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"minor", "body", m.Minor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeResponseInlineRecordsInlineArrayItemInlineVersion) UnmarshalBinary(b []byte) error {
	var res NodeResponseInlineRecordsInlineArrayItemInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
