// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NodeStatistics Raw CPU performance for the nodes.
//
// swagger:model node_statistics
type NodeStatistics struct {

	// Base counter for CPU Utilization.
	// Example: 12345123
	ProcessorUtilizationBase *int64 `json:"processor_utilization_base,omitempty"`

	// Raw CPU utilization for the node. The change in this value over time should be divided by corresponding change in processor_utilization_base, then multiplied by 100 to calculate the percentage CPU utilization for the node. For example: ((processor_utilization_raw_t2 - processor_utilization_raw_t1) / (processor_utilization_base_t2 - processor_utilization_base_t1)) * 100.
	//
	// Example: 13
	ProcessorUtilizationRaw *int64 `json:"processor_utilization_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this node statistics
func (m *NodeStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nodeStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nodeStatisticsTypeStatusPropEnum = append(nodeStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NodeStatisticsStatusOk captures enum value "ok"
	NodeStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// NodeStatisticsStatusError captures enum value "error"
	NodeStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NodeStatisticsStatusPartialNoData captures enum value "partial_no_data"
	NodeStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NodeStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NodeStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NodeStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	NodeStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NodeStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	NodeStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NodeStatisticsStatusNegativeDelta captures enum value "negative_delta"
	NodeStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NodeStatisticsStatusBackfilledData captures enum value "backfilled_data"
	NodeStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NodeStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NodeStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// node_statistics
	// NodeStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NodeStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NodeStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *NodeStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nodeStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NodeStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NodeStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node statistics based on context it is used
func (m *NodeStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeStatistics) UnmarshalBinary(b []byte) error {
	var res NodeStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
