// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NtpKey ntp key
//
// swagger:model ntp_key
type NtpKey struct {

	// links
	Links *NtpKeyInlineLinks `json:"_links,omitempty"`

	// The type of cryptographic hash used to create and verify the NTP's message authentication code appended to each NTP packet header.
	//
	// Example: sha1
	// Enum: ["sha1"]
	DigestType *string `json:"digest_type,omitempty"`

	// NTP symmetric authentication key identifier or index number (ID). This ID is included
	// in the NTP cryptographic hash encoded header.
	//
	// Example: 10
	// Maximum: 65535
	// Minimum: 1
	ID *int64 `json:"id,omitempty"`

	// A hexadecimal digit string that represents the cryptographic key that is shared with the remote NTP server.
	// The current expected length is 40 characters.
	// </br>
	// Use the cryptographic key and key ID to create a unique hash value used to authenticate the rest of the NTP data.
	//
	// Example: da39a3ee5e6b4b0d3255bfef95601890afd80709
	Value *string `json:"value,omitempty"`
}

// Validate validates this ntp key
func (m *NtpKey) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDigestType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NtpKey) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var ntpKeyTypeDigestTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha1"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ntpKeyTypeDigestTypePropEnum = append(ntpKeyTypeDigestTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ntp_key
	// NtpKey
	// digest_type
	// DigestType
	// sha1
	// END DEBUGGING
	// NtpKeyDigestTypeSha1 captures enum value "sha1"
	NtpKeyDigestTypeSha1 string = "sha1"
)

// prop value enum
func (m *NtpKey) validateDigestTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ntpKeyTypeDigestTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NtpKey) validateDigestType(formats strfmt.Registry) error {
	if swag.IsZero(m.DigestType) { // not required
		return nil
	}

	// value enum
	if err := m.validateDigestTypeEnum("digest_type", "body", *m.DigestType); err != nil {
		return err
	}

	return nil
}

func (m *NtpKey) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.MinimumInt("id", "body", *m.ID, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("id", "body", *m.ID, 65535, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ntp key based on the context it is used
func (m *NtpKey) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NtpKey) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NtpKey) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NtpKey) UnmarshalBinary(b []byte) error {
	var res NtpKey
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NtpKeyInlineLinks ntp key inline links
//
// swagger:model ntp_key_inline__links
type NtpKeyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ntp key inline links
func (m *NtpKeyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NtpKeyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ntp key inline links based on the context it is used
func (m *NtpKeyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NtpKeyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NtpKeyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NtpKeyInlineLinks) UnmarshalBinary(b []byte) error {
	var res NtpKeyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
