// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NtpServer ntp server
//
// swagger:model ntp_server
type NtpServer struct {

	// links
	Links *NtpServerInlineLinks `json:"_links,omitempty"`

	// Set NTP symmetric authentication on (true) or off (false).
	// Example: true
	AuthenticationEnabled *bool `json:"authentication_enabled,omitempty"`

	// key
	Key *NtpKeyReference `json:"key,omitempty"`

	// NTP server host name, IPv4, or IPv6 address.
	// Example: time.nist.gov
	Server *string `json:"server,omitempty"`

	// NTP protocol version for server. Valid versions are 3, 4, or auto.
	// Example: auto
	// Enum: ["3","4","auto"]
	Version *string `json:"version,omitempty"`
}

// Validate validates this ntp server
func (m *NtpServer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NtpServer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NtpServer) validateKey(formats strfmt.Registry) error {
	if swag.IsZero(m.Key) { // not required
		return nil
	}

	if m.Key != nil {
		if err := m.Key.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("key")
			}
			return err
		}
	}

	return nil
}

var ntpServerTypeVersionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["3","4","auto"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ntpServerTypeVersionPropEnum = append(ntpServerTypeVersionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ntp_server
	// NtpServer
	// version
	// Version
	// 3
	// END DEBUGGING
	// NtpServerVersionNr3 captures enum value "3"
	NtpServerVersionNr3 string = "3"

	// BEGIN DEBUGGING
	// ntp_server
	// NtpServer
	// version
	// Version
	// 4
	// END DEBUGGING
	// NtpServerVersionNr4 captures enum value "4"
	NtpServerVersionNr4 string = "4"

	// BEGIN DEBUGGING
	// ntp_server
	// NtpServer
	// version
	// Version
	// auto
	// END DEBUGGING
	// NtpServerVersionAuto captures enum value "auto"
	NtpServerVersionAuto string = "auto"
)

// prop value enum
func (m *NtpServer) validateVersionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ntpServerTypeVersionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NtpServer) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	// value enum
	if err := m.validateVersionEnum("version", "body", *m.Version); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ntp server based on the context it is used
func (m *NtpServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKey(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NtpServer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NtpServer) contextValidateKey(ctx context.Context, formats strfmt.Registry) error {

	if m.Key != nil {
		if err := m.Key.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("key")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NtpServer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NtpServer) UnmarshalBinary(b []byte) error {
	var res NtpServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NtpServerInlineLinks ntp server inline links
//
// swagger:model ntp_server_inline__links
type NtpServerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this ntp server inline links
func (m *NtpServerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NtpServerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ntp server inline links based on the context it is used
func (m *NtpServerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NtpServerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NtpServerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NtpServerInlineLinks) UnmarshalBinary(b []byte) error {
	var res NtpServerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
