// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeInterface NVMe interfaces are network interfaces configured to support an NVMe over Fabrics (NVMe-oF) protocol. The NVMe interfaces are Fibre Channel interfaces supporting an NVMe-oF data protocol. Regardless of the underlying physical and data protocol, NVMe interfaces are treated equally for host-side application configuration. This endpoint provides a consolidated view of all NVMe interfaces for the purpose of configuring host-side applications.<br/>
// NVMe interfaces must be created using the protocol-specific endpoints for Fibre Channel interfaces. See [`POST /network/fc/interfaces`](#/networking/fc_interface_create). After creation, the interfaces are available via this interface.
//
// swagger:model nvme_interface
type NvmeInterface struct {

	// links
	Links *NvmeInterfaceInlineLinks `json:"_links,omitempty"`

	// The administrative state of the NVMe interface.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// fc interface
	FcInterface *NvmeInterfaceInlineFcInterface `json:"fc_interface,omitempty"`

	// The underlying interface type of the NVMe interface. This property identifies which of _fc_interface_ and _ip_interface_ will be further populated.
	//
	// Read Only: true
	// Enum: ["fc_interface","ip_interface"]
	InterfaceType *string `json:"interface_type,omitempty"`

	// ip interface
	IPInterface *NvmeInterfaceInlineIPInterface `json:"ip_interface,omitempty"`

	// The name of the NVMe interface.
	//
	// Example: lif1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *NvmeInterfaceInlineNode `json:"node,omitempty"`

	// svm
	Svm *NvmeInterfaceInlineSvm `json:"svm,omitempty"`

	// The transport address of the NVMe interface.
	//
	// Example: nn-0x200a00a0989062da:pn-0x200100a0989062da
	// Read Only: true
	TransportAddress *string `json:"transport_address,omitempty"`

	// The transport protocols supported by the NVMe interface.
	//
	TransportProtocols []*string `json:"transport_protocols,omitempty"`

	// The unique identifier of the NVMe interface.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme interface
func (m *NvmeInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFcInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterfaceType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransportProtocols(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterface) validateFcInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.FcInterface) { // not required
		return nil
	}

	if m.FcInterface != nil {
		if err := m.FcInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface")
			}
			return err
		}
	}

	return nil
}

var nvmeInterfaceTypeInterfaceTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc_interface","ip_interface"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeInterfaceTypeInterfaceTypePropEnum = append(nvmeInterfaceTypeInterfaceTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_interface
	// NvmeInterface
	// interface_type
	// InterfaceType
	// fc_interface
	// END DEBUGGING
	// NvmeInterfaceInterfaceTypeFcInterface captures enum value "fc_interface"
	NvmeInterfaceInterfaceTypeFcInterface string = "fc_interface"

	// BEGIN DEBUGGING
	// nvme_interface
	// NvmeInterface
	// interface_type
	// InterfaceType
	// ip_interface
	// END DEBUGGING
	// NvmeInterfaceInterfaceTypeIPInterface captures enum value "ip_interface"
	NvmeInterfaceInterfaceTypeIPInterface string = "ip_interface"
)

// prop value enum
func (m *NvmeInterface) validateInterfaceTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeInterfaceTypeInterfaceTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeInterface) validateInterfaceType(formats strfmt.Registry) error {
	if swag.IsZero(m.InterfaceType) { // not required
		return nil
	}

	// value enum
	if err := m.validateInterfaceTypeEnum("interface_type", "body", *m.InterfaceType); err != nil {
		return err
	}

	return nil
}

func (m *NvmeInterface) validateIPInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPInterface) { // not required
		return nil
	}

	if m.IPInterface != nil {
		if err := m.IPInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterface) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterface) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var nvmeInterfaceTransportProtocolsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc_nvme","nvme_tcp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeInterfaceTransportProtocolsItemsEnum = append(nvmeInterfaceTransportProtocolsItemsEnum, v)
	}
}

func (m *NvmeInterface) validateTransportProtocolsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeInterfaceTransportProtocolsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeInterface) validateTransportProtocols(formats strfmt.Registry) error {
	if swag.IsZero(m.TransportProtocols) { // not required
		return nil
	}

	for i := 0; i < len(m.TransportProtocols); i++ {
		if swag.IsZero(m.TransportProtocols[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateTransportProtocolsItemsEnum("transport_protocols"+"."+strconv.Itoa(i), "body", *m.TransportProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

// ContextValidate validate this nvme interface based on the context it is used
func (m *NvmeInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFcInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterfaceType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransportAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransportProtocols(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterface) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *NvmeInterface) contextValidateFcInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.FcInterface != nil {
		if err := m.FcInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterface) contextValidateInterfaceType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface_type", "body", m.InterfaceType); err != nil {
		return err
	}

	return nil
}

func (m *NvmeInterface) contextValidateIPInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPInterface != nil {
		if err := m.IPInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterface) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *NvmeInterface) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterface) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterface) contextValidateTransportAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "transport_address", "body", m.TransportAddress); err != nil {
		return err
	}

	return nil
}

func (m *NvmeInterface) contextValidateTransportProtocols(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TransportProtocols); i++ {

		if err := validate.ReadOnly(ctx, "transport_protocols"+"."+strconv.Itoa(i), "body", m.TransportProtocols[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *NvmeInterface) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterface) UnmarshalBinary(b []byte) error {
	var res NvmeInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineFcInterface The attributes specific to a Fibre Channel-based NVMe interface.<br/>
// This is populated when `interface_type` is _fc_interface_.
//
// swagger:model nvme_interface_inline_fc_interface
type NvmeInterfaceInlineFcInterface struct {

	// links
	Links *NvmeInterfaceInlineFcInterfaceInlineLinks `json:"_links,omitempty"`

	// port
	Port *NvmeInterfaceInlineFcInterfaceInlinePort `json:"port,omitempty"`

	// The WWNN (world wide node name) of the Fibre Channel NVMe interface.
	//
	// Example: 20:00:00:50:56:b4:13:a9
	// Read Only: true
	Wwnn *string `json:"wwnn,omitempty"`

	// The WWPN (world wide port name) of the Fibre Channel NVMe interface.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this nvme interface inline fc interface
func (m *NvmeInterfaceInlineFcInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineFcInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineFcInterface) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if m.Port != nil {
		if err := m.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline fc interface based on the context it is used
func (m *NvmeInterfaceInlineFcInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwnn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineFcInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineFcInterface) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if m.Port != nil {
		if err := m.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "port")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineFcInterface) contextValidateWwnn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc_interface"+"."+"wwnn", "body", m.Wwnn); err != nil {
		return err
	}

	return nil
}

func (m *NvmeInterfaceInlineFcInterface) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc_interface"+"."+"wwpn", "body", m.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterface) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineFcInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineFcInterfaceInlineLinks nvme interface inline fc interface inline links
//
// swagger:model nvme_interface_inline_fc_interface_inline__links
type NvmeInterfaceInlineFcInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme interface inline fc interface inline links
func (m *NvmeInterfaceInlineFcInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineFcInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline fc interface inline links based on the context it is used
func (m *NvmeInterfaceInlineFcInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineFcInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineFcInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineFcInterfaceInlinePort An FC port is the physical port of an FC adapter on a cluster node that can be connected to an FC network.
//
// swagger:model nvme_interface_inline_fc_interface_inline_port
type NvmeInterfaceInlineFcInterfaceInlinePort struct {

	// links
	Links *NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks `json:"_links,omitempty"`

	// The name of the FC port.
	//
	// Example: 0a
	Name *string `json:"name,omitempty"`

	// node
	Node *NvmeInterfaceInlineFcInterfaceInlinePortInlineNode `json:"node,omitempty"`

	// The unique identifier of the FC port.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme interface inline fc interface inline port
func (m *NvmeInterfaceInlineFcInterfaceInlinePort) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineFcInterfaceInlinePort) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineFcInterfaceInlinePort) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline fc interface inline port based on the context it is used
func (m *NvmeInterfaceInlineFcInterfaceInlinePort) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineFcInterfaceInlinePort) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "port" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineFcInterfaceInlinePort) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "port" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterfaceInlinePort) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterfaceInlinePort) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineFcInterfaceInlinePort
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks nvme interface inline fc interface inline port inline links
//
// swagger:model nvme_interface_inline_fc_interface_inline_port_inline__links
type NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme interface inline fc interface inline port inline links
func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline fc interface inline port inline links based on the context it is used
func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc_interface" + "." + "port" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineFcInterfaceInlinePortInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineFcInterfaceInlinePortInlineNode The node on which the FC port is located.
//
// swagger:model nvme_interface_inline_fc_interface_inline_port_inline_node
type NvmeInterfaceInlineFcInterfaceInlinePortInlineNode struct {

	// The name of the node on which the FC port is located.
	//
	// Example: node1
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme interface inline fc interface inline port inline node
func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme interface inline fc interface inline port inline node based on context it is used
func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineFcInterfaceInlinePortInlineNode) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineFcInterfaceInlinePortInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineIPInterface The attributes specific to an IP-based NVMe interface.<br/>
// This is populated when `interface_type` is _ip_interface_.
//
// swagger:model nvme_interface_inline_ip_interface
type NvmeInterfaceInlineIPInterface struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// ip
	IP *NvmeInterfaceInlineIPInterfaceInlineIP `json:"ip,omitempty"`

	// location
	Location *NvmeInterfaceInlineIPInterfaceInlineLocation `json:"location,omitempty"`
}

// Validate validates this nvme interface inline ip interface
func (m *NvmeInterfaceInlineIPInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineIPInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineIPInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineIPInterface) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline ip interface based on the context it is used
func (m *NvmeInterfaceInlineIPInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineIPInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineIPInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeInterfaceInlineIPInterface) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineIPInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineIPInterface) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineIPInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineIPInterfaceInlineIP nvme interface inline ip interface inline ip
//
// swagger:model nvme_interface_inline_ip_interface_inline_ip
type NvmeInterfaceInlineIPInterfaceInlineIP struct {

	// address
	// Read Only: true
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this nvme interface inline ip interface inline ip
func (m *NvmeInterfaceInlineIPInterfaceInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineIPInterfaceInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline ip interface inline ip based on the context it is used
func (m *NvmeInterfaceInlineIPInterfaceInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineIPInterfaceInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineIPInterfaceInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineIPInterfaceInlineIP) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineIPInterfaceInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineIPInterfaceInlineLocation nvme interface inline ip interface inline location
//
// swagger:model nvme_interface_inline_ip_interface_inline_location
type NvmeInterfaceInlineIPInterfaceInlineLocation struct {

	// port
	// Read Only: true
	Port *PortReference `json:"port,omitempty"`
}

// Validate validates this nvme interface inline ip interface inline location
func (m *NvmeInterfaceInlineIPInterfaceInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineIPInterfaceInlineLocation) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if m.Port != nil {
		if err := m.Port.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline ip interface inline location based on the context it is used
func (m *NvmeInterfaceInlineIPInterfaceInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineIPInterfaceInlineLocation) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if m.Port != nil {
		if err := m.Port.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_interface" + "." + "location" + "." + "port")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineIPInterfaceInlineLocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineIPInterfaceInlineLocation) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineIPInterfaceInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineLinks nvme interface inline links
//
// swagger:model nvme_interface_inline__links
type NvmeInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme interface inline links
func (m *NvmeInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline links based on the context it is used
func (m *NvmeInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineNode nvme interface inline node
//
// swagger:model nvme_interface_inline_node
type NvmeInterfaceInlineNode struct {

	// links
	Links *NvmeInterfaceInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme interface inline node
func (m *NvmeInterfaceInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline node based on the context it is used
func (m *NvmeInterfaceInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineNode) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineNodeInlineLinks nvme interface inline node inline links
//
// swagger:model nvme_interface_inline_node_inline__links
type NvmeInterfaceInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme interface inline node inline links
func (m *NvmeInterfaceInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline node inline links based on the context it is used
func (m *NvmeInterfaceInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model nvme_interface_inline_svm
type NvmeInterfaceInlineSvm struct {

	// links
	Links *NvmeInterfaceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme interface inline svm
func (m *NvmeInterfaceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline svm based on the context it is used
func (m *NvmeInterfaceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeInterfaceInlineSvmInlineLinks nvme interface inline svm inline links
//
// swagger:model nvme_interface_inline_svm_inline__links
type NvmeInterfaceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme interface inline svm inline links
func (m *NvmeInterfaceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme interface inline svm inline links based on the context it is used
func (m *NvmeInterfaceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeInterfaceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeInterfaceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeInterfaceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeInterfaceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
