// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeNamespace An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
// swagger:model nvme_namespace
type NvmeNamespace struct {

	// links
	Links *NvmeNamespaceInlineLinks `json:"_links,omitempty"`

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// clone
	Clone *NvmeNamespaceInlineClone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// consistency group
	ConsistencyGroup *NvmeNamespaceInlineConsistencyGroup `json:"consistency_group,omitempty"`

	// convert
	Convert *NvmeNamespaceInlineConvert `json:"convert,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// encryption
	Encryption *StorageUnitEncryption `json:"encryption,omitempty"`

	// location
	Location *NvmeNamespaceInlineLocation `json:"location,omitempty"`

	// metric
	Metric *NvmeNamespaceInlineMetric `json:"metric,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *NvmeNamespaceInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos policy
	QosPolicy *NvmeNamespaceInlineQosPolicy `json:"qos_policy,omitempty"`

	// space
	Space *NvmeNamespaceInlineSpace `json:"space,omitempty"`

	// statistics
	Statistics *NvmeNamespaceInlineStatistics `json:"statistics,omitempty"`

	// status
	Status *NvmeNamespaceInlineStatus `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *NvmeNamespaceInlineSubsystemMap `json:"subsystem_map,omitempty"`

	// svm
	Svm *NvmeNamespaceInlineSvm `json:"svm,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace
func (m *NvmeNamespace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConvert(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(m.Clone) { // not required
		return nil
	}

	if m.Clone != nil {
		if err := m.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespace) validateConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroup) { // not required
		return nil
	}

	if m.ConsistencyGroup != nil {
		if err := m.ConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateConvert(formats strfmt.Registry) error {
	if swag.IsZero(m.Convert) { // not required
		return nil
	}

	if m.Convert != nil {
		if err := m.Convert.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("convert")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespace) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	if m.Encryption != nil {
		if err := m.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceTypeOsTypePropEnum = append(nvmeNamespaceTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace
	// NvmeNamespace
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// NvmeNamespaceOsTypeAix captures enum value "aix"
	NvmeNamespaceOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// nvme_namespace
	// NvmeNamespace
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// NvmeNamespaceOsTypeLinux captures enum value "linux"
	NvmeNamespaceOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// nvme_namespace
	// NvmeNamespace
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// NvmeNamespaceOsTypeVmware captures enum value "vmware"
	NvmeNamespaceOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// nvme_namespace
	// NvmeNamespace
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// NvmeNamespaceOsTypeWindows captures enum value "windows"
	NvmeNamespaceOsTypeWindows string = "windows"
)

// prop value enum
func (m *NvmeNamespace) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespace) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespace) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(m.SubsystemMap) { // not required
		return nil
	}

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace based on the context it is used
func (m *NvmeNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConvert(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if m.Clone != nil {
		if err := m.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ConsistencyGroup != nil {
		if err := m.ConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateConvert(ctx context.Context, formats strfmt.Registry) error {

	if m.Convert != nil {
		if err := m.Convert.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("convert")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespace) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespace) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.Encryption != nil {
		if err := m.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespace) UnmarshalBinary(b []byte) error {
	var res NvmeNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineClone <personalities supports=unified>This sub-object is used in POST to create a new NVMe namespace as a clone of an existing namespace, or PATCH to overwrite an existing namespace as a clone of another. Setting a property in this sub-object indicates that a namespace clone is desired.<br/>
// When used in a PATCH, the patched NVMe namespace's data is over-written as a clone of the source and the following properties are preserved from the patched namespace unless otherwise specified as part of the PATCH: `auto_delete` (unless specified in the request), `subsystem_map`, `status.state`, and `uuid`.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning NVMe namespaces.</personalities>
//
// swagger:model nvme_namespace_inline_clone
type NvmeNamespaceInlineClone struct {

	// source
	Source *NvmeNamespaceInlineCloneInlineSource `json:"source,omitempty"`
}

// Validate validates this nvme namespace inline clone
func (m *NvmeNamespaceInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineClone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline clone based on the context it is used
func (m *NvmeNamespaceInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineClone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineClone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineClone) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineCloneInlineSource The source NVMe namespace for a namespace clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same namespace.<br/>
// Valid in POST to create a new NVMe namespace as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing NVMe namespace's data as a clone of another.
//
// swagger:model nvme_namespace_inline_clone_inline_source
type NvmeNamespaceInlineCloneInlineSource struct {

	// The name of the clone source NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning NVMe namespaces.</personalities>
	//
	// Example: /vol/volume1/namespace1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source NVMe namespace.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning NVMe namespaces.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline clone inline source
func (m *NvmeNamespaceInlineCloneInlineSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme namespace inline clone inline source based on context it is used
func (m *NvmeNamespaceInlineCloneInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineCloneInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineCloneInlineSource) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineCloneInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineConsistencyGroup The namespace's consistency group. This property is populated for namespaces that are members of a consistency group. If the namespace is a member of a child consistency group, the parent consistency group is reported.
// <personalities supports=unified>A namespace's consistency group is the consistency group of its containing volume.</personalities>
// <personalities supports=asar2>A namespace is optionally associated directly with a consistency group.</personalities>
//
// swagger:model nvme_namespace_inline_consistency_group
type NvmeNamespaceInlineConsistencyGroup struct {

	// links
	Links *NvmeNamespaceInlineConsistencyGroupInlineLinks `json:"_links,omitempty"`

	// The name of the consistency group.
	//
	// Example: cg1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	//
	// Example: 4abc2317-4332-9d37-93a0-20bd29c22df0
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline consistency group
func (m *NvmeNamespaceInlineConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline consistency group based on the context it is used
func (m *NvmeNamespaceInlineConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineConsistencyGroup) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "consistency_group"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineConsistencyGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "consistency_group"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineConsistencyGroupInlineLinks nvme namespace inline consistency group inline links
//
// swagger:model nvme_namespace_inline_consistency_group_inline__links
type NvmeNamespaceInlineConsistencyGroupInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline consistency group inline links
func (m *NvmeNamespaceInlineConsistencyGroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineConsistencyGroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline consistency group inline links based on the context it is used
func (m *NvmeNamespaceInlineConsistencyGroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineConsistencyGroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("consistency_group" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineConsistencyGroupInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineConsistencyGroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineConsistencyGroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineConvert This sub-object is used in POST to convert a valid in-place LUN to an NVMe namespace. Setting a property in this sub-object indicates that a conversion from the specified LUN to NVMe namespace is desired.<br/>
//
// swagger:model nvme_namespace_inline_convert
type NvmeNamespaceInlineConvert struct {

	// lun
	Lun *NvmeNamespaceInlineConvertInlineLun `json:"lun,omitempty"`
}

// Validate validates this nvme namespace inline convert
func (m *NvmeNamespaceInlineConvert) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLun(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineConvert) validateLun(formats strfmt.Registry) error {
	if swag.IsZero(m.Lun) { // not required
		return nil
	}

	if m.Lun != nil {
		if err := m.Lun.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("convert" + "." + "lun")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline convert based on the context it is used
func (m *NvmeNamespaceInlineConvert) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineConvert) contextValidateLun(ctx context.Context, formats strfmt.Registry) error {

	if m.Lun != nil {
		if err := m.Lun.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("convert" + "." + "lun")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineConvert) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineConvert) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineConvert
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineConvertInlineLun The source LUN for convert operation. This can be specified using property `convert.lun.uuid` or `convert.lun.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST. A convert request from LUN to NVMe namespace cannot be combined with setting any other namespace properties. All other properties of the converted NVMe namespace come from the source LUN.<br/>
//
// swagger:model nvme_namespace_inline_convert_inline_lun
type NvmeNamespaceInlineConvertInlineLun struct {

	// The name of the source LUN. Valid in POST.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.</personalities>
	// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the source LUN. Valid in POST.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline convert inline lun
func (m *NvmeNamespaceInlineConvertInlineLun) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme namespace inline convert inline lun based on context it is used
func (m *NvmeNamespaceInlineConvertInlineLun) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineConvertInlineLun) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineConvertInlineLun) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineConvertInlineLun
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLinks nvme namespace inline links
//
// swagger:model nvme_namespace_inline__links
type NvmeNamespaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline links
func (m *NvmeNamespaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline links based on the context it is used
func (m *NvmeNamespaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocation The location of the NVMe namespace within the ONTAP cluster.
// <personalities supports=unified>NVMe namespaces do not support rename, or movement between volumes. Valid in POST.</personalities>
// <personalities supports=asar2>The NVMe namespace name can be changed by PATCHing the `name` property. The `location` properties are read-only.</personalities>
//
// swagger:model nvme_namespace_inline_location
type NvmeNamespaceInlineLocation struct {

	// <personalities supports=unified>The base name component of the NVMe namespace. Valid in POST.<br/>
	// If properties `name` and `location.namespace` are specified in the same request, they must refer to the base name.<br/>
	// NVMe namespaces do not support rename.</personalities>
	// <personalities supports=asar2>The namespace property is read-only and cannot be set in POST or PATCH. Use the `name` property for POST and PATCH.</personalities>
	//
	// Example: namespace1
	Namespace *string `json:"namespace,omitempty"`

	// node
	Node *NvmeNamespaceInlineLocationInlineNode `json:"node,omitempty"`

	// qtree
	Qtree *NvmeNamespaceInlineLocationInlineQtree `json:"qtree,omitempty"`

	// storage availability zone
	StorageAvailabilityZone *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone `json:"storage_availability_zone,omitempty"`

	// volume
	Volume *NvmeNamespaceInlineLocationInlineVolume `json:"volume,omitempty"`
}

// Validate validates this nvme namespace inline location
func (m *NvmeNamespaceInlineLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQtree(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageAvailabilityZone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocation) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineLocation) validateQtree(formats strfmt.Registry) error {
	if swag.IsZero(m.Qtree) { // not required
		return nil
	}

	if m.Qtree != nil {
		if err := m.Qtree.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineLocation) validateStorageAvailabilityZone(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZone) { // not required
		return nil
	}

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineLocation) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location based on the context it is used
func (m *NvmeNamespaceInlineLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQtree(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageAvailabilityZone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocation) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineLocation) contextValidateQtree(ctx context.Context, formats strfmt.Registry) error {

	if m.Qtree != nil {
		if err := m.Qtree.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineLocation) contextValidateStorageAvailabilityZone(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageAvailabilityZone != nil {
		if err := m.StorageAvailabilityZone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineLocation) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocation) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocationInlineNode The cluster node that hosts the NVMe namespace.
//
// swagger:model nvme_namespace_inline_location_inline_node
type NvmeNamespaceInlineLocationInlineNode struct {

	// links
	Links *NvmeNamespaceInlineLocationInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline location inline node
func (m *NvmeNamespaceInlineLocationInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline node based on the context it is used
func (m *NvmeNamespaceInlineLocationInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineNode) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocationInlineNodeInlineLinks nvme namespace inline location inline node inline links
//
// swagger:model nvme_namespace_inline_location_inline_node_inline__links
type NvmeNamespaceInlineLocationInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline location inline node inline links
func (m *NvmeNamespaceInlineLocationInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline node inline links based on the context it is used
func (m *NvmeNamespaceInlineLocationInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocationInlineQtree <personalities supports=unified>The qtree in which the NVMe namespace is optionally located. Valid in POST.<br/>
// If properties `name` and `location.qtree.name` and/or `location.qtree.uuid` are specified in the same request, they must refer to the same qtree.<br/>
// NVMe namespaces do not support rename.</personalities>
// <personalities supports=asar2>Qtrees are not supported. The properties of the qtree sub-object cannot be set in POST or PATCH.</personalities>
//
// swagger:model nvme_namespace_inline_location_inline_qtree
type NvmeNamespaceInlineLocationInlineQtree struct {

	// links
	Links *NvmeNamespaceInlineLocationInlineQtreeInlineLinks `json:"_links,omitempty"`

	// The identifier for the qtree, unique within the qtree's volume.
	//
	// Example: 1
	// Maximum: 4994
	// Minimum: 0
	ID *int64 `json:"id,omitempty"`

	// The name of the qtree.
	// Example: qt1
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme namespace inline location inline qtree
func (m *NvmeNamespaceInlineLocationInlineQtree) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineQtree) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineLocationInlineQtree) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.MinimumInt("location"+"."+"qtree"+"."+"id", "body", *m.ID, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("location"+"."+"qtree"+"."+"id", "body", *m.ID, 4994, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline qtree based on the context it is used
func (m *NvmeNamespaceInlineLocationInlineQtree) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineQtree) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineQtree) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineQtree) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineQtree
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocationInlineQtreeInlineLinks nvme namespace inline location inline qtree inline links
//
// swagger:model nvme_namespace_inline_location_inline_qtree_inline__links
type NvmeNamespaceInlineLocationInlineQtreeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline location inline qtree inline links
func (m *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline qtree inline links based on the context it is used
func (m *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "qtree" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineQtreeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineQtreeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocationInlineStorageAvailabilityZone The storage availability zone that contains the NVMe namespace.
//
// swagger:model nvme_namespace_inline_location_inline_storage_availability_zone
type NvmeNamespaceInlineLocationInlineStorageAvailabilityZone struct {

	// links
	Links *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks `json:"_links,omitempty"`

	// The name of the storage availability zone.
	// Example: storage_availability_zone_1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the storage availability zone.
	// Example: 9b3ff559-3333-11ef-b420-005056ae6060
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline location inline storage availability zone
func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline storage availability zone based on the context it is used
func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZone) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineStorageAvailabilityZone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks nvme namespace inline location inline storage availability zone inline links
//
// swagger:model nvme_namespace_inline_location_inline_storage_availability_zone_inline__links
type NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline location inline storage availability zone inline links
func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline storage availability zone inline links based on the context it is used
func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "storage_availability_zone" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineStorageAvailabilityZoneInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocationInlineVolume <personalities supports=unified>The volume in which the NVMe namespace is located. Valid in POST.<br/>
// If properties `name` and `location.volume.name` and/or `location.volume.uuid` are specified in the same request, they must refer to the same volume.<br/>
// NVMe namespaces do not support movement between volumes.</personalities>
// <personalities supports=asar2>The volume sub-object is read-only and its properties cannot be set in POST or PATCH. Use the `name` property for POST.</personalities>
//
// swagger:model nvme_namespace_inline_location_inline_volume
type NvmeNamespaceInlineLocationInlineVolume struct {

	// links
	Links *NvmeNamespaceInlineLocationInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline location inline volume
func (m *NvmeNamespaceInlineLocationInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline volume based on the context it is used
func (m *NvmeNamespaceInlineLocationInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineVolume) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineLocationInlineVolumeInlineLinks nvme namespace inline location inline volume inline links
//
// swagger:model nvme_namespace_inline_location_inline_volume_inline__links
type NvmeNamespaceInlineLocationInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline location inline volume inline links
func (m *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline location inline volume inline links based on the context it is used
func (m *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineLocationInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineLocationInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineMetric Performance numbers, such as IOPS latency and throughput
//
// swagger:model nvme_namespace_inline_metric
type NvmeNamespaceInlineMetric struct {

	// links
	Links *NvmeNamespaceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NvmeNamespaceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeNamespaceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NvmeNamespaceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme namespace inline metric
func (m *NvmeNamespaceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineMetricTypeDurationPropEnum = append(nvmeNamespaceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT15S captures enum value "PT15S"
	NvmeNamespaceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT4M captures enum value "PT4M"
	NvmeNamespaceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT30M captures enum value "PT30M"
	NvmeNamespaceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT2H captures enum value "PT2H"
	NvmeNamespaceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationP1D captures enum value "P1D"
	NvmeNamespaceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeNamespaceInlineMetricDurationPT5M captures enum value "PT5M"
	NvmeNamespaceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *NvmeNamespaceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineMetricTypeStatusPropEnum = append(nvmeNamespaceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusOk captures enum value "ok"
	NvmeNamespaceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusError captures enum value "error"
	NvmeNamespaceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	NvmeNamespaceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeNamespaceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	NvmeNamespaceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	NvmeNamespaceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusNotFound captures enum value "not_found"
	NvmeNamespaceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	NvmeNamespaceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeNamespaceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeNamespaceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_metric
	// NvmeNamespaceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeNamespaceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeNamespaceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeNamespaceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline metric based on the context it is used
func (m *NvmeNamespaceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetric) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nvme_namespace_inline_metric_inline_iops
type NvmeNamespaceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline metric inline iops
func (m *NvmeNamespaceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline metric inline iops based on the context it is used
func (m *NvmeNamespaceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nvme_namespace_inline_metric_inline_latency
type NvmeNamespaceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline metric inline latency
func (m *NvmeNamespaceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline metric inline latency based on the context it is used
func (m *NvmeNamespaceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineMetricInlineLinks nvme namespace inline metric inline links
//
// swagger:model nvme_namespace_inline_metric_inline__links
type NvmeNamespaceInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline metric inline links
func (m *NvmeNamespaceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline metric inline links based on the context it is used
func (m *NvmeNamespaceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nvme_namespace_inline_metric_inline_throughput
type NvmeNamespaceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline metric inline throughput
func (m *NvmeNamespaceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline metric inline throughput based on the context it is used
func (m *NvmeNamespaceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model nvme_namespace_inline_provisioning_options
type NvmeNamespaceInlineProvisioningOptions struct {

	// If the volume specified in the request does not exist, automatically provision one of appropriate size. If the volume does exist, resize it to accommodate the new namespace.<br/>
	// This property is only supported on Unified ONTAP.<br/>
	// The following behavior is different from a traditional POST request:
	// * The operation is asynchronous.
	// * The `qos_policy` property is supported and is applied to the provisioned volume. A default QoS policy is applied to the volume if one is not provided.
	// * The `provisioning_options.count` property is supported, provisioning _count_ namespaces on the volume using the specified properties.
	// * The `subsystem_map` property is supported. If the specified subsystem does not exist, it is created. The namespace is mapped to this subsystem. If a subsystem is provisioned in this way, it is deleted after it is no longer mapped to any namespaces.
	// * The `clone` and `convert` properties are not supported.
	// * When performing `records` based operations, specifying this property in the query applies to the entire operation. Specifying it for an individual record within the request applies to only that record.
	// * Many other `provisioning_options` properties are supported to control the placement of the namespace and the properties of the volume containing the namespace.
	//
	Auto *bool `json:"auto,omitempty"`

	// The number of namespaces to provision with these properties. Only POST requests based on `space.size` are supported. When provided, the name is considered a prefix, and a suffix of the form __&lt;N&gt;_ is generated where N is the next available numeric index, starting with 1.
	// Maximum: 80
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// A list of aggregates to exclude when determining the placement of the volume. <br/>
	//
	// Max Items: 100
	// Min Items: 0
	ExcludeAggregates []*NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0 `json:"exclude_aggregates,omitempty"`

	// qos policy
	QosPolicy *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy `json:"qos_policy,omitempty"`

	// The snapshot policy for the volume provisioned to host the namespace. This property is only supported when the request provisions a new volume.
	//
	SnapshotPolicy *SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// storage service
	StorageService *NvmeNamespaceInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`

	// tiering
	Tiering *NvmeNamespaceInlineProvisioningOptionsInlineTiering `json:"tiering,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning the volume to host the namespace. Only mirrored aggregates are used if this parameter is set to _true_ and only unmirrored aggregates are used if this parameter is set to _false_. The default value is _true_ for a MetroCluster configuration and is _false_ for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`
}

// Validate validates this nvme namespace inline provisioning options
func (m *NvmeNamespaceInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(m.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("provisioning_options"+"."+"count", "body", *m.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("provisioning_options"+"."+"count", "body", *m.Count, 80, false); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) validateExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.ExcludeAggregates) { // not required
		return nil
	}

	iExcludeAggregatesSize := int64(len(m.ExcludeAggregates))

	if err := validate.MinItems("provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 100); err != nil {
		return err
	}

	for i := 0; i < len(m.ExcludeAggregates); i++ {
		if swag.IsZero(m.ExcludeAggregates[i]) { // not required
			continue
		}

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.QosPolicy) { // not required
		return nil
	}

	if m.QosPolicy != nil {
		if err := m.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline provisioning options based on the context it is used
func (m *NvmeNamespaceInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) contextValidateExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ExcludeAggregates); i++ {

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.QosPolicy != nil {
		if err := m.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptions) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "tiering")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0 nvme namespace provisioning options exclude aggregates items0
//
// swagger:model NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0
type NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0 struct {

	// The aggregate name.
	//
	// Example: aggr1
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme namespace provisioning options exclude aggregates items0
func (m *NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme namespace provisioning options exclude aggregates items0 based on context it is used
func (m *NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceProvisioningOptionsExcludeAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy The QoS policy for the volume provisioned to host the namespace. This property is only supported when the request provisions a new volume. If no `qos_policy` is provided, a policy is be set based on the `storage_service.name`, which defaults to the most performant service available.
//
// swagger:model nvme_namespace_inline_provisioning_options_inline_qos_policy
type NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline provisioning options inline qos policy
func (m *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline provisioning options inline qos policy based on the context it is used
func (m *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineProvisioningOptionsInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineProvisioningOptionsInlineStorageService Determines the placement of the namespace based on the value specified. Valid in POST.
//
// swagger:model nvme_namespace_inline_provisioning_options_inline_storage_service
type NvmeNamespaceInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme namespace inline provisioning options inline storage service
func (m *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(nvmeNamespaceInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_storage_service
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_storage_service
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_storage_service
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	NvmeNamespaceInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme namespace inline provisioning options inline storage service based on context it is used
func (m *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineProvisioningOptionsInlineTiering The tiering placement and policy definitions for the volume provisioned to host the namespace. This property is only supported when the request provisions a new volume.
//
// swagger:model nvme_namespace_inline_provisioning_options_inline_tiering
type NvmeNamespaceInlineProvisioningOptionsInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0 `json:"object_stores,omitempty"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this nvme namespace inline provisioning options inline tiering
func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceInlineProvisioningOptionsInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineProvisioningOptionsInlineTieringTypeControlPropEnum = append(nvmeNamespaceInlineProvisioningOptionsInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringControlAllowed captures enum value "allowed"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringControlBestEffort captures enum value "best_effort"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringControlDisallowed captures enum value "disallowed"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringControlRequired captures enum value "required"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineProvisioningOptionsInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("provisioning_options"+"."+"tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("provisioning_options"+"."+"tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("provisioning_options"+"."+"tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nvmeNamespaceInlineProvisioningOptionsInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineProvisioningOptionsInlineTieringTypePolicyPropEnum = append(nvmeNamespaceInlineProvisioningOptionsInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyAll captures enum value "all"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyAuto captures enum value "auto"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyBackup captures enum value "backup"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyNone captures enum value "none"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_provisioning_options_inline_tiering
	// NvmeNamespaceInlineProvisioningOptionsInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	NvmeNamespaceInlineProvisioningOptionsInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineProvisioningOptionsInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("provisioning_options"+"."+"tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline provisioning options inline tiering based on the context it is used
func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineProvisioningOptionsInlineTiering) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineProvisioningOptionsInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0 nvme namespace provisioning options tiering object stores items0
//
// swagger:model NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0
type NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this nvme namespace provisioning options tiering object stores items0
func (m *NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this nvme namespace provisioning options tiering object stores items0 based on context it is used
func (m *NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceProvisioningOptionsTieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineQosPolicy The QoS policy for the NVMe namespace. Both traditional and adaptive QoS policies are supported. If both property `qos_policy.uuid` and `qos_policy.name` are specified in the same request, they must refer to the same QoS policy. To remove the QoS policy from an NVMe namespace, leaving it with no QoS policy, set property `qos_policy.name` to an empty string ("") in a PATCH request. An NVMe namespace is optionally associated directly with a QoS policy. To remove the QoS policy, set it to `null` in a PATCH request. Valid in POST and PATCH.
//
// swagger:model nvme_namespace_inline_qos_policy
type NvmeNamespaceInlineQosPolicy struct {

	// links
	Links *NvmeNamespaceInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// The name of the QoS policy. To remove the QoS policy from an NVMe namespace, leaving it with no QoS policy, set this property to an empty string ("") in a PATCH request. Valid in POST and PATCH.
	//
	// Example: qos1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the QoS policy. Valid in POST and PATCH.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline qos policy
func (m *NvmeNamespaceInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline qos policy based on the context it is used
func (m *NvmeNamespaceInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineQosPolicyInlineLinks nvme namespace inline qos policy inline links
//
// swagger:model nvme_namespace_inline_qos_policy_inline__links
type NvmeNamespaceInlineQosPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline qos policy inline links
func (m *NvmeNamespaceInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline qos policy inline links based on the context it is used
func (m *NvmeNamespaceInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineSpace The storage space related properties of the NVMe namespace.
//
// swagger:model nvme_namespace_inline_space
type NvmeNamespaceInlineSpace struct {

	// The size of blocks in the namespace in bytes. The default for namespaces with an `os_type` of _vmware_ is _512_. All other namespaces default to _4096_.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// The storage efficiency ratio of the namespace without snapshots. (Logical Used / Used)
	// <personalities supports=unified>This property is not available on the namespace object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 2.5
	// Read Only: true
	EfficiencyRatio *float64 `json:"efficiency_ratio,omitempty"`

	// guarantee
	Guarantee *NvmeNamespaceInlineSpaceInlineGuarantee `json:"guarantee,omitempty"`

	// The number of bytes consumed on the disk by the namespace, excluding snapshots.
	// <personalities supports=unified>This property is not available on the namespace object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// The number of bytes consumed on the disk by the namespace's snapshots.
	// This property has been replaced by `space.snapshot.used`.
	// <personalities supports=unified>This property is not available on the namespace object in the REST API and is not reported for GET requests. See the containing volume object for this information.</personalities>
	// <personalities supports=asar2>Available for GET.</personalities>
	//
	// Example: 1073741824
	// Read Only: true
	PhysicalUsedBySnapshots *int64 `json:"physical_used_by_snapshots,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not be made smaller using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used and an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this nvme namespace inline space
func (m *NvmeNamespaceInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceInlineSpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineSpaceTypeBlockSizePropEnum = append(nvmeNamespaceInlineSpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (m *NvmeNamespaceInlineSpace) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineSpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineSpace) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateBlockSizeEnum("space"+"."+"block_size", "body", *m.BlockSize); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSpace) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline space based on the context it is used
func (m *NvmeNamespaceInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEfficiencyRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSpace) contextValidateEfficiencyRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"efficiency_ratio", "body", m.EfficiencyRatio); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSpace) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineSpace) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_used", "body", m.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSpace) contextValidatePhysicalUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"physical_used_by_snapshots", "body", m.PhysicalUsedBySnapshots); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineSpace) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineSpaceInlineGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
// swagger:model nvme_namespace_inline_space_inline_guarantee
type NvmeNamespaceInlineSpaceInlineGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	// Read Only: true
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this nvme namespace inline space inline guarantee
func (m *NvmeNamespaceInlineSpaceInlineGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline space inline guarantee based on the context it is used
func (m *NvmeNamespaceInlineSpaceInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRequested(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSpaceInlineGuarantee) contextValidateRequested(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"requested", "body", m.Requested); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSpaceInlineGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", m.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineSpaceInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineSpaceInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSpaceInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model nvme_namespace_inline_statistics
type NvmeNamespaceInlineStatistics struct {

	// iops raw
	IopsRaw *NvmeNamespaceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NvmeNamespaceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *NvmeNamespaceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme namespace inline statistics
func (m *NvmeNamespaceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineStatisticsTypeStatusPropEnum = append(nvmeNamespaceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusOk captures enum value "ok"
	NvmeNamespaceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusError captures enum value "error"
	NvmeNamespaceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	NvmeNamespaceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeNamespaceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	NvmeNamespaceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	NvmeNamespaceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusNotFound captures enum value "not_found"
	NvmeNamespaceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	NvmeNamespaceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeNamespaceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeNamespaceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_statistics
	// NvmeNamespaceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeNamespaceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeNamespaceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeNamespaceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline statistics based on the context it is used
func (m *NvmeNamespaceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nvme_namespace_inline_statistics_inline_iops_raw
type NvmeNamespaceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline statistics inline iops raw
func (m *NvmeNamespaceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline statistics inline iops raw based on the context it is used
func (m *NvmeNamespaceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nvme_namespace_inline_statistics_inline_latency_raw
type NvmeNamespaceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline statistics inline latency raw
func (m *NvmeNamespaceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline statistics inline latency raw based on the context it is used
func (m *NvmeNamespaceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nvme_namespace_inline_statistics_inline_throughput_raw
type NvmeNamespaceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme namespace inline statistics inline throughput raw
func (m *NvmeNamespaceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme namespace inline statistics inline throughput raw based on the context it is used
func (m *NvmeNamespaceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineStatus Status information about the NVMe namespace.
//
// swagger:model nvme_namespace_inline_status
type NvmeNamespaceInlineStatus struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Read Only: true
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	// Read Only: true
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Read Only: true
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this nvme namespace inline status
func (m *NvmeNamespaceInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceInlineStatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineStatusTypeContainerStatePropEnum = append(nvmeNamespaceInlineStatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// NvmeNamespaceInlineStatusContainerStateOnline captures enum value "online"
	NvmeNamespaceInlineStatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// NvmeNamespaceInlineStatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	NvmeNamespaceInlineStatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// NvmeNamespaceInlineStatusContainerStateVolumeOffline captures enum value "volume_offline"
	NvmeNamespaceInlineStatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (m *NvmeNamespaceInlineStatus) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineStatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineStatus) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := m.validateContainerStateEnum("status"+"."+"container_state", "body", *m.ContainerState); err != nil {
		return err
	}

	return nil
}

var nvmeNamespaceInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineStatusTypeStatePropEnum = append(nvmeNamespaceInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// state
	// State
	// nvfail
	// END DEBUGGING
	// NvmeNamespaceInlineStatusStateNvfail captures enum value "nvfail"
	NvmeNamespaceInlineStatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// state
	// State
	// offline
	// END DEBUGGING
	// NvmeNamespaceInlineStatusStateOffline captures enum value "offline"
	NvmeNamespaceInlineStatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// state
	// State
	// online
	// END DEBUGGING
	// NvmeNamespaceInlineStatusStateOnline captures enum value "online"
	NvmeNamespaceInlineStatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_status
	// NvmeNamespaceInlineStatus
	// state
	// State
	// space_error
	// END DEBUGGING
	// NvmeNamespaceInlineStatusStateSpaceError captures enum value "space_error"
	NvmeNamespaceInlineStatusStateSpaceError string = "space_error"
)

// prop value enum
func (m *NvmeNamespaceInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline status based on the context it is used
func (m *NvmeNamespaceInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContainerState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMapped(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReadOnly(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineStatus) contextValidateContainerState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"container_state", "body", m.ContainerState); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineStatus) contextValidateMapped(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"mapped", "body", m.Mapped); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineStatus) contextValidateReadOnly(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"read_only", "body", m.ReadOnly); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineStatus) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineStatus) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineSubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
// <personalities supports=unified>These properties are supported for GET and POST. During POST, it requires the `provisioning_options.auto` property to be set to true.
// See the `provisioning_options.auto` property for full details.</personalities>
// <personalities supports=asar2>These properties are supported for GET and POST. During POST, a new or existing subsystem can be referenced. When referencing an existing subsystem, only the `name` and `uuid` properties are supported.</personalities>
//
// swagger:model nvme_namespace_inline_subsystem_map
type NvmeNamespaceInlineSubsystemMap struct {

	// links
	Links *NvmeNamespaceInlineSubsystemMapInlineLinks `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// subsystem
	Subsystem *NvmeNamespaceInlineSubsystemMapInlineSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this nvme namespace inline subsystem map
func (m *NvmeNamespaceInlineSubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineSubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline subsystem map based on the context it is used
func (m *NvmeNamespaceInlineSubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineSubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", m.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", m.Nsid); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineSubsystemMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineSubsystemMap) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineSubsystemMapInlineLinks nvme namespace inline subsystem map inline links
//
// swagger:model nvme_namespace_inline_subsystem_map_inline__links
type NvmeNamespaceInlineSubsystemMapInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline subsystem map inline links
func (m *NvmeNamespaceInlineSubsystemMapInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline subsystem map inline links based on the context it is used
func (m *NvmeNamespaceInlineSubsystemMapInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineSubsystemMapInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineSubsystemMapInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSubsystemMapInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineSubsystemMapInlineSubsystem The NVMe subsystem to which the NVMe namespace is mapped.
//
// swagger:model nvme_namespace_inline_subsystem_map_inline_subsystem
type NvmeNamespaceInlineSubsystemMapInlineSubsystem struct {

	// links
	Links *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// A configurable comment for the NVMe subsystem. Optional in POST.
	//
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The NVMe hosts configured for access to the NVMe subsystem.
	// Optional in POST.
	//
	Hosts []*NvmeNamespaceSubsystemMapSubsystemHostsItems0 `json:"hosts,omitempty"`

	// The name of the NVMe subsystem. Once created, an NVMe subsystem cannot be renamed. Optional in POST.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the NVMe subsystem's hosts. Optional in POST.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline subsystem map inline subsystem
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHosts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("subsystem_map"+"."+"subsystem"+"."+"comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("subsystem_map"+"."+"subsystem"+"."+"comment", "body", *m.Comment, 255); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateHosts(formats strfmt.Registry) error {
	if swag.IsZero(m.Hosts) { // not required
		return nil
	}

	for i := 0; i < len(m.Hosts); i++ {
		if swag.IsZero(m.Hosts[i]) { // not required
			continue
		}

		if m.Hosts[i] != nil {
			if err := m.Hosts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("subsystem_map"+"."+"subsystem"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("subsystem_map"+"."+"subsystem"+"."+"name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

var nvmeNamespaceInlineSubsystemMapInlineSubsystemTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceInlineSubsystemMapInlineSubsystemTypeOsTypePropEnum = append(nvmeNamespaceInlineSubsystemMapInlineSubsystemTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_namespace_inline_subsystem_map_inline_subsystem
	// NvmeNamespaceInlineSubsystemMapInlineSubsystem
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeAix captures enum value "aix"
	NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_subsystem_map_inline_subsystem
	// NvmeNamespaceInlineSubsystemMapInlineSubsystem
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeLinux captures enum value "linux"
	NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_subsystem_map_inline_subsystem
	// NvmeNamespaceInlineSubsystemMapInlineSubsystem
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeVmware captures enum value "vmware"
	NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// nvme_namespace_inline_subsystem_map_inline_subsystem
	// NvmeNamespaceInlineSubsystemMapInlineSubsystem
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeWindows captures enum value "windows"
	NvmeNamespaceInlineSubsystemMapInlineSubsystemOsTypeWindows string = "windows"
)

// prop value enum
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceInlineSubsystemMapInlineSubsystemTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("subsystem_map"+"."+"subsystem"+"."+"os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme namespace inline subsystem map inline subsystem based on the context it is used
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHosts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) contextValidateHosts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Hosts); i++ {

		if m.Hosts[i] != nil {
			if err := m.Hosts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSubsystemMapInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceSubsystemMapSubsystemHostsItems0 The NVMe host provisioned to access NVMe namespaces mapped to a subsystem.
//
// swagger:model NvmeNamespaceSubsystemMapSubsystemHostsItems0
type NvmeNamespaceSubsystemMapSubsystemHostsItems0 struct {

	// dh hmac chap
	DhHmacChap *ConsistencyGroupNvmeHostDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target.
	//
	// Example: nqn.1992-01.example.com:string
	Nqn *string `json:"nqn,omitempty"`

	// The host priority setting allocates appropriate NVMe I/O queues (count and depth) for the host to submit I/O commands. Absence of this property in GET implies io_queue count and I/O queue depth are being used.
	//
	// Enum: ["regular","high"]
	Priority *string `json:"priority,omitempty"`

	// proximity
	Proximity *NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity `json:"proximity,omitempty"`

	// tls
	TLS *NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS `json:"tls,omitempty"`
}

// Validate validates this nvme namespace subsystem map subsystem hosts items0
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePriority(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(m.DhHmacChap) { // not required
		return nil
	}

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

var nvmeNamespaceSubsystemMapSubsystemHostsItems0TypePriorityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceSubsystemMapSubsystemHostsItems0TypePriorityPropEnum = append(nvmeNamespaceSubsystemMapSubsystemHostsItems0TypePriorityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0
	// priority
	// Priority
	// regular
	// END DEBUGGING
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0PriorityRegular captures enum value "regular"
	NvmeNamespaceSubsystemMapSubsystemHostsItems0PriorityRegular string = "regular"

	// BEGIN DEBUGGING
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0
	// priority
	// Priority
	// high
	// END DEBUGGING
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0PriorityHigh captures enum value "high"
	NvmeNamespaceSubsystemMapSubsystemHostsItems0PriorityHigh string = "high"
)

// prop value enum
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) validatePriorityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceSubsystemMapSubsystemHostsItems0TypePriorityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) validatePriority(formats strfmt.Registry) error {
	if swag.IsZero(m.Priority) { // not required
		return nil
	}

	// value enum
	if err := m.validatePriorityEnum("priority", "body", *m.Priority); err != nil {
		return err
	}

	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(m.Proximity) { // not required
		return nil
	}

	if m.Proximity != nil {
		if err := m.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(m.TLS) { // not required
		return nil
	}

	if m.TLS != nil {
		if err := m.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace subsystem map subsystem hosts items0 based on the context it is used
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if m.Proximity != nil {
		if err := m.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if m.TLS != nil {
		if err := m.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceSubsystemMapSubsystemHostsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity Properties that define the SVMs to which the host is proximal. This information is used to properly report active optimized and active non-optimized network paths using an NVMe controller. If no configuration has been specified for the host, the sub-object is not present in GET requests.<br/>
// These properties apply to all instances of the host in the NVMe subsystem in the SVM and its peers.
//
// swagger:model NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity
type NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity struct {

	// A boolean that indicates if the host is proximal to the SVM for which it is configured.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the host is proximal.
	//
	PeerSvms []*NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0 `json:"peer_svms"`
}

// Validate validates this nvme namespace subsystem map subsystem hosts items0 proximity
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.PeerSvms); i++ {
		if swag.IsZero(m.PeerSvms[i]) { // not required
			continue
		}

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme namespace subsystem map subsystem hosts items0 proximity based on the context it is used
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PeerSvms); i++ {

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceSubsystemMapSubsystemHostsItems0Proximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0 A reference to an SVM peer relationship.
//
// swagger:model NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0
type NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0 struct {

	// links
	Links *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace subsystem map subsystem hosts items0 proximity peer svms items0
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace subsystem map subsystem hosts items0 proximity peer svms items0 based on the context it is used
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links nvme namespace subsystem map subsystem hosts items0 proximity peer svms items0 links
//
// swagger:model NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links
type NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace subsystem map subsystem hosts items0 proximity peer svms items0 links
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace subsystem map subsystem hosts items0 proximity peer svms items0 links based on the context it is used
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceSubsystemMapSubsystemHostsItems0ProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
// swagger:model NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS
type NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme namespace subsystem map subsystem hosts items0 TLS
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeNamespaceSubsystemMapSubsystemHostsItems0TlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeNamespaceSubsystemMapSubsystemHostsItems0TlsTypeKeyTypePropEnum = append(nvmeNamespaceSubsystemMapSubsystemHostsItems0TlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0TLSKeyTypeNone captures enum value "none"
	NvmeNamespaceSubsystemMapSubsystemHostsItems0TLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeNamespaceSubsystemMapSubsystemHostsItems0TLSKeyTypeConfigured captures enum value "configured"
	NvmeNamespaceSubsystemMapSubsystemHostsItems0TLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeNamespaceSubsystemMapSubsystemHostsItems0TlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyTypeEnum("tls"+"."+"key_type", "body", *m.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme namespace subsystem map subsystem hosts items0 TLS based on context it is used
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceSubsystemMapSubsystemHostsItems0TLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks nvme namespace inline subsystem map inline subsystem inline links
//
// swagger:model nvme_namespace_inline_subsystem_map_inline_subsystem_inline__links
type NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline subsystem map inline subsystem inline links
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline subsystem map inline subsystem inline links based on the context it is used
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSubsystemMapInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model nvme_namespace_inline_svm
type NvmeNamespaceInlineSvm struct {

	// links
	Links *NvmeNamespaceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme namespace inline svm
func (m *NvmeNamespaceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline svm based on the context it is used
func (m *NvmeNamespaceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeNamespaceInlineSvmInlineLinks nvme namespace inline svm inline links
//
// swagger:model nvme_namespace_inline_svm_inline__links
type NvmeNamespaceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme namespace inline svm inline links
func (m *NvmeNamespaceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme namespace inline svm inline links based on the context it is used
func (m *NvmeNamespaceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeNamespaceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeNamespaceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeNamespaceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeNamespaceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
