// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeService A Non-Volatile Memory Express (NVMe) service defines the properties of the NVMe controller target for an SVM. There can be at most one NVMe service for an SVM. An SVM's NVMe service must be created before NVMe host initiators can connect to the SVM.<br/>
// An NVMe service is identified by the UUID of its SVM.
//
// swagger:model nvme_service
type NvmeService struct {

	// links
	Links *NvmeServiceInlineLinks `json:"_links,omitempty"`

	// The administrative state of the NVMe service. The NVMe service can be disabled to block all NVMe connectivity to the SVM.<br/>
	// This is optional in POST and PATCH. The default setting is _true_ (enabled) in POST.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// metric
	Metric *NvmeServiceInlineMetric `json:"metric,omitempty"`

	// statistics
	Statistics *NvmeServiceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *NvmeServiceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this nvme service
func (m *NvmeService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeService) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeService) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeService) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeService) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service based on the context it is used
func (m *NvmeService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeService) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeService) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeService) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeService) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeService) UnmarshalBinary(b []byte) error {
	var res NvmeService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineLinks nvme service inline links
//
// swagger:model nvme_service_inline__links
type NvmeServiceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline links
func (m *NvmeServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline links based on the context it is used
func (m *NvmeServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model nvme_service_inline_metric
type NvmeServiceInlineMetric struct {

	// links
	Links *NvmeServiceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// fc
	Fc *NvmeServiceInlineMetricInlineFc `json:"fc,omitempty"`

	// iops
	Iops *NvmeServiceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// tcp
	TCP *NvmeServiceInlineMetricInlineTCP `json:"tcp,omitempty"`

	// throughput
	Throughput *NvmeServiceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline metric
func (m *NvmeServiceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricTypeDurationPropEnum = append(nvmeServiceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT15S captures enum value "PT15S"
	NvmeServiceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT4M captures enum value "PT4M"
	NvmeServiceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT30M captures enum value "PT30M"
	NvmeServiceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT2H captures enum value "PT2H"
	NvmeServiceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationP1D captures enum value "P1D"
	NvmeServiceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceInlineMetricDurationPT5M captures enum value "PT5M"
	NvmeServiceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *NvmeServiceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetric) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricTypeStatusPropEnum = append(nvmeServiceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusOk captures enum value "ok"
	NvmeServiceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusError captures enum value "error"
	NvmeServiceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusNotFound captures enum value "not_found"
	NvmeServiceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric
	// NvmeServiceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetric) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(m.TCP) { // not required
		return nil
	}

	if m.TCP != nil {
		if err := m.TCP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline metric based on the context it is used
func (m *NvmeServiceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateTCP(ctx context.Context, formats strfmt.Registry) error {

	if m.TCP != nil {
		if err := m.TCP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetric) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineFc The NVMe/FC portion of the aggregated metrics.
//
// swagger:model nvme_service_inline_metric_inline_fc
type NvmeServiceInlineMetricInlineFc struct {

	// links
	Links *NvmeServiceInlineMetricInlineFcInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NvmeServiceInlineMetricInlineFcInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceInlineMetricInlineFcInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NvmeServiceInlineMetricInlineFcInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline metric inline fc
func (m *NvmeServiceInlineMetricInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricInlineFcTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricInlineFcTypeDurationPropEnum = append(nvmeServiceInlineMetricInlineFcTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT15S captures enum value "PT15S"
	NvmeServiceInlineMetricInlineFcDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT4M captures enum value "PT4M"
	NvmeServiceInlineMetricInlineFcDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT30M captures enum value "PT30M"
	NvmeServiceInlineMetricInlineFcDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT2H captures enum value "PT2H"
	NvmeServiceInlineMetricInlineFcDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationP1D captures enum value "P1D"
	NvmeServiceInlineMetricInlineFcDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcDurationPT5M captures enum value "PT5M"
	NvmeServiceInlineMetricInlineFcDurationPT5M string = "PT5M"
)

// prop value enum
func (m *NvmeServiceInlineMetricInlineFc) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricInlineFcTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"fc"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricInlineFcTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricInlineFcTypeStatusPropEnum = append(nvmeServiceInlineMetricInlineFcTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusOk captures enum value "ok"
	NvmeServiceInlineMetricInlineFcStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusError captures enum value "error"
	NvmeServiceInlineMetricInlineFcStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineMetricInlineFcStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineMetricInlineFcStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineMetricInlineFcStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineMetricInlineFcStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusNotFound captures enum value "not_found"
	NvmeServiceInlineMetricInlineFcStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineMetricInlineFcStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineMetricInlineFcStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineMetricInlineFcStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_fc
	// NvmeServiceInlineMetricInlineFc
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineFcStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineMetricInlineFcStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceInlineMetricInlineFc) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricInlineFcTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"fc"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"fc"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline fc based on the context it is used
func (m *NvmeServiceInlineMetricInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"fc"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"fc"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineFc) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"fc"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFc) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineFcInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_fc_inline_iops
type NvmeServiceInlineMetricInlineFcInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline fc inline iops
func (m *NvmeServiceInlineMetricInlineFcInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline fc inline iops based on the context it is used
func (m *NvmeServiceInlineMetricInlineFcInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFcInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFcInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFcInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineFcInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_fc_inline_latency
type NvmeServiceInlineMetricInlineFcInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline fc inline latency
func (m *NvmeServiceInlineMetricInlineFcInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline fc inline latency based on the context it is used
func (m *NvmeServiceInlineMetricInlineFcInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFcInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFcInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFcInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineFcInlineLinks nvme service inline metric inline fc inline links
//
// swagger:model nvme_service_inline_metric_inline_fc_inline__links
type NvmeServiceInlineMetricInlineFcInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline metric inline fc inline links
func (m *NvmeServiceInlineMetricInlineFcInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineFcInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline fc inline links based on the context it is used
func (m *NvmeServiceInlineMetricInlineFcInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineFcInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFcInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFcInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFcInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineFcInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_fc_inline_throughput
type NvmeServiceInlineMetricInlineFcInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline fc inline throughput
func (m *NvmeServiceInlineMetricInlineFcInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline fc inline throughput based on the context it is used
func (m *NvmeServiceInlineMetricInlineFcInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFcInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineFcInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineFcInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_iops
type NvmeServiceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline iops
func (m *NvmeServiceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline iops based on the context it is used
func (m *NvmeServiceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_latency
type NvmeServiceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline latency
func (m *NvmeServiceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline latency based on the context it is used
func (m *NvmeServiceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineLinks nvme service inline metric inline links
//
// swagger:model nvme_service_inline_metric_inline__links
type NvmeServiceInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline metric inline links
func (m *NvmeServiceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline links based on the context it is used
func (m *NvmeServiceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineTCP The NVMe/TCP portion of the aggregated metrics.
//
// swagger:model nvme_service_inline_metric_inline_tcp
type NvmeServiceInlineMetricInlineTCP struct {

	// links
	Links *NvmeServiceInlineMetricInlineTCPInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NvmeServiceInlineMetricInlineTCPInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceInlineMetricInlineTCPInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NvmeServiceInlineMetricInlineTCPInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp
func (m *NvmeServiceInlineMetricInlineTCP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricInlineTcpTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricInlineTcpTypeDurationPropEnum = append(nvmeServiceInlineMetricInlineTcpTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT15S captures enum value "PT15S"
	NvmeServiceInlineMetricInlineTCPDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT4M captures enum value "PT4M"
	NvmeServiceInlineMetricInlineTCPDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT30M captures enum value "PT30M"
	NvmeServiceInlineMetricInlineTCPDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT2H captures enum value "PT2H"
	NvmeServiceInlineMetricInlineTCPDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationP1D captures enum value "P1D"
	NvmeServiceInlineMetricInlineTCPDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPDurationPT5M captures enum value "PT5M"
	NvmeServiceInlineMetricInlineTCPDurationPT5M string = "PT5M"
)

// prop value enum
func (m *NvmeServiceInlineMetricInlineTCP) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricInlineTcpTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"tcp"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineMetricInlineTcpTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineMetricInlineTcpTypeStatusPropEnum = append(nvmeServiceInlineMetricInlineTcpTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusOk captures enum value "ok"
	NvmeServiceInlineMetricInlineTCPStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusError captures enum value "error"
	NvmeServiceInlineMetricInlineTCPStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineMetricInlineTCPStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineMetricInlineTCPStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineMetricInlineTCPStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineMetricInlineTCPStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusNotFound captures enum value "not_found"
	NvmeServiceInlineMetricInlineTCPStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineMetricInlineTCPStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineMetricInlineTCPStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineMetricInlineTCPStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_metric_inline_tcp
	// NvmeServiceInlineMetricInlineTCP
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineMetricInlineTCPStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineMetricInlineTCPStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceInlineMetricInlineTCP) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineMetricInlineTcpTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"tcp"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"tcp"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp based on the context it is used
func (m *NvmeServiceInlineMetricInlineTCP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"tcp"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"tcp"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineMetricInlineTCP) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"tcp"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCP) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineTCPInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_tcp_inline_iops
type NvmeServiceInlineMetricInlineTCPInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp inline iops
func (m *NvmeServiceInlineMetricInlineTCPInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp inline iops based on the context it is used
func (m *NvmeServiceInlineMetricInlineTCPInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCPInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCPInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCPInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineTCPInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_tcp_inline_latency
type NvmeServiceInlineMetricInlineTCPInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp inline latency
func (m *NvmeServiceInlineMetricInlineTCPInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp inline latency based on the context it is used
func (m *NvmeServiceInlineMetricInlineTCPInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCPInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCPInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCPInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineTCPInlineLinks nvme service inline metric inline tcp inline links
//
// swagger:model nvme_service_inline_metric_inline_tcp_inline__links
type NvmeServiceInlineMetricInlineTCPInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp inline links
func (m *NvmeServiceInlineMetricInlineTCPInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineTCPInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp inline links based on the context it is used
func (m *NvmeServiceInlineMetricInlineTCPInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineMetricInlineTCPInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "tcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCPInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCPInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCPInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineTCPInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_tcp_inline_throughput
type NvmeServiceInlineMetricInlineTCPInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline tcp inline throughput
func (m *NvmeServiceInlineMetricInlineTCPInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline tcp inline throughput based on the context it is used
func (m *NvmeServiceInlineMetricInlineTCPInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCPInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineTCPInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineTCPInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nvme_service_inline_metric_inline_throughput
type NvmeServiceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline metric inline throughput
func (m *NvmeServiceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline metric inline throughput based on the context it is used
func (m *NvmeServiceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput for SVM protocols. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model nvme_service_inline_statistics
type NvmeServiceInlineStatistics struct {

	// fc
	Fc *NvmeServiceInlineStatisticsInlineFc `json:"fc,omitempty"`

	// iops raw
	IopsRaw *NvmeServiceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NvmeServiceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// tcp
	TCP *NvmeServiceInlineStatisticsInlineTCP `json:"tcp,omitempty"`

	// throughput raw
	ThroughputRaw *NvmeServiceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline statistics
func (m *NvmeServiceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineStatistics) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineStatisticsTypeStatusPropEnum = append(nvmeServiceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusOk captures enum value "ok"
	NvmeServiceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusError captures enum value "error"
	NvmeServiceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusNotFound captures enum value "not_found"
	NvmeServiceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics
	// NvmeServiceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(m.TCP) { // not required
		return nil
	}

	if m.TCP != nil {
		if err := m.TCP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "tcp")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline statistics based on the context it is used
func (m *NvmeServiceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineStatistics) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) contextValidateTCP(ctx context.Context, formats strfmt.Registry) error {

	if m.TCP != nil {
		if err := m.TCP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "tcp")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineFc The NVMe/FC portion of the aggregated statistics.
//
// swagger:model nvme_service_inline_statistics_inline_fc
type NvmeServiceInlineStatisticsInlineFc struct {

	// iops raw
	IopsRaw *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline statistics inline fc
func (m *NvmeServiceInlineStatisticsInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "fc" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "fc" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineStatisticsInlineFcTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineStatisticsInlineFcTypeStatusPropEnum = append(nvmeServiceInlineStatisticsInlineFcTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusOk captures enum value "ok"
	NvmeServiceInlineStatisticsInlineFcStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusError captures enum value "error"
	NvmeServiceInlineStatisticsInlineFcStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineStatisticsInlineFcStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineStatisticsInlineFcStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineStatisticsInlineFcStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineStatisticsInlineFcStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusNotFound captures enum value "not_found"
	NvmeServiceInlineStatisticsInlineFcStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineStatisticsInlineFcStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineStatisticsInlineFcStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineStatisticsInlineFcStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_fc
	// NvmeServiceInlineStatisticsInlineFc
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineFcStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineStatisticsInlineFcStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceInlineStatisticsInlineFc) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineStatisticsInlineFcTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"fc"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "fc" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"fc"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline statistics inline fc based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "fc" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "fc" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"fc"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "fc" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineFc) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"fc"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineFc) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineFcInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nvme_service_inline_statistics_inline_fc_inline_iops_raw
type NvmeServiceInlineStatisticsInlineFcInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline fc inline iops raw
func (m *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline fc inline iops raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineFcInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineFcInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nvme_service_inline_statistics_inline_fc_inline_latency_raw
type NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline fc inline latency raw
func (m *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline fc inline latency raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineFcInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nvme_service_inline_statistics_inline_fc_inline_throughput_raw
type NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline fc inline throughput raw
func (m *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline fc inline throughput raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineFcInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nvme_service_inline_statistics_inline_iops_raw
type NvmeServiceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline iops raw
func (m *NvmeServiceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline iops raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nvme_service_inline_statistics_inline_latency_raw
type NvmeServiceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline latency raw
func (m *NvmeServiceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline latency raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineTCP The NVMe/TCP portion of the aggregated statistics.
//
// swagger:model nvme_service_inline_statistics_inline_tcp
type NvmeServiceInlineStatisticsInlineTCP struct {

	// iops raw
	IopsRaw *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service inline statistics inline tcp
func (m *NvmeServiceInlineStatisticsInlineTCP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "tcp" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "tcp" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceInlineStatisticsInlineTcpTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceInlineStatisticsInlineTcpTypeStatusPropEnum = append(nvmeServiceInlineStatisticsInlineTcpTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusOk captures enum value "ok"
	NvmeServiceInlineStatisticsInlineTCPStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusError captures enum value "error"
	NvmeServiceInlineStatisticsInlineTCPStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceInlineStatisticsInlineTCPStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceInlineStatisticsInlineTCPStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceInlineStatisticsInlineTCPStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceInlineStatisticsInlineTCPStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusNotFound captures enum value "not_found"
	NvmeServiceInlineStatisticsInlineTCPStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceInlineStatisticsInlineTCPStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceInlineStatisticsInlineTCPStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceInlineStatisticsInlineTCPStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_inline_statistics_inline_tcp
	// NvmeServiceInlineStatisticsInlineTCP
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceInlineStatisticsInlineTCPStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceInlineStatisticsInlineTCPStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceInlineStatisticsInlineTCP) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceInlineStatisticsInlineTcpTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"tcp"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "tcp" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"tcp"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service inline statistics inline tcp based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineTCP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "tcp" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "tcp" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"tcp"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "tcp" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceInlineStatisticsInlineTCP) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"tcp"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineTCP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineTCP) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineTCP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nvme_service_inline_statistics_inline_tcp_inline_iops_raw
type NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline tcp inline iops raw
func (m *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline tcp inline iops raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineTCPInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nvme_service_inline_statistics_inline_tcp_inline_latency_raw
type NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline tcp inline latency raw
func (m *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline tcp inline latency raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineTCPInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nvme_service_inline_statistics_inline_tcp_inline_throughput_raw
type NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline tcp inline throughput raw
func (m *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline tcp inline throughput raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineTCPInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nvme_service_inline_statistics_inline_throughput_raw
type NvmeServiceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service inline statistics inline throughput raw
func (m *NvmeServiceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service inline statistics inline throughput raw based on the context it is used
func (m *NvmeServiceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model nvme_service_inline_svm
type NvmeServiceInlineSvm struct {

	// links
	Links *NvmeServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme service inline svm
func (m *NvmeServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline svm based on the context it is used
func (m *NvmeServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceInlineSvmInlineLinks nvme service inline svm inline links
//
// swagger:model nvme_service_inline_svm_inline__links
type NvmeServiceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme service inline svm inline links
func (m *NvmeServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service inline svm inline links based on the context it is used
func (m *NvmeServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
