// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeServiceMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model nvme_service_metric
type NvmeServiceMetric struct {

	// links
	Links *NvmeServiceMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// fc
	Fc *NvmeServiceMetricInlineFc `json:"fc,omitempty"`

	// iops
	Iops *NvmeServiceMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// tcp
	TCP *NvmeServiceMetricInlineTCP `json:"tcp,omitempty"`

	// throughput
	Throughput *NvmeServiceMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service metric
func (m *NvmeServiceMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceMetricTypeDurationPropEnum = append(nvmeServiceMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceMetricDurationPT15S captures enum value "PT15S"
	NvmeServiceMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceMetricDurationPT4M captures enum value "PT4M"
	NvmeServiceMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceMetricDurationPT30M captures enum value "PT30M"
	NvmeServiceMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceMetricDurationPT2H captures enum value "PT2H"
	NvmeServiceMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceMetricDurationP1D captures enum value "P1D"
	NvmeServiceMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceMetricDurationPT5M captures enum value "PT5M"
	NvmeServiceMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *NvmeServiceMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetric) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceMetricTypeStatusPropEnum = append(nvmeServiceMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceMetricStatusOk captures enum value "ok"
	NvmeServiceMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceMetricStatusError captures enum value "error"
	NvmeServiceMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceMetricStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceMetricStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceMetricStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceMetricStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceMetricStatusNotFound captures enum value "not_found"
	NvmeServiceMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceMetricStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_metric
	// NvmeServiceMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetric) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(m.TCP) { // not required
		return nil
	}

	if m.TCP != nil {
		if err := m.TCP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service metric based on the context it is used
func (m *NvmeServiceMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetric) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetric) contextValidateTCP(ctx context.Context, formats strfmt.Registry) error {

	if m.TCP != nil {
		if err := m.TCP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetric) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineFc The NVMe/FC portion of the aggregated metrics.
//
// swagger:model nvme_service_metric_inline_fc
type NvmeServiceMetricInlineFc struct {

	// links
	Links *NvmeServiceMetricInlineFcInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NvmeServiceMetricInlineFcInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceMetricInlineFcInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NvmeServiceMetricInlineFcInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service metric inline fc
func (m *NvmeServiceMetricInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineFc) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceMetricInlineFcTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceMetricInlineFcTypeDurationPropEnum = append(nvmeServiceMetricInlineFcTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceMetricInlineFcDurationPT15S captures enum value "PT15S"
	NvmeServiceMetricInlineFcDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceMetricInlineFcDurationPT4M captures enum value "PT4M"
	NvmeServiceMetricInlineFcDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceMetricInlineFcDurationPT30M captures enum value "PT30M"
	NvmeServiceMetricInlineFcDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceMetricInlineFcDurationPT2H captures enum value "PT2H"
	NvmeServiceMetricInlineFcDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceMetricInlineFcDurationP1D captures enum value "P1D"
	NvmeServiceMetricInlineFcDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceMetricInlineFcDurationPT5M captures enum value "PT5M"
	NvmeServiceMetricInlineFcDurationPT5M string = "PT5M"
)

// prop value enum
func (m *NvmeServiceMetricInlineFc) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceMetricInlineFcTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceMetricInlineFc) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("fc"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceMetricInlineFcTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceMetricInlineFcTypeStatusPropEnum = append(nvmeServiceMetricInlineFcTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusOk captures enum value "ok"
	NvmeServiceMetricInlineFcStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusError captures enum value "error"
	NvmeServiceMetricInlineFcStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceMetricInlineFcStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceMetricInlineFcStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceMetricInlineFcStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceMetricInlineFcStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusNotFound captures enum value "not_found"
	NvmeServiceMetricInlineFcStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceMetricInlineFcStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceMetricInlineFcStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceMetricInlineFcStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_fc
	// NvmeServiceMetricInlineFc
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceMetricInlineFcStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceMetricInlineFcStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceMetricInlineFc) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceMetricInlineFcTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceMetricInlineFc) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("fc"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("fc"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service metric inline fc based on the context it is used
func (m *NvmeServiceMetricInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineFc) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineFc) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFc) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineFcInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nvme_service_metric_inline_fc_inline_iops
type NvmeServiceMetricInlineFcInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline fc inline iops
func (m *NvmeServiceMetricInlineFcInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline fc inline iops based on the context it is used
func (m *NvmeServiceMetricInlineFcInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFcInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFcInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineFcInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineFcInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nvme_service_metric_inline_fc_inline_latency
type NvmeServiceMetricInlineFcInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline fc inline latency
func (m *NvmeServiceMetricInlineFcInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline fc inline latency based on the context it is used
func (m *NvmeServiceMetricInlineFcInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFcInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFcInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineFcInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineFcInlineLinks nvme service metric inline fc inline links
//
// swagger:model nvme_service_metric_inline_fc_inline__links
type NvmeServiceMetricInlineFcInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme service metric inline fc inline links
func (m *NvmeServiceMetricInlineFcInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineFcInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service metric inline fc inline links based on the context it is used
func (m *NvmeServiceMetricInlineFcInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineFcInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFcInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFcInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineFcInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineFcInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nvme_service_metric_inline_fc_inline_throughput
type NvmeServiceMetricInlineFcInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline fc inline throughput
func (m *NvmeServiceMetricInlineFcInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline fc inline throughput based on the context it is used
func (m *NvmeServiceMetricInlineFcInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFcInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineFcInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineFcInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nvme_service_metric_inline_iops
type NvmeServiceMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline iops
func (m *NvmeServiceMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline iops based on the context it is used
func (m *NvmeServiceMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nvme_service_metric_inline_latency
type NvmeServiceMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline latency
func (m *NvmeServiceMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline latency based on the context it is used
func (m *NvmeServiceMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineLinks nvme service metric inline links
//
// swagger:model nvme_service_metric_inline__links
type NvmeServiceMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme service metric inline links
func (m *NvmeServiceMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service metric inline links based on the context it is used
func (m *NvmeServiceMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineTCP The NVMe/TCP portion of the aggregated metrics.
//
// swagger:model nvme_service_metric_inline_tcp
type NvmeServiceMetricInlineTCP struct {

	// links
	Links *NvmeServiceMetricInlineTCPInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *NvmeServiceMetricInlineTCPInlineIops `json:"iops,omitempty"`

	// latency
	Latency *NvmeServiceMetricInlineTCPInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *NvmeServiceMetricInlineTCPInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service metric inline tcp
func (m *NvmeServiceMetricInlineTCP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineTCP) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceMetricInlineTcpTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceMetricInlineTcpTypeDurationPropEnum = append(nvmeServiceMetricInlineTcpTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPDurationPT15S captures enum value "PT15S"
	NvmeServiceMetricInlineTCPDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPDurationPT4M captures enum value "PT4M"
	NvmeServiceMetricInlineTCPDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPDurationPT30M captures enum value "PT30M"
	NvmeServiceMetricInlineTCPDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPDurationPT2H captures enum value "PT2H"
	NvmeServiceMetricInlineTCPDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPDurationP1D captures enum value "P1D"
	NvmeServiceMetricInlineTCPDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPDurationPT5M captures enum value "PT5M"
	NvmeServiceMetricInlineTCPDurationPT5M string = "PT5M"
)

// prop value enum
func (m *NvmeServiceMetricInlineTCP) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceMetricInlineTcpTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceMetricInlineTCP) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("tcp"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceMetricInlineTcpTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceMetricInlineTcpTypeStatusPropEnum = append(nvmeServiceMetricInlineTcpTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusOk captures enum value "ok"
	NvmeServiceMetricInlineTCPStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusError captures enum value "error"
	NvmeServiceMetricInlineTCPStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceMetricInlineTCPStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceMetricInlineTCPStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceMetricInlineTCPStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceMetricInlineTCPStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusNotFound captures enum value "not_found"
	NvmeServiceMetricInlineTCPStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceMetricInlineTCPStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceMetricInlineTCPStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceMetricInlineTCPStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_metric_inline_tcp
	// NvmeServiceMetricInlineTCP
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceMetricInlineTCPStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceMetricInlineTCPStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceMetricInlineTCP) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceMetricInlineTcpTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceMetricInlineTCP) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("tcp"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("tcp"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service metric inline tcp based on the context it is used
func (m *NvmeServiceMetricInlineTCP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineTCP) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceMetricInlineTCP) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCP) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineTCP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineTCPInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model nvme_service_metric_inline_tcp_inline_iops
type NvmeServiceMetricInlineTCPInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline tcp inline iops
func (m *NvmeServiceMetricInlineTCPInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline tcp inline iops based on the context it is used
func (m *NvmeServiceMetricInlineTCPInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCPInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCPInlineIops) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineTCPInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineTCPInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model nvme_service_metric_inline_tcp_inline_latency
type NvmeServiceMetricInlineTCPInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline tcp inline latency
func (m *NvmeServiceMetricInlineTCPInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline tcp inline latency based on the context it is used
func (m *NvmeServiceMetricInlineTCPInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCPInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCPInlineLatency) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineTCPInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineTCPInlineLinks nvme service metric inline tcp inline links
//
// swagger:model nvme_service_metric_inline_tcp_inline__links
type NvmeServiceMetricInlineTCPInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme service metric inline tcp inline links
func (m *NvmeServiceMetricInlineTCPInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineTCPInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme service metric inline tcp inline links based on the context it is used
func (m *NvmeServiceMetricInlineTCPInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceMetricInlineTCPInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCPInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCPInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineTCPInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineTCPInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nvme_service_metric_inline_tcp_inline_throughput
type NvmeServiceMetricInlineTCPInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline tcp inline throughput
func (m *NvmeServiceMetricInlineTCPInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline tcp inline throughput based on the context it is used
func (m *NvmeServiceMetricInlineTCPInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCPInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineTCPInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineTCPInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model nvme_service_metric_inline_throughput
type NvmeServiceMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service metric inline throughput
func (m *NvmeServiceMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service metric inline throughput based on the context it is used
func (m *NvmeServiceMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res NvmeServiceMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
