// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeServiceStatistics These are raw performance numbers, such as IOPS latency and throughput for SVM protocols. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model nvme_service_statistics
type NvmeServiceStatistics struct {

	// fc
	Fc *NvmeServiceStatisticsInlineFc `json:"fc,omitempty"`

	// iops raw
	IopsRaw *NvmeServiceStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NvmeServiceStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// tcp
	TCP *NvmeServiceStatisticsInlineTCP `json:"tcp,omitempty"`

	// throughput raw
	ThroughputRaw *NvmeServiceStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service statistics
func (m *NvmeServiceStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceStatistics) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceStatisticsTypeStatusPropEnum = append(nvmeServiceStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceStatisticsStatusOk captures enum value "ok"
	NvmeServiceStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceStatisticsStatusError captures enum value "error"
	NvmeServiceStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceStatisticsStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceStatisticsStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceStatisticsStatusNotFound captures enum value "not_found"
	NvmeServiceStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceStatisticsStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics
	// NvmeServiceStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceStatistics) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(m.TCP) { // not required
		return nil
	}

	if m.TCP != nil {
		if err := m.TCP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service statistics based on the context it is used
func (m *NvmeServiceStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceStatistics) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceStatistics) contextValidateTCP(ctx context.Context, formats strfmt.Registry) error {

	if m.TCP != nil {
		if err := m.TCP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatistics) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineFc The NVMe/FC portion of the aggregated statistics.
//
// swagger:model nvme_service_statistics_inline_fc
type NvmeServiceStatisticsInlineFc struct {

	// iops raw
	IopsRaw *NvmeServiceStatisticsInlineFcInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NvmeServiceStatisticsInlineFcInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *NvmeServiceStatisticsInlineFcInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service statistics inline fc
func (m *NvmeServiceStatisticsInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceStatisticsInlineFc) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineFc) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceStatisticsInlineFcTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceStatisticsInlineFcTypeStatusPropEnum = append(nvmeServiceStatisticsInlineFcTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusOk captures enum value "ok"
	NvmeServiceStatisticsInlineFcStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusError captures enum value "error"
	NvmeServiceStatisticsInlineFcStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceStatisticsInlineFcStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceStatisticsInlineFcStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceStatisticsInlineFcStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceStatisticsInlineFcStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusNotFound captures enum value "not_found"
	NvmeServiceStatisticsInlineFcStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceStatisticsInlineFcStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceStatisticsInlineFcStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceStatisticsInlineFcStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_fc
	// NvmeServiceStatisticsInlineFc
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceStatisticsInlineFcStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceStatisticsInlineFcStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceStatisticsInlineFc) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceStatisticsInlineFcTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceStatisticsInlineFc) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("fc"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineFc) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineFc) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("fc"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service statistics inline fc based on the context it is used
func (m *NvmeServiceStatisticsInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceStatisticsInlineFc) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineFc) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineFc) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineFc) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineFc) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineFc) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineFcInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nvme_service_statistics_inline_fc_inline_iops_raw
type NvmeServiceStatisticsInlineFcInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline fc inline iops raw
func (m *NvmeServiceStatisticsInlineFcInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline fc inline iops raw based on the context it is used
func (m *NvmeServiceStatisticsInlineFcInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineFcInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineFcInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineFcInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineFcInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nvme_service_statistics_inline_fc_inline_latency_raw
type NvmeServiceStatisticsInlineFcInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline fc inline latency raw
func (m *NvmeServiceStatisticsInlineFcInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline fc inline latency raw based on the context it is used
func (m *NvmeServiceStatisticsInlineFcInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineFcInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineFcInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineFcInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineFcInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nvme_service_statistics_inline_fc_inline_throughput_raw
type NvmeServiceStatisticsInlineFcInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline fc inline throughput raw
func (m *NvmeServiceStatisticsInlineFcInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline fc inline throughput raw based on the context it is used
func (m *NvmeServiceStatisticsInlineFcInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineFcInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineFcInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineFcInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nvme_service_statistics_inline_iops_raw
type NvmeServiceStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline iops raw
func (m *NvmeServiceStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline iops raw based on the context it is used
func (m *NvmeServiceStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nvme_service_statistics_inline_latency_raw
type NvmeServiceStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline latency raw
func (m *NvmeServiceStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline latency raw based on the context it is used
func (m *NvmeServiceStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineTCP The NVMe/TCP portion of the aggregated statistics.
//
// swagger:model nvme_service_statistics_inline_tcp
type NvmeServiceStatisticsInlineTCP struct {

	// iops raw
	IopsRaw *NvmeServiceStatisticsInlineTCPInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *NvmeServiceStatisticsInlineTCPInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *NvmeServiceStatisticsInlineTCPInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this nvme service statistics inline tcp
func (m *NvmeServiceStatisticsInlineTCP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var nvmeServiceStatisticsInlineTcpTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeServiceStatisticsInlineTcpTypeStatusPropEnum = append(nvmeServiceStatisticsInlineTcpTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// ok
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusOk captures enum value "ok"
	NvmeServiceStatisticsInlineTCPStatusOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// error
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusError captures enum value "error"
	NvmeServiceStatisticsInlineTCPStatusError string = "error"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusPartialNoData captures enum value "partial_no_data"
	NvmeServiceStatisticsInlineTCPStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusPartialNoResponse captures enum value "partial_no_response"
	NvmeServiceStatisticsInlineTCPStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusPartialOtherError captures enum value "partial_other_error"
	NvmeServiceStatisticsInlineTCPStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusNegativeDelta captures enum value "negative_delta"
	NvmeServiceStatisticsInlineTCPStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// not_found
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusNotFound captures enum value "not_found"
	NvmeServiceStatisticsInlineTCPStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusBackfilledData captures enum value "backfilled_data"
	NvmeServiceStatisticsInlineTCPStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	NvmeServiceStatisticsInlineTCPStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusInconsistentOldData captures enum value "inconsistent_old_data"
	NvmeServiceStatisticsInlineTCPStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// nvme_service_statistics_inline_tcp
	// NvmeServiceStatisticsInlineTCP
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// NvmeServiceStatisticsInlineTCPStatusPartialNoUUID captures enum value "partial_no_uuid"
	NvmeServiceStatisticsInlineTCPStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *NvmeServiceStatisticsInlineTCP) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeServiceStatisticsInlineTcpTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("tcp"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("tcp"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme service statistics inline tcp based on the context it is used
func (m *NvmeServiceStatisticsInlineTCP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeServiceStatisticsInlineTCP) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineTCP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineTCP) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineTCP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineTCPInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model nvme_service_statistics_inline_tcp_inline_iops_raw
type NvmeServiceStatisticsInlineTCPInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline tcp inline iops raw
func (m *NvmeServiceStatisticsInlineTCPInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline tcp inline iops raw based on the context it is used
func (m *NvmeServiceStatisticsInlineTCPInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineTCPInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineTCPInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineTCPInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineTCPInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model nvme_service_statistics_inline_tcp_inline_latency_raw
type NvmeServiceStatisticsInlineTCPInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline tcp inline latency raw
func (m *NvmeServiceStatisticsInlineTCPInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline tcp inline latency raw based on the context it is used
func (m *NvmeServiceStatisticsInlineTCPInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineTCPInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineTCPInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineTCPInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineTCPInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nvme_service_statistics_inline_tcp_inline_throughput_raw
type NvmeServiceStatisticsInlineTCPInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline tcp inline throughput raw
func (m *NvmeServiceStatisticsInlineTCPInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline tcp inline throughput raw based on the context it is used
func (m *NvmeServiceStatisticsInlineTCPInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineTCPInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineTCPInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineTCPInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeServiceStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model nvme_service_statistics_inline_throughput_raw
type NvmeServiceStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this nvme service statistics inline throughput raw
func (m *NvmeServiceStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme service statistics inline throughput raw based on the context it is used
func (m *NvmeServiceStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeServiceStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res NvmeServiceStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
