// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeSubsystem An NVMe subsystem maintains configuration state and namespace access control for a set of NVMe-connected hosts.
//
// swagger:model nvme_subsystem
type NvmeSubsystem struct {

	// links
	Links *NvmeSubsystemInlineLinks `json:"_links,omitempty"`

	// A configurable comment for the NVMe subsystem. Optional in POST and PATCH.
	//
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// An option that causes the subsystem to be deleted when the last subsystem map associated with it is deleted. Optional in POST and PATCH. This property defaults to _false_ when the subsystem is created.
	//
	DeleteOnUnmap *bool `json:"delete_on_unmap,omitempty"`

	// io queue
	IoQueue *NvmeSubsystemInlineIoQueue `json:"io_queue,omitempty"`

	// The name of the NVMe subsystem. Once created, an NVMe subsystem cannot be renamed. Required in POST.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The NVMe hosts configured for access to the NVMe subsystem. Optional in POST.
	//
	NvmeSubsystemInlineHosts []*NvmeSubsystemInlineHostsInlineArrayItem `json:"hosts,omitempty"`

	// The NVMe namespaces mapped to the NVMe subsystem.<br/>
	// There is an added computational cost to retrieving property values for `subsystem_maps`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	NvmeSubsystemInlineSubsystemMaps []*NvmeSubsystemInlineSubsystemMapsInlineArrayItem `json:"subsystem_maps,omitempty"`

	// Vendor-specific identifiers (UUIDs) optionally assigned to an NVMe subsystem when the subsystem is created. The identifiers are used to enable vendor-specific NVMe protocol features. The identifiers are provided by a host application vendor and shared with NetApp prior to a joint product release. Creating an NVMe subsystem with an unknown or non-specific identifier will have no effect on the NVMe subsystem. Refer to the ONTAP SAN Administration Guide for a list of the supported vendor-specific identifiers. After a subsystem is created, the vendor-specific identifiers cannot be changed or removed. Optional in POST.
	//
	NvmeSubsystemInlineVendorUuids []*string `json:"vendor_uuids,omitempty"`

	// The host operating system of the NVMe subsystem's hosts. Required in POST.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// replication
	Replication *NvmeSubsystemInlineReplication `json:"replication,omitempty"`

	// The serial number of the NVMe subsystem.
	//
	// Example: wCVsgFMiuMhVAAAAAAAB
	// Read Only: true
	// Max Length: 20
	// Min Length: 20
	SerialNumber *string `json:"serial_number,omitempty"`

	// svm
	Svm *NvmeSubsystemInlineSvm `json:"svm,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target.
	//
	// Example: nqn.1992-01.example.com:string
	// Read Only: true
	// Max Length: 223
	// Min Length: 1
	TargetNqn *string `json:"target_nqn,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem
func (m *NvmeSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIoQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvmeSubsystemInlineHosts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvmeSubsystemInlineSubsystemMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetNqn(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 255); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystem) validateIoQueue(formats strfmt.Registry) error {
	if swag.IsZero(m.IoQueue) { // not required
		return nil
	}

	if m.IoQueue != nil {
		if err := m.IoQueue.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystem) validateNvmeSubsystemInlineHosts(formats strfmt.Registry) error {
	if swag.IsZero(m.NvmeSubsystemInlineHosts) { // not required
		return nil
	}

	for i := 0; i < len(m.NvmeSubsystemInlineHosts); i++ {
		if swag.IsZero(m.NvmeSubsystemInlineHosts[i]) { // not required
			continue
		}

		if m.NvmeSubsystemInlineHosts[i] != nil {
			if err := m.NvmeSubsystemInlineHosts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NvmeSubsystem) validateNvmeSubsystemInlineSubsystemMaps(formats strfmt.Registry) error {
	if swag.IsZero(m.NvmeSubsystemInlineSubsystemMaps) { // not required
		return nil
	}

	for i := 0; i < len(m.NvmeSubsystemInlineSubsystemMaps); i++ {
		if swag.IsZero(m.NvmeSubsystemInlineSubsystemMaps[i]) { // not required
			continue
		}

		if m.NvmeSubsystemInlineSubsystemMaps[i] != nil {
			if err := m.NvmeSubsystemInlineSubsystemMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subsystem_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nvmeSubsystemTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemTypeOsTypePropEnum = append(nvmeSubsystemTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem
	// NvmeSubsystem
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// NvmeSubsystemOsTypeAix captures enum value "aix"
	NvmeSubsystemOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// nvme_subsystem
	// NvmeSubsystem
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// NvmeSubsystemOsTypeLinux captures enum value "linux"
	NvmeSubsystemOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// nvme_subsystem
	// NvmeSubsystem
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// NvmeSubsystemOsTypeVmware captures enum value "vmware"
	NvmeSubsystemOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// nvme_subsystem
	// NvmeSubsystem
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// NvmeSubsystemOsTypeWindows captures enum value "windows"
	NvmeSubsystemOsTypeWindows string = "windows"
)

// prop value enum
func (m *NvmeSubsystem) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystem) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystem) validateReplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Replication) { // not required
		return nil
	}

	if m.Replication != nil {
		if err := m.Replication.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystem) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *m.SerialNumber, 20); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *m.SerialNumber, 20); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystem) validateTargetNqn(formats strfmt.Registry) error {
	if swag.IsZero(m.TargetNqn) { // not required
		return nil
	}

	if err := validate.MinLength("target_nqn", "body", *m.TargetNqn, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("target_nqn", "body", *m.TargetNqn, 223); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem based on the context it is used
func (m *NvmeSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIoQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvmeSubsystemInlineHosts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvmeSubsystemInlineSubsystemMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetNqn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystem) contextValidateIoQueue(ctx context.Context, formats strfmt.Registry) error {

	if m.IoQueue != nil {
		if err := m.IoQueue.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystem) contextValidateNvmeSubsystemInlineHosts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NvmeSubsystemInlineHosts); i++ {

		if m.NvmeSubsystemInlineHosts[i] != nil {
			if err := m.NvmeSubsystemInlineHosts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NvmeSubsystem) contextValidateNvmeSubsystemInlineSubsystemMaps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_maps", "body", []*NvmeSubsystemInlineSubsystemMapsInlineArrayItem(m.NvmeSubsystemInlineSubsystemMaps)); err != nil {
		return err
	}

	for i := 0; i < len(m.NvmeSubsystemInlineSubsystemMaps); i++ {

		if m.NvmeSubsystemInlineSubsystemMaps[i] != nil {
			if err := m.NvmeSubsystemInlineSubsystemMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subsystem_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NvmeSubsystem) contextValidateReplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Replication != nil {
		if err := m.Replication.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystem) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystem) contextValidateTargetNqn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "target_nqn", "body", m.TargetNqn); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineHostsInlineArrayItem nvme subsystem inline hosts inline array item
//
// swagger:model nvme_subsystem_inline_hosts_inline_array_item
type NvmeSubsystemInlineHostsInlineArrayItem struct {

	// links
	Links *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// dh hmac chap
	DhHmacChap *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target.
	//
	// Example: nqn.1992-01.example.com:string
	Nqn *string `json:"nqn,omitempty"`

	// The host priority setting allocates appropriate NVMe I/O queues (count and depth) for the host to submit I/O commands. Absence of this property in GET implies user configured values of I/O queue count and I/O queue depth are being used.
	//
	// Enum: ["regular","high"]
	Priority *string `json:"priority,omitempty"`

	// proximity
	Proximity *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity `json:"proximity,omitempty"`

	// tls
	TLS *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS `json:"tls,omitempty"`
}

// Validate validates this nvme subsystem inline hosts inline array item
func (m *NvmeSubsystemInlineHostsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePriority(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(m.DhHmacChap) { // not required
		return nil
	}

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemTypePriorityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemTypePriorityPropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemTypePriorityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item
	// NvmeSubsystemInlineHostsInlineArrayItem
	// priority
	// Priority
	// regular
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemPriorityRegular captures enum value "regular"
	NvmeSubsystemInlineHostsInlineArrayItemPriorityRegular string = "regular"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item
	// NvmeSubsystemInlineHostsInlineArrayItem
	// priority
	// Priority
	// high
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemPriorityHigh captures enum value "high"
	NvmeSubsystemInlineHostsInlineArrayItemPriorityHigh string = "high"
)

// prop value enum
func (m *NvmeSubsystemInlineHostsInlineArrayItem) validatePriorityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemTypePriorityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) validatePriority(formats strfmt.Registry) error {
	if swag.IsZero(m.Priority) { // not required
		return nil
	}

	// value enum
	if err := m.validatePriorityEnum("priority", "body", *m.Priority); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(m.Proximity) { // not required
		return nil
	}

	if m.Proximity != nil {
		if err := m.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(m.TLS) { // not required
		return nil
	}

	if m.TLS != nil {
		if err := m.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline hosts inline array item based on the context it is used
func (m *NvmeSubsystemInlineHostsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if m.Proximity != nil {
		if err := m.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItem) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if m.TLS != nil {
		if err := m.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap A container for the configuration of NVMe in-band authentication using the DH-HMAC-CHAP protocol for a host.
//
// swagger:model nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
type NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap struct {

	// The controller secret for NVMe in-band authentication. The value of this property is used by the NVMe host to authenticate the NVMe controller while establishing a connection. If unset, the controller is not authenticated. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a controller secret has been set for the host, but the controller secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	ControllerSecretKey *string `json:"controller_secret_key,omitempty"`

	// The Diffie-Hellman group size for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `2048_bit`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]
	GroupSize *string `json:"group_size,omitempty"`

	// The hash function for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `sha_256`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["sha_256","sha_512"]
	HashFunction *string `json:"hash_function,omitempty"`

	// The host secret for NVMe in-band authentication. The value of this property is used by the NVMe controller to authenticate the NVMe host while establishing a connection. If unset, no authentication is performed by the host or controller. This property must be supplied if any other NVMe in-band authentication properties are supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a host secret has been set for the host, but the host secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	HostSecretKey *string `json:"host_secret_key,omitempty"`

	// The expected NVMe in-band authentication mode for the host. This property is an indication of which secrets are configured for the host. When set to:
	// - none: The host has neither the host nor controller secret configured, and no authentication is performed.
	// - unidirectional: The host has a host secret configured. The controller will authenticate the host.
	// - bidirectional: The host has both a host and controller secret configured. The controller will authenticate the host and the host will authenticate the controller.
	//
	// Example: bidirectional
	// Read Only: true
	// Enum: ["none","unidirectional","bidirectional"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this nvme subsystem inline hosts inline array item inline dh hmac chap
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroupSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHashFunction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// none
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNone captures enum value "none"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 2048_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr2048Bit captures enum value "2048_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr2048Bit string = "2048_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 3072_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr3072Bit captures enum value "3072_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr3072Bit string = "3072_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 4096_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr4096Bit captures enum value "4096_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr4096Bit string = "4096_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 6144_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr6144Bit captures enum value "6144_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr6144Bit string = "6144_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 8192_bit
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr8192Bit captures enum value "8192_bit"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapGroupSizeNr8192Bit string = "8192_bit"
)

// prop value enum
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateGroupSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateGroupSize(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateGroupSizeEnum("dh_hmac_chap"+"."+"group_size", "body", *m.GroupSize); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha_256","sha_512"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_256
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapHashFunctionSha256 captures enum value "sha_256"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapHashFunctionSha256 string = "sha_256"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_512
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapHashFunctionSha512 captures enum value "sha_512"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapHashFunctionSha512 string = "sha_512"
)

// prop value enum
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateHashFunctionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateHashFunction(formats strfmt.Registry) error {
	if swag.IsZero(m.HashFunction) { // not required
		return nil
	}

	// value enum
	if err := m.validateHashFunctionEnum("dh_hmac_chap"+"."+"hash_function", "body", *m.HashFunction); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","unidirectional","bidirectional"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeModePropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// none
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeNone captures enum value "none"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// unidirectional
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeUnidirectional captures enum value "unidirectional"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeUnidirectional string = "unidirectional"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// bidirectional
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeBidirectional captures enum value "bidirectional"
	NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapModeBidirectional string = "bidirectional"
)

// prop value enum
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChapTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("dh_hmac_chap"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline hosts inline array item inline dh hmac chap based on the context it is used
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dh_hmac_chap"+"."+"mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItemInlineDhHmacChap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineHostsInlineArrayItemInlineLinks nvme subsystem inline hosts inline array item inline links
//
// swagger:model nvme_subsystem_inline_hosts_inline_array_item_inline__links
type NvmeSubsystemInlineHostsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline hosts inline array item inline links
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline hosts inline array item inline links based on the context it is used
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineHostsInlineArrayItemInlineProximity Properties that define the SVMs to which the host is proximal. This information is used to properly report active optimized and active non-optimized network paths using an NVMe controller. If no configuration has been specified for the host, the sub-object is not present in GET requests.<br/>
// These properties apply to all instances of the host in the NVMe subsystem in the SVM and its peers.
//
// swagger:model nvme_subsystem_inline_hosts_inline_array_item_inline_proximity
type NvmeSubsystemInlineHostsInlineArrayItemInlineProximity struct {

	// A boolean that indicates if the host is proximal to the SVM for which it is configured.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the host is proximal.
	//
	PeerSvms []*NvmeSubsystemHostsItems0ProximityPeerSvmsItems0 `json:"peer_svms"`
}

// Validate validates this nvme subsystem inline hosts inline array item inline proximity
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.PeerSvms); i++ {
		if swag.IsZero(m.PeerSvms[i]) { // not required
			continue
		}

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme subsystem inline hosts inline array item inline proximity based on the context it is used
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PeerSvms); i++ {

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineProximity) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItemInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostsItems0ProximityPeerSvmsItems0 A reference to an SVM peer relationship.
//
// swagger:model NvmeSubsystemHostsItems0ProximityPeerSvmsItems0
type NvmeSubsystemHostsItems0ProximityPeerSvmsItems0 struct {

	// links
	Links *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem hosts items0 proximity peer svms items0
func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem hosts items0 proximity peer svms items0 based on the context it is used
func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostsItems0ProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links nvme subsystem hosts items0 proximity peer svms items0 links
//
// swagger:model NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links
type NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem hosts items0 proximity peer svms items0 links
func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem hosts items0 proximity peer svms items0 links based on the context it is used
func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostsItems0ProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineHostsInlineArrayItemInlineTLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
// swagger:model nvme_subsystem_inline_hosts_inline_array_item_inline_tls
type NvmeSubsystemInlineHostsInlineArrayItemInlineTLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme subsystem inline hosts inline array item inline tls
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemInlineHostsInlineArrayItemInlineTlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineHostsInlineArrayItemInlineTlsTypeKeyTypePropEnum = append(nvmeSubsystemInlineHostsInlineArrayItemInlineTlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_tls
	// NvmeSubsystemInlineHostsInlineArrayItemInlineTLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineTLSKeyTypeNone captures enum value "none"
	NvmeSubsystemInlineHostsInlineArrayItemInlineTLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_hosts_inline_array_item_inline_tls
	// NvmeSubsystemInlineHostsInlineArrayItemInlineTLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeSubsystemInlineHostsInlineArrayItemInlineTLSKeyTypeConfigured captures enum value "configured"
	NvmeSubsystemInlineHostsInlineArrayItemInlineTLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineHostsInlineArrayItemInlineTlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyTypeEnum("tls"+"."+"key_type", "body", *m.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme subsystem inline hosts inline array item inline tls based on context it is used
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineHostsInlineArrayItemInlineTLS) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineHostsInlineArrayItemInlineTLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineIoQueue The properties of the submission queue used to submit I/O commands for execution by the NVMe controller.
//
// swagger:model nvme_subsystem_inline_io_queue
type NvmeSubsystemInlineIoQueue struct {

	// default
	Default *NvmeSubsystemInlineIoQueueInlineDefault `json:"default,omitempty"`
}

// Validate validates this nvme subsystem inline io queue
func (m *NvmeSubsystemInlineIoQueue) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDefault(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineIoQueue) validateDefault(formats strfmt.Registry) error {
	if swag.IsZero(m.Default) { // not required
		return nil
	}

	if m.Default != nil {
		if err := m.Default.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue" + "." + "default")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline io queue based on the context it is used
func (m *NvmeSubsystemInlineIoQueue) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDefault(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineIoQueue) contextValidateDefault(ctx context.Context, formats strfmt.Registry) error {

	if m.Default != nil {
		if err := m.Default.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue" + "." + "default")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineIoQueue) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineIoQueue) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineIoQueue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineIoQueueInlineDefault Important: Support for this field will be removed in a future release.
// The default I/O queue parameters inherited by NVMe hosts in the NVMe subsystem.
//
// swagger:model nvme_subsystem_inline_io_queue_inline_default
type NvmeSubsystemInlineIoQueueInlineDefault struct {

	// The number of host I/O queue pairs.
	//
	// Example: 4
	// Read Only: true
	// Maximum: 15
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// The host I/O queue depth.
	//
	// Example: 16
	// Read Only: true
	// Maximum: 128
	// Minimum: 16
	Depth *int64 `json:"depth,omitempty"`
}

// Validate validates this nvme subsystem inline io queue inline default
func (m *NvmeSubsystemInlineIoQueueInlineDefault) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDepth(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineIoQueueInlineDefault) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(m.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("io_queue"+"."+"default"+"."+"count", "body", *m.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("io_queue"+"."+"default"+"."+"count", "body", *m.Count, 15, false); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemInlineIoQueueInlineDefault) validateDepth(formats strfmt.Registry) error {
	if swag.IsZero(m.Depth) { // not required
		return nil
	}

	if err := validate.MinimumInt("io_queue"+"."+"default"+"."+"depth", "body", *m.Depth, 16, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("io_queue"+"."+"default"+"."+"depth", "body", *m.Depth, 128, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline io queue inline default based on the context it is used
func (m *NvmeSubsystemInlineIoQueueInlineDefault) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDepth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineIoQueueInlineDefault) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"default"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemInlineIoQueueInlineDefault) contextValidateDepth(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"default"+"."+"depth", "body", m.Depth); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineIoQueueInlineDefault) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineIoQueueInlineDefault) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineIoQueueInlineDefault
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineLinks nvme subsystem inline links
//
// swagger:model nvme_subsystem_inline__links
type NvmeSubsystemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline links
func (m *NvmeSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline links based on the context it is used
func (m *NvmeSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineReplication Properties related to subsystem replication.
//
// swagger:model nvme_subsystem_inline_replication
type NvmeSubsystemInlineReplication struct {

	// error
	Error *NvmeSubsystemInlineReplicationInlineError `json:"error,omitempty"`

	// peer subsystem
	PeerSubsystem *NvmeSubsystemInlineReplicationInlinePeerSubsystem `json:"peer_subsystem,omitempty"`

	// peer svm
	PeerSvm *NvmeSubsystemInlineReplicationInlinePeerSvm `json:"peer_svm,omitempty"`

	// The state of the replication queue associated with this subsystem. If this subsystem is not in the replication queue, the state is reported as _ok_. If this subsystem is in the replication queue, but no errors have been encountered, the state is reported as _replicating_. If this subsystem is in the replication queue and the queue is blocked by an error, the state is reported as _error_. When in the _error_ state, additional context is provided by the `replication.error` property.
	//
	// Read Only: true
	// Enum: ["ok","replicating","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this nvme subsystem inline replication
func (m *NvmeSubsystemInlineReplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeerSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeerSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplication) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineReplication) validatePeerSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSubsystem) { // not required
		return nil
	}

	if m.PeerSubsystem != nil {
		if err := m.PeerSubsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineReplication) validatePeerSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvm) { // not required
		return nil
	}

	if m.PeerSvm != nil {
		if err := m.PeerSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm")
			}
			return err
		}
	}

	return nil
}

var nvmeSubsystemInlineReplicationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","replicating","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemInlineReplicationTypeStatePropEnum = append(nvmeSubsystemInlineReplicationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_replication
	// NvmeSubsystemInlineReplication
	// state
	// State
	// ok
	// END DEBUGGING
	// NvmeSubsystemInlineReplicationStateOk captures enum value "ok"
	NvmeSubsystemInlineReplicationStateOk string = "ok"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_replication
	// NvmeSubsystemInlineReplication
	// state
	// State
	// replicating
	// END DEBUGGING
	// NvmeSubsystemInlineReplicationStateReplicating captures enum value "replicating"
	NvmeSubsystemInlineReplicationStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// nvme_subsystem_inline_replication
	// NvmeSubsystemInlineReplication
	// state
	// State
	// error
	// END DEBUGGING
	// NvmeSubsystemInlineReplicationStateError captures enum value "error"
	NvmeSubsystemInlineReplicationStateError string = "error"
)

// prop value enum
func (m *NvmeSubsystemInlineReplication) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemInlineReplicationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemInlineReplication) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("replication"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication based on the context it is used
func (m *NvmeSubsystemInlineReplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeerSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeerSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplication) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineReplication) contextValidatePeerSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.PeerSubsystem != nil {
		if err := m.PeerSubsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineReplication) contextValidatePeerSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.PeerSvm != nil {
		if err := m.PeerSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineReplication) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplication) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineReplicationInlineError Information about asynchronous errors encountered while replicating this subsystem. Subsystems within a peering relationship are replicated in the same stream, so the error reported here might be related to this subsystem or a prior replicated subsystem that is now blocking the replication of this subsystem. Both the error information and the subsystem encountering the error are reported. If the error is configuration related, it can be corrected on the referenced subsystem. The replication is retried using exponential backoff up to a maximum of one retry every 5 minutes. Every operation on the same stream triggers an immediate retry and restarts the exponential backoff starting with a 1 second delay. If the error is system related, the retries should correct the error when the system enters a healthy state.
//
// swagger:model nvme_subsystem_inline_replication_inline_error
type NvmeSubsystemInlineReplicationInlineError struct {

	// subsystem
	Subsystem *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem `json:"subsystem,omitempty"`

	// summary
	Summary *NvmeSubsystemInlineReplicationInlineErrorInlineSummary `json:"summary,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline error
func (m *NvmeSubsystemInlineReplicationInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineError) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineError) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(m.Summary) { // not required
		return nil
	}

	if m.Summary != nil {
		if err := m.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline error based on the context it is used
func (m *NvmeSubsystemInlineReplicationInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineError) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineError) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if m.Summary != nil {
		if err := m.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "error" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlineError) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlineError) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem An NVMe subsystem maintains configuration state and NVMe namespace access control for a set of NVMe-connected hosts.
//
// swagger:model nvme_subsystem_inline_replication_inline_error_inline_subsystem
type NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem struct {

	// Indicates whether the reported subsystem is on the local SVM or the peer SVM. When deleting a replicated subsystem, the local copy is deleted first and then the peer copy is deleted. If the error is encountered between these two operations and only the peer subsystem remains, the peer subsystem is reported and the problem might need to be corrected on the peer cluster.
	//
	// Read Only: true
	LocalSvm *bool `json:"local_svm,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline error inline subsystem
func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("replication"+"."+"error"+"."+"subsystem"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("replication"+"."+"error"+"."+"subsystem"+"."+"name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline error inline subsystem based on the context it is used
func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocalSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) contextValidateLocalSvm(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"error"+"."+"subsystem"+"."+"local_svm", "body", m.LocalSvm); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlineErrorInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineReplicationInlineErrorInlineSummary A user friendly message describing the error.
//
// swagger:model nvme_subsystem_inline_replication_inline_error_inline_summary
type NvmeSubsystemInlineReplicationInlineErrorInlineSummary struct {

	// Message arguments
	// Read Only: true
	Arguments []*ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline error inline summary
func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(m.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(m.Arguments); i++ {
		if swag.IsZero(m.Arguments[i]) { // not required
			continue
		}

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replication" + "." + "error" + "." + "summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline error inline summary based on the context it is used
func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"error"+"."+"summary"+"."+"arguments", "body", []*ErrorArguments(m.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(m.Arguments); i++ {

		if m.Arguments[i] != nil {
			if err := m.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replication" + "." + "error" + "." + "summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"error"+"."+"summary"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"error"+"."+"summary"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlineErrorInlineSummary) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlineErrorInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineReplicationInlinePeerSubsystem nvme subsystem inline replication inline peer subsystem
//
// swagger:model nvme_subsystem_inline_replication_inline_peer_subsystem
type NvmeSubsystemInlineReplicationInlinePeerSubsystem struct {

	// The unique identifier of the peer subsystem.
	//
	// Example: 1cd8a443-86d2-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline peer subsystem
func (m *NvmeSubsystemInlineReplicationInlinePeerSubsystem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline peer subsystem based on the context it is used
func (m *NvmeSubsystemInlineReplicationInlinePeerSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlinePeerSubsystem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication"+"."+"peer_subsystem"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlinePeerSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlinePeerSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlinePeerSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineReplicationInlinePeerSvm The peered SVM to which the subsystem is replicated. Subsystem are are automatically replicated when mapped to a namespace in a SnapMirror active sync relationship. When a subsystem is mapped to a namespace in an active sync relationship, the subsystem is restricted to only be mapped to namespaces that are members of the same consistency group.
//
// swagger:model nvme_subsystem_inline_replication_inline_peer_svm
type NvmeSubsystemInlineReplicationInlinePeerSvm struct {

	// links
	Links *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline peer svm
func (m *NvmeSubsystemInlineReplicationInlinePeerSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlinePeerSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline peer svm based on the context it is used
func (m *NvmeSubsystemInlineReplicationInlinePeerSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlinePeerSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlinePeerSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlinePeerSvm) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlinePeerSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks nvme subsystem inline replication inline peer svm inline links
//
// swagger:model nvme_subsystem_inline_replication_inline_peer_svm_inline__links
type NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline replication inline peer svm inline links
func (m *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline replication inline peer svm inline links based on the context it is used
func (m *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("replication" + "." + "peer_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineReplicationInlinePeerSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineSubsystemMapsInlineArrayItem An NVMe namespace mapped to the NVMe subsystem.
//
// swagger:model nvme_subsystem_inline_subsystem_maps_inline_array_item
type NvmeSubsystemInlineSubsystemMapsInlineArrayItem struct {

	// links
	Links *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPIP is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// namespace
	Namespace *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace `json:"namespace,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`
}

// Validate validates this nvme subsystem inline subsystem maps inline array item
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNamespace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) validateNamespace(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespace) { // not required
		return nil
	}

	if m.Namespace != nil {
		if err := m.Namespace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline subsystem maps inline array item based on the context it is used
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNamespace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anagrpid", "body", m.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) contextValidateNamespace(ctx context.Context, formats strfmt.Registry) error {

	if m.Namespace != nil {
		if err := m.Namespace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nsid", "body", m.Nsid); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSubsystemMapsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks nvme subsystem inline subsystem maps inline array item inline links
//
// swagger:model nvme_subsystem_inline_subsystem_maps_inline_array_item_inline__links
type NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline subsystem maps inline array item inline links
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline subsystem maps inline array item inline links based on the context it is used
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace An NVMe namespace mapped to the NVMe subsystem.
//
// swagger:model nvme_subsystem_inline_subsystem_maps_inline_array_item_inline_namespace
type NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace struct {

	// links
	Links *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe namespace.
	//
	// Example: /vol/vol1/namespace1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline subsystem maps inline array item inline namespace
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline subsystem maps inline array item inline namespace based on the context it is used
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "namespace"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "namespace"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks nvme subsystem inline subsystem maps inline array item inline namespace inline links
//
// swagger:model nvme_subsystem_inline_subsystem_maps_inline_array_item_inline_namespace_inline__links
type NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline subsystem maps inline array item inline namespace inline links
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline subsystem maps inline array item inline namespace inline links based on the context it is used
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSubsystemMapsInlineArrayItemInlineNamespaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model nvme_subsystem_inline_svm
type NvmeSubsystemInlineSvm struct {

	// links
	Links *NvmeSubsystemInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem inline svm
func (m *NvmeSubsystemInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline svm based on the context it is used
func (m *NvmeSubsystemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineSvm) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemInlineSvmInlineLinks nvme subsystem inline svm inline links
//
// swagger:model nvme_subsystem_inline_svm_inline__links
type NvmeSubsystemInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem inline svm inline links
func (m *NvmeSubsystemInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem inline svm inline links based on the context it is used
func (m *NvmeSubsystemInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
