// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeSubsystemController A Non-Volatile Memory Express (NVMe) subsystem controller represents a connection between a host and a storage solution.<br/>
// An NVMe subsystem controller is identified by the NVMe subsystem UUID and the controller ID.
//
// swagger:model nvme_subsystem_controller
type NvmeSubsystemController struct {

	// links
	Links *NvmeSubsystemControllerInlineLinks `json:"_links,omitempty"`

	// admin queue
	AdminQueue *NvmeSubsystemControllerInlineAdminQueue `json:"admin_queue,omitempty"`

	// dh hmac chap
	DhHmacChap *NvmeSubsystemControllerInlineDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// digest
	Digest *NvmeSubsystemControllerInlineDigest `json:"digest,omitempty"`

	// host
	Host *NvmeSubsystemControllerInlineHost `json:"host,omitempty"`

	// The identifier of the subsystem controller. This field consists of 4 zero-filled hexadecimal digits followed by an 'h'.
	//
	// Example: 0040h
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// interface
	Interface *NvmeSubsystemControllerInlineInterface `json:"interface,omitempty"`

	// io queue
	IoQueue *NvmeSubsystemControllerInlineIoQueue `json:"io_queue,omitempty"`

	// The keep-alive timeout value for the controller and all of its host connections, in milliseconds. <br/>
	// If the NVMe controller does not receive a keep-alive request or an I/O request within the timeout window, the NVMe controller terminates its admin queue and I/O queue connections leading to NVMe controller teardown. If the NVMe host does not receive a response to a keep-alive request or an I/O request within the timeout window, the NVMe host initiates a connection disconnect.
	//
	// Example: 1500
	// Read Only: true
	KeepAliveTimeout *int64 `json:"keep_alive_timeout,omitempty"`

	// node
	Node *NvmeSubsystemControllerInlineNode `json:"node,omitempty"`

	// subsystem
	Subsystem *NvmeSubsystemControllerInlineSubsystem `json:"subsystem,omitempty"`

	// svm
	Svm *NvmeSubsystemControllerInlineSvm `json:"svm,omitempty"`

	// tls
	TLS *NvmeSubsystemControllerInlineTLS `json:"tls,omitempty"`

	// Transport Protocol
	// Read Only: true
	// Enum: ["fc_nvme","nvme_tcp","nvme_roce"]
	TransportProtocol *string `json:"transport_protocol,omitempty"`
}

// Validate validates this nvme subsystem controller
func (m *NvmeSubsystemController) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAdminQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDigest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHost(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIoQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransportProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemController) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateAdminQueue(formats strfmt.Registry) error {
	if swag.IsZero(m.AdminQueue) { // not required
		return nil
	}

	if m.AdminQueue != nil {
		if err := m.AdminQueue.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("admin_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(m.DhHmacChap) { // not required
		return nil
	}

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateDigest(formats strfmt.Registry) error {
	if swag.IsZero(m.Digest) { // not required
		return nil
	}

	if m.Digest != nil {
		if err := m.Digest.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("digest")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateHost(formats strfmt.Registry) error {
	if swag.IsZero(m.Host) { // not required
		return nil
	}

	if m.Host != nil {
		if err := m.Host.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.Interface) { // not required
		return nil
	}

	if m.Interface != nil {
		if err := m.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateIoQueue(formats strfmt.Registry) error {
	if swag.IsZero(m.IoQueue) { // not required
		return nil
	}

	if m.IoQueue != nil {
		if err := m.IoQueue.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(m.TLS) { // not required
		return nil
	}

	if m.TLS != nil {
		if err := m.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

var nvmeSubsystemControllerTypeTransportProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc_nvme","nvme_tcp","nvme_roce"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemControllerTypeTransportProtocolPropEnum = append(nvmeSubsystemControllerTypeTransportProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_controller
	// NvmeSubsystemController
	// transport_protocol
	// TransportProtocol
	// fc_nvme
	// END DEBUGGING
	// NvmeSubsystemControllerTransportProtocolFcNvme captures enum value "fc_nvme"
	NvmeSubsystemControllerTransportProtocolFcNvme string = "fc_nvme"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller
	// NvmeSubsystemController
	// transport_protocol
	// TransportProtocol
	// nvme_tcp
	// END DEBUGGING
	// NvmeSubsystemControllerTransportProtocolNvmeTCP captures enum value "nvme_tcp"
	NvmeSubsystemControllerTransportProtocolNvmeTCP string = "nvme_tcp"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller
	// NvmeSubsystemController
	// transport_protocol
	// TransportProtocol
	// nvme_roce
	// END DEBUGGING
	// NvmeSubsystemControllerTransportProtocolNvmeRoce captures enum value "nvme_roce"
	NvmeSubsystemControllerTransportProtocolNvmeRoce string = "nvme_roce"
)

// prop value enum
func (m *NvmeSubsystemController) validateTransportProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemControllerTypeTransportProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemController) validateTransportProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.TransportProtocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateTransportProtocolEnum("transport_protocol", "body", *m.TransportProtocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller based on the context it is used
func (m *NvmeSubsystemController) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAdminQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDigest(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHost(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIoQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKeepAliveTimeout(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransportProtocol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemController) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateAdminQueue(ctx context.Context, formats strfmt.Registry) error {

	if m.AdminQueue != nil {
		if err := m.AdminQueue.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("admin_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateDigest(ctx context.Context, formats strfmt.Registry) error {

	if m.Digest != nil {
		if err := m.Digest.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("digest")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateHost(ctx context.Context, formats strfmt.Registry) error {

	if m.Host != nil {
		if err := m.Host.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.Interface != nil {
		if err := m.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateIoQueue(ctx context.Context, formats strfmt.Registry) error {

	if m.IoQueue != nil {
		if err := m.IoQueue.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateKeepAliveTimeout(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "keep_alive_timeout", "body", m.KeepAliveTimeout); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if m.TLS != nil {
		if err := m.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemController) contextValidateTransportProtocol(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "transport_protocol", "body", m.TransportProtocol); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemController) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemController) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemController
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineAdminQueue nvme subsystem controller inline admin queue
//
// swagger:model nvme_subsystem_controller_inline_admin_queue
type NvmeSubsystemControllerInlineAdminQueue struct {

	// The depth of the admin queue for the controller.
	//
	// Read Only: true
	Depth *int64 `json:"depth,omitempty"`
}

// Validate validates this nvme subsystem controller inline admin queue
func (m *NvmeSubsystemControllerInlineAdminQueue) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme subsystem controller inline admin queue based on the context it is used
func (m *NvmeSubsystemControllerInlineAdminQueue) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDepth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineAdminQueue) contextValidateDepth(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "admin_queue"+"."+"depth", "body", m.Depth); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineAdminQueue) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineAdminQueue) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineAdminQueue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineDhHmacChap A container for properties of the NVMe in-band authentication DH-HMAC-CHAP protocol used by the the host connection to the controller.
//
// swagger:model nvme_subsystem_controller_inline_dh_hmac_chap
type NvmeSubsystemControllerInlineDhHmacChap struct {

	// The Diffie-Hellman group size used for NVMe in-band authentication. This property is populated only when NVMe in-band authentication was performed for the NVMe-oF transport connection.
	//
	// Read Only: true
	// Enum: ["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]
	GroupSize *string `json:"group_size,omitempty"`

	// The hash function used for NVMe in-band authentication. This property is populated only when NVMe in-band authentication was performed for the NVMe-oF transport connection.
	//
	// Read Only: true
	// Enum: ["sha_256","sha_512"]
	HashFunction *string `json:"hash_function,omitempty"`

	// The NVMe in-band authentication mode used for the host connection. When set to:
	// - none: Neither the host nor controller was authenticated.
	// - unidirectional: The controller authenticated the host.
	// - bidirectional: The controller authenticated the host and the host authenticated the controller.
	//
	// Example: bidirectional
	// Read Only: true
	// Enum: ["none","unidirectional","bidirectional"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this nvme subsystem controller inline dh hmac chap
func (m *NvmeSubsystemControllerInlineDhHmacChap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroupSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHashFunction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemControllerInlineDhHmacChapTypeGroupSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemControllerInlineDhHmacChapTypeGroupSizePropEnum = append(nvmeSubsystemControllerInlineDhHmacChapTypeGroupSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// group_size
	// GroupSize
	// none
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapGroupSizeNone captures enum value "none"
	NvmeSubsystemControllerInlineDhHmacChapGroupSizeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// group_size
	// GroupSize
	// 2048_bit
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr2048Bit captures enum value "2048_bit"
	NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr2048Bit string = "2048_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// group_size
	// GroupSize
	// 3072_bit
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr3072Bit captures enum value "3072_bit"
	NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr3072Bit string = "3072_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// group_size
	// GroupSize
	// 4096_bit
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr4096Bit captures enum value "4096_bit"
	NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr4096Bit string = "4096_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// group_size
	// GroupSize
	// 6144_bit
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr6144Bit captures enum value "6144_bit"
	NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr6144Bit string = "6144_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// group_size
	// GroupSize
	// 8192_bit
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr8192Bit captures enum value "8192_bit"
	NvmeSubsystemControllerInlineDhHmacChapGroupSizeNr8192Bit string = "8192_bit"
)

// prop value enum
func (m *NvmeSubsystemControllerInlineDhHmacChap) validateGroupSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemControllerInlineDhHmacChapTypeGroupSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineDhHmacChap) validateGroupSize(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateGroupSizeEnum("dh_hmac_chap"+"."+"group_size", "body", *m.GroupSize); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemControllerInlineDhHmacChapTypeHashFunctionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha_256","sha_512"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemControllerInlineDhHmacChapTypeHashFunctionPropEnum = append(nvmeSubsystemControllerInlineDhHmacChapTypeHashFunctionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_256
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapHashFunctionSha256 captures enum value "sha_256"
	NvmeSubsystemControllerInlineDhHmacChapHashFunctionSha256 string = "sha_256"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_512
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapHashFunctionSha512 captures enum value "sha_512"
	NvmeSubsystemControllerInlineDhHmacChapHashFunctionSha512 string = "sha_512"
)

// prop value enum
func (m *NvmeSubsystemControllerInlineDhHmacChap) validateHashFunctionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemControllerInlineDhHmacChapTypeHashFunctionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineDhHmacChap) validateHashFunction(formats strfmt.Registry) error {
	if swag.IsZero(m.HashFunction) { // not required
		return nil
	}

	// value enum
	if err := m.validateHashFunctionEnum("dh_hmac_chap"+"."+"hash_function", "body", *m.HashFunction); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemControllerInlineDhHmacChapTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","unidirectional","bidirectional"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemControllerInlineDhHmacChapTypeModePropEnum = append(nvmeSubsystemControllerInlineDhHmacChapTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// mode
	// Mode
	// none
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapModeNone captures enum value "none"
	NvmeSubsystemControllerInlineDhHmacChapModeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// mode
	// Mode
	// unidirectional
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapModeUnidirectional captures enum value "unidirectional"
	NvmeSubsystemControllerInlineDhHmacChapModeUnidirectional string = "unidirectional"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_dh_hmac_chap
	// NvmeSubsystemControllerInlineDhHmacChap
	// mode
	// Mode
	// bidirectional
	// END DEBUGGING
	// NvmeSubsystemControllerInlineDhHmacChapModeBidirectional captures enum value "bidirectional"
	NvmeSubsystemControllerInlineDhHmacChapModeBidirectional string = "bidirectional"
)

// prop value enum
func (m *NvmeSubsystemControllerInlineDhHmacChap) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemControllerInlineDhHmacChapTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineDhHmacChap) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("dh_hmac_chap"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline dh hmac chap based on the context it is used
func (m *NvmeSubsystemControllerInlineDhHmacChap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGroupSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHashFunction(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineDhHmacChap) contextValidateGroupSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dh_hmac_chap"+"."+"group_size", "body", m.GroupSize); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineDhHmacChap) contextValidateHashFunction(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dh_hmac_chap"+"."+"hash_function", "body", m.HashFunction); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineDhHmacChap) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dh_hmac_chap"+"."+"mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineDhHmacChap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineDhHmacChap) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineDhHmacChap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineDigest Digests are properties of NVMe controllers created over the NVMe/TCP transport protocol. The usage of digests is negotiated between the host and the controller during connection setup. ONTAP enables digests only if the host requests them. The header digest is the crc32 checksum of the header portion of the NVMe/TCP PDU. The data digest is the crc32 checksum of the data portion of the NVMe/TCP PDU.<br/>
// If a digest is enabled, upon receiving an NVMe/TCP PDU, ONTAP calculates the crc32 checksum of the associated portion of the PDU and compares it with the digest value present in the transmitted PDU. If there is a mismatch, ONTAP returns an error and destroys the controller.
//
// swagger:model nvme_subsystem_controller_inline_digest
type NvmeSubsystemControllerInlineDigest struct {

	// Reports if digests are enabled for the data portion of the PDU.
	//
	// Read Only: true
	Data *bool `json:"data,omitempty"`

	// Reports if digests are enabled for the header portion of the PDU.
	//
	// Read Only: true
	Header *bool `json:"header,omitempty"`
}

// Validate validates this nvme subsystem controller inline digest
func (m *NvmeSubsystemControllerInlineDigest) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme subsystem controller inline digest based on the context it is used
func (m *NvmeSubsystemControllerInlineDigest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHeader(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineDigest) contextValidateData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "digest"+"."+"data", "body", m.Data); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineDigest) contextValidateHeader(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "digest"+"."+"header", "body", m.Header); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineDigest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineDigest) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineDigest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineHost Properties of the connected host.
//
// swagger:model nvme_subsystem_controller_inline_host
type NvmeSubsystemControllerInlineHost struct {

	// The host identifier registered with the controller.
	//
	// Example: b8546ca6097349e5b1558dc154fc073b
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// The NVMe qualified name of the host.
	//
	// Example: nqn.2014-08.org.nvmexpress:uuid:c2846cb1-89d2-4020-a3b0-71ce907b4eef
	// Read Only: true
	// Max Length: 223
	// Min Length: 1
	Nqn *string `json:"nqn,omitempty"`

	// The transport address of the host.
	//
	// Example: nn-0x20000090fae00806:pn-0x10000090fae00806
	// Read Only: true
	TransportAddress *string `json:"transport_address,omitempty"`
}

// Validate validates this nvme subsystem controller inline host
func (m *NvmeSubsystemControllerInlineHost) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNqn(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineHost) validateNqn(formats strfmt.Registry) error {
	if swag.IsZero(m.Nqn) { // not required
		return nil
	}

	if err := validate.MinLength("host"+"."+"nqn", "body", *m.Nqn, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("host"+"."+"nqn", "body", *m.Nqn, 223); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline host based on the context it is used
func (m *NvmeSubsystemControllerInlineHost) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNqn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransportAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineHost) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineHost) contextValidateNqn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host"+"."+"nqn", "body", m.Nqn); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineHost) contextValidateTransportAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "host"+"."+"transport_address", "body", m.TransportAddress); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineHost) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineHost) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineHost
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineInterface The logical interface through which the host is connected.
//
// swagger:model nvme_subsystem_controller_inline_interface
type NvmeSubsystemControllerInlineInterface struct {

	// The name of the logical interface.
	//
	// Example: lif1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The transport address of the logical interface.
	//
	// Example: nn-0x200400a0989a1c8d:pn-0x200500a0989a1c8d
	// Read Only: true
	TransportAddress *string `json:"transport_address,omitempty"`

	// The unique identifier of the logical interface.
	//
	// Example: fa1c5941-2593-11e9-94c4-00a0989a1c8e
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem controller inline interface
func (m *NvmeSubsystemControllerInlineInterface) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme subsystem controller inline interface based on the context it is used
func (m *NvmeSubsystemControllerInlineInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransportAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineInterface) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineInterface) contextValidateTransportAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"transport_address", "body", m.TransportAddress); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineInterface) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineInterface) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineIoQueue Properties of the I/O queues available to the controller.
//
// swagger:model nvme_subsystem_controller_inline_io_queue
type NvmeSubsystemControllerInlineIoQueue struct {

	// The number of I/O queues available to the controller.
	//
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The depths of the I/O queues.
	//
	Depth []*int64 `json:"depth,omitempty"`
}

// Validate validates this nvme subsystem controller inline io queue
func (m *NvmeSubsystemControllerInlineIoQueue) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this nvme subsystem controller inline io queue based on the context it is used
func (m *NvmeSubsystemControllerInlineIoQueue) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDepth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineIoQueue) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineIoQueue) contextValidateDepth(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Depth); i++ {

		if err := validate.ReadOnly(ctx, "io_queue"+"."+"depth"+"."+strconv.Itoa(i), "body", m.Depth[i]); err != nil {
			return err
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineIoQueue) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineIoQueue) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineIoQueue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineLinks nvme subsystem controller inline links
//
// swagger:model nvme_subsystem_controller_inline__links
type NvmeSubsystemControllerInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem controller inline links
func (m *NvmeSubsystemControllerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline links based on the context it is used
func (m *NvmeSubsystemControllerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineNode nvme subsystem controller inline node
//
// swagger:model nvme_subsystem_controller_inline_node
type NvmeSubsystemControllerInlineNode struct {

	// links
	Links *NvmeSubsystemControllerInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem controller inline node
func (m *NvmeSubsystemControllerInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline node based on the context it is used
func (m *NvmeSubsystemControllerInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineNode) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineNodeInlineLinks nvme subsystem controller inline node inline links
//
// swagger:model nvme_subsystem_controller_inline_node_inline__links
type NvmeSubsystemControllerInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem controller inline node inline links
func (m *NvmeSubsystemControllerInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline node inline links based on the context it is used
func (m *NvmeSubsystemControllerInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineSubsystem An NVMe subsystem maintains configuration state and NVMe namespace access control for a set of NVMe-connected hosts.
//
// swagger:model nvme_subsystem_controller_inline_subsystem
type NvmeSubsystemControllerInlineSubsystem struct {

	// links
	Links *NvmeSubsystemControllerInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem controller inline subsystem
func (m *NvmeSubsystemControllerInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("subsystem"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("subsystem"+"."+"name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline subsystem based on the context it is used
func (m *NvmeSubsystemControllerInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineSubsystemInlineLinks nvme subsystem controller inline subsystem inline links
//
// swagger:model nvme_subsystem_controller_inline_subsystem_inline__links
type NvmeSubsystemControllerInlineSubsystemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem controller inline subsystem inline links
func (m *NvmeSubsystemControllerInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline subsystem inline links based on the context it is used
func (m *NvmeSubsystemControllerInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model nvme_subsystem_controller_inline_svm
type NvmeSubsystemControllerInlineSvm struct {

	// links
	Links *NvmeSubsystemControllerInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem controller inline svm
func (m *NvmeSubsystemControllerInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline svm based on the context it is used
func (m *NvmeSubsystemControllerInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineSvm) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineSvmInlineLinks nvme subsystem controller inline svm inline links
//
// swagger:model nvme_subsystem_controller_inline_svm_inline__links
type NvmeSubsystemControllerInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem controller inline svm inline links
func (m *NvmeSubsystemControllerInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline svm inline links based on the context it is used
func (m *NvmeSubsystemControllerInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemControllerInlineTLS A container for properties that describe the encrypted NVMe/TCP transport connection between the host and the NVMe subsystem.
//
// swagger:model nvme_subsystem_controller_inline_tls
type NvmeSubsystemControllerInlineTLS struct {

	// The cipher suite used for the transport by the encrypted NVMe/TCP transport connection between the host and the NVMe subsystem. This property is populated only when encryption is in use for the transport connection.
	//
	// Example: tls_aes_128_gcm_sha256
	// Read Only: true
	// Enum: ["tls_aes_128_gcm_sha256","tls_aes_256_gcm_sha384"]
	Cipher *string `json:"cipher,omitempty"`

	// The method by which the TLS pre-shared key (PSK) was obtained when establishing the encrypted NVMe/TCP transport connection between the host and the NVMe subsystem.
	// Possible values:
	//   - `none` - TLS encryption is not configured for the host connection.
	//   - `configured` - A user supplied PSK was used for the encrypted NVMe/TCP-TLS transport connection between the host and the NVMe subsystem.
	//
	// Example: configured
	// Read Only: true
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`

	// The TLS PSK identity supplied by the host when establishing the encrypted NVMe/TCP transport connection between the host and the NVMe subsystem. This property is populated only when encryption is in use for the transport connection.
	//
	// Example: NVMe1R01 nqn.2014-08.org.nvmexpress:uuid:713b3816-f9bf-ba43-b95a-5e4bf8c726e9 nqn.1992-08.com.netapp:sn.76f9d9bfb96511eea95e005056bb72b2:subsystem.ss1 mS1A7nrooevA9ZqAM09fQzWQlB2UZRt0BE1X4vINjY0=:
	// Read Only: true
	PskIdentity *string `json:"psk_identity,omitempty"`
}

// Validate validates this nvme subsystem controller inline tls
func (m *NvmeSubsystemControllerInlineTLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCipher(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemControllerInlineTlsTypeCipherPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["tls_aes_128_gcm_sha256","tls_aes_256_gcm_sha384"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemControllerInlineTlsTypeCipherPropEnum = append(nvmeSubsystemControllerInlineTlsTypeCipherPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_tls
	// NvmeSubsystemControllerInlineTLS
	// cipher
	// Cipher
	// tls_aes_128_gcm_sha256
	// END DEBUGGING
	// NvmeSubsystemControllerInlineTLSCipherTLSAes128GcmSha256 captures enum value "tls_aes_128_gcm_sha256"
	NvmeSubsystemControllerInlineTLSCipherTLSAes128GcmSha256 string = "tls_aes_128_gcm_sha256"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_tls
	// NvmeSubsystemControllerInlineTLS
	// cipher
	// Cipher
	// tls_aes_256_gcm_sha384
	// END DEBUGGING
	// NvmeSubsystemControllerInlineTLSCipherTLSAes256GcmSha384 captures enum value "tls_aes_256_gcm_sha384"
	NvmeSubsystemControllerInlineTLSCipherTLSAes256GcmSha384 string = "tls_aes_256_gcm_sha384"
)

// prop value enum
func (m *NvmeSubsystemControllerInlineTLS) validateCipherEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemControllerInlineTlsTypeCipherPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineTLS) validateCipher(formats strfmt.Registry) error {
	if swag.IsZero(m.Cipher) { // not required
		return nil
	}

	// value enum
	if err := m.validateCipherEnum("tls"+"."+"cipher", "body", *m.Cipher); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemControllerInlineTlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemControllerInlineTlsTypeKeyTypePropEnum = append(nvmeSubsystemControllerInlineTlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_tls
	// NvmeSubsystemControllerInlineTLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeSubsystemControllerInlineTLSKeyTypeNone captures enum value "none"
	NvmeSubsystemControllerInlineTLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_controller_inline_tls
	// NvmeSubsystemControllerInlineTLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeSubsystemControllerInlineTLSKeyTypeConfigured captures enum value "configured"
	NvmeSubsystemControllerInlineTLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (m *NvmeSubsystemControllerInlineTLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemControllerInlineTlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineTLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyTypeEnum("tls"+"."+"key_type", "body", *m.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem controller inline tls based on the context it is used
func (m *NvmeSubsystemControllerInlineTLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCipher(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateKeyType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePskIdentity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemControllerInlineTLS) contextValidateCipher(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tls"+"."+"cipher", "body", m.Cipher); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineTLS) contextValidateKeyType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tls"+"."+"key_type", "body", m.KeyType); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemControllerInlineTLS) contextValidatePskIdentity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tls"+"."+"psk_identity", "body", m.PskIdentity); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineTLS) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemControllerInlineTLS) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemControllerInlineTLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
