// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeSubsystemHost The NVMe host provisioned to access NVMe namespaces mapped to a subsystem.
//
// swagger:model nvme_subsystem_host
type NvmeSubsystemHost struct {

	// links
	Links *NvmeSubsystemHostInlineLinks `json:"_links,omitempty"`

	// dh hmac chap
	DhHmacChap *NvmeSubsystemHostInlineDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// io queue
	IoQueue *NvmeSubsystemHostInlineIoQueue `json:"io_queue,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target.
	//
	// Example: nqn.1992-01.example.com:string
	Nqn *string `json:"nqn,omitempty"`

	// An array of NVMe hosts specified to add multiple NVMe hosts to an NVMe subsystem in a single API call. Valid in POST only.
	//
	NvmeSubsystemHostInlineRecords []*NvmeSubsystemHostInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// The host priority setting allocates appropriate NVMe I/O queues (count and depth) for the host to submit I/O commands. Absence of this property in GET implies io_queue count and I/O queue depth are being used.
	//
	// Enum: ["regular","high"]
	Priority *string `json:"priority,omitempty"`

	// proximity
	Proximity *NvmeSubsystemHostInlineProximity `json:"proximity,omitempty"`

	// subsystem
	Subsystem *NvmeSubsystemHostInlineSubsystem `json:"subsystem,omitempty"`

	// tls
	TLS *NvmeSubsystemHostInlineTLS `json:"tls,omitempty"`
}

// Validate validates this nvme subsystem host
func (m *NvmeSubsystemHost) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIoQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvmeSubsystemHostInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePriority(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHost) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(m.DhHmacChap) { // not required
		return nil
	}

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) validateIoQueue(formats strfmt.Registry) error {
	if swag.IsZero(m.IoQueue) { // not required
		return nil
	}

	if m.IoQueue != nil {
		if err := m.IoQueue.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) validateNvmeSubsystemHostInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.NvmeSubsystemHostInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.NvmeSubsystemHostInlineRecords); i++ {
		if swag.IsZero(m.NvmeSubsystemHostInlineRecords[i]) { // not required
			continue
		}

		if m.NvmeSubsystemHostInlineRecords[i] != nil {
			if err := m.NvmeSubsystemHostInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var nvmeSubsystemHostTypePriorityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["regular","high"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostTypePriorityPropEnum = append(nvmeSubsystemHostTypePriorityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host
	// NvmeSubsystemHost
	// priority
	// Priority
	// regular
	// END DEBUGGING
	// NvmeSubsystemHostPriorityRegular captures enum value "regular"
	NvmeSubsystemHostPriorityRegular string = "regular"

	// BEGIN DEBUGGING
	// nvme_subsystem_host
	// NvmeSubsystemHost
	// priority
	// Priority
	// high
	// END DEBUGGING
	// NvmeSubsystemHostPriorityHigh captures enum value "high"
	NvmeSubsystemHostPriorityHigh string = "high"
)

// prop value enum
func (m *NvmeSubsystemHost) validatePriorityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostTypePriorityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHost) validatePriority(formats strfmt.Registry) error {
	if swag.IsZero(m.Priority) { // not required
		return nil
	}

	// value enum
	if err := m.validatePriorityEnum("priority", "body", *m.Priority); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemHost) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(m.Proximity) { // not required
		return nil
	}

	if m.Proximity != nil {
		if err := m.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(m.TLS) { // not required
		return nil
	}

	if m.TLS != nil {
		if err := m.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host based on the context it is used
func (m *NvmeSubsystemHost) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIoQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvmeSubsystemHostInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHost) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) contextValidateIoQueue(ctx context.Context, formats strfmt.Registry) error {

	if m.IoQueue != nil {
		if err := m.IoQueue.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) contextValidateNvmeSubsystemHostInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NvmeSubsystemHostInlineRecords); i++ {

		if m.NvmeSubsystemHostInlineRecords[i] != nil {
			if err := m.NvmeSubsystemHostInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NvmeSubsystemHost) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if m.Proximity != nil {
		if err := m.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHost) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if m.TLS != nil {
		if err := m.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHost) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHost) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHost
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineDhHmacChap A container for the configuration of NVMe in-band authentication using the DH-HMAC-CHAP protocol for a host.
//
// swagger:model nvme_subsystem_host_inline_dh_hmac_chap
type NvmeSubsystemHostInlineDhHmacChap struct {

	// The controller secret for NVMe in-band authentication. The value of this property is used by the NVMe host to authenticate the NVMe controller while establishing a connection. If unset, the controller is not authenticated. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a controller secret has been set for the host, but the controller secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	ControllerSecretKey *string `json:"controller_secret_key,omitempty"`

	// The Diffie-Hellman group size for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `2048_bit`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]
	GroupSize *string `json:"group_size,omitempty"`

	// The hash function for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `sha_256`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["sha_256","sha_512"]
	HashFunction *string `json:"hash_function,omitempty"`

	// The host secret for NVMe in-band authentication. The value of this property is used by the NVMe controller to authenticate the NVMe host while establishing a connection. If unset, no authentication is performed by the host or controller. This property must be supplied if any other NVMe in-band authentication properties are supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a host secret has been set for the host, but the host secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	HostSecretKey *string `json:"host_secret_key,omitempty"`

	// The expected NVMe in-band authentication mode for the host. This property is an indication of which secrets are configured for the host. When set to:
	// - none: The host has neither the host nor controller secret configured, and no authentication is performed.
	// - unidirectional: The host has a host secret configured. The controller will authenticate the host.
	// - bidirectional: The host has both a host and controller secret configured. The controller will authenticate the host and the host will authenticate the controller.
	//
	// Example: bidirectional
	// Read Only: true
	// Enum: ["none","unidirectional","bidirectional"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this nvme subsystem host inline dh hmac chap
func (m *NvmeSubsystemHostInlineDhHmacChap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroupSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHashFunction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemHostInlineDhHmacChapTypeGroupSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineDhHmacChapTypeGroupSizePropEnum = append(nvmeSubsystemHostInlineDhHmacChapTypeGroupSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNone captures enum value "none"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 2048_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr2048Bit captures enum value "2048_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr2048Bit string = "2048_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 3072_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr3072Bit captures enum value "3072_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr3072Bit string = "3072_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 4096_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr4096Bit captures enum value "4096_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr4096Bit string = "4096_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 6144_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr6144Bit captures enum value "6144_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr6144Bit string = "6144_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// group_size
	// GroupSize
	// 8192_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapGroupSizeNr8192Bit captures enum value "8192_bit"
	NvmeSubsystemHostInlineDhHmacChapGroupSizeNr8192Bit string = "8192_bit"
)

// prop value enum
func (m *NvmeSubsystemHostInlineDhHmacChap) validateGroupSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineDhHmacChapTypeGroupSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHostInlineDhHmacChap) validateGroupSize(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateGroupSizeEnum("dh_hmac_chap"+"."+"group_size", "body", *m.GroupSize); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemHostInlineDhHmacChapTypeHashFunctionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha_256","sha_512"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineDhHmacChapTypeHashFunctionPropEnum = append(nvmeSubsystemHostInlineDhHmacChapTypeHashFunctionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_256
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapHashFunctionSha256 captures enum value "sha_256"
	NvmeSubsystemHostInlineDhHmacChapHashFunctionSha256 string = "sha_256"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_512
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapHashFunctionSha512 captures enum value "sha_512"
	NvmeSubsystemHostInlineDhHmacChapHashFunctionSha512 string = "sha_512"
)

// prop value enum
func (m *NvmeSubsystemHostInlineDhHmacChap) validateHashFunctionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineDhHmacChapTypeHashFunctionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHostInlineDhHmacChap) validateHashFunction(formats strfmt.Registry) error {
	if swag.IsZero(m.HashFunction) { // not required
		return nil
	}

	// value enum
	if err := m.validateHashFunctionEnum("dh_hmac_chap"+"."+"hash_function", "body", *m.HashFunction); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemHostInlineDhHmacChapTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","unidirectional","bidirectional"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineDhHmacChapTypeModePropEnum = append(nvmeSubsystemHostInlineDhHmacChapTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// mode
	// Mode
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapModeNone captures enum value "none"
	NvmeSubsystemHostInlineDhHmacChapModeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// mode
	// Mode
	// unidirectional
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapModeUnidirectional captures enum value "unidirectional"
	NvmeSubsystemHostInlineDhHmacChapModeUnidirectional string = "unidirectional"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineDhHmacChap
	// mode
	// Mode
	// bidirectional
	// END DEBUGGING
	// NvmeSubsystemHostInlineDhHmacChapModeBidirectional captures enum value "bidirectional"
	NvmeSubsystemHostInlineDhHmacChapModeBidirectional string = "bidirectional"
)

// prop value enum
func (m *NvmeSubsystemHostInlineDhHmacChap) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineDhHmacChapTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHostInlineDhHmacChap) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("dh_hmac_chap"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline dh hmac chap based on the context it is used
func (m *NvmeSubsystemHostInlineDhHmacChap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineDhHmacChap) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dh_hmac_chap"+"."+"mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineDhHmacChap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineDhHmacChap) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineDhHmacChap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineIoQueue The properties of the submission queue used to submit I/O commands for execution by the NVMe controller.
//
// swagger:model nvme_subsystem_host_inline_io_queue
type NvmeSubsystemHostInlineIoQueue struct {

	// The number of I/O queue pairs. Absence of this property in GET implies property priority is set and platform and transport protocol specific values for I/O queue count is being used. Valid in GET only.
	//
	// Example: 4
	// Read Only: true
	// Maximum: 15
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// The I/O queue depth. Absence of this property in GET implies property priority is set and platform and transport protocol specific values for I/O queue depth is being used. Valid in GET only.
	//
	// Example: 32
	// Read Only: true
	// Maximum: 128
	// Minimum: 16
	Depth *int64 `json:"depth,omitempty"`
}

// Validate validates this nvme subsystem host inline io queue
func (m *NvmeSubsystemHostInlineIoQueue) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDepth(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineIoQueue) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(m.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("io_queue"+"."+"count", "body", *m.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("io_queue"+"."+"count", "body", *m.Count, 15, false); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemHostInlineIoQueue) validateDepth(formats strfmt.Registry) error {
	if swag.IsZero(m.Depth) { // not required
		return nil
	}

	if err := validate.MinimumInt("io_queue"+"."+"depth", "body", *m.Depth, 16, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("io_queue"+"."+"depth", "body", *m.Depth, 128, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline io queue based on the context it is used
func (m *NvmeSubsystemHostInlineIoQueue) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDepth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineIoQueue) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemHostInlineIoQueue) contextValidateDepth(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"depth", "body", m.Depth); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineIoQueue) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineIoQueue) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineIoQueue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineLinks nvme subsystem host inline links
//
// swagger:model nvme_subsystem_host_inline__links
type NvmeSubsystemHostInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host inline links
func (m *NvmeSubsystemHostInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline links based on the context it is used
func (m *NvmeSubsystemHostInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineProximity Properties that define the SVMs to which the host is proximal. This information is used to properly report active optimized and active non-optimized network paths using an NVMe controller. If no configuration has been specified for the host, the sub-object is not present in GET requests.<br/>
// These properties apply to all instances of the host in the NVMe subsystem in the SVM and its peers.
//
// swagger:model nvme_subsystem_host_inline_proximity
type NvmeSubsystemHostInlineProximity struct {

	// A boolean that indicates if the host is proximal to the SVM for which it is configured.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the host is proximal.
	//
	PeerSvms []*NvmeSubsystemHostProximityPeerSvmsItems0 `json:"peer_svms,omitempty"`
}

// Validate validates this nvme subsystem host inline proximity
func (m *NvmeSubsystemHostInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.PeerSvms); i++ {
		if swag.IsZero(m.PeerSvms[i]) { // not required
			continue
		}

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline proximity based on the context it is used
func (m *NvmeSubsystemHostInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PeerSvms); i++ {

		if m.PeerSvms[i] != nil {
			if err := m.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineProximity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineProximity) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostProximityPeerSvmsItems0 A reference to an SVM peer relationship.
//
// swagger:model NvmeSubsystemHostProximityPeerSvmsItems0
type NvmeSubsystemHostProximityPeerSvmsItems0 struct {

	// links
	Links *NvmeSubsystemHostProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem host proximity peer svms items0
func (m *NvmeSubsystemHostProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host proximity peer svms items0 based on the context it is used
func (m *NvmeSubsystemHostProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostProximityPeerSvmsItems0Links nvme subsystem host proximity peer svms items0 links
//
// swagger:model NvmeSubsystemHostProximityPeerSvmsItems0Links
type NvmeSubsystemHostProximityPeerSvmsItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host proximity peer svms items0 links
func (m *NvmeSubsystemHostProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host proximity peer svms items0 links based on the context it is used
func (m *NvmeSubsystemHostProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineRecordsInlineArrayItem The NVMe host provisioned to access NVMe namespaces mapped to a subsystem.
//
// swagger:model nvme_subsystem_host_inline_records_inline_array_item
type NvmeSubsystemHostInlineRecordsInlineArrayItem struct {

	// links
	Links *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// dh hmac chap
	DhHmacChap *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap `json:"dh_hmac_chap,omitempty"`

	// io queue
	IoQueue *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue `json:"io_queue,omitempty"`

	// The NVMe qualified name (NQN) used to identify the NVMe storage target. Not allowed in POST when the `records` property is used.
	//
	// Example: nqn.1992-01.example.com:string
	Nqn *string `json:"nqn,omitempty"`

	// subsystem
	Subsystem *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem `json:"subsystem,omitempty"`

	// tls
	TLS *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS `json:"tls,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDhHmacChap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIoQueue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateDhHmacChap(formats strfmt.Registry) error {
	if swag.IsZero(m.DhHmacChap) { // not required
		return nil
	}

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateIoQueue(formats strfmt.Registry) error {
	if swag.IsZero(m.IoQueue) { // not required
		return nil
	}

	if m.IoQueue != nil {
		if err := m.IoQueue.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) validateTLS(formats strfmt.Registry) error {
	if swag.IsZero(m.TLS) { // not required
		return nil
	}

	if m.TLS != nil {
		if err := m.TLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item based on the context it is used
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDhHmacChap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIoQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateDhHmacChap(ctx context.Context, formats strfmt.Registry) error {

	if m.DhHmacChap != nil {
		if err := m.DhHmacChap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dh_hmac_chap")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateIoQueue(ctx context.Context, formats strfmt.Registry) error {

	if m.IoQueue != nil {
		if err := m.IoQueue.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("io_queue")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) contextValidateTLS(ctx context.Context, formats strfmt.Registry) error {

	if m.TLS != nil {
		if err := m.TLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap A container for the configuration of NVMe in-band authentication using the DH-HMAC-CHAP protocol for a host.
//
// swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap struct {

	// The controller secret for NVMe in-band authentication. The value of this property is used by the NVMe host to authenticate the NVMe controller while establishing a connection. If unset, the controller is not authenticated. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a controller secret has been set for the host, but the controller secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	ControllerSecretKey *string `json:"controller_secret_key,omitempty"`

	// The Diffie-Hellman group size for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `2048_bit`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]
	GroupSize *string `json:"group_size,omitempty"`

	// The hash function for NVMe in-band authentication. When property `host_secret_key` is provided, this property defaults to `sha_256`. When supplied, the property `host_secret_key` must also be supplied. Optional in POST.
	//
	// Enum: ["sha_256","sha_512"]
	HashFunction *string `json:"hash_function,omitempty"`

	// The host secret for NVMe in-band authentication. The value of this property is used by the NVMe controller to authenticate the NVMe host while establishing a connection. If unset, no authentication is performed by the host or controller. This property must be supplied if any other NVMe in-band authentication properties are supplied. Optional in POST.<br/>
	// This property is write-only. The `mode` property can be used to identify if a host secret has been set for the host, but the host secret value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: DHHC-1:00:ia6zGodOr4SEG0Zzaw398rpY0wqipUWj4jWjUh4HWUz6aQ2n:
	HostSecretKey *string `json:"host_secret_key,omitempty"`

	// The expected NVMe in-band authentication mode for the host. This property is an indication of which secrets are configured for the host. When set to:
	// - none: The host has neither the host nor controller secret configured, and no authentication is performed.
	// - unidirectional: The host has a host secret configured. The controller will authenticate the host.
	// - bidirectional: The host has both a host and controller secret configured. The controller will authenticate the host and the host will authenticate the controller.
	//
	// Example: bidirectional
	// Read Only: true
	// Enum: ["none","unidirectional","bidirectional"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline dh hmac chap
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroupSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHashFunction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","2048_bit","3072_bit","4096_bit","6144_bit","8192_bit"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum = append(nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNone captures enum value "none"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 2048_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr2048Bit captures enum value "2048_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr2048Bit string = "2048_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 3072_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr3072Bit captures enum value "3072_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr3072Bit string = "3072_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 4096_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr4096Bit captures enum value "4096_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr4096Bit string = "4096_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 6144_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr6144Bit captures enum value "6144_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr6144Bit string = "6144_bit"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// group_size
	// GroupSize
	// 8192_bit
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr8192Bit captures enum value "8192_bit"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapGroupSizeNr8192Bit string = "8192_bit"
)

// prop value enum
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateGroupSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeGroupSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateGroupSize(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateGroupSizeEnum("dh_hmac_chap"+"."+"group_size", "body", *m.GroupSize); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sha_256","sha_512"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum = append(nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_256
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapHashFunctionSha256 captures enum value "sha_256"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapHashFunctionSha256 string = "sha_256"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// hash_function
	// HashFunction
	// sha_512
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapHashFunctionSha512 captures enum value "sha_512"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapHashFunctionSha512 string = "sha_512"
)

// prop value enum
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateHashFunctionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeHashFunctionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateHashFunction(formats strfmt.Registry) error {
	if swag.IsZero(m.HashFunction) { // not required
		return nil
	}

	// value enum
	if err := m.validateHashFunctionEnum("dh_hmac_chap"+"."+"hash_function", "body", *m.HashFunction); err != nil {
		return err
	}

	return nil
}

var nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","unidirectional","bidirectional"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeModePropEnum = append(nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeNone captures enum value "none"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// unidirectional
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeUnidirectional captures enum value "unidirectional"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeUnidirectional string = "unidirectional"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_dh_hmac_chap
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	// mode
	// Mode
	// bidirectional
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeBidirectional captures enum value "bidirectional"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapModeBidirectional string = "bidirectional"
)

// prop value enum
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChapTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("dh_hmac_chap"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline dh hmac chap based on the context it is used
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dh_hmac_chap"+"."+"mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineDhHmacChap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue The properties of the submission queue used to submit I/O commands for execution by the NVMe controller.
//
// swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_io_queue
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue struct {

	// The number of I/O queue pairs. The default value is inherited from the owning NVMe subsystem.
	//
	// Example: 4
	// Read Only: true
	// Maximum: 15
	// Minimum: 1
	Count *int64 `json:"count,omitempty"`

	// The I/O queue depth. The default value is inherited from the owning NVMe subsystem.
	//
	// Example: 32
	// Read Only: true
	// Maximum: 128
	// Minimum: 16
	Depth *int64 `json:"depth,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline io queue
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDepth(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) validateCount(formats strfmt.Registry) error {
	if swag.IsZero(m.Count) { // not required
		return nil
	}

	if err := validate.MinimumInt("io_queue"+"."+"count", "body", *m.Count, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("io_queue"+"."+"count", "body", *m.Count, 15, false); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) validateDepth(formats strfmt.Registry) error {
	if swag.IsZero(m.Depth) { // not required
		return nil
	}

	if err := validate.MinimumInt("io_queue"+"."+"depth", "body", *m.Depth, 16, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("io_queue"+"."+"depth", "body", *m.Depth, 128, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline io queue based on the context it is used
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDepth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) contextValidateDepth(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "io_queue"+"."+"depth", "body", m.Depth); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineIoQueue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks nvme subsystem host inline records inline array item inline links
//
// swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline__links
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline links
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline links based on the context it is used
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem The NVMe subsystem to which the NVMe host has been provisioned.
//
// swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_subsystem
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem struct {

	// links
	Links *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Read Only: true
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline subsystem
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("subsystem"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("subsystem"+"."+"name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline subsystem based on the context it is used
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks nvme subsystem host inline records inline array item inline subsystem inline links
//
// swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_subsystem_inline__links
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline subsystem inline links
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline records inline array item inline subsystem inline links based on the context it is used
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
// swagger:model nvme_subsystem_host_inline_records_inline_array_item_inline_tls
type NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme subsystem host inline records inline array item inline tls
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemHostInlineRecordsInlineArrayItemInlineTlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineRecordsInlineArrayItemInlineTlsTypeKeyTypePropEnum = append(nvmeSubsystemHostInlineRecordsInlineArrayItemInlineTlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_tls
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLSKeyTypeNone captures enum value "none"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_records_inline_array_item_inline_tls
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLSKeyTypeConfigured captures enum value "configured"
	NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineRecordsInlineArrayItemInlineTlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyTypeEnum("tls"+"."+"key_type", "body", *m.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme subsystem host inline records inline array item inline tls based on context it is used
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineRecordsInlineArrayItemInlineTLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineSubsystem The NVMe subsystem to which the NVMe host has been provisioned.
//
// swagger:model nvme_subsystem_host_inline_subsystem
type NvmeSubsystemHostInlineSubsystem struct {

	// links
	Links *NvmeSubsystemHostInlineSubsystemInlineLinks `json:"_links,omitempty"`

	// The name of the NVMe subsystem.
	//
	// Example: subsystem1
	// Read Only: true
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the NVMe subsystem.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nvme subsystem host inline subsystem
func (m *NvmeSubsystemHostInlineSubsystem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineSubsystem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineSubsystem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("subsystem"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("subsystem"+"."+"name", "body", *m.Name, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline subsystem based on the context it is used
func (m *NvmeSubsystemHostInlineSubsystem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineSubsystem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *NvmeSubsystemHostInlineSubsystem) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *NvmeSubsystemHostInlineSubsystem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineSubsystem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineSubsystem) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineSubsystem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineSubsystemInlineLinks nvme subsystem host inline subsystem inline links
//
// swagger:model nvme_subsystem_host_inline_subsystem_inline__links
type NvmeSubsystemHostInlineSubsystemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this nvme subsystem host inline subsystem inline links
func (m *NvmeSubsystemHostInlineSubsystemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineSubsystemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nvme subsystem host inline subsystem inline links based on the context it is used
func (m *NvmeSubsystemHostInlineSubsystemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NvmeSubsystemHostInlineSubsystemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineSubsystemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineSubsystemInlineLinks) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineSubsystemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NvmeSubsystemHostInlineTLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
// swagger:model nvme_subsystem_host_inline_tls
type NvmeSubsystemHostInlineTLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme subsystem host inline tls
func (m *NvmeSubsystemHostInlineTLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeSubsystemHostInlineTlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeSubsystemHostInlineTlsTypeKeyTypePropEnum = append(nvmeSubsystemHostInlineTlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_tls
	// NvmeSubsystemHostInlineTLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeSubsystemHostInlineTLSKeyTypeNone captures enum value "none"
	NvmeSubsystemHostInlineTLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_subsystem_host_inline_tls
	// NvmeSubsystemHostInlineTLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeSubsystemHostInlineTLSKeyTypeConfigured captures enum value "configured"
	NvmeSubsystemHostInlineTLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (m *NvmeSubsystemHostInlineTLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeSubsystemHostInlineTlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeSubsystemHostInlineTLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyTypeEnum("tls"+"."+"key_type", "body", *m.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme subsystem host inline tls based on context it is used
func (m *NvmeSubsystemHostInlineTLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineTLS) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeSubsystemHostInlineTLS) UnmarshalBinary(b []byte) error {
	var res NvmeSubsystemHostInlineTLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
