// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NvmeTCPTLS A container for the configuration for NVMe/TCP-TLS transport session for the host.
//
// swagger:model nvme_tcp_tls
type NvmeTCPTLS struct {

	// A user supplied pre-shared key (PSK) value in PSK Interchange Format. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree. This property is only allowed when `key_type` is `configured`. If `configured_psk` is supplied and `key_type` is unset, `key_type` defaults to `configured`.</br>
	// This property is write-only. The `key_type` property can be used to identify if a configured PSK has been set for the host, but the PSK value cannot be read. To change the value, the host must be deleted from the subsystem and re-added.
	//
	// Example: NVMeTLSkey-1:01:VRLbtnN9AQb2WXW3c9+wEf/DRLz0QuLdbYvEhwtdWwNf9LrZ:
	ConfiguredPsk *string `json:"configured_psk,omitempty"`

	// The method by which the TLS pre-shared key (PSK) is configured for the host. Optional in POST.</br>
	// The values for property `key_type` and property `configured_psk` must logically agree.</br>
	// Possible values:
	// - `none` - TLS is not configured for the host connection. No value is allowed for property `configured_psk`.
	// - `configured` - A user supplied PSK is configured for the NVMe/TCP-TLS transport connection between the host and the NVMe subsystem. A valid value for property `configured_psk` is required.
	// </br>
	// This property defaults to `none` unless a value is supplied for `configured_psk` in which case it defaults to `configured`.
	//
	// Example: configured
	// Enum: ["none","configured"]
	KeyType *string `json:"key_type,omitempty"`
}

// Validate validates this nvme tcp tls
func (m *NvmeTCPTLS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKeyType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var nvmeTcpTlsTypeKeyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","configured"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		nvmeTcpTlsTypeKeyTypePropEnum = append(nvmeTcpTlsTypeKeyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// nvme_tcp_tls
	// NvmeTCPTLS
	// key_type
	// KeyType
	// none
	// END DEBUGGING
	// NvmeTCPTLSKeyTypeNone captures enum value "none"
	NvmeTCPTLSKeyTypeNone string = "none"

	// BEGIN DEBUGGING
	// nvme_tcp_tls
	// NvmeTCPTLS
	// key_type
	// KeyType
	// configured
	// END DEBUGGING
	// NvmeTCPTLSKeyTypeConfigured captures enum value "configured"
	NvmeTCPTLSKeyTypeConfigured string = "configured"
)

// prop value enum
func (m *NvmeTCPTLS) validateKeyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, nvmeTcpTlsTypeKeyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *NvmeTCPTLS) validateKeyType(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeyTypeEnum("key_type", "body", *m.KeyType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this nvme tcp tls based on context it is used
func (m *NvmeTCPTLS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NvmeTCPTLS) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NvmeTCPTLS) UnmarshalBinary(b []byte) error {
	var res NvmeTCPTLS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
