// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OracleOnNfs Oracle using NFS.
//
// swagger:model oracle_on_nfs
type OracleOnNfs struct {

	// archive log
	ArchiveLog *OracleOnNfsInlineArchiveLog `json:"archive_log,omitempty"`

	// db
	// Required: true
	Db *OracleOnNfsInlineDb `json:"db"`

	// ora home
	OraHome *OracleOnNfsInlineOraHome `json:"ora_home,omitempty"`

	// The list of NFS access controls. You must provide either 'host' or 'access' to enable NFS access.
	OracleOnNfsInlineNfsAccess []*AppNfsAccess `json:"nfs_access,omitempty"`

	// protection type
	ProtectionType *OracleOnNfsInlineProtectionType `json:"protection_type,omitempty"`

	// redo log
	// Required: true
	RedoLog *OracleOnNfsInlineRedoLog `json:"redo_log"`
}

// Validate validates this oracle on nfs
func (m *OracleOnNfs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArchiveLog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDb(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOraHome(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleOnNfsInlineNfsAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedoLog(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfs) validateArchiveLog(formats strfmt.Registry) error {
	if swag.IsZero(m.ArchiveLog) { // not required
		return nil
	}

	if m.ArchiveLog != nil {
		if err := m.ArchiveLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnNfs) validateDb(formats strfmt.Registry) error {

	if err := validate.Required("db", "body", m.Db); err != nil {
		return err
	}

	if m.Db != nil {
		if err := m.Db.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnNfs) validateOraHome(formats strfmt.Registry) error {
	if swag.IsZero(m.OraHome) { // not required
		return nil
	}

	if m.OraHome != nil {
		if err := m.OraHome.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnNfs) validateOracleOnNfsInlineNfsAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleOnNfsInlineNfsAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.OracleOnNfsInlineNfsAccess); i++ {
		if swag.IsZero(m.OracleOnNfsInlineNfsAccess[i]) { // not required
			continue
		}

		if m.OracleOnNfsInlineNfsAccess[i] != nil {
			if err := m.OracleOnNfsInlineNfsAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleOnNfs) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnNfs) validateRedoLog(formats strfmt.Registry) error {

	if err := validate.Required("redo_log", "body", m.RedoLog); err != nil {
		return err
	}

	if m.RedoLog != nil {
		if err := m.RedoLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on nfs based on the context it is used
func (m *OracleOnNfs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArchiveLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOraHome(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleOnNfsInlineNfsAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRedoLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfs) contextValidateArchiveLog(ctx context.Context, formats strfmt.Registry) error {

	if m.ArchiveLog != nil {
		if err := m.ArchiveLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnNfs) contextValidateDb(ctx context.Context, formats strfmt.Registry) error {

	if m.Db != nil {
		if err := m.Db.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnNfs) contextValidateOraHome(ctx context.Context, formats strfmt.Registry) error {

	if m.OraHome != nil {
		if err := m.OraHome.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnNfs) contextValidateOracleOnNfsInlineNfsAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OracleOnNfsInlineNfsAccess); i++ {

		if m.OracleOnNfsInlineNfsAccess[i] != nil {
			if err := m.OracleOnNfsInlineNfsAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleOnNfs) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnNfs) contextValidateRedoLog(ctx context.Context, formats strfmt.Registry) error {

	if m.RedoLog != nil {
		if err := m.RedoLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfs) UnmarshalBinary(b []byte) error {
	var res OracleOnNfs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineArchiveLog oracle on nfs inline archive log
//
// swagger:model oracle_on_nfs_inline_archive_log
type OracleOnNfsInlineArchiveLog struct {

	// The size of the archive log. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleOnNfsInlineArchiveLogInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle on nfs inline archive log
func (m *OracleOnNfsInlineArchiveLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfsInlineArchiveLog) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on nfs inline archive log based on the context it is used
func (m *OracleOnNfsInlineArchiveLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfsInlineArchiveLog) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineArchiveLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineArchiveLog) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineArchiveLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineArchiveLogInlineStorageService oracle on nfs inline archive log inline storage service
//
// swagger:model oracle_on_nfs_inline_archive_log_inline_storage_service
type OracleOnNfsInlineArchiveLogInlineStorageService struct {

	// The storage service of the archive log.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on nfs inline archive log inline storage service
func (m *OracleOnNfsInlineArchiveLogInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnNfsInlineArchiveLogInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnNfsInlineArchiveLogInlineStorageServiceTypeNamePropEnum = append(oracleOnNfsInlineArchiveLogInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_archive_log_inline_storage_service
	// OracleOnNfsInlineArchiveLogInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleOnNfsInlineArchiveLogInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleOnNfsInlineArchiveLogInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_archive_log_inline_storage_service
	// OracleOnNfsInlineArchiveLogInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleOnNfsInlineArchiveLogInlineStorageServiceNamePerformance captures enum value "performance"
	OracleOnNfsInlineArchiveLogInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_archive_log_inline_storage_service
	// OracleOnNfsInlineArchiveLogInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleOnNfsInlineArchiveLogInlineStorageServiceNameValue captures enum value "value"
	OracleOnNfsInlineArchiveLogInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleOnNfsInlineArchiveLogInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnNfsInlineArchiveLogInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnNfsInlineArchiveLogInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("archive_log"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on nfs inline archive log inline storage service based on context it is used
func (m *OracleOnNfsInlineArchiveLogInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineArchiveLogInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineArchiveLogInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineArchiveLogInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineDb oracle on nfs inline db
//
// swagger:model oracle_on_nfs_inline_db
type OracleOnNfsInlineDb struct {

	// The size of the database. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *OracleOnNfsInlineDbInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle on nfs inline db
func (m *OracleOnNfsInlineDb) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfsInlineDb) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("db"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnNfsInlineDb) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on nfs inline db based on the context it is used
func (m *OracleOnNfsInlineDb) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfsInlineDb) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineDb) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineDb) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineDb
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineDbInlineStorageService oracle on nfs inline db inline storage service
//
// swagger:model oracle_on_nfs_inline_db_inline_storage_service
type OracleOnNfsInlineDbInlineStorageService struct {

	// The storage service of the database.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on nfs inline db inline storage service
func (m *OracleOnNfsInlineDbInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnNfsInlineDbInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnNfsInlineDbInlineStorageServiceTypeNamePropEnum = append(oracleOnNfsInlineDbInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_db_inline_storage_service
	// OracleOnNfsInlineDbInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleOnNfsInlineDbInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleOnNfsInlineDbInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_db_inline_storage_service
	// OracleOnNfsInlineDbInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleOnNfsInlineDbInlineStorageServiceNamePerformance captures enum value "performance"
	OracleOnNfsInlineDbInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_db_inline_storage_service
	// OracleOnNfsInlineDbInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleOnNfsInlineDbInlineStorageServiceNameValue captures enum value "value"
	OracleOnNfsInlineDbInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleOnNfsInlineDbInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnNfsInlineDbInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnNfsInlineDbInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("db"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on nfs inline db inline storage service based on context it is used
func (m *OracleOnNfsInlineDbInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineDbInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineDbInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineDbInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineOraHome oracle on nfs inline ora home
//
// swagger:model oracle_on_nfs_inline_ora_home
type OracleOnNfsInlineOraHome struct {

	// The size of the ORACLE_HOME storage volume. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleOnNfsInlineOraHomeInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle on nfs inline ora home
func (m *OracleOnNfsInlineOraHome) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfsInlineOraHome) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on nfs inline ora home based on the context it is used
func (m *OracleOnNfsInlineOraHome) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfsInlineOraHome) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineOraHome) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineOraHome) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineOraHome
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineOraHomeInlineStorageService oracle on nfs inline ora home inline storage service
//
// swagger:model oracle_on_nfs_inline_ora_home_inline_storage_service
type OracleOnNfsInlineOraHomeInlineStorageService struct {

	// The storage service of the ORACLE_HOME storage volume.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on nfs inline ora home inline storage service
func (m *OracleOnNfsInlineOraHomeInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnNfsInlineOraHomeInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnNfsInlineOraHomeInlineStorageServiceTypeNamePropEnum = append(oracleOnNfsInlineOraHomeInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_ora_home_inline_storage_service
	// OracleOnNfsInlineOraHomeInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleOnNfsInlineOraHomeInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleOnNfsInlineOraHomeInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_ora_home_inline_storage_service
	// OracleOnNfsInlineOraHomeInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleOnNfsInlineOraHomeInlineStorageServiceNamePerformance captures enum value "performance"
	OracleOnNfsInlineOraHomeInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_ora_home_inline_storage_service
	// OracleOnNfsInlineOraHomeInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleOnNfsInlineOraHomeInlineStorageServiceNameValue captures enum value "value"
	OracleOnNfsInlineOraHomeInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleOnNfsInlineOraHomeInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnNfsInlineOraHomeInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnNfsInlineOraHomeInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("ora_home"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on nfs inline ora home inline storage service based on context it is used
func (m *OracleOnNfsInlineOraHomeInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineOraHomeInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineOraHomeInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineOraHomeInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineProtectionType oracle on nfs inline protection type
//
// swagger:model oracle_on_nfs_inline_protection_type
type OracleOnNfsInlineProtectionType struct {

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this oracle on nfs inline protection type
func (m *OracleOnNfsInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnNfsInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnNfsInlineProtectionTypeTypeLocalRpoPropEnum = append(oracleOnNfsInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_protection_type
	// OracleOnNfsInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// OracleOnNfsInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	OracleOnNfsInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_protection_type
	// OracleOnNfsInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// OracleOnNfsInlineProtectionTypeLocalRpoNone captures enum value "none"
	OracleOnNfsInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *OracleOnNfsInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnNfsInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnNfsInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var oracleOnNfsInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnNfsInlineProtectionTypeTypeRemoteRpoPropEnum = append(oracleOnNfsInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_protection_type
	// OracleOnNfsInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// OracleOnNfsInlineProtectionTypeRemoteRpoNone captures enum value "none"
	OracleOnNfsInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_protection_type
	// OracleOnNfsInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// OracleOnNfsInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	OracleOnNfsInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *OracleOnNfsInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnNfsInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnNfsInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on nfs inline protection type based on context it is used
func (m *OracleOnNfsInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineRedoLog oracle on nfs inline redo log
//
// swagger:model oracle_on_nfs_inline_redo_log
type OracleOnNfsInlineRedoLog struct {

	// Specifies whether the redo log group should be mirrored.
	// Enum: [false,true]
	Mirrored *bool `json:"mirrored,omitempty"`

	// The size of the redo log group. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *OracleOnNfsInlineRedoLogInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle on nfs inline redo log
func (m *OracleOnNfsInlineRedoLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMirrored(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnNfsInlineRedoLogTypeMirroredPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnNfsInlineRedoLogTypeMirroredPropEnum = append(oracleOnNfsInlineRedoLogTypeMirroredPropEnum, v)
	}
}

// prop value enum
func (m *OracleOnNfsInlineRedoLog) validateMirroredEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, oracleOnNfsInlineRedoLogTypeMirroredPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnNfsInlineRedoLog) validateMirrored(formats strfmt.Registry) error {
	if swag.IsZero(m.Mirrored) { // not required
		return nil
	}

	// value enum
	if err := m.validateMirroredEnum("redo_log"+"."+"mirrored", "body", *m.Mirrored); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnNfsInlineRedoLog) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("redo_log"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnNfsInlineRedoLog) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on nfs inline redo log based on the context it is used
func (m *OracleOnNfsInlineRedoLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnNfsInlineRedoLog) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineRedoLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineRedoLog) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineRedoLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnNfsInlineRedoLogInlineStorageService oracle on nfs inline redo log inline storage service
//
// swagger:model oracle_on_nfs_inline_redo_log_inline_storage_service
type OracleOnNfsInlineRedoLogInlineStorageService struct {

	// The storage service of the redo log group.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on nfs inline redo log inline storage service
func (m *OracleOnNfsInlineRedoLogInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnNfsInlineRedoLogInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnNfsInlineRedoLogInlineStorageServiceTypeNamePropEnum = append(oracleOnNfsInlineRedoLogInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_redo_log_inline_storage_service
	// OracleOnNfsInlineRedoLogInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleOnNfsInlineRedoLogInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleOnNfsInlineRedoLogInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_redo_log_inline_storage_service
	// OracleOnNfsInlineRedoLogInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleOnNfsInlineRedoLogInlineStorageServiceNamePerformance captures enum value "performance"
	OracleOnNfsInlineRedoLogInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_on_nfs_inline_redo_log_inline_storage_service
	// OracleOnNfsInlineRedoLogInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleOnNfsInlineRedoLogInlineStorageServiceNameValue captures enum value "value"
	OracleOnNfsInlineRedoLogInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleOnNfsInlineRedoLogInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnNfsInlineRedoLogInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnNfsInlineRedoLogInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("redo_log"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on nfs inline redo log inline storage service based on context it is used
func (m *OracleOnNfsInlineRedoLogInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnNfsInlineRedoLogInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnNfsInlineRedoLogInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleOnNfsInlineRedoLogInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
