// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OracleOnSan Oracle using SAN.
//
// swagger:model oracle_on_san
type OracleOnSan struct {

	// archive log
	ArchiveLog *OracleOnSanInlineArchiveLog `json:"archive_log,omitempty"`

	// db
	// Required: true
	Db *OracleOnSanInlineDb `json:"db"`

	// The name of the initiator group through which the contents of this application will be accessed. Modification of this parameter is a disruptive operation. All LUNs in the application component will be unmapped from the current igroup and re-mapped to the new igroup.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	IgroupName *string `json:"igroup_name"`

	// ora home
	OraHome *OracleOnSanInlineOraHome `json:"ora_home,omitempty"`

	// The list of initiator groups to create.
	// Max Items: 1
	// Min Items: 0
	OracleOnSanInlineNewIgroups []*OracleOnSanNewIgroups `json:"new_igroups,omitempty"`

	// The name of the host OS running the application.
	// Required: true
	// Enum: ["aix","hpux","hyper_v","linux","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type"`

	// protection type
	ProtectionType *OracleOnSanInlineProtectionType `json:"protection_type,omitempty"`

	// redo log
	// Required: true
	RedoLog *OracleOnSanInlineRedoLog `json:"redo_log"`
}

// Validate validates this oracle on san
func (m *OracleOnSan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArchiveLog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDb(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroupName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOraHome(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleOnSanInlineNewIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedoLog(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSan) validateArchiveLog(formats strfmt.Registry) error {
	if swag.IsZero(m.ArchiveLog) { // not required
		return nil
	}

	if m.ArchiveLog != nil {
		if err := m.ArchiveLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnSan) validateDb(formats strfmt.Registry) error {

	if err := validate.Required("db", "body", m.Db); err != nil {
		return err
	}

	if m.Db != nil {
		if err := m.Db.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnSan) validateIgroupName(formats strfmt.Registry) error {

	if err := validate.Required("igroup_name", "body", m.IgroupName); err != nil {
		return err
	}

	if err := validate.MinLength("igroup_name", "body", *m.IgroupName, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup_name", "body", *m.IgroupName, 96); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnSan) validateOraHome(formats strfmt.Registry) error {
	if swag.IsZero(m.OraHome) { // not required
		return nil
	}

	if m.OraHome != nil {
		if err := m.OraHome.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnSan) validateOracleOnSanInlineNewIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleOnSanInlineNewIgroups) { // not required
		return nil
	}

	iOracleOnSanInlineNewIgroupsSize := int64(len(m.OracleOnSanInlineNewIgroups))

	if err := validate.MinItems("new_igroups", "body", iOracleOnSanInlineNewIgroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("new_igroups", "body", iOracleOnSanInlineNewIgroupsSize, 1); err != nil {
		return err
	}

	for i := 0; i < len(m.OracleOnSanInlineNewIgroups); i++ {
		if swag.IsZero(m.OracleOnSanInlineNewIgroups[i]) { // not required
			continue
		}

		if m.OracleOnSanInlineNewIgroups[i] != nil {
			if err := m.OracleOnSanInlineNewIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var oracleOnSanTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanTypeOsTypePropEnum = append(oracleOnSanTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// OracleOnSanOsTypeAix captures enum value "aix"
	OracleOnSanOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// OracleOnSanOsTypeHpux captures enum value "hpux"
	OracleOnSanOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// OracleOnSanOsTypeHyperv captures enum value "hyper_v"
	OracleOnSanOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// OracleOnSanOsTypeLinux captures enum value "linux"
	OracleOnSanOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// OracleOnSanOsTypeSolaris captures enum value "solaris"
	OracleOnSanOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// OracleOnSanOsTypeSolarisEfi captures enum value "solaris_efi"
	OracleOnSanOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// OracleOnSanOsTypeVmware captures enum value "vmware"
	OracleOnSanOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// OracleOnSanOsTypeWindows captures enum value "windows"
	OracleOnSanOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// OracleOnSanOsTypeWindows2008 captures enum value "windows_2008"
	OracleOnSanOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// OracleOnSanOsTypeWindowsGpt captures enum value "windows_gpt"
	OracleOnSanOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// oracle_on_san
	// OracleOnSan
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// OracleOnSanOsTypeXen captures enum value "xen"
	OracleOnSanOsTypeXen string = "xen"
)

// prop value enum
func (m *OracleOnSan) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSan) validateOsType(formats strfmt.Registry) error {

	if err := validate.Required("os_type", "body", m.OsType); err != nil {
		return err
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnSan) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnSan) validateRedoLog(formats strfmt.Registry) error {

	if err := validate.Required("redo_log", "body", m.RedoLog); err != nil {
		return err
	}

	if m.RedoLog != nil {
		if err := m.RedoLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on san based on the context it is used
func (m *OracleOnSan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArchiveLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOraHome(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleOnSanInlineNewIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRedoLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSan) contextValidateArchiveLog(ctx context.Context, formats strfmt.Registry) error {

	if m.ArchiveLog != nil {
		if err := m.ArchiveLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnSan) contextValidateDb(ctx context.Context, formats strfmt.Registry) error {

	if m.Db != nil {
		if err := m.Db.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnSan) contextValidateOraHome(ctx context.Context, formats strfmt.Registry) error {

	if m.OraHome != nil {
		if err := m.OraHome.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnSan) contextValidateOracleOnSanInlineNewIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OracleOnSanInlineNewIgroups); i++ {

		if m.OracleOnSanInlineNewIgroups[i] != nil {
			if err := m.OracleOnSanInlineNewIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleOnSan) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *OracleOnSan) contextValidateRedoLog(ctx context.Context, formats strfmt.Registry) error {

	if m.RedoLog != nil {
		if err := m.RedoLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSan) UnmarshalBinary(b []byte) error {
	var res OracleOnSan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineArchiveLog oracle on san inline archive log
//
// swagger:model oracle_on_san_inline_archive_log
type OracleOnSanInlineArchiveLog struct {

	// The size of the archive log. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleOnSanInlineArchiveLogInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle on san inline archive log
func (m *OracleOnSanInlineArchiveLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanInlineArchiveLog) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on san inline archive log based on the context it is used
func (m *OracleOnSanInlineArchiveLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanInlineArchiveLog) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineArchiveLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineArchiveLog) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineArchiveLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineArchiveLogInlineStorageService oracle on san inline archive log inline storage service
//
// swagger:model oracle_on_san_inline_archive_log_inline_storage_service
type OracleOnSanInlineArchiveLogInlineStorageService struct {

	// The storage service of the archive log.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on san inline archive log inline storage service
func (m *OracleOnSanInlineArchiveLogInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnSanInlineArchiveLogInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanInlineArchiveLogInlineStorageServiceTypeNamePropEnum = append(oracleOnSanInlineArchiveLogInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san_inline_archive_log_inline_storage_service
	// OracleOnSanInlineArchiveLogInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleOnSanInlineArchiveLogInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleOnSanInlineArchiveLogInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_archive_log_inline_storage_service
	// OracleOnSanInlineArchiveLogInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleOnSanInlineArchiveLogInlineStorageServiceNamePerformance captures enum value "performance"
	OracleOnSanInlineArchiveLogInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_archive_log_inline_storage_service
	// OracleOnSanInlineArchiveLogInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleOnSanInlineArchiveLogInlineStorageServiceNameValue captures enum value "value"
	OracleOnSanInlineArchiveLogInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleOnSanInlineArchiveLogInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanInlineArchiveLogInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanInlineArchiveLogInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("archive_log"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on san inline archive log inline storage service based on context it is used
func (m *OracleOnSanInlineArchiveLogInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineArchiveLogInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineArchiveLogInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineArchiveLogInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineDb oracle on san inline db
//
// swagger:model oracle_on_san_inline_db
type OracleOnSanInlineDb struct {

	// The size of the database. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *OracleOnSanInlineDbInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle on san inline db
func (m *OracleOnSanInlineDb) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanInlineDb) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("db"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnSanInlineDb) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on san inline db based on the context it is used
func (m *OracleOnSanInlineDb) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanInlineDb) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineDb) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineDb) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineDb
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineDbInlineStorageService oracle on san inline db inline storage service
//
// swagger:model oracle_on_san_inline_db_inline_storage_service
type OracleOnSanInlineDbInlineStorageService struct {

	// The storage service of the database.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on san inline db inline storage service
func (m *OracleOnSanInlineDbInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnSanInlineDbInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanInlineDbInlineStorageServiceTypeNamePropEnum = append(oracleOnSanInlineDbInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san_inline_db_inline_storage_service
	// OracleOnSanInlineDbInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleOnSanInlineDbInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleOnSanInlineDbInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_db_inline_storage_service
	// OracleOnSanInlineDbInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleOnSanInlineDbInlineStorageServiceNamePerformance captures enum value "performance"
	OracleOnSanInlineDbInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_db_inline_storage_service
	// OracleOnSanInlineDbInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleOnSanInlineDbInlineStorageServiceNameValue captures enum value "value"
	OracleOnSanInlineDbInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleOnSanInlineDbInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanInlineDbInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanInlineDbInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("db"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on san inline db inline storage service based on context it is used
func (m *OracleOnSanInlineDbInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineDbInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineDbInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineDbInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineOraHome oracle on san inline ora home
//
// swagger:model oracle_on_san_inline_ora_home
type OracleOnSanInlineOraHome struct {

	// The size of the ORACLE_HOME storage volume. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleOnSanInlineOraHomeInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle on san inline ora home
func (m *OracleOnSanInlineOraHome) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanInlineOraHome) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on san inline ora home based on the context it is used
func (m *OracleOnSanInlineOraHome) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanInlineOraHome) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineOraHome) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineOraHome) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineOraHome
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineOraHomeInlineStorageService oracle on san inline ora home inline storage service
//
// swagger:model oracle_on_san_inline_ora_home_inline_storage_service
type OracleOnSanInlineOraHomeInlineStorageService struct {

	// The storage service of the ORACLE_HOME storage volume.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on san inline ora home inline storage service
func (m *OracleOnSanInlineOraHomeInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnSanInlineOraHomeInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanInlineOraHomeInlineStorageServiceTypeNamePropEnum = append(oracleOnSanInlineOraHomeInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san_inline_ora_home_inline_storage_service
	// OracleOnSanInlineOraHomeInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleOnSanInlineOraHomeInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleOnSanInlineOraHomeInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_ora_home_inline_storage_service
	// OracleOnSanInlineOraHomeInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleOnSanInlineOraHomeInlineStorageServiceNamePerformance captures enum value "performance"
	OracleOnSanInlineOraHomeInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_ora_home_inline_storage_service
	// OracleOnSanInlineOraHomeInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleOnSanInlineOraHomeInlineStorageServiceNameValue captures enum value "value"
	OracleOnSanInlineOraHomeInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleOnSanInlineOraHomeInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanInlineOraHomeInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanInlineOraHomeInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("ora_home"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on san inline ora home inline storage service based on context it is used
func (m *OracleOnSanInlineOraHomeInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineOraHomeInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineOraHomeInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineOraHomeInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineProtectionType oracle on san inline protection type
//
// swagger:model oracle_on_san_inline_protection_type
type OracleOnSanInlineProtectionType struct {

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this oracle on san inline protection type
func (m *OracleOnSanInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnSanInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanInlineProtectionTypeTypeLocalRpoPropEnum = append(oracleOnSanInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san_inline_protection_type
	// OracleOnSanInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// OracleOnSanInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	OracleOnSanInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_protection_type
	// OracleOnSanInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// OracleOnSanInlineProtectionTypeLocalRpoNone captures enum value "none"
	OracleOnSanInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *OracleOnSanInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var oracleOnSanInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanInlineProtectionTypeTypeRemoteRpoPropEnum = append(oracleOnSanInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san_inline_protection_type
	// OracleOnSanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// OracleOnSanInlineProtectionTypeRemoteRpoNone captures enum value "none"
	OracleOnSanInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_protection_type
	// OracleOnSanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// OracleOnSanInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	OracleOnSanInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *OracleOnSanInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on san inline protection type based on context it is used
func (m *OracleOnSanInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineRedoLog oracle on san inline redo log
//
// swagger:model oracle_on_san_inline_redo_log
type OracleOnSanInlineRedoLog struct {

	// Specifies whether the redo log group should be mirrored.
	// Enum: [false,true]
	Mirrored *bool `json:"mirrored,omitempty"`

	// The size of the redo log group. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *OracleOnSanInlineRedoLogInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle on san inline redo log
func (m *OracleOnSanInlineRedoLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMirrored(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnSanInlineRedoLogTypeMirroredPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanInlineRedoLogTypeMirroredPropEnum = append(oracleOnSanInlineRedoLogTypeMirroredPropEnum, v)
	}
}

// prop value enum
func (m *OracleOnSanInlineRedoLog) validateMirroredEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanInlineRedoLogTypeMirroredPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanInlineRedoLog) validateMirrored(formats strfmt.Registry) error {
	if swag.IsZero(m.Mirrored) { // not required
		return nil
	}

	// value enum
	if err := m.validateMirroredEnum("redo_log"+"."+"mirrored", "body", *m.Mirrored); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnSanInlineRedoLog) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("redo_log"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnSanInlineRedoLog) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle on san inline redo log based on the context it is used
func (m *OracleOnSanInlineRedoLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanInlineRedoLog) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineRedoLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineRedoLog) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineRedoLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanInlineRedoLogInlineStorageService oracle on san inline redo log inline storage service
//
// swagger:model oracle_on_san_inline_redo_log_inline_storage_service
type OracleOnSanInlineRedoLogInlineStorageService struct {

	// The storage service of the redo log group.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on san inline redo log inline storage service
func (m *OracleOnSanInlineRedoLogInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleOnSanInlineRedoLogInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanInlineRedoLogInlineStorageServiceTypeNamePropEnum = append(oracleOnSanInlineRedoLogInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san_inline_redo_log_inline_storage_service
	// OracleOnSanInlineRedoLogInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleOnSanInlineRedoLogInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleOnSanInlineRedoLogInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_redo_log_inline_storage_service
	// OracleOnSanInlineRedoLogInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleOnSanInlineRedoLogInlineStorageServiceNamePerformance captures enum value "performance"
	OracleOnSanInlineRedoLogInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_on_san_inline_redo_log_inline_storage_service
	// OracleOnSanInlineRedoLogInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleOnSanInlineRedoLogInlineStorageServiceNameValue captures enum value "value"
	OracleOnSanInlineRedoLogInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleOnSanInlineRedoLogInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanInlineRedoLogInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanInlineRedoLogInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("redo_log"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle on san inline redo log inline storage service based on context it is used
func (m *OracleOnSanInlineRedoLogInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanInlineRedoLogInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanInlineRedoLogInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleOnSanInlineRedoLogInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
