// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OracleOnSanNewIgroups The list of initiator groups to create.
//
// swagger:model oracle_on_san_new_igroups
type OracleOnSanNewIgroups struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The name of the new initiator group.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name"`

	// oracle on san new igroups inline igroups
	OracleOnSanNewIgroupsInlineIgroups []*OracleOnSanNewIgroupsInlineIgroupsInlineArrayItem `json:"igroups,omitempty"`

	// oracle on san new igroups inline initiator objects
	OracleOnSanNewIgroupsInlineInitiatorObjects []*OracleOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem `json:"initiator_objects,omitempty"`

	// oracle on san new igroups inline initiators
	OracleOnSanNewIgroupsInlineInitiators []*string `json:"initiators,omitempty"`

	// The name of the host OS accessing the application. The default value is the host OS that is running the application.
	// Enum: ["aix","hpux","hyper_v","linux","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocol of the new initiator group.
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`
}

// Validate validates this oracle on san new igroups
func (m *OracleOnSanNewIgroups) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleOnSanNewIgroupsInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleOnSanNewIgroupsInlineInitiatorObjects(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanNewIgroups) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

func (m *OracleOnSanNewIgroups) validateOracleOnSanNewIgroupsInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleOnSanNewIgroupsInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.OracleOnSanNewIgroupsInlineIgroups); i++ {
		if swag.IsZero(m.OracleOnSanNewIgroupsInlineIgroups[i]) { // not required
			continue
		}

		if m.OracleOnSanNewIgroupsInlineIgroups[i] != nil {
			if err := m.OracleOnSanNewIgroupsInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleOnSanNewIgroups) validateOracleOnSanNewIgroupsInlineInitiatorObjects(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleOnSanNewIgroupsInlineInitiatorObjects) { // not required
		return nil
	}

	for i := 0; i < len(m.OracleOnSanNewIgroupsInlineInitiatorObjects); i++ {
		if swag.IsZero(m.OracleOnSanNewIgroupsInlineInitiatorObjects[i]) { // not required
			continue
		}

		if m.OracleOnSanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.OracleOnSanNewIgroupsInlineInitiatorObjects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var oracleOnSanNewIgroupsTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanNewIgroupsTypeOsTypePropEnum = append(oracleOnSanNewIgroupsTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// OracleOnSanNewIgroupsOsTypeAix captures enum value "aix"
	OracleOnSanNewIgroupsOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// OracleOnSanNewIgroupsOsTypeHpux captures enum value "hpux"
	OracleOnSanNewIgroupsOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// OracleOnSanNewIgroupsOsTypeHyperv captures enum value "hyper_v"
	OracleOnSanNewIgroupsOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// OracleOnSanNewIgroupsOsTypeLinux captures enum value "linux"
	OracleOnSanNewIgroupsOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// OracleOnSanNewIgroupsOsTypeSolaris captures enum value "solaris"
	OracleOnSanNewIgroupsOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// OracleOnSanNewIgroupsOsTypeVmware captures enum value "vmware"
	OracleOnSanNewIgroupsOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// OracleOnSanNewIgroupsOsTypeWindows captures enum value "windows"
	OracleOnSanNewIgroupsOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// OracleOnSanNewIgroupsOsTypeXen captures enum value "xen"
	OracleOnSanNewIgroupsOsTypeXen string = "xen"
)

// prop value enum
func (m *OracleOnSanNewIgroups) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanNewIgroupsTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanNewIgroups) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var oracleOnSanNewIgroupsTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleOnSanNewIgroupsTypeProtocolPropEnum = append(oracleOnSanNewIgroupsTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// OracleOnSanNewIgroupsProtocolFcp captures enum value "fcp"
	OracleOnSanNewIgroupsProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// OracleOnSanNewIgroupsProtocolIscsi captures enum value "iscsi"
	OracleOnSanNewIgroupsProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// oracle_on_san_new_igroups
	// OracleOnSanNewIgroups
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// OracleOnSanNewIgroupsProtocolMixed captures enum value "mixed"
	OracleOnSanNewIgroupsProtocolMixed string = "mixed"
)

// prop value enum
func (m *OracleOnSanNewIgroups) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleOnSanNewIgroupsTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleOnSanNewIgroups) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this oracle on san new igroups based on the context it is used
func (m *OracleOnSanNewIgroups) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateOracleOnSanNewIgroupsInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleOnSanNewIgroupsInlineInitiatorObjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleOnSanNewIgroups) contextValidateOracleOnSanNewIgroupsInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OracleOnSanNewIgroupsInlineIgroups); i++ {

		if m.OracleOnSanNewIgroupsInlineIgroups[i] != nil {
			if err := m.OracleOnSanNewIgroupsInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleOnSanNewIgroups) contextValidateOracleOnSanNewIgroupsInlineInitiatorObjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OracleOnSanNewIgroupsInlineInitiatorObjects); i++ {

		if m.OracleOnSanNewIgroupsInlineInitiatorObjects[i] != nil {
			if err := m.OracleOnSanNewIgroupsInlineInitiatorObjects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiator_objects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanNewIgroups) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanNewIgroups) UnmarshalBinary(b []byte) error {
	var res OracleOnSanNewIgroups
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanNewIgroupsInlineIgroupsInlineArrayItem oracle on san new igroups inline igroups inline array item
//
// swagger:model oracle_on_san_new_igroups_inline_igroups_inline_array_item
type OracleOnSanNewIgroupsInlineIgroupsInlineArrayItem struct {

	// The name of an igroup to nest within a parent igroup. Mutually exclusive with initiators and initiator_objects.
	Name *string `json:"name,omitempty"`

	// The UUID of an igroup to nest within a parent igroup Usage: &lt;UUID&gt;
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this oracle on san new igroups inline igroups inline array item
func (m *OracleOnSanNewIgroupsInlineIgroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this oracle on san new igroups inline igroups inline array item based on context it is used
func (m *OracleOnSanNewIgroupsInlineIgroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanNewIgroupsInlineIgroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanNewIgroupsInlineIgroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res OracleOnSanNewIgroupsInlineIgroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem oracle on san new igroups inline initiator objects inline array item
//
// swagger:model oracle_on_san_new_igroups_inline_initiator_objects_inline_array_item
type OracleOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem struct {

	// A comment available for use by the administrator.
	Comment *string `json:"comment,omitempty"`

	// The WWPN, IQN, or Alias of the initiator. Mutually exclusive with nested igroups and the initiators array.
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle on san new igroups inline initiator objects inline array item
func (m *OracleOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this oracle on san new igroups inline initiator objects inline array item based on context it is used
func (m *OracleOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res OracleOnSanNewIgroupsInlineInitiatorObjectsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
