// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OracleRacOnNfs Oracle RAC using NFS.
//
// swagger:model oracle_rac_on_nfs
type OracleRacOnNfs struct {

	// archive log
	ArchiveLog *OracleRacOnNfsInlineArchiveLog `json:"archive_log,omitempty"`

	// db
	// Required: true
	Db *OracleRacOnNfsInlineDb `json:"db"`

	// grid binary
	GridBinary *OracleRacOnNfsInlineGridBinary `json:"grid_binary,omitempty"`

	// ora home
	OraHome *OracleRacOnNfsInlineOraHome `json:"ora_home,omitempty"`

	// oracle crs
	OracleCrs *OracleRacOnNfsInlineOracleCrs `json:"oracle_crs,omitempty"`

	// The list of NFS access controls. You must provide either 'host' or 'access' to enable NFS access.
	OracleRacOnNfsInlineNfsAccess []*AppNfsAccess `json:"nfs_access,omitempty"`

	// protection type
	ProtectionType *OracleRacOnNfsInlineProtectionType `json:"protection_type,omitempty"`

	// redo log
	// Required: true
	RedoLog *OracleRacOnNfsInlineRedoLog `json:"redo_log"`
}

// Validate validates this oracle rac on nfs
func (m *OracleRacOnNfs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArchiveLog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDb(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGridBinary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOraHome(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleCrs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleRacOnNfsInlineNfsAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedoLog(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfs) validateArchiveLog(formats strfmt.Registry) error {
	if swag.IsZero(m.ArchiveLog) { // not required
		return nil
	}

	if m.ArchiveLog != nil {
		if err := m.ArchiveLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) validateDb(formats strfmt.Registry) error {

	if err := validate.Required("db", "body", m.Db); err != nil {
		return err
	}

	if m.Db != nil {
		if err := m.Db.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) validateGridBinary(formats strfmt.Registry) error {
	if swag.IsZero(m.GridBinary) { // not required
		return nil
	}

	if m.GridBinary != nil {
		if err := m.GridBinary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("grid_binary")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) validateOraHome(formats strfmt.Registry) error {
	if swag.IsZero(m.OraHome) { // not required
		return nil
	}

	if m.OraHome != nil {
		if err := m.OraHome.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) validateOracleCrs(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleCrs) { // not required
		return nil
	}

	if m.OracleCrs != nil {
		if err := m.OracleCrs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_crs")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) validateOracleRacOnNfsInlineNfsAccess(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleRacOnNfsInlineNfsAccess) { // not required
		return nil
	}

	for i := 0; i < len(m.OracleRacOnNfsInlineNfsAccess); i++ {
		if swag.IsZero(m.OracleRacOnNfsInlineNfsAccess[i]) { // not required
			continue
		}

		if m.OracleRacOnNfsInlineNfsAccess[i] != nil {
			if err := m.OracleRacOnNfsInlineNfsAccess[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleRacOnNfs) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) validateRedoLog(formats strfmt.Registry) error {

	if err := validate.Required("redo_log", "body", m.RedoLog); err != nil {
		return err
	}

	if m.RedoLog != nil {
		if err := m.RedoLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on nfs based on the context it is used
func (m *OracleRacOnNfs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArchiveLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGridBinary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOraHome(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleCrs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleRacOnNfsInlineNfsAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRedoLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfs) contextValidateArchiveLog(ctx context.Context, formats strfmt.Registry) error {

	if m.ArchiveLog != nil {
		if err := m.ArchiveLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) contextValidateDb(ctx context.Context, formats strfmt.Registry) error {

	if m.Db != nil {
		if err := m.Db.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) contextValidateGridBinary(ctx context.Context, formats strfmt.Registry) error {

	if m.GridBinary != nil {
		if err := m.GridBinary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("grid_binary")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) contextValidateOraHome(ctx context.Context, formats strfmt.Registry) error {

	if m.OraHome != nil {
		if err := m.OraHome.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) contextValidateOracleCrs(ctx context.Context, formats strfmt.Registry) error {

	if m.OracleCrs != nil {
		if err := m.OracleCrs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_crs")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) contextValidateOracleRacOnNfsInlineNfsAccess(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OracleRacOnNfsInlineNfsAccess); i++ {

		if m.OracleRacOnNfsInlineNfsAccess[i] != nil {
			if err := m.OracleRacOnNfsInlineNfsAccess[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nfs_access" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleRacOnNfs) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnNfs) contextValidateRedoLog(ctx context.Context, formats strfmt.Registry) error {

	if m.RedoLog != nil {
		if err := m.RedoLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfs) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineArchiveLog oracle rac on nfs inline archive log
//
// swagger:model oracle_rac_on_nfs_inline_archive_log
type OracleRacOnNfsInlineArchiveLog struct {

	// The size of the archive log. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleRacOnNfsInlineArchiveLogInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on nfs inline archive log
func (m *OracleRacOnNfsInlineArchiveLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineArchiveLog) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on nfs inline archive log based on the context it is used
func (m *OracleRacOnNfsInlineArchiveLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineArchiveLog) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineArchiveLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineArchiveLog) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineArchiveLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineArchiveLogInlineStorageService oracle rac on nfs inline archive log inline storage service
//
// swagger:model oracle_rac_on_nfs_inline_archive_log_inline_storage_service
type OracleRacOnNfsInlineArchiveLogInlineStorageService struct {

	// The storage service of the archive log.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on nfs inline archive log inline storage service
func (m *OracleRacOnNfsInlineArchiveLogInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnNfsInlineArchiveLogInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineArchiveLogInlineStorageServiceTypeNamePropEnum = append(oracleRacOnNfsInlineArchiveLogInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_archive_log_inline_storage_service
	// OracleRacOnNfsInlineArchiveLogInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnNfsInlineArchiveLogInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnNfsInlineArchiveLogInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_archive_log_inline_storage_service
	// OracleRacOnNfsInlineArchiveLogInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnNfsInlineArchiveLogInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnNfsInlineArchiveLogInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_archive_log_inline_storage_service
	// OracleRacOnNfsInlineArchiveLogInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnNfsInlineArchiveLogInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnNfsInlineArchiveLogInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnNfsInlineArchiveLogInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineArchiveLogInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineArchiveLogInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("archive_log"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on nfs inline archive log inline storage service based on context it is used
func (m *OracleRacOnNfsInlineArchiveLogInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineArchiveLogInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineArchiveLogInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineArchiveLogInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineDb oracle rac on nfs inline db
//
// swagger:model oracle_rac_on_nfs_inline_db
type OracleRacOnNfsInlineDb struct {

	// The size of the database. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *OracleRacOnNfsInlineDbInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on nfs inline db
func (m *OracleRacOnNfsInlineDb) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineDb) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("db"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnNfsInlineDb) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on nfs inline db based on the context it is used
func (m *OracleRacOnNfsInlineDb) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineDb) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineDb) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineDb) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineDb
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineDbInlineStorageService oracle rac on nfs inline db inline storage service
//
// swagger:model oracle_rac_on_nfs_inline_db_inline_storage_service
type OracleRacOnNfsInlineDbInlineStorageService struct {

	// The storage service of the database.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on nfs inline db inline storage service
func (m *OracleRacOnNfsInlineDbInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnNfsInlineDbInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineDbInlineStorageServiceTypeNamePropEnum = append(oracleRacOnNfsInlineDbInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_db_inline_storage_service
	// OracleRacOnNfsInlineDbInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnNfsInlineDbInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnNfsInlineDbInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_db_inline_storage_service
	// OracleRacOnNfsInlineDbInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnNfsInlineDbInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnNfsInlineDbInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_db_inline_storage_service
	// OracleRacOnNfsInlineDbInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnNfsInlineDbInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnNfsInlineDbInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnNfsInlineDbInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineDbInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineDbInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("db"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on nfs inline db inline storage service based on context it is used
func (m *OracleRacOnNfsInlineDbInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineDbInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineDbInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineDbInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineGridBinary oracle rac on nfs inline grid binary
//
// swagger:model oracle_rac_on_nfs_inline_grid_binary
type OracleRacOnNfsInlineGridBinary struct {

	// The size of the Oracle grid binary storage volume. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleRacOnNfsInlineGridBinaryInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on nfs inline grid binary
func (m *OracleRacOnNfsInlineGridBinary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineGridBinary) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("grid_binary" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on nfs inline grid binary based on the context it is used
func (m *OracleRacOnNfsInlineGridBinary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineGridBinary) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("grid_binary" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineGridBinary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineGridBinary) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineGridBinary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineGridBinaryInlineStorageService oracle rac on nfs inline grid binary inline storage service
//
// swagger:model oracle_rac_on_nfs_inline_grid_binary_inline_storage_service
type OracleRacOnNfsInlineGridBinaryInlineStorageService struct {

	// The storage service of the Oracle grid binary storage volume.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on nfs inline grid binary inline storage service
func (m *OracleRacOnNfsInlineGridBinaryInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnNfsInlineGridBinaryInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineGridBinaryInlineStorageServiceTypeNamePropEnum = append(oracleRacOnNfsInlineGridBinaryInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_grid_binary_inline_storage_service
	// OracleRacOnNfsInlineGridBinaryInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnNfsInlineGridBinaryInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnNfsInlineGridBinaryInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_grid_binary_inline_storage_service
	// OracleRacOnNfsInlineGridBinaryInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnNfsInlineGridBinaryInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnNfsInlineGridBinaryInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_grid_binary_inline_storage_service
	// OracleRacOnNfsInlineGridBinaryInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnNfsInlineGridBinaryInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnNfsInlineGridBinaryInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnNfsInlineGridBinaryInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineGridBinaryInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineGridBinaryInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("grid_binary"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on nfs inline grid binary inline storage service based on context it is used
func (m *OracleRacOnNfsInlineGridBinaryInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineGridBinaryInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineGridBinaryInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineGridBinaryInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineOraHome oracle rac on nfs inline ora home
//
// swagger:model oracle_rac_on_nfs_inline_ora_home
type OracleRacOnNfsInlineOraHome struct {

	// The size of the ORACLE_HOME storage volume. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleRacOnNfsInlineOraHomeInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on nfs inline ora home
func (m *OracleRacOnNfsInlineOraHome) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineOraHome) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on nfs inline ora home based on the context it is used
func (m *OracleRacOnNfsInlineOraHome) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineOraHome) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineOraHome) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineOraHome) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineOraHome
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineOraHomeInlineStorageService oracle rac on nfs inline ora home inline storage service
//
// swagger:model oracle_rac_on_nfs_inline_ora_home_inline_storage_service
type OracleRacOnNfsInlineOraHomeInlineStorageService struct {

	// The storage service of the ORACLE_HOME storage volume.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on nfs inline ora home inline storage service
func (m *OracleRacOnNfsInlineOraHomeInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnNfsInlineOraHomeInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineOraHomeInlineStorageServiceTypeNamePropEnum = append(oracleRacOnNfsInlineOraHomeInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_ora_home_inline_storage_service
	// OracleRacOnNfsInlineOraHomeInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnNfsInlineOraHomeInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnNfsInlineOraHomeInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_ora_home_inline_storage_service
	// OracleRacOnNfsInlineOraHomeInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnNfsInlineOraHomeInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnNfsInlineOraHomeInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_ora_home_inline_storage_service
	// OracleRacOnNfsInlineOraHomeInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnNfsInlineOraHomeInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnNfsInlineOraHomeInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnNfsInlineOraHomeInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineOraHomeInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineOraHomeInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("ora_home"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on nfs inline ora home inline storage service based on context it is used
func (m *OracleRacOnNfsInlineOraHomeInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineOraHomeInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineOraHomeInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineOraHomeInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineOracleCrs oracle rac on nfs inline oracle crs
//
// swagger:model oracle_rac_on_nfs_inline_oracle_crs
type OracleRacOnNfsInlineOracleCrs struct {

	// The number of CRS volumes.
	// Maximum: 10
	// Minimum: 1
	Copies *int64 `json:"copies,omitempty"`

	// The size of the Oracle CRS/voting storage volume. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleRacOnNfsInlineOracleCrsInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on nfs inline oracle crs
func (m *OracleRacOnNfsInlineOracleCrs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCopies(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineOracleCrs) validateCopies(formats strfmt.Registry) error {
	if swag.IsZero(m.Copies) { // not required
		return nil
	}

	if err := validate.MinimumInt("oracle_crs"+"."+"copies", "body", *m.Copies, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("oracle_crs"+"."+"copies", "body", *m.Copies, 10, false); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnNfsInlineOracleCrs) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_crs" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on nfs inline oracle crs based on the context it is used
func (m *OracleRacOnNfsInlineOracleCrs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineOracleCrs) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_crs" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineOracleCrs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineOracleCrs) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineOracleCrs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineOracleCrsInlineStorageService oracle rac on nfs inline oracle crs inline storage service
//
// swagger:model oracle_rac_on_nfs_inline_oracle_crs_inline_storage_service
type OracleRacOnNfsInlineOracleCrsInlineStorageService struct {

	// The storage service of the Oracle CRS volume.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on nfs inline oracle crs inline storage service
func (m *OracleRacOnNfsInlineOracleCrsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnNfsInlineOracleCrsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineOracleCrsInlineStorageServiceTypeNamePropEnum = append(oracleRacOnNfsInlineOracleCrsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_oracle_crs_inline_storage_service
	// OracleRacOnNfsInlineOracleCrsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnNfsInlineOracleCrsInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnNfsInlineOracleCrsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_oracle_crs_inline_storage_service
	// OracleRacOnNfsInlineOracleCrsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnNfsInlineOracleCrsInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnNfsInlineOracleCrsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_oracle_crs_inline_storage_service
	// OracleRacOnNfsInlineOracleCrsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnNfsInlineOracleCrsInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnNfsInlineOracleCrsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnNfsInlineOracleCrsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineOracleCrsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineOracleCrsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("oracle_crs"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on nfs inline oracle crs inline storage service based on context it is used
func (m *OracleRacOnNfsInlineOracleCrsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineOracleCrsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineOracleCrsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineOracleCrsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineProtectionType oracle rac on nfs inline protection type
//
// swagger:model oracle_rac_on_nfs_inline_protection_type
type OracleRacOnNfsInlineProtectionType struct {

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this oracle rac on nfs inline protection type
func (m *OracleRacOnNfsInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnNfsInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineProtectionTypeTypeLocalRpoPropEnum = append(oracleRacOnNfsInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_protection_type
	// OracleRacOnNfsInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// OracleRacOnNfsInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	OracleRacOnNfsInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_protection_type
	// OracleRacOnNfsInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// OracleRacOnNfsInlineProtectionTypeLocalRpoNone captures enum value "none"
	OracleRacOnNfsInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *OracleRacOnNfsInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var oracleRacOnNfsInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineProtectionTypeTypeRemoteRpoPropEnum = append(oracleRacOnNfsInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_protection_type
	// OracleRacOnNfsInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// OracleRacOnNfsInlineProtectionTypeRemoteRpoNone captures enum value "none"
	OracleRacOnNfsInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_protection_type
	// OracleRacOnNfsInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// OracleRacOnNfsInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	OracleRacOnNfsInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *OracleRacOnNfsInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on nfs inline protection type based on context it is used
func (m *OracleRacOnNfsInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineRedoLog oracle rac on nfs inline redo log
//
// swagger:model oracle_rac_on_nfs_inline_redo_log
type OracleRacOnNfsInlineRedoLog struct {

	// Specifies whether the redo log group should be mirrored.
	// Enum: [false,true]
	Mirrored *bool `json:"mirrored,omitempty"`

	// The size of the redo log group. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *OracleRacOnNfsInlineRedoLogInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on nfs inline redo log
func (m *OracleRacOnNfsInlineRedoLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMirrored(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnNfsInlineRedoLogTypeMirroredPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineRedoLogTypeMirroredPropEnum = append(oracleRacOnNfsInlineRedoLogTypeMirroredPropEnum, v)
	}
}

// prop value enum
func (m *OracleRacOnNfsInlineRedoLog) validateMirroredEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineRedoLogTypeMirroredPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineRedoLog) validateMirrored(formats strfmt.Registry) error {
	if swag.IsZero(m.Mirrored) { // not required
		return nil
	}

	// value enum
	if err := m.validateMirroredEnum("redo_log"+"."+"mirrored", "body", *m.Mirrored); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnNfsInlineRedoLog) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("redo_log"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnNfsInlineRedoLog) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on nfs inline redo log based on the context it is used
func (m *OracleRacOnNfsInlineRedoLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnNfsInlineRedoLog) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineRedoLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineRedoLog) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineRedoLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnNfsInlineRedoLogInlineStorageService oracle rac on nfs inline redo log inline storage service
//
// swagger:model oracle_rac_on_nfs_inline_redo_log_inline_storage_service
type OracleRacOnNfsInlineRedoLogInlineStorageService struct {

	// The storage service of the redo log group.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on nfs inline redo log inline storage service
func (m *OracleRacOnNfsInlineRedoLogInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnNfsInlineRedoLogInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnNfsInlineRedoLogInlineStorageServiceTypeNamePropEnum = append(oracleRacOnNfsInlineRedoLogInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_redo_log_inline_storage_service
	// OracleRacOnNfsInlineRedoLogInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnNfsInlineRedoLogInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnNfsInlineRedoLogInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_redo_log_inline_storage_service
	// OracleRacOnNfsInlineRedoLogInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnNfsInlineRedoLogInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnNfsInlineRedoLogInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_nfs_inline_redo_log_inline_storage_service
	// OracleRacOnNfsInlineRedoLogInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnNfsInlineRedoLogInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnNfsInlineRedoLogInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnNfsInlineRedoLogInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnNfsInlineRedoLogInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnNfsInlineRedoLogInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("redo_log"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on nfs inline redo log inline storage service based on context it is used
func (m *OracleRacOnNfsInlineRedoLogInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnNfsInlineRedoLogInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnNfsInlineRedoLogInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnNfsInlineRedoLogInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
