// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OracleRacOnSan Oracle RAC using SAN.
//
// swagger:model oracle_rac_on_san
type OracleRacOnSan struct {

	// archive log
	ArchiveLog *OracleRacOnSanInlineArchiveLog `json:"archive_log,omitempty"`

	// db
	// Required: true
	Db *OracleRacOnSanInlineDb `json:"db"`

	// grid binary
	GridBinary *OracleRacOnSanInlineGridBinary `json:"grid_binary,omitempty"`

	// ora home
	OraHome *OracleRacOnSanInlineOraHome `json:"ora_home,omitempty"`

	// oracle crs
	OracleCrs *OracleRacOnSanInlineOracleCrs `json:"oracle_crs,omitempty"`

	// oracle rac on san inline db sids
	// Required: true
	// Max Items: 2
	// Min Items: 2
	OracleRacOnSanInlineDbSids []*OracleRacOnSanInlineDbSidsInlineArrayItem `json:"db_sids"`

	// The list of initiator groups to create.
	// Max Items: 2
	// Min Items: 0
	OracleRacOnSanInlineNewIgroups []*OracleRacOnSanNewIgroups `json:"new_igroups,omitempty"`

	// The name of the host OS running the application.
	// Required: true
	// Enum: ["aix","hpux","hyper_v","linux","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type"`

	// protection type
	ProtectionType *OracleRacOnSanInlineProtectionType `json:"protection_type,omitempty"`

	// redo log
	// Required: true
	RedoLog *OracleRacOnSanInlineRedoLog `json:"redo_log"`
}

// Validate validates this oracle rac on san
func (m *OracleRacOnSan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArchiveLog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDb(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGridBinary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOraHome(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleCrs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleRacOnSanInlineDbSids(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOracleRacOnSanInlineNewIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedoLog(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSan) validateArchiveLog(formats strfmt.Registry) error {
	if swag.IsZero(m.ArchiveLog) { // not required
		return nil
	}

	if m.ArchiveLog != nil {
		if err := m.ArchiveLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) validateDb(formats strfmt.Registry) error {

	if err := validate.Required("db", "body", m.Db); err != nil {
		return err
	}

	if m.Db != nil {
		if err := m.Db.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) validateGridBinary(formats strfmt.Registry) error {
	if swag.IsZero(m.GridBinary) { // not required
		return nil
	}

	if m.GridBinary != nil {
		if err := m.GridBinary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("grid_binary")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) validateOraHome(formats strfmt.Registry) error {
	if swag.IsZero(m.OraHome) { // not required
		return nil
	}

	if m.OraHome != nil {
		if err := m.OraHome.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) validateOracleCrs(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleCrs) { // not required
		return nil
	}

	if m.OracleCrs != nil {
		if err := m.OracleCrs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_crs")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) validateOracleRacOnSanInlineDbSids(formats strfmt.Registry) error {

	if err := validate.Required("db_sids", "body", m.OracleRacOnSanInlineDbSids); err != nil {
		return err
	}

	iOracleRacOnSanInlineDbSidsSize := int64(len(m.OracleRacOnSanInlineDbSids))

	if err := validate.MinItems("db_sids", "body", iOracleRacOnSanInlineDbSidsSize, 2); err != nil {
		return err
	}

	if err := validate.MaxItems("db_sids", "body", iOracleRacOnSanInlineDbSidsSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.OracleRacOnSanInlineDbSids); i++ {
		if swag.IsZero(m.OracleRacOnSanInlineDbSids[i]) { // not required
			continue
		}

		if m.OracleRacOnSanInlineDbSids[i] != nil {
			if err := m.OracleRacOnSanInlineDbSids[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("db_sids" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleRacOnSan) validateOracleRacOnSanInlineNewIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.OracleRacOnSanInlineNewIgroups) { // not required
		return nil
	}

	iOracleRacOnSanInlineNewIgroupsSize := int64(len(m.OracleRacOnSanInlineNewIgroups))

	if err := validate.MinItems("new_igroups", "body", iOracleRacOnSanInlineNewIgroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("new_igroups", "body", iOracleRacOnSanInlineNewIgroupsSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.OracleRacOnSanInlineNewIgroups); i++ {
		if swag.IsZero(m.OracleRacOnSanInlineNewIgroups[i]) { // not required
			continue
		}

		if m.OracleRacOnSanInlineNewIgroups[i] != nil {
			if err := m.OracleRacOnSanInlineNewIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var oracleRacOnSanTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanTypeOsTypePropEnum = append(oracleRacOnSanTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// OracleRacOnSanOsTypeAix captures enum value "aix"
	OracleRacOnSanOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// OracleRacOnSanOsTypeHpux captures enum value "hpux"
	OracleRacOnSanOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// OracleRacOnSanOsTypeHyperv captures enum value "hyper_v"
	OracleRacOnSanOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// OracleRacOnSanOsTypeLinux captures enum value "linux"
	OracleRacOnSanOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// OracleRacOnSanOsTypeSolaris captures enum value "solaris"
	OracleRacOnSanOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// OracleRacOnSanOsTypeSolarisEfi captures enum value "solaris_efi"
	OracleRacOnSanOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// OracleRacOnSanOsTypeVmware captures enum value "vmware"
	OracleRacOnSanOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// OracleRacOnSanOsTypeWindows captures enum value "windows"
	OracleRacOnSanOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// OracleRacOnSanOsTypeWindows2008 captures enum value "windows_2008"
	OracleRacOnSanOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// OracleRacOnSanOsTypeWindowsGpt captures enum value "windows_gpt"
	OracleRacOnSanOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// oracle_rac_on_san
	// OracleRacOnSan
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// OracleRacOnSanOsTypeXen captures enum value "xen"
	OracleRacOnSanOsTypeXen string = "xen"
)

// prop value enum
func (m *OracleRacOnSan) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSan) validateOsType(formats strfmt.Registry) error {

	if err := validate.Required("os_type", "body", m.OsType); err != nil {
		return err
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnSan) validateProtectionType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProtectionType) { // not required
		return nil
	}

	if m.ProtectionType != nil {
		if err := m.ProtectionType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) validateRedoLog(formats strfmt.Registry) error {

	if err := validate.Required("redo_log", "body", m.RedoLog); err != nil {
		return err
	}

	if m.RedoLog != nil {
		if err := m.RedoLog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on san based on the context it is used
func (m *OracleRacOnSan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArchiveLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGridBinary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOraHome(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleCrs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleRacOnSanInlineDbSids(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOracleRacOnSanInlineNewIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProtectionType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRedoLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSan) contextValidateArchiveLog(ctx context.Context, formats strfmt.Registry) error {

	if m.ArchiveLog != nil {
		if err := m.ArchiveLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) contextValidateDb(ctx context.Context, formats strfmt.Registry) error {

	if m.Db != nil {
		if err := m.Db.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) contextValidateGridBinary(ctx context.Context, formats strfmt.Registry) error {

	if m.GridBinary != nil {
		if err := m.GridBinary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("grid_binary")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) contextValidateOraHome(ctx context.Context, formats strfmt.Registry) error {

	if m.OraHome != nil {
		if err := m.OraHome.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) contextValidateOracleCrs(ctx context.Context, formats strfmt.Registry) error {

	if m.OracleCrs != nil {
		if err := m.OracleCrs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_crs")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) contextValidateOracleRacOnSanInlineDbSids(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OracleRacOnSanInlineDbSids); i++ {

		if m.OracleRacOnSanInlineDbSids[i] != nil {
			if err := m.OracleRacOnSanInlineDbSids[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("db_sids" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleRacOnSan) contextValidateOracleRacOnSanInlineNewIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.OracleRacOnSanInlineNewIgroups); i++ {

		if m.OracleRacOnSanInlineNewIgroups[i] != nil {
			if err := m.OracleRacOnSanInlineNewIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("new_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *OracleRacOnSan) contextValidateProtectionType(ctx context.Context, formats strfmt.Registry) error {

	if m.ProtectionType != nil {
		if err := m.ProtectionType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("protection_type")
			}
			return err
		}
	}

	return nil
}

func (m *OracleRacOnSan) contextValidateRedoLog(ctx context.Context, formats strfmt.Registry) error {

	if m.RedoLog != nil {
		if err := m.RedoLog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSan) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineArchiveLog oracle rac on san inline archive log
//
// swagger:model oracle_rac_on_san_inline_archive_log
type OracleRacOnSanInlineArchiveLog struct {

	// The size of the archive log. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleRacOnSanInlineArchiveLogInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on san inline archive log
func (m *OracleRacOnSanInlineArchiveLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineArchiveLog) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on san inline archive log based on the context it is used
func (m *OracleRacOnSanInlineArchiveLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineArchiveLog) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("archive_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineArchiveLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineArchiveLog) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineArchiveLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineArchiveLogInlineStorageService oracle rac on san inline archive log inline storage service
//
// swagger:model oracle_rac_on_san_inline_archive_log_inline_storage_service
type OracleRacOnSanInlineArchiveLogInlineStorageService struct {

	// The storage service of the archive log.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on san inline archive log inline storage service
func (m *OracleRacOnSanInlineArchiveLogInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnSanInlineArchiveLogInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineArchiveLogInlineStorageServiceTypeNamePropEnum = append(oracleRacOnSanInlineArchiveLogInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_archive_log_inline_storage_service
	// OracleRacOnSanInlineArchiveLogInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnSanInlineArchiveLogInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnSanInlineArchiveLogInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_archive_log_inline_storage_service
	// OracleRacOnSanInlineArchiveLogInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnSanInlineArchiveLogInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnSanInlineArchiveLogInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_archive_log_inline_storage_service
	// OracleRacOnSanInlineArchiveLogInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnSanInlineArchiveLogInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnSanInlineArchiveLogInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnSanInlineArchiveLogInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineArchiveLogInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineArchiveLogInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("archive_log"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on san inline archive log inline storage service based on context it is used
func (m *OracleRacOnSanInlineArchiveLogInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineArchiveLogInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineArchiveLogInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineArchiveLogInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineDb oracle rac on san inline db
//
// swagger:model oracle_rac_on_san_inline_db
type OracleRacOnSanInlineDb struct {

	// The size of the database. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *OracleRacOnSanInlineDbInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on san inline db
func (m *OracleRacOnSanInlineDb) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineDb) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("db"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnSanInlineDb) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on san inline db based on the context it is used
func (m *OracleRacOnSanInlineDb) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineDb) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("db" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineDb) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineDb) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineDb
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineDbSidsInlineArrayItem oracle rac on san inline db sids inline array item
//
// swagger:model oracle_rac_on_san_inline_db_sids_inline_array_item
type OracleRacOnSanInlineDbSidsInlineArrayItem struct {

	// The name of the initiator group through which the contents of this application will be accessed. Modification of this parameter is a disruptive operation. All LUNs in the application component will be unmapped from the current igroup and re-mapped to the new igroup.
	// Required: true
	// Max Length: 96
	// Min Length: 1
	IgroupName *string `json:"igroup_name"`
}

// Validate validates this oracle rac on san inline db sids inline array item
func (m *OracleRacOnSanInlineDbSidsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIgroupName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineDbSidsInlineArrayItem) validateIgroupName(formats strfmt.Registry) error {

	if err := validate.Required("igroup_name", "body", m.IgroupName); err != nil {
		return err
	}

	if err := validate.MinLength("igroup_name", "body", *m.IgroupName, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup_name", "body", *m.IgroupName, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on san inline db sids inline array item based on context it is used
func (m *OracleRacOnSanInlineDbSidsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineDbSidsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineDbSidsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineDbSidsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineDbInlineStorageService oracle rac on san inline db inline storage service
//
// swagger:model oracle_rac_on_san_inline_db_inline_storage_service
type OracleRacOnSanInlineDbInlineStorageService struct {

	// The storage service of the database.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on san inline db inline storage service
func (m *OracleRacOnSanInlineDbInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnSanInlineDbInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineDbInlineStorageServiceTypeNamePropEnum = append(oracleRacOnSanInlineDbInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_db_inline_storage_service
	// OracleRacOnSanInlineDbInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnSanInlineDbInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnSanInlineDbInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_db_inline_storage_service
	// OracleRacOnSanInlineDbInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnSanInlineDbInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnSanInlineDbInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_db_inline_storage_service
	// OracleRacOnSanInlineDbInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnSanInlineDbInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnSanInlineDbInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnSanInlineDbInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineDbInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineDbInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("db"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on san inline db inline storage service based on context it is used
func (m *OracleRacOnSanInlineDbInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineDbInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineDbInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineDbInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineGridBinary oracle rac on san inline grid binary
//
// swagger:model oracle_rac_on_san_inline_grid_binary
type OracleRacOnSanInlineGridBinary struct {

	// The size of the Oracle grid binary storage volume. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleRacOnSanInlineGridBinaryInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on san inline grid binary
func (m *OracleRacOnSanInlineGridBinary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineGridBinary) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("grid_binary" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on san inline grid binary based on the context it is used
func (m *OracleRacOnSanInlineGridBinary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineGridBinary) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("grid_binary" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineGridBinary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineGridBinary) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineGridBinary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineGridBinaryInlineStorageService oracle rac on san inline grid binary inline storage service
//
// swagger:model oracle_rac_on_san_inline_grid_binary_inline_storage_service
type OracleRacOnSanInlineGridBinaryInlineStorageService struct {

	// The storage service of the Oracle grid binary storage volume.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on san inline grid binary inline storage service
func (m *OracleRacOnSanInlineGridBinaryInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnSanInlineGridBinaryInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineGridBinaryInlineStorageServiceTypeNamePropEnum = append(oracleRacOnSanInlineGridBinaryInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_grid_binary_inline_storage_service
	// OracleRacOnSanInlineGridBinaryInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnSanInlineGridBinaryInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnSanInlineGridBinaryInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_grid_binary_inline_storage_service
	// OracleRacOnSanInlineGridBinaryInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnSanInlineGridBinaryInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnSanInlineGridBinaryInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_grid_binary_inline_storage_service
	// OracleRacOnSanInlineGridBinaryInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnSanInlineGridBinaryInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnSanInlineGridBinaryInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnSanInlineGridBinaryInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineGridBinaryInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineGridBinaryInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("grid_binary"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on san inline grid binary inline storage service based on context it is used
func (m *OracleRacOnSanInlineGridBinaryInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineGridBinaryInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineGridBinaryInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineGridBinaryInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineOraHome oracle rac on san inline ora home
//
// swagger:model oracle_rac_on_san_inline_ora_home
type OracleRacOnSanInlineOraHome struct {

	// The size of the ORACLE_HOME storage volume. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleRacOnSanInlineOraHomeInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on san inline ora home
func (m *OracleRacOnSanInlineOraHome) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineOraHome) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on san inline ora home based on the context it is used
func (m *OracleRacOnSanInlineOraHome) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineOraHome) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ora_home" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineOraHome) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineOraHome) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineOraHome
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineOraHomeInlineStorageService oracle rac on san inline ora home inline storage service
//
// swagger:model oracle_rac_on_san_inline_ora_home_inline_storage_service
type OracleRacOnSanInlineOraHomeInlineStorageService struct {

	// The storage service of the ORACLE_HOME storage volume.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on san inline ora home inline storage service
func (m *OracleRacOnSanInlineOraHomeInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnSanInlineOraHomeInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineOraHomeInlineStorageServiceTypeNamePropEnum = append(oracleRacOnSanInlineOraHomeInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_ora_home_inline_storage_service
	// OracleRacOnSanInlineOraHomeInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnSanInlineOraHomeInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnSanInlineOraHomeInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_ora_home_inline_storage_service
	// OracleRacOnSanInlineOraHomeInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnSanInlineOraHomeInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnSanInlineOraHomeInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_ora_home_inline_storage_service
	// OracleRacOnSanInlineOraHomeInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnSanInlineOraHomeInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnSanInlineOraHomeInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnSanInlineOraHomeInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineOraHomeInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineOraHomeInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("ora_home"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on san inline ora home inline storage service based on context it is used
func (m *OracleRacOnSanInlineOraHomeInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineOraHomeInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineOraHomeInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineOraHomeInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineOracleCrs oracle rac on san inline oracle crs
//
// swagger:model oracle_rac_on_san_inline_oracle_crs
type OracleRacOnSanInlineOracleCrs struct {

	// The number of CRS volumes.
	// Maximum: 10
	// Minimum: 1
	Copies *int64 `json:"copies,omitempty"`

	// The size of the Oracle CRS/voting storage volume. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	Size *int64 `json:"size,omitempty"`

	// storage service
	StorageService *OracleRacOnSanInlineOracleCrsInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on san inline oracle crs
func (m *OracleRacOnSanInlineOracleCrs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCopies(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineOracleCrs) validateCopies(formats strfmt.Registry) error {
	if swag.IsZero(m.Copies) { // not required
		return nil
	}

	if err := validate.MinimumInt("oracle_crs"+"."+"copies", "body", *m.Copies, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("oracle_crs"+"."+"copies", "body", *m.Copies, 10, false); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnSanInlineOracleCrs) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_crs" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on san inline oracle crs based on the context it is used
func (m *OracleRacOnSanInlineOracleCrs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineOracleCrs) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("oracle_crs" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineOracleCrs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineOracleCrs) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineOracleCrs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineOracleCrsInlineStorageService oracle rac on san inline oracle crs inline storage service
//
// swagger:model oracle_rac_on_san_inline_oracle_crs_inline_storage_service
type OracleRacOnSanInlineOracleCrsInlineStorageService struct {

	// The storage service of the Oracle CRS volume.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on san inline oracle crs inline storage service
func (m *OracleRacOnSanInlineOracleCrsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnSanInlineOracleCrsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineOracleCrsInlineStorageServiceTypeNamePropEnum = append(oracleRacOnSanInlineOracleCrsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_oracle_crs_inline_storage_service
	// OracleRacOnSanInlineOracleCrsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnSanInlineOracleCrsInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnSanInlineOracleCrsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_oracle_crs_inline_storage_service
	// OracleRacOnSanInlineOracleCrsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnSanInlineOracleCrsInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnSanInlineOracleCrsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_oracle_crs_inline_storage_service
	// OracleRacOnSanInlineOracleCrsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnSanInlineOracleCrsInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnSanInlineOracleCrsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnSanInlineOracleCrsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineOracleCrsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineOracleCrsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("oracle_crs"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on san inline oracle crs inline storage service based on context it is used
func (m *OracleRacOnSanInlineOracleCrsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineOracleCrsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineOracleCrsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineOracleCrsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineProtectionType oracle rac on san inline protection type
//
// swagger:model oracle_rac_on_san_inline_protection_type
type OracleRacOnSanInlineProtectionType struct {

	// The local RPO of the application.
	// Enum: ["hourly","none"]
	LocalRpo *string `json:"local_rpo,omitempty"`

	// The remote RPO of the application.
	// Enum: ["none","zero"]
	RemoteRpo *string `json:"remote_rpo,omitempty"`
}

// Validate validates this oracle rac on san inline protection type
func (m *OracleRacOnSanInlineProtectionType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocalRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnSanInlineProtectionTypeTypeLocalRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineProtectionTypeTypeLocalRpoPropEnum = append(oracleRacOnSanInlineProtectionTypeTypeLocalRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_protection_type
	// OracleRacOnSanInlineProtectionType
	// local_rpo
	// LocalRpo
	// hourly
	// END DEBUGGING
	// OracleRacOnSanInlineProtectionTypeLocalRpoHourly captures enum value "hourly"
	OracleRacOnSanInlineProtectionTypeLocalRpoHourly string = "hourly"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_protection_type
	// OracleRacOnSanInlineProtectionType
	// local_rpo
	// LocalRpo
	// none
	// END DEBUGGING
	// OracleRacOnSanInlineProtectionTypeLocalRpoNone captures enum value "none"
	OracleRacOnSanInlineProtectionTypeLocalRpoNone string = "none"
)

// prop value enum
func (m *OracleRacOnSanInlineProtectionType) validateLocalRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineProtectionTypeTypeLocalRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineProtectionType) validateLocalRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalRpoEnum("protection_type"+"."+"local_rpo", "body", *m.LocalRpo); err != nil {
		return err
	}

	return nil
}

var oracleRacOnSanInlineProtectionTypeTypeRemoteRpoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineProtectionTypeTypeRemoteRpoPropEnum = append(oracleRacOnSanInlineProtectionTypeTypeRemoteRpoPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_protection_type
	// OracleRacOnSanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// none
	// END DEBUGGING
	// OracleRacOnSanInlineProtectionTypeRemoteRpoNone captures enum value "none"
	OracleRacOnSanInlineProtectionTypeRemoteRpoNone string = "none"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_protection_type
	// OracleRacOnSanInlineProtectionType
	// remote_rpo
	// RemoteRpo
	// zero
	// END DEBUGGING
	// OracleRacOnSanInlineProtectionTypeRemoteRpoZero captures enum value "zero"
	OracleRacOnSanInlineProtectionTypeRemoteRpoZero string = "zero"
)

// prop value enum
func (m *OracleRacOnSanInlineProtectionType) validateRemoteRpoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineProtectionTypeTypeRemoteRpoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineProtectionType) validateRemoteRpo(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteRpo) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteRpoEnum("protection_type"+"."+"remote_rpo", "body", *m.RemoteRpo); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on san inline protection type based on context it is used
func (m *OracleRacOnSanInlineProtectionType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineProtectionType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineProtectionType) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineProtectionType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineRedoLog oracle rac on san inline redo log
//
// swagger:model oracle_rac_on_san_inline_redo_log
type OracleRacOnSanInlineRedoLog struct {

	// Specifies whether the redo log group should be mirrored.
	// Enum: [false,true]
	Mirrored *bool `json:"mirrored,omitempty"`

	// The size of the redo log group. Usage: {&lt;integer&gt;[KB|MB|GB|TB|PB]}
	// Required: true
	Size *int64 `json:"size"`

	// storage service
	StorageService *OracleRacOnSanInlineRedoLogInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this oracle rac on san inline redo log
func (m *OracleRacOnSanInlineRedoLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMirrored(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnSanInlineRedoLogTypeMirroredPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineRedoLogTypeMirroredPropEnum = append(oracleRacOnSanInlineRedoLogTypeMirroredPropEnum, v)
	}
}

// prop value enum
func (m *OracleRacOnSanInlineRedoLog) validateMirroredEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineRedoLogTypeMirroredPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineRedoLog) validateMirrored(formats strfmt.Registry) error {
	if swag.IsZero(m.Mirrored) { // not required
		return nil
	}

	// value enum
	if err := m.validateMirroredEnum("redo_log"+"."+"mirrored", "body", *m.Mirrored); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnSanInlineRedoLog) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("redo_log"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *OracleRacOnSanInlineRedoLog) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this oracle rac on san inline redo log based on the context it is used
func (m *OracleRacOnSanInlineRedoLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OracleRacOnSanInlineRedoLog) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("redo_log" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineRedoLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineRedoLog) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineRedoLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// OracleRacOnSanInlineRedoLogInlineStorageService oracle rac on san inline redo log inline storage service
//
// swagger:model oracle_rac_on_san_inline_redo_log_inline_storage_service
type OracleRacOnSanInlineRedoLogInlineStorageService struct {

	// The storage service of the redo log group.
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this oracle rac on san inline redo log inline storage service
func (m *OracleRacOnSanInlineRedoLogInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var oracleRacOnSanInlineRedoLogInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		oracleRacOnSanInlineRedoLogInlineStorageServiceTypeNamePropEnum = append(oracleRacOnSanInlineRedoLogInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_redo_log_inline_storage_service
	// OracleRacOnSanInlineRedoLogInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// OracleRacOnSanInlineRedoLogInlineStorageServiceNameExtreme captures enum value "extreme"
	OracleRacOnSanInlineRedoLogInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_redo_log_inline_storage_service
	// OracleRacOnSanInlineRedoLogInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// OracleRacOnSanInlineRedoLogInlineStorageServiceNamePerformance captures enum value "performance"
	OracleRacOnSanInlineRedoLogInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// oracle_rac_on_san_inline_redo_log_inline_storage_service
	// OracleRacOnSanInlineRedoLogInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// OracleRacOnSanInlineRedoLogInlineStorageServiceNameValue captures enum value "value"
	OracleRacOnSanInlineRedoLogInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *OracleRacOnSanInlineRedoLogInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, oracleRacOnSanInlineRedoLogInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *OracleRacOnSanInlineRedoLogInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("redo_log"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this oracle rac on san inline redo log inline storage service based on context it is used
func (m *OracleRacOnSanInlineRedoLogInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OracleRacOnSanInlineRedoLogInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OracleRacOnSanInlineRedoLogInlineStorageService) UnmarshalBinary(b []byte) error {
	var res OracleRacOnSanInlineRedoLogInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
