// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceFcInterfaceMetric Performance numbers, such as IOPS latency and throughput
//
// swagger:model performance_fc_interface_metric
type PerformanceFcInterfaceMetric struct {

	// links
	Links *PerformanceFcInterfaceMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceFcInterfaceMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceFcInterfaceMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceFcInterfaceMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The unique identifier of the FC interface.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this performance fc interface metric
func (m *PerformanceFcInterfaceMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcInterfaceMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceFcInterfaceMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceFcInterfaceMetricTypeDurationPropEnum = append(performanceFcInterfaceMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceFcInterfaceMetricDurationPT15S captures enum value "PT15S"
	PerformanceFcInterfaceMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceFcInterfaceMetricDurationPT4M captures enum value "PT4M"
	PerformanceFcInterfaceMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceFcInterfaceMetricDurationPT30M captures enum value "PT30M"
	PerformanceFcInterfaceMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceFcInterfaceMetricDurationPT2H captures enum value "PT2H"
	PerformanceFcInterfaceMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceFcInterfaceMetricDurationP1D captures enum value "P1D"
	PerformanceFcInterfaceMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceFcInterfaceMetricDurationPT5M captures enum value "PT5M"
	PerformanceFcInterfaceMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceFcInterfaceMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceFcInterfaceMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceFcInterfaceMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var performanceFcInterfaceMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceFcInterfaceMetricTypeStatusPropEnum = append(performanceFcInterfaceMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusOk captures enum value "ok"
	PerformanceFcInterfaceMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusError captures enum value "error"
	PerformanceFcInterfaceMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusPartialNoData captures enum value "partial_no_data"
	PerformanceFcInterfaceMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceFcInterfaceMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceFcInterfaceMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusNegativeDelta captures enum value "negative_delta"
	PerformanceFcInterfaceMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusNotFound captures enum value "not_found"
	PerformanceFcInterfaceMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusBackfilledData captures enum value "backfilled_data"
	PerformanceFcInterfaceMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceFcInterfaceMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceFcInterfaceMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_fc_interface_metric
	// PerformanceFcInterfaceMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceFcInterfaceMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceFcInterfaceMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceFcInterfaceMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceFcInterfaceMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceFcInterfaceMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance fc interface metric based on the context it is used
func (m *PerformanceFcInterfaceMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcInterfaceMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcInterfaceMetric) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetric) UnmarshalBinary(b []byte) error {
	var res PerformanceFcInterfaceMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcInterfaceMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_fc_interface_metric_inline_iops
type PerformanceFcInterfaceMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fc interface metric inline iops
func (m *PerformanceFcInterfaceMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fc interface metric inline iops based on the context it is used
func (m *PerformanceFcInterfaceMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceFcInterfaceMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcInterfaceMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_fc_interface_metric_inline_latency
type PerformanceFcInterfaceMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fc interface metric inline latency
func (m *PerformanceFcInterfaceMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fc interface metric inline latency based on the context it is used
func (m *PerformanceFcInterfaceMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceFcInterfaceMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcInterfaceMetricInlineLinks performance fc interface metric inline links
//
// swagger:model performance_fc_interface_metric_inline__links
type PerformanceFcInterfaceMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance fc interface metric inline links
func (m *PerformanceFcInterfaceMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcInterfaceMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance fc interface metric inline links based on the context it is used
func (m *PerformanceFcInterfaceMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcInterfaceMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceFcInterfaceMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcInterfaceMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_fc_interface_metric_inline_throughput
type PerformanceFcInterfaceMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fc interface metric inline throughput
func (m *PerformanceFcInterfaceMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fc interface metric inline throughput based on the context it is used
func (m *PerformanceFcInterfaceMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcInterfaceMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceFcInterfaceMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
