// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceFcPortMetric Performance numbers, such as IOPS latency and throughput
//
// swagger:model performance_fc_port_metric
type PerformanceFcPortMetric struct {

	// links
	Links *PerformanceFcPortMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceFcPortMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceFcPortMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceFcPortMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The unique identifier of the FC port.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this performance fc port metric
func (m *PerformanceFcPortMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcPortMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceFcPortMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceFcPortMetricTypeDurationPropEnum = append(performanceFcPortMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceFcPortMetricDurationPT15S captures enum value "PT15S"
	PerformanceFcPortMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceFcPortMetricDurationPT4M captures enum value "PT4M"
	PerformanceFcPortMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceFcPortMetricDurationPT30M captures enum value "PT30M"
	PerformanceFcPortMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceFcPortMetricDurationPT2H captures enum value "PT2H"
	PerformanceFcPortMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceFcPortMetricDurationP1D captures enum value "P1D"
	PerformanceFcPortMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceFcPortMetricDurationPT5M captures enum value "PT5M"
	PerformanceFcPortMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceFcPortMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceFcPortMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceFcPortMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcPortMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcPortMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var performanceFcPortMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceFcPortMetricTypeStatusPropEnum = append(performanceFcPortMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceFcPortMetricStatusOk captures enum value "ok"
	PerformanceFcPortMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceFcPortMetricStatusError captures enum value "error"
	PerformanceFcPortMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceFcPortMetricStatusPartialNoData captures enum value "partial_no_data"
	PerformanceFcPortMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceFcPortMetricStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceFcPortMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceFcPortMetricStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceFcPortMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceFcPortMetricStatusNegativeDelta captures enum value "negative_delta"
	PerformanceFcPortMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceFcPortMetricStatusNotFound captures enum value "not_found"
	PerformanceFcPortMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceFcPortMetricStatusBackfilledData captures enum value "backfilled_data"
	PerformanceFcPortMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceFcPortMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceFcPortMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceFcPortMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceFcPortMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_fc_port_metric
	// PerformanceFcPortMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceFcPortMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceFcPortMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceFcPortMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceFcPortMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceFcPortMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcPortMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcPortMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance fc port metric based on the context it is used
func (m *PerformanceFcPortMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcPortMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcPortMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcPortMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcPortMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcPortMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcPortMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcPortMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcPortMetric) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcPortMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcPortMetric) UnmarshalBinary(b []byte) error {
	var res PerformanceFcPortMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcPortMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_fc_port_metric_inline_iops
type PerformanceFcPortMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fc port metric inline iops
func (m *PerformanceFcPortMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fc port metric inline iops based on the context it is used
func (m *PerformanceFcPortMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcPortMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcPortMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceFcPortMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcPortMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_fc_port_metric_inline_latency
type PerformanceFcPortMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fc port metric inline latency
func (m *PerformanceFcPortMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fc port metric inline latency based on the context it is used
func (m *PerformanceFcPortMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcPortMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcPortMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceFcPortMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcPortMetricInlineLinks performance fc port metric inline links
//
// swagger:model performance_fc_port_metric_inline__links
type PerformanceFcPortMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance fc port metric inline links
func (m *PerformanceFcPortMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcPortMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance fc port metric inline links based on the context it is used
func (m *PerformanceFcPortMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcPortMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcPortMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcPortMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceFcPortMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcPortMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_fc_port_metric_inline_throughput
type PerformanceFcPortMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fc port metric inline throughput
func (m *PerformanceFcPortMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fc port metric inline throughput based on the context it is used
func (m *PerformanceFcPortMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcPortMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcPortMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceFcPortMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
