// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceFcpMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model performance_fcp_metric
type PerformanceFcpMetric struct {

	// links
	Links *PerformanceFcpMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceFcpMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceFcpMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// svm
	Svm *PerformanceFcpMetricInlineSvm `json:"svm,omitempty"`

	// throughput
	Throughput *PerformanceFcpMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance fcp metric
func (m *PerformanceFcpMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcpMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceFcpMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceFcpMetricTypeDurationPropEnum = append(performanceFcpMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceFcpMetricDurationPT15S captures enum value "PT15S"
	PerformanceFcpMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceFcpMetricDurationPT4M captures enum value "PT4M"
	PerformanceFcpMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceFcpMetricDurationPT30M captures enum value "PT30M"
	PerformanceFcpMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceFcpMetricDurationPT2H captures enum value "PT2H"
	PerformanceFcpMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceFcpMetricDurationP1D captures enum value "P1D"
	PerformanceFcpMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceFcpMetricDurationPT5M captures enum value "PT5M"
	PerformanceFcpMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceFcpMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceFcpMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceFcpMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcpMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcpMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var performanceFcpMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceFcpMetricTypeStatusPropEnum = append(performanceFcpMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceFcpMetricStatusOk captures enum value "ok"
	PerformanceFcpMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceFcpMetricStatusError captures enum value "error"
	PerformanceFcpMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceFcpMetricStatusPartialNoData captures enum value "partial_no_data"
	PerformanceFcpMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceFcpMetricStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceFcpMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceFcpMetricStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceFcpMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceFcpMetricStatusNegativeDelta captures enum value "negative_delta"
	PerformanceFcpMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceFcpMetricStatusNotFound captures enum value "not_found"
	PerformanceFcpMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceFcpMetricStatusBackfilledData captures enum value "backfilled_data"
	PerformanceFcpMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceFcpMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceFcpMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceFcpMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceFcpMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_fcp_metric
	// PerformanceFcpMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceFcpMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceFcpMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceFcpMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceFcpMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceFcpMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcpMetric) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcpMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcpMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance fcp metric based on the context it is used
func (m *PerformanceFcpMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcpMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcpMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcpMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcpMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcpMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceFcpMetric) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcpMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceFcpMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcpMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcpMetric) UnmarshalBinary(b []byte) error {
	var res PerformanceFcpMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcpMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_fcp_metric_inline_iops
type PerformanceFcpMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fcp metric inline iops
func (m *PerformanceFcpMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fcp metric inline iops based on the context it is used
func (m *PerformanceFcpMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceFcpMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcpMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_fcp_metric_inline_latency
type PerformanceFcpMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fcp metric inline latency
func (m *PerformanceFcpMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fcp metric inline latency based on the context it is used
func (m *PerformanceFcpMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceFcpMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcpMetricInlineLinks performance fcp metric inline links
//
// swagger:model performance_fcp_metric_inline__links
type PerformanceFcpMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance fcp metric inline links
func (m *PerformanceFcpMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcpMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance fcp metric inline links based on the context it is used
func (m *PerformanceFcpMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceFcpMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceFcpMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcpMetricInlineSvm performance fcp metric inline svm
//
// swagger:model performance_fcp_metric_inline_svm
type PerformanceFcpMetricInlineSvm struct {

	// The unique identifier of the SVM.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this performance fcp metric inline svm
func (m *PerformanceFcpMetricInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this performance fcp metric inline svm based on context it is used
func (m *PerformanceFcpMetricInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineSvm) UnmarshalBinary(b []byte) error {
	var res PerformanceFcpMetricInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceFcpMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_fcp_metric_inline_throughput
type PerformanceFcpMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance fcp metric inline throughput
func (m *PerformanceFcpMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance fcp metric inline throughput based on the context it is used
func (m *PerformanceFcpMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceFcpMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceFcpMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
