// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceIscsiMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model performance_iscsi_metric
type PerformanceIscsiMetric struct {

	// links
	Links *PerformanceIscsiMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceIscsiMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceIscsiMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// svm
	Svm *PerformanceIscsiMetricInlineSvm `json:"svm,omitempty"`

	// throughput
	Throughput *PerformanceIscsiMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance iscsi metric
func (m *PerformanceIscsiMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceIscsiMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceIscsiMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceIscsiMetricTypeDurationPropEnum = append(performanceIscsiMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceIscsiMetricDurationPT15S captures enum value "PT15S"
	PerformanceIscsiMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceIscsiMetricDurationPT4M captures enum value "PT4M"
	PerformanceIscsiMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceIscsiMetricDurationPT30M captures enum value "PT30M"
	PerformanceIscsiMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceIscsiMetricDurationPT2H captures enum value "PT2H"
	PerformanceIscsiMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceIscsiMetricDurationP1D captures enum value "P1D"
	PerformanceIscsiMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceIscsiMetricDurationPT5M captures enum value "PT5M"
	PerformanceIscsiMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceIscsiMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceIscsiMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceIscsiMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceIscsiMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceIscsiMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var performanceIscsiMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceIscsiMetricTypeStatusPropEnum = append(performanceIscsiMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceIscsiMetricStatusOk captures enum value "ok"
	PerformanceIscsiMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceIscsiMetricStatusError captures enum value "error"
	PerformanceIscsiMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceIscsiMetricStatusPartialNoData captures enum value "partial_no_data"
	PerformanceIscsiMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceIscsiMetricStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceIscsiMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceIscsiMetricStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceIscsiMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceIscsiMetricStatusNegativeDelta captures enum value "negative_delta"
	PerformanceIscsiMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceIscsiMetricStatusNotFound captures enum value "not_found"
	PerformanceIscsiMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceIscsiMetricStatusBackfilledData captures enum value "backfilled_data"
	PerformanceIscsiMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceIscsiMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceIscsiMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceIscsiMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceIscsiMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_iscsi_metric
	// PerformanceIscsiMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceIscsiMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceIscsiMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceIscsiMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceIscsiMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceIscsiMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceIscsiMetric) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceIscsiMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceIscsiMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance iscsi metric based on the context it is used
func (m *PerformanceIscsiMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceIscsiMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceIscsiMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceIscsiMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceIscsiMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceIscsiMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceIscsiMetric) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceIscsiMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceIscsiMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceIscsiMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceIscsiMetric) UnmarshalBinary(b []byte) error {
	var res PerformanceIscsiMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceIscsiMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_iscsi_metric_inline_iops
type PerformanceIscsiMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance iscsi metric inline iops
func (m *PerformanceIscsiMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance iscsi metric inline iops based on the context it is used
func (m *PerformanceIscsiMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceIscsiMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceIscsiMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_iscsi_metric_inline_latency
type PerformanceIscsiMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance iscsi metric inline latency
func (m *PerformanceIscsiMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance iscsi metric inline latency based on the context it is used
func (m *PerformanceIscsiMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceIscsiMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceIscsiMetricInlineLinks performance iscsi metric inline links
//
// swagger:model performance_iscsi_metric_inline__links
type PerformanceIscsiMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance iscsi metric inline links
func (m *PerformanceIscsiMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceIscsiMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance iscsi metric inline links based on the context it is used
func (m *PerformanceIscsiMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceIscsiMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceIscsiMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceIscsiMetricInlineSvm performance iscsi metric inline svm
//
// swagger:model performance_iscsi_metric_inline_svm
type PerformanceIscsiMetricInlineSvm struct {

	// The unique identifier of the SVM.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this performance iscsi metric inline svm
func (m *PerformanceIscsiMetricInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this performance iscsi metric inline svm based on context it is used
func (m *PerformanceIscsiMetricInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineSvm) UnmarshalBinary(b []byte) error {
	var res PerformanceIscsiMetricInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceIscsiMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_iscsi_metric_inline_throughput
type PerformanceIscsiMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance iscsi metric inline throughput
func (m *PerformanceIscsiMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance iscsi metric inline throughput based on the context it is used
func (m *PerformanceIscsiMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceIscsiMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceIscsiMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
