// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceLunMetricResponse performance lun metric response
//
// swagger:model performance_lun_metric_response
type PerformanceLunMetricResponse struct {

	// links
	Links *PerformanceLunMetricResponseInlineLinks `json:"_links,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// performance lun metric response inline records
	PerformanceLunMetricResponseInlineRecords []*PerformanceLunMetricResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this performance lun metric response
func (m *PerformanceLunMetricResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePerformanceLunMetricResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponse) validatePerformanceLunMetricResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.PerformanceLunMetricResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.PerformanceLunMetricResponseInlineRecords); i++ {
		if swag.IsZero(m.PerformanceLunMetricResponseInlineRecords[i]) { // not required
			continue
		}

		if m.PerformanceLunMetricResponseInlineRecords[i] != nil {
			if err := m.PerformanceLunMetricResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this performance lun metric response based on the context it is used
func (m *PerformanceLunMetricResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePerformanceLunMetricResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponse) contextValidatePerformanceLunMetricResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PerformanceLunMetricResponseInlineRecords); i++ {

		if m.PerformanceLunMetricResponseInlineRecords[i] != nil {
			if err := m.PerformanceLunMetricResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceLunMetricResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceLunMetricResponse) UnmarshalBinary(b []byte) error {
	var res PerformanceLunMetricResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceLunMetricResponseInlineLinks performance lun metric response inline links
//
// swagger:model performance_lun_metric_response_inline__links
type PerformanceLunMetricResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance lun metric response inline links
func (m *PerformanceLunMetricResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance lun metric response inline links based on the context it is used
func (m *PerformanceLunMetricResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceLunMetricResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceLunMetricResponseInlineRecordsInlineArrayItem Performance numbers, such as IOPS latency and throughput.
//
// swagger:model performance_lun_metric_response_inline_records_inline_array_item
type PerformanceLunMetricResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLatency `json:"latency,omitempty"`

	// space
	Space *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace `json:"space,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The unique identifier of the LUN.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this performance lun metric response inline records inline array item
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceLunMetricResponseInlineRecordsInlineArrayItemTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceLunMetricResponseInlineRecordsInlineArrayItemTypeDurationPropEnum = append(performanceLunMetricResponseInlineRecordsInlineArrayItemTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT15S captures enum value "PT15S"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT4M captures enum value "PT4M"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT30M captures enum value "PT30M"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT2H captures enum value "PT2H"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationP1D captures enum value "P1D"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT5M captures enum value "PT5M"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceLunMetricResponseInlineRecordsInlineArrayItemTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

var performanceLunMetricResponseInlineRecordsInlineArrayItemTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceLunMetricResponseInlineRecordsInlineArrayItemTypeStatusPropEnum = append(performanceLunMetricResponseInlineRecordsInlineArrayItemTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusOk captures enum value "ok"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusError captures enum value "error"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusPartialNoData captures enum value "partial_no_data"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusNegativeDelta captures enum value "negative_delta"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusNotFound captures enum value "not_found"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusBackfilledData captures enum value "backfilled_data"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceLunMetricResponseInlineRecordsInlineArrayItemTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance lun metric response inline records inline array item based on the context it is used
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res PerformanceLunMetricResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_lun_metric_response_inline_records_inline_array_item_inline_iops
type PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance lun metric response inline records inline array item inline iops
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance lun metric response inline records inline array item inline iops based on the context it is used
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_lun_metric_response_inline_records_inline_array_item_inline_latency
type PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance lun metric response inline records inline array item inline latency
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance lun metric response inline records inline array item inline latency based on the context it is used
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks performance lun metric response inline records inline array item inline links
//
// swagger:model performance_lun_metric_response_inline_records_inline_array_item_inline__links
type PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance lun metric response inline records inline array item inline links
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance lun metric response inline records inline array item inline links based on the context it is used
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace Space metrics of the LUN.
//
// swagger:model performance_lun_metric_response_inline_records_inline_array_item_inline_space
type PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace struct {

	// Total available free space of the LUN.
	//
	// Example: 924
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT1D
	// Read Only: true
	// Enum: ["PT15S","PT5M","PT30M","PT2H","PT1D"]
	Duration *string `json:"duration,omitempty"`

	// Total allocated space of the LUN.
	//
	// Example: 1024
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, any partial errors might return "ok" on success or "error" on an internal uncategorized failure. When a sample collection is missed but completed at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". The "Inconsistent_ delta_time" error occurs when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// Total occupied space of the LUN.
	//
	// Example: 100
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Total space used by snapshots of the LUN.
	//
	// Example: 30
	// Read Only: true
	UsedBySnapshots *int64 `json:"used_by_snapshots,omitempty"`
}

// Validate validates this performance lun metric response inline records inline array item inline space
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","PT1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceTypeDurationPropEnum = append(performanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT15S captures enum value "PT15S"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT5M captures enum value "PT5M"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT30M captures enum value "PT30M"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT2H captures enum value "PT2H"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// duration
	// Duration
	// PT1D
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT1D captures enum value "PT1D"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceDurationPT1D string = "PT1D"
)

// prop value enum
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("space"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var performanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceTypeStatusPropEnum = append(performanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusOk captures enum value "ok"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusError captures enum value "error"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusPartialNoData captures enum value "partial_no_data"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusNegativeDelta captures enum value "negative_delta"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusBackfilledData captures enum value "backfilled_data"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_lun_metric_response_inline_records_inline_array_item_inline_space
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpaceTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("space"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance lun metric response inline records inline array item inline space based on the context it is used
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) contextValidateUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used_by_snapshots", "body", m.UsedBySnapshots); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_lun_metric_response_inline_records_inline_array_item_inline_throughput
type PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance lun metric response inline records inline array item inline throughput
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance lun metric response inline records inline array item inline throughput based on the context it is used
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceLunMetricResponseInlineRecordsInlineArrayItemInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
