// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceNamespaceMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model performance_namespace_metric
type PerformanceNamespaceMetric struct {

	// links
	Links *PerformanceNamespaceMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceNamespaceMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceNamespaceMetricInlineLatency `json:"latency,omitempty"`

	// space
	Space *PerformanceNamespaceMetricInlineSpace `json:"space,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceNamespaceMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this performance namespace metric
func (m *PerformanceNamespaceMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNamespaceMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceNamespaceMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNamespaceMetricTypeDurationPropEnum = append(performanceNamespaceMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceNamespaceMetricDurationPT15S captures enum value "PT15S"
	PerformanceNamespaceMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceNamespaceMetricDurationPT4M captures enum value "PT4M"
	PerformanceNamespaceMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceNamespaceMetricDurationPT30M captures enum value "PT30M"
	PerformanceNamespaceMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceNamespaceMetricDurationPT2H captures enum value "PT2H"
	PerformanceNamespaceMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceNamespaceMetricDurationP1D captures enum value "P1D"
	PerformanceNamespaceMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceNamespaceMetricDurationPT5M captures enum value "PT5M"
	PerformanceNamespaceMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceNamespaceMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNamespaceMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNamespaceMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNamespaceMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNamespaceMetric) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

var performanceNamespaceMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNamespaceMetricTypeStatusPropEnum = append(performanceNamespaceMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusOk captures enum value "ok"
	PerformanceNamespaceMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusError captures enum value "error"
	PerformanceNamespaceMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusPartialNoData captures enum value "partial_no_data"
	PerformanceNamespaceMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceNamespaceMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceNamespaceMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusNegativeDelta captures enum value "negative_delta"
	PerformanceNamespaceMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusNotFound captures enum value "not_found"
	PerformanceNamespaceMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusBackfilledData captures enum value "backfilled_data"
	PerformanceNamespaceMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceNamespaceMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceNamespaceMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_namespace_metric
	// PerformanceNamespaceMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceNamespaceMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceNamespaceMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceNamespaceMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNamespaceMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNamespaceMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNamespaceMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance namespace metric based on the context it is used
func (m *PerformanceNamespaceMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetric) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNamespaceMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNamespaceMetric) UnmarshalBinary(b []byte) error {
	var res PerformanceNamespaceMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNamespaceMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_namespace_metric_inline_iops
type PerformanceNamespaceMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance namespace metric inline iops
func (m *PerformanceNamespaceMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance namespace metric inline iops based on the context it is used
func (m *PerformanceNamespaceMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceNamespaceMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNamespaceMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_namespace_metric_inline_latency
type PerformanceNamespaceMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance namespace metric inline latency
func (m *PerformanceNamespaceMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance namespace metric inline latency based on the context it is used
func (m *PerformanceNamespaceMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceNamespaceMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNamespaceMetricInlineLinks performance namespace metric inline links
//
// swagger:model performance_namespace_metric_inline__links
type PerformanceNamespaceMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance namespace metric inline links
func (m *PerformanceNamespaceMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNamespaceMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance namespace metric inline links based on the context it is used
func (m *PerformanceNamespaceMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNamespaceMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceNamespaceMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNamespaceMetricInlineSpace Space metrics of an NVMe namespace.
//
// swagger:model performance_namespace_metric_inline_space
type PerformanceNamespaceMetricInlineSpace struct {

	// Total available free space of the NVMe namespace.
	//
	// Example: 924
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT1D
	// Read Only: true
	// Enum: ["PT15S","PT5M","PT30M","PT2H","PT1D"]
	Duration *string `json:"duration,omitempty"`

	// Total allocated space of the NVMe namespace.
	//
	// Example: 1024
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, any partial errors might return "ok" on success or "error" on an internal uncategorized failure. When a sample collection is missed but completed at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". The "Inconsistent_ delta_time" error occurs when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// Total occupied space of the NVMe namespace.
	//
	// Example: 100
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Total space used by snapshots of the NVMe namespace.
	//
	// Example: 30
	// Read Only: true
	UsedBySnapshots *int64 `json:"used_by_snapshots,omitempty"`
}

// Validate validates this performance namespace metric inline space
func (m *PerformanceNamespaceMetricInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceNamespaceMetricInlineSpaceTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","PT1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNamespaceMetricInlineSpaceTypeDurationPropEnum = append(performanceNamespaceMetricInlineSpaceTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceDurationPT15S captures enum value "PT15S"
	PerformanceNamespaceMetricInlineSpaceDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceDurationPT5M captures enum value "PT5M"
	PerformanceNamespaceMetricInlineSpaceDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceDurationPT30M captures enum value "PT30M"
	PerformanceNamespaceMetricInlineSpaceDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceDurationPT2H captures enum value "PT2H"
	PerformanceNamespaceMetricInlineSpaceDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// duration
	// Duration
	// PT1D
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceDurationPT1D captures enum value "PT1D"
	PerformanceNamespaceMetricInlineSpaceDurationPT1D string = "PT1D"
)

// prop value enum
func (m *PerformanceNamespaceMetricInlineSpace) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNamespaceMetricInlineSpaceTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNamespaceMetricInlineSpace) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("space"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var performanceNamespaceMetricInlineSpaceTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNamespaceMetricInlineSpaceTypeStatusPropEnum = append(performanceNamespaceMetricInlineSpaceTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusOk captures enum value "ok"
	PerformanceNamespaceMetricInlineSpaceStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusError captures enum value "error"
	PerformanceNamespaceMetricInlineSpaceStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusPartialNoData captures enum value "partial_no_data"
	PerformanceNamespaceMetricInlineSpaceStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceNamespaceMetricInlineSpaceStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceNamespaceMetricInlineSpaceStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceNamespaceMetricInlineSpaceStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusNegativeDelta captures enum value "negative_delta"
	PerformanceNamespaceMetricInlineSpaceStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusBackfilledData captures enum value "backfilled_data"
	PerformanceNamespaceMetricInlineSpaceStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceNamespaceMetricInlineSpaceStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_namespace_metric_inline_space
	// PerformanceNamespaceMetricInlineSpace
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceNamespaceMetricInlineSpaceStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceNamespaceMetricInlineSpaceStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *PerformanceNamespaceMetricInlineSpace) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNamespaceMetricInlineSpaceTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNamespaceMetricInlineSpace) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("space"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance namespace metric inline space based on the context it is used
func (m *PerformanceNamespaceMetricInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedBySnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNamespaceMetricInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetricInlineSpace) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetricInlineSpace) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetricInlineSpace) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetricInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNamespaceMetricInlineSpace) contextValidateUsedBySnapshots(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used_by_snapshots", "body", m.UsedBySnapshots); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineSpace) UnmarshalBinary(b []byte) error {
	var res PerformanceNamespaceMetricInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNamespaceMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_namespace_metric_inline_throughput
type PerformanceNamespaceMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance namespace metric inline throughput
func (m *PerformanceNamespaceMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance namespace metric inline throughput based on the context it is used
func (m *PerformanceNamespaceMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNamespaceMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceNamespaceMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
