// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceNvmeMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model performance_nvme_metric
type PerformanceNvmeMetric struct {

	// links
	Links *PerformanceNvmeMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// fc
	Fc *PerformanceNvmeMetricInlineFc `json:"fc,omitempty"`

	// iops
	Iops *PerformanceNvmeMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceNvmeMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// svm
	Svm *PerformanceNvmeMetricInlineSvm `json:"svm,omitempty"`

	// tcp
	TCP *PerformanceNvmeMetricInlineTCP `json:"tcp,omitempty"`

	// throughput
	Throughput *PerformanceNvmeMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance nvme metric
func (m *PerformanceNvmeMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceNvmeMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricTypeDurationPropEnum = append(performanceNvmeMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceNvmeMetricDurationPT15S captures enum value "PT15S"
	PerformanceNvmeMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceNvmeMetricDurationPT4M captures enum value "PT4M"
	PerformanceNvmeMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceNvmeMetricDurationPT30M captures enum value "PT30M"
	PerformanceNvmeMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceNvmeMetricDurationPT2H captures enum value "PT2H"
	PerformanceNvmeMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceNvmeMetricDurationP1D captures enum value "P1D"
	PerformanceNvmeMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceNvmeMetricDurationPT5M captures enum value "PT5M"
	PerformanceNvmeMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceNvmeMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetric) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var performanceNvmeMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricTypeStatusPropEnum = append(performanceNvmeMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceNvmeMetricStatusOk captures enum value "ok"
	PerformanceNvmeMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceNvmeMetricStatusError captures enum value "error"
	PerformanceNvmeMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceNvmeMetricStatusPartialNoData captures enum value "partial_no_data"
	PerformanceNvmeMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceNvmeMetricStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceNvmeMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceNvmeMetricStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceNvmeMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceNvmeMetricStatusNegativeDelta captures enum value "negative_delta"
	PerformanceNvmeMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceNvmeMetricStatusNotFound captures enum value "not_found"
	PerformanceNvmeMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceNvmeMetricStatusBackfilledData captures enum value "backfilled_data"
	PerformanceNvmeMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceNvmeMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceNvmeMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceNvmeMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceNvmeMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric
	// PerformanceNvmeMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceNvmeMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceNvmeMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceNvmeMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetric) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(m.TCP) { // not required
		return nil
	}

	if m.TCP != nil {
		if err := m.TCP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance nvme metric based on the context it is used
func (m *PerformanceNvmeMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateTCP(ctx context.Context, formats strfmt.Registry) error {

	if m.TCP != nil {
		if err := m.TCP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetric) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineFc The NVMe/FC portion of the aggregated metrics.
//
// swagger:model performance_nvme_metric_inline_fc
type PerformanceNvmeMetricInlineFc struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceNvmeMetricInlineFcInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceNvmeMetricInlineFcInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceNvmeMetricInlineFcInlineThroughput `json:"throughput,omitempty"`
}

// Validate validates this performance nvme metric inline fc
func (m *PerformanceNvmeMetricInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceNvmeMetricInlineFcTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricInlineFcTypeDurationPropEnum = append(performanceNvmeMetricInlineFcTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcDurationPT15S captures enum value "PT15S"
	PerformanceNvmeMetricInlineFcDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcDurationPT4M captures enum value "PT4M"
	PerformanceNvmeMetricInlineFcDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcDurationPT30M captures enum value "PT30M"
	PerformanceNvmeMetricInlineFcDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcDurationPT2H captures enum value "PT2H"
	PerformanceNvmeMetricInlineFcDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcDurationP1D captures enum value "P1D"
	PerformanceNvmeMetricInlineFcDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcDurationPT5M captures enum value "PT5M"
	PerformanceNvmeMetricInlineFcDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceNvmeMetricInlineFc) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricInlineFcTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricInlineFc) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("fc"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineFc) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineFc) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceNvmeMetricInlineFcTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricInlineFcTypeStatusPropEnum = append(performanceNvmeMetricInlineFcTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusOk captures enum value "ok"
	PerformanceNvmeMetricInlineFcStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusError captures enum value "error"
	PerformanceNvmeMetricInlineFcStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusPartialNoData captures enum value "partial_no_data"
	PerformanceNvmeMetricInlineFcStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceNvmeMetricInlineFcStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceNvmeMetricInlineFcStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusNegativeDelta captures enum value "negative_delta"
	PerformanceNvmeMetricInlineFcStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusNotFound captures enum value "not_found"
	PerformanceNvmeMetricInlineFcStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusBackfilledData captures enum value "backfilled_data"
	PerformanceNvmeMetricInlineFcStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceNvmeMetricInlineFcStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceNvmeMetricInlineFcStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_fc
	// PerformanceNvmeMetricInlineFc
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceNvmeMetricInlineFcStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceNvmeMetricInlineFcStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceNvmeMetricInlineFc) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricInlineFcTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricInlineFc) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("fc"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineFc) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance nvme metric inline fc based on the context it is used
func (m *PerformanceNvmeMetricInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricInlineFc) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineFc) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineFc) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineFc) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineFc) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineFc) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineFcInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_fc_inline_iops
type PerformanceNvmeMetricInlineFcInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline fc inline iops
func (m *PerformanceNvmeMetricInlineFcInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline fc inline iops based on the context it is used
func (m *PerformanceNvmeMetricInlineFcInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineFcInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineFcInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineFcInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineFcInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_fc_inline_latency
type PerformanceNvmeMetricInlineFcInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline fc inline latency
func (m *PerformanceNvmeMetricInlineFcInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline fc inline latency based on the context it is used
func (m *PerformanceNvmeMetricInlineFcInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineFcInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineFcInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineFcInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineFcInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_fc_inline_throughput
type PerformanceNvmeMetricInlineFcInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline fc inline throughput
func (m *PerformanceNvmeMetricInlineFcInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline fc inline throughput based on the context it is used
func (m *PerformanceNvmeMetricInlineFcInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineFcInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineFcInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineFcInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_iops
type PerformanceNvmeMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline iops
func (m *PerformanceNvmeMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline iops based on the context it is used
func (m *PerformanceNvmeMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_latency
type PerformanceNvmeMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline latency
func (m *PerformanceNvmeMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline latency based on the context it is used
func (m *PerformanceNvmeMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineLinks performance nvme metric inline links
//
// swagger:model performance_nvme_metric_inline__links
type PerformanceNvmeMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance nvme metric inline links
func (m *PerformanceNvmeMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance nvme metric inline links based on the context it is used
func (m *PerformanceNvmeMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineSvm performance nvme metric inline svm
//
// swagger:model performance_nvme_metric_inline_svm
type PerformanceNvmeMetricInlineSvm struct {

	// The unique identifier of the SVM.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this performance nvme metric inline svm
func (m *PerformanceNvmeMetricInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this performance nvme metric inline svm based on context it is used
func (m *PerformanceNvmeMetricInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineSvm) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineTCP The NVMe/TCP portion of the aggregated metrics.
//
// swagger:model performance_nvme_metric_inline_tcp
type PerformanceNvmeMetricInlineTCP struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceNvmeMetricInlineTCPInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceNvmeMetricInlineTCPInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceNvmeMetricInlineTCPInlineThroughput `json:"throughput,omitempty"`
}

// Validate validates this performance nvme metric inline tcp
func (m *PerformanceNvmeMetricInlineTCP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceNvmeMetricInlineTcpTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricInlineTcpTypeDurationPropEnum = append(performanceNvmeMetricInlineTcpTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPDurationPT15S captures enum value "PT15S"
	PerformanceNvmeMetricInlineTCPDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPDurationPT4M captures enum value "PT4M"
	PerformanceNvmeMetricInlineTCPDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPDurationPT30M captures enum value "PT30M"
	PerformanceNvmeMetricInlineTCPDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPDurationPT2H captures enum value "PT2H"
	PerformanceNvmeMetricInlineTCPDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPDurationP1D captures enum value "P1D"
	PerformanceNvmeMetricInlineTCPDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPDurationPT5M captures enum value "PT5M"
	PerformanceNvmeMetricInlineTCPDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceNvmeMetricInlineTCP) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricInlineTcpTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("tcp"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceNvmeMetricInlineTcpTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricInlineTcpTypeStatusPropEnum = append(performanceNvmeMetricInlineTcpTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusOk captures enum value "ok"
	PerformanceNvmeMetricInlineTCPStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusError captures enum value "error"
	PerformanceNvmeMetricInlineTCPStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusPartialNoData captures enum value "partial_no_data"
	PerformanceNvmeMetricInlineTCPStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceNvmeMetricInlineTCPStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceNvmeMetricInlineTCPStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusNegativeDelta captures enum value "negative_delta"
	PerformanceNvmeMetricInlineTCPStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusNotFound captures enum value "not_found"
	PerformanceNvmeMetricInlineTCPStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusBackfilledData captures enum value "backfilled_data"
	PerformanceNvmeMetricInlineTCPStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceNvmeMetricInlineTCPStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceNvmeMetricInlineTCPStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_inline_tcp
	// PerformanceNvmeMetricInlineTCP
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceNvmeMetricInlineTCPStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceNvmeMetricInlineTCPStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceNvmeMetricInlineTCP) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricInlineTcpTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("tcp"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance nvme metric inline tcp based on the context it is used
func (m *PerformanceNvmeMetricInlineTCP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricInlineTCP) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineTCP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineTCP) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineTCP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineTCPInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_tcp_inline_iops
type PerformanceNvmeMetricInlineTCPInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline tcp inline iops
func (m *PerformanceNvmeMetricInlineTCPInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline tcp inline iops based on the context it is used
func (m *PerformanceNvmeMetricInlineTCPInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineTCPInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineTCPInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineTCPInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineTCPInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_tcp_inline_latency
type PerformanceNvmeMetricInlineTCPInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline tcp inline latency
func (m *PerformanceNvmeMetricInlineTCPInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline tcp inline latency based on the context it is used
func (m *PerformanceNvmeMetricInlineTCPInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineTCPInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineTCPInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineTCPInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineTCPInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_tcp_inline_throughput
type PerformanceNvmeMetricInlineTCPInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline tcp inline throughput
func (m *PerformanceNvmeMetricInlineTCPInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline tcp inline throughput based on the context it is used
func (m *PerformanceNvmeMetricInlineTCPInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineTCPInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineTCPInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineTCPInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_nvme_metric_inline_throughput
type PerformanceNvmeMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric inline throughput
func (m *PerformanceNvmeMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric inline throughput based on the context it is used
func (m *PerformanceNvmeMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
