// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceNvmeMetricResponse performance nvme metric response
//
// swagger:model performance_nvme_metric_response
type PerformanceNvmeMetricResponse struct {

	// links
	Links *PerformanceNvmeMetricResponseInlineLinks `json:"_links,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// performance nvme metric response inline records
	PerformanceNvmeMetricResponseInlineRecords []*PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this performance nvme metric response
func (m *PerformanceNvmeMetricResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePerformanceNvmeMetricResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponse) validatePerformanceNvmeMetricResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.PerformanceNvmeMetricResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.PerformanceNvmeMetricResponseInlineRecords); i++ {
		if swag.IsZero(m.PerformanceNvmeMetricResponseInlineRecords[i]) { // not required
			continue
		}

		if m.PerformanceNvmeMetricResponseInlineRecords[i] != nil {
			if err := m.PerformanceNvmeMetricResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this performance nvme metric response based on the context it is used
func (m *PerformanceNvmeMetricResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePerformanceNvmeMetricResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponse) contextValidatePerformanceNvmeMetricResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PerformanceNvmeMetricResponseInlineRecords); i++ {

		if m.PerformanceNvmeMetricResponseInlineRecords[i] != nil {
			if err := m.PerformanceNvmeMetricResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponse) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineLinks performance nvme metric response inline links
//
// swagger:model performance_nvme_metric_response_inline__links
type PerformanceNvmeMetricResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance nvme metric response inline links
func (m *PerformanceNvmeMetricResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance nvme metric response inline links based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// fc
	Fc *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc `json:"fc,omitempty"`

	// iops
	Iops *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// svm
	Svm *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// tcp
	TCP *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP `json:"tcp,omitempty"`

	// throughput
	Throughput *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceNvmeMetricResponseInlineRecordsInlineArrayItemTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricResponseInlineRecordsInlineArrayItemTypeDurationPropEnum = append(performanceNvmeMetricResponseInlineRecordsInlineArrayItemTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT15S captures enum value "PT15S"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT4M captures enum value "PT4M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT30M captures enum value "PT30M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT2H captures enum value "PT2H"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationP1D captures enum value "P1D"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT5M captures enum value "PT5M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricResponseInlineRecordsInlineArrayItemTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(m.Fc) { // not required
		return nil
	}

	if m.Fc != nil {
		if err := m.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var performanceNvmeMetricResponseInlineRecordsInlineArrayItemTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricResponseInlineRecordsInlineArrayItemTypeStatusPropEnum = append(performanceNvmeMetricResponseInlineRecordsInlineArrayItemTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusOk captures enum value "ok"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusError captures enum value "error"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusPartialNoData captures enum value "partial_no_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusNegativeDelta captures enum value "negative_delta"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusNotFound captures enum value "not_found"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusBackfilledData captures enum value "backfilled_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricResponseInlineRecordsInlineArrayItemTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(m.TCP) { // not required
		return nil
	}

	if m.TCP != nil {
		if err := m.TCP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if m.Fc != nil {
		if err := m.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateTCP(ctx context.Context, formats strfmt.Registry) error {

	if m.TCP != nil {
		if err := m.TCP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc The NVMe/FC portion of the aggregated metrics.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineThroughput `json:"throughput,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline fc
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcTypeDurationPropEnum = append(performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT15S captures enum value "PT15S"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT4M captures enum value "PT4M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT30M captures enum value "PT30M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT2H captures enum value "PT2H"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationP1D captures enum value "P1D"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT5M captures enum value "PT5M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("fc"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcTypeStatusPropEnum = append(performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusOk captures enum value "ok"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusError captures enum value "error"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusPartialNoData captures enum value "partial_no_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusNegativeDelta captures enum value "negative_delta"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusNotFound captures enum value "not_found"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusBackfilledData captures enum value "backfilled_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_fc
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("fc"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline fc based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fc"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fc" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_fc_inline_iops
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline fc inline iops
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline fc inline iops based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_fc_inline_latency
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline fc inline latency
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline fc inline latency based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_fc_inline_throughput
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline fc inline throughput
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline fc inline throughput based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineFcInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_iops
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline iops
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline iops based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_latency
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline latency
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline latency based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks performance nvme metric response inline records inline array item inline links
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline__links
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline links
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline links based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineSvm performance nvme metric response inline records inline array item inline svm
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_svm
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineSvm struct {

	// The unique identifier of the SVM.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline svm
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this performance nvme metric response inline records inline array item inline svm based on context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineSvm) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP The NVMe/TCP portion of the aggregated metrics.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineThroughput `json:"throughput,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline tcp
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTcpTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTcpTypeDurationPropEnum = append(performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTcpTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT15S captures enum value "PT15S"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT4M captures enum value "PT4M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT30M captures enum value "PT30M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT2H captures enum value "PT2H"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationP1D captures enum value "P1D"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT5M captures enum value "PT5M"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTcpTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("tcp"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTcpTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTcpTypeStatusPropEnum = append(performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTcpTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusOk captures enum value "ok"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusError captures enum value "error"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusPartialNoData captures enum value "partial_no_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusNegativeDelta captures enum value "negative_delta"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusNotFound captures enum value "not_found"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusBackfilledData captures enum value "backfilled_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTcpTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("tcp"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline tcp based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "tcp"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tcp" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp_inline_iops
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline tcp inline iops
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline tcp inline iops based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp_inline_latency
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline tcp inline latency
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline tcp inline latency based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_tcp_inline_throughput
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline tcp inline throughput
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline tcp inline throughput based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineTCPInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_nvme_metric_response_inline_records_inline_array_item_inline_throughput
type PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance nvme metric response inline records inline array item inline throughput
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance nvme metric response inline records inline array item inline throughput based on the context it is used
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceNvmeMetricResponseInlineRecordsInlineArrayItemInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
