// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceS3Metric Performance numbers, such as IOPS latency and throughput.
//
// swagger:model performance_s3_metric
type PerformanceS3Metric struct {

	// links
	Links *PerformanceS3MetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceS3MetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceS3MetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceS3MetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance s3 metric
func (m *PerformanceS3Metric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceS3Metric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var performanceS3MetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceS3MetricTypeDurationPropEnum = append(performanceS3MetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceS3MetricDurationPT15S captures enum value "PT15S"
	PerformanceS3MetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceS3MetricDurationPT4M captures enum value "PT4M"
	PerformanceS3MetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceS3MetricDurationPT30M captures enum value "PT30M"
	PerformanceS3MetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceS3MetricDurationPT2H captures enum value "PT2H"
	PerformanceS3MetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceS3MetricDurationP1D captures enum value "P1D"
	PerformanceS3MetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceS3MetricDurationPT5M captures enum value "PT5M"
	PerformanceS3MetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceS3Metric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceS3MetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceS3Metric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceS3Metric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceS3Metric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var performanceS3MetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceS3MetricTypeStatusPropEnum = append(performanceS3MetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceS3MetricStatusOk captures enum value "ok"
	PerformanceS3MetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceS3MetricStatusError captures enum value "error"
	PerformanceS3MetricStatusError string = "error"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceS3MetricStatusPartialNoData captures enum value "partial_no_data"
	PerformanceS3MetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceS3MetricStatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceS3MetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceS3MetricStatusPartialOtherError captures enum value "partial_other_error"
	PerformanceS3MetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceS3MetricStatusNegativeDelta captures enum value "negative_delta"
	PerformanceS3MetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceS3MetricStatusNotFound captures enum value "not_found"
	PerformanceS3MetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceS3MetricStatusBackfilledData captures enum value "backfilled_data"
	PerformanceS3MetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceS3MetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceS3MetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceS3MetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceS3MetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_s3_metric
	// PerformanceS3Metric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceS3MetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceS3MetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceS3Metric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceS3MetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceS3Metric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceS3Metric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceS3Metric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance s3 metric based on the context it is used
func (m *PerformanceS3Metric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceS3Metric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceS3Metric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceS3Metric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceS3Metric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceS3Metric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceS3Metric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceS3Metric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceS3Metric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceS3Metric) UnmarshalBinary(b []byte) error {
	var res PerformanceS3Metric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceS3MetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_s3_metric_inline_iops
type PerformanceS3MetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance s3 metric inline iops
func (m *PerformanceS3MetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance s3 metric inline iops based on the context it is used
func (m *PerformanceS3MetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceS3MetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceS3MetricInlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceS3MetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceS3MetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_s3_metric_inline_latency
type PerformanceS3MetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance s3 metric inline latency
func (m *PerformanceS3MetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance s3 metric inline latency based on the context it is used
func (m *PerformanceS3MetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceS3MetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceS3MetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceS3MetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceS3MetricInlineLinks performance s3 metric inline links
//
// swagger:model performance_s3_metric_inline__links
type PerformanceS3MetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance s3 metric inline links
func (m *PerformanceS3MetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceS3MetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance s3 metric inline links based on the context it is used
func (m *PerformanceS3MetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceS3MetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceS3MetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceS3MetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceS3MetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceS3MetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_s3_metric_inline_throughput
type PerformanceS3MetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance s3 metric inline throughput
func (m *PerformanceS3MetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance s3 metric inline throughput based on the context it is used
func (m *PerformanceS3MetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceS3MetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceS3MetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceS3MetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
