// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceSvmNfsMetric Historical performance numbers, such as IOPS latency and throughput, for SVM-NFS protocol.
//
// swagger:model performance_svm_nfs_metric
type PerformanceSvmNfsMetric struct {

	// v3
	V3 *PerformanceSvmNfsMetricInlineV3 `json:"v3,omitempty"`

	// v4
	V4 *PerformanceSvmNfsMetricInlineV4 `json:"v4,omitempty"`

	// v41
	V41 *PerformanceSvmNfsMetricInlineV41 `json:"v41,omitempty"`
}

// Validate validates this performance svm nfs metric
func (m *PerformanceSvmNfsMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateV3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV41(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetric) validateV3(formats strfmt.Registry) error {
	if swag.IsZero(m.V3) { // not required
		return nil
	}

	if m.V3 != nil {
		if err := m.V3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetric) validateV4(formats strfmt.Registry) error {
	if swag.IsZero(m.V4) { // not required
		return nil
	}

	if m.V4 != nil {
		if err := m.V4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetric) validateV41(formats strfmt.Registry) error {
	if swag.IsZero(m.V41) { // not required
		return nil
	}

	if m.V41 != nil {
		if err := m.V41.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric based on the context it is used
func (m *PerformanceSvmNfsMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateV3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV41(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetric) contextValidateV3(ctx context.Context, formats strfmt.Registry) error {

	if m.V3 != nil {
		if err := m.V3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetric) contextValidateV4(ctx context.Context, formats strfmt.Registry) error {

	if m.V4 != nil {
		if err := m.V4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetric) contextValidateV41(ctx context.Context, formats strfmt.Registry) error {

	if m.V41 != nil {
		if err := m.V41.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetric) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV3 The NFSv3 operations
//
// swagger:model performance_svm_nfs_metric_inline_v3
type PerformanceSvmNfsMetricInlineV3 struct {

	// links
	Links *PerformanceSvmNfsMetricInlineV3InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsMetricInlineV3InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsMetricInlineV3InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsMetricInlineV3InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs metric inline v3
func (m *PerformanceSvmNfsMetricInlineV3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricInlineV3TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricInlineV3TypeDurationPropEnum = append(performanceSvmNfsMetricInlineV3TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsMetricInlineV3DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3DurationPT4M captures enum value "PT4M"
	PerformanceSvmNfsMetricInlineV3DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsMetricInlineV3DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsMetricInlineV3DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3DurationP1D captures enum value "P1D"
	PerformanceSvmNfsMetricInlineV3DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsMetricInlineV3DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsMetricInlineV3) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricInlineV3TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v3"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricInlineV3TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricInlineV3TypeStatusPropEnum = append(performanceSvmNfsMetricInlineV3TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusOk captures enum value "ok"
	PerformanceSvmNfsMetricInlineV3StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusError captures enum value "error"
	PerformanceSvmNfsMetricInlineV3StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsMetricInlineV3StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsMetricInlineV3StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsMetricInlineV3StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsMetricInlineV3StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsMetricInlineV3StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsMetricInlineV3StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsMetricInlineV3StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsMetricInlineV3StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v3
	// PerformanceSvmNfsMetricInlineV3
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV3StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsMetricInlineV3StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsMetricInlineV3) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricInlineV3TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v3"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v3"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric inline v3 based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV3InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v3_inline_iops
type PerformanceSvmNfsMetricInlineV3InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v3 inline iops
func (m *PerformanceSvmNfsMetricInlineV3InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v3 inline iops based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV3InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV3InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV3InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v3_inline_latency
type PerformanceSvmNfsMetricInlineV3InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v3 inline latency
func (m *PerformanceSvmNfsMetricInlineV3InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v3 inline latency based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV3InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV3InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV3InlineLinks performance svm nfs metric inline v3 inline links
//
// swagger:model performance_svm_nfs_metric_inline_v3_inline__links
type PerformanceSvmNfsMetricInlineV3InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance svm nfs metric inline v3 inline links
func (m *PerformanceSvmNfsMetricInlineV3InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric inline v3 inline links based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV3InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV3InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3InlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV3InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV3InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v3_inline_throughput
type PerformanceSvmNfsMetricInlineV3InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v3 inline throughput
func (m *PerformanceSvmNfsMetricInlineV3InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v3 inline throughput based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV3InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV3InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV3InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV4 The NFSv4 operations
//
// swagger:model performance_svm_nfs_metric_inline_v4
type PerformanceSvmNfsMetricInlineV4 struct {

	// links
	Links *PerformanceSvmNfsMetricInlineV4InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsMetricInlineV4InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsMetricInlineV4InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsMetricInlineV4InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs metric inline v4
func (m *PerformanceSvmNfsMetricInlineV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricInlineV4TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricInlineV4TypeDurationPropEnum = append(performanceSvmNfsMetricInlineV4TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsMetricInlineV4DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4DurationPT4M captures enum value "PT4M"
	PerformanceSvmNfsMetricInlineV4DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsMetricInlineV4DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsMetricInlineV4DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4DurationP1D captures enum value "P1D"
	PerformanceSvmNfsMetricInlineV4DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsMetricInlineV4DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsMetricInlineV4) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricInlineV4TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v4"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricInlineV4TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricInlineV4TypeStatusPropEnum = append(performanceSvmNfsMetricInlineV4TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusOk captures enum value "ok"
	PerformanceSvmNfsMetricInlineV4StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusError captures enum value "error"
	PerformanceSvmNfsMetricInlineV4StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsMetricInlineV4StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsMetricInlineV4StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsMetricInlineV4StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsMetricInlineV4StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsMetricInlineV4StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsMetricInlineV4StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsMetricInlineV4StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsMetricInlineV4StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v4
	// PerformanceSvmNfsMetricInlineV4
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV4StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsMetricInlineV4StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsMetricInlineV4) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricInlineV4TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v4"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v4"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric inline v4 based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV41 The NFSv4.1 operations
//
// swagger:model performance_svm_nfs_metric_inline_v41
type PerformanceSvmNfsMetricInlineV41 struct {

	// links
	Links *PerformanceSvmNfsMetricInlineV41InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsMetricInlineV41InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsMetricInlineV41InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsMetricInlineV41InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs metric inline v41
func (m *PerformanceSvmNfsMetricInlineV41) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricInlineV41TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricInlineV41TypeDurationPropEnum = append(performanceSvmNfsMetricInlineV41TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsMetricInlineV41DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41DurationPT4M captures enum value "PT4M"
	PerformanceSvmNfsMetricInlineV41DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsMetricInlineV41DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsMetricInlineV41DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41DurationP1D captures enum value "P1D"
	PerformanceSvmNfsMetricInlineV41DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsMetricInlineV41DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsMetricInlineV41) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricInlineV41TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v41"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricInlineV41TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricInlineV41TypeStatusPropEnum = append(performanceSvmNfsMetricInlineV41TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusOk captures enum value "ok"
	PerformanceSvmNfsMetricInlineV41StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusError captures enum value "error"
	PerformanceSvmNfsMetricInlineV41StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsMetricInlineV41StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsMetricInlineV41StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsMetricInlineV41StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsMetricInlineV41StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsMetricInlineV41StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsMetricInlineV41StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsMetricInlineV41StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsMetricInlineV41StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_inline_v41
	// PerformanceSvmNfsMetricInlineV41
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsMetricInlineV41StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsMetricInlineV41StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsMetricInlineV41) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricInlineV41TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v41"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v41"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric inline v41 based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV41) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV41
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV41InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v41_inline_iops
type PerformanceSvmNfsMetricInlineV41InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v41 inline iops
func (m *PerformanceSvmNfsMetricInlineV41InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v41 inline iops based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV41InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV41InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV41InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v41_inline_latency
type PerformanceSvmNfsMetricInlineV41InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v41 inline latency
func (m *PerformanceSvmNfsMetricInlineV41InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v41 inline latency based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV41InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV41InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV41InlineLinks performance svm nfs metric inline v41 inline links
//
// swagger:model performance_svm_nfs_metric_inline_v41_inline__links
type PerformanceSvmNfsMetricInlineV41InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance svm nfs metric inline v41 inline links
func (m *PerformanceSvmNfsMetricInlineV41InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric inline v41 inline links based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV41InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV41InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41InlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV41InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV41InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v41_inline_throughput
type PerformanceSvmNfsMetricInlineV41InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v41 inline throughput
func (m *PerformanceSvmNfsMetricInlineV41InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v41 inline throughput based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV41InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV41InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV41InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV4InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v4_inline_iops
type PerformanceSvmNfsMetricInlineV4InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v4 inline iops
func (m *PerformanceSvmNfsMetricInlineV4InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v4 inline iops based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV4InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV4InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV4InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v4_inline_latency
type PerformanceSvmNfsMetricInlineV4InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v4 inline latency
func (m *PerformanceSvmNfsMetricInlineV4InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v4 inline latency based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV4InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV4InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV4InlineLinks performance svm nfs metric inline v4 inline links
//
// swagger:model performance_svm_nfs_metric_inline_v4_inline__links
type PerformanceSvmNfsMetricInlineV4InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance svm nfs metric inline v4 inline links
func (m *PerformanceSvmNfsMetricInlineV4InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric inline v4 inline links based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV4InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricInlineV4InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4InlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV4InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricInlineV4InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_inline_v4_inline_throughput
type PerformanceSvmNfsMetricInlineV4InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric inline v4 inline throughput
func (m *PerformanceSvmNfsMetricInlineV4InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric inline v4 inline throughput based on the context it is used
func (m *PerformanceSvmNfsMetricInlineV4InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricInlineV4InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricInlineV4InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
