// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceSvmNfsMetricHistorical Historical performance numbers, such as IOPS latency and throughput, for SVM-NFS protocol.
//
// swagger:model performance_svm_nfs_metric_historical
type PerformanceSvmNfsMetricHistorical struct {

	// links
	Links *PerformanceSvmNfsMetricHistoricalInlineLinks `json:"_links,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// v3
	V3 *PerformanceSvmNfsMetricHistoricalInlineV3 `json:"v3,omitempty"`

	// v4
	V4 *PerformanceSvmNfsMetricHistoricalInlineV4 `json:"v4,omitempty"`

	// v41
	V41 *PerformanceSvmNfsMetricHistoricalInlineV41 `json:"v41,omitempty"`
}

// Validate validates this performance svm nfs metric historical
func (m *PerformanceSvmNfsMetricHistorical) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV41(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) validateV3(formats strfmt.Registry) error {
	if swag.IsZero(m.V3) { // not required
		return nil
	}

	if m.V3 != nil {
		if err := m.V3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) validateV4(formats strfmt.Registry) error {
	if swag.IsZero(m.V4) { // not required
		return nil
	}

	if m.V4 != nil {
		if err := m.V4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) validateV41(formats strfmt.Registry) error {
	if swag.IsZero(m.V41) { // not required
		return nil
	}

	if m.V41 != nil {
		if err := m.V41.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric historical based on the context it is used
func (m *PerformanceSvmNfsMetricHistorical) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV41(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) contextValidateV3(ctx context.Context, formats strfmt.Registry) error {

	if m.V3 != nil {
		if err := m.V3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) contextValidateV4(ctx context.Context, formats strfmt.Registry) error {

	if m.V4 != nil {
		if err := m.V4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistorical) contextValidateV41(ctx context.Context, formats strfmt.Registry) error {

	if m.V41 != nil {
		if err := m.V41.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistorical) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistorical) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistorical
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineLinks performance svm nfs metric historical inline links
//
// swagger:model performance_svm_nfs_metric_historical_inline__links
type PerformanceSvmNfsMetricHistoricalInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline links
func (m *PerformanceSvmNfsMetricHistoricalInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline links based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV3 The NFSv3 operations
//
// swagger:model performance_svm_nfs_metric_historical_inline_v3
type PerformanceSvmNfsMetricHistoricalInlineV3 struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsMetricHistoricalInlineV3InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsMetricHistoricalInlineV3InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsMetricHistoricalInlineV3InlineThroughput `json:"throughput,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v3
func (m *PerformanceSvmNfsMetricHistoricalInlineV3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceSvmNfsMetricHistoricalInlineV3TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricHistoricalInlineV3TypeDurationPropEnum = append(performanceSvmNfsMetricHistoricalInlineV3TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsMetricHistoricalInlineV3DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3DurationPT4M captures enum value "PT4M"
	PerformanceSvmNfsMetricHistoricalInlineV3DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsMetricHistoricalInlineV3DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsMetricHistoricalInlineV3DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3DurationP1D captures enum value "P1D"
	PerformanceSvmNfsMetricHistoricalInlineV3DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsMetricHistoricalInlineV3DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsMetricHistoricalInlineV3) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricHistoricalInlineV3TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v3"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricHistoricalInlineV3TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricHistoricalInlineV3TypeStatusPropEnum = append(performanceSvmNfsMetricHistoricalInlineV3TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusOk captures enum value "ok"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusError captures enum value "error"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v3
	// PerformanceSvmNfsMetricHistoricalInlineV3
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV3StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsMetricHistoricalInlineV3StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsMetricHistoricalInlineV3) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricHistoricalInlineV3TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v3"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v3 based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV3) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV3) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV3InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v3_inline_iops
type PerformanceSvmNfsMetricHistoricalInlineV3InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v3 inline iops
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v3 inline iops based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV3InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV3InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v3_inline_latency
type PerformanceSvmNfsMetricHistoricalInlineV3InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v3 inline latency
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v3 inline latency based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV3InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV3InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v3_inline_throughput
type PerformanceSvmNfsMetricHistoricalInlineV3InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v3 inline throughput
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v3 inline throughput based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV3InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV3InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV4 The NFSv4 operations
//
// swagger:model performance_svm_nfs_metric_historical_inline_v4
type PerformanceSvmNfsMetricHistoricalInlineV4 struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsMetricHistoricalInlineV4InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsMetricHistoricalInlineV4InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsMetricHistoricalInlineV4InlineThroughput `json:"throughput,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v4
func (m *PerformanceSvmNfsMetricHistoricalInlineV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceSvmNfsMetricHistoricalInlineV4TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricHistoricalInlineV4TypeDurationPropEnum = append(performanceSvmNfsMetricHistoricalInlineV4TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsMetricHistoricalInlineV4DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsMetricHistoricalInlineV4DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsMetricHistoricalInlineV4DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4DurationP1D captures enum value "P1D"
	PerformanceSvmNfsMetricHistoricalInlineV4DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsMetricHistoricalInlineV4DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsMetricHistoricalInlineV4) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricHistoricalInlineV4TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v4"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricHistoricalInlineV4TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricHistoricalInlineV4TypeStatusPropEnum = append(performanceSvmNfsMetricHistoricalInlineV4TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusOk captures enum value "ok"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusError captures enum value "error"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v4
	// PerformanceSvmNfsMetricHistoricalInlineV4
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV4StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsMetricHistoricalInlineV4StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsMetricHistoricalInlineV4) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricHistoricalInlineV4TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v4"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v4 based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV4) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV4) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV41 The NFSv4.1 operations
//
// swagger:model performance_svm_nfs_metric_historical_inline_v41
type PerformanceSvmNfsMetricHistoricalInlineV41 struct {

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsMetricHistoricalInlineV41InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsMetricHistoricalInlineV41InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsMetricHistoricalInlineV41InlineThroughput `json:"throughput,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v41
func (m *PerformanceSvmNfsMetricHistoricalInlineV41) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var performanceSvmNfsMetricHistoricalInlineV41TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricHistoricalInlineV41TypeDurationPropEnum = append(performanceSvmNfsMetricHistoricalInlineV41TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsMetricHistoricalInlineV41DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsMetricHistoricalInlineV41DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsMetricHistoricalInlineV41DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41DurationP1D captures enum value "P1D"
	PerformanceSvmNfsMetricHistoricalInlineV41DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsMetricHistoricalInlineV41DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsMetricHistoricalInlineV41) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricHistoricalInlineV41TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v41"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsMetricHistoricalInlineV41TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsMetricHistoricalInlineV41TypeStatusPropEnum = append(performanceSvmNfsMetricHistoricalInlineV41TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusOk captures enum value "ok"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusError captures enum value "error"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_metric_historical_inline_v41
	// PerformanceSvmNfsMetricHistoricalInlineV41
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsMetricHistoricalInlineV41StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsMetricHistoricalInlineV41StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsMetricHistoricalInlineV41) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsMetricHistoricalInlineV41TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v41"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v41 based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV41) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsMetricHistoricalInlineV41) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV41) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV41) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV41
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV41InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v41_inline_iops
type PerformanceSvmNfsMetricHistoricalInlineV41InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v41 inline iops
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v41 inline iops based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV41InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV41InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v41_inline_latency
type PerformanceSvmNfsMetricHistoricalInlineV41InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v41 inline latency
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v41 inline latency based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV41InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV41InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v41_inline_throughput
type PerformanceSvmNfsMetricHistoricalInlineV41InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v41 inline throughput
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v41 inline throughput based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV41InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV41InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV4InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v4_inline_iops
type PerformanceSvmNfsMetricHistoricalInlineV4InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v4 inline iops
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v4 inline iops based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV4InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV4InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v4_inline_latency
type PerformanceSvmNfsMetricHistoricalInlineV4InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v4 inline latency
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v4 inline latency based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV4InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsMetricHistoricalInlineV4InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_metric_historical_inline_v4_inline_throughput
type PerformanceSvmNfsMetricHistoricalInlineV4InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs metric historical inline v4 inline throughput
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs metric historical inline v4 inline throughput based on the context it is used
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsMetricHistoricalInlineV4InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsMetricHistoricalInlineV4InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
