// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceSvmNfsResponse performance svm nfs response
//
// swagger:model performance_svm_nfs_response
type PerformanceSvmNfsResponse struct {

	// links
	Links *PerformanceSvmNfsResponseInlineLinks `json:"_links,omitempty"`

	// Number of records
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`

	// performance svm nfs response inline records
	PerformanceSvmNfsResponseInlineRecords []*PerformanceSvmNfsResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this performance svm nfs response
func (m *PerformanceSvmNfsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePerformanceSvmNfsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponse) validatePerformanceSvmNfsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.PerformanceSvmNfsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.PerformanceSvmNfsResponseInlineRecords); i++ {
		if swag.IsZero(m.PerformanceSvmNfsResponseInlineRecords[i]) { // not required
			continue
		}

		if m.PerformanceSvmNfsResponseInlineRecords[i] != nil {
			if err := m.PerformanceSvmNfsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this performance svm nfs response based on the context it is used
func (m *PerformanceSvmNfsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePerformanceSvmNfsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponse) contextValidatePerformanceSvmNfsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PerformanceSvmNfsResponseInlineRecords); i++ {

		if m.PerformanceSvmNfsResponseInlineRecords[i] != nil {
			if err := m.PerformanceSvmNfsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponse) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineLinks performance svm nfs response inline links
//
// swagger:model performance_svm_nfs_response_inline__links
type PerformanceSvmNfsResponseInlineLinks struct {

	// next
	Next *Href `json:"next,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance svm nfs response inline links
func (m *PerformanceSvmNfsResponseInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(m.Next) { // not required
		return nil
	}

	if m.Next != nil {
		if err := m.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs response inline links based on the context it is used
func (m *PerformanceSvmNfsResponseInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if m.Next != nil {
		if err := m.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItem Historical performance numbers, such as IOPS latency and throughput, for SVM-NFS protocol.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItem struct {

	// v3
	V3 *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3 `json:"v3,omitempty"`

	// v4
	V4 *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4 `json:"v4,omitempty"`

	// v41
	V41 *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41 `json:"v41,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateV3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV41(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) validateV3(formats strfmt.Registry) error {
	if swag.IsZero(m.V3) { // not required
		return nil
	}

	if m.V3 != nil {
		if err := m.V3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) validateV4(formats strfmt.Registry) error {
	if swag.IsZero(m.V4) { // not required
		return nil
	}

	if m.V4 != nil {
		if err := m.V4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) validateV41(formats strfmt.Registry) error {
	if swag.IsZero(m.V41) { // not required
		return nil
	}

	if m.V41 != nil {
		if err := m.V41.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateV3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV41(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) contextValidateV3(ctx context.Context, formats strfmt.Registry) error {

	if m.V3 != nil {
		if err := m.V3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) contextValidateV4(ctx context.Context, formats strfmt.Registry) error {

	if m.V4 != nil {
		if err := m.V4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) contextValidateV41(ctx context.Context, formats strfmt.Registry) error {

	if m.V41 != nil {
		if err := m.V41.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3 The NFSv3 operations
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3 struct {

	// links
	Links *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v3
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3TypeDurationPropEnum = append(performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT4M captures enum value "PT4M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationP1D captures enum value "P1D"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v3"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3TypeStatusPropEnum = append(performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusOk captures enum value "ok"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusError captures enum value "error"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v3
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v3"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v3"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v3 based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v3_inline_iops
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v3 inline iops
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v3 inline iops based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v3_inline_latency
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v3 inline latency
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v3 inline latency based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks performance svm nfs response inline records inline array item inline v3 inline links
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v3_inline__links
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v3 inline links
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v3 inline links based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v3_inline_throughput
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v3 inline throughput
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v3 inline throughput based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV3InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4 The NFSv4 operations
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4 struct {

	// links
	Links *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v4
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4TypeDurationPropEnum = append(performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT4M captures enum value "PT4M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationP1D captures enum value "P1D"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v4"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4TypeStatusPropEnum = append(performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusOk captures enum value "ok"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusError captures enum value "error"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v4
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v4"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v4"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v4 based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41 The NFSv4.1 operations
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41 struct {

	// links
	Links *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineIops `json:"iops,omitempty"`

	// latency
	Latency *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v41
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41TypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41TypeDurationPropEnum = append(performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41TypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT15S captures enum value "PT15S"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT4M captures enum value "PT4M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT30M captures enum value "PT30M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT2H captures enum value "PT2H"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationP1D captures enum value "P1D"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT5M captures enum value "PT5M"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41DurationPT5M string = "PT5M"
)

// prop value enum
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41TypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("v41"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41TypeStatusPropEnum = append(performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusOk captures enum value "ok"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusError captures enum value "error"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_response_inline_records_inline_array_item_inline_v41
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v41"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v41"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v41 based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v41_inline_iops
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v41 inline iops
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v41 inline iops based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v41_inline_latency
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v41 inline latency
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v41 inline latency based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks performance svm nfs response inline records inline array item inline v41 inline links
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v41_inline__links
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v41 inline links
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v41 inline links based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v41_inline_throughput
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v41 inline throughput
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v41 inline throughput based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV41InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v4_inline_iops
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v4 inline iops
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v4 inline iops based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineIops) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v4_inline_latency
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v4 inline latency
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v4 inline latency based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLatency) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks performance svm nfs response inline records inline array item inline v4 inline links
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v4_inline__links
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v4 inline links
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v4 inline links based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model performance_svm_nfs_response_inline_records_inline_array_item_inline_v4_inline_throughput
type PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs response inline records inline array item inline v4 inline throughput
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs response inline records inline array item inline v4 inline throughput based on the context it is used
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineThroughput) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsResponseInlineRecordsInlineArrayItemInlineV4InlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
