// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PerformanceSvmNfsStatistics Realtime performance numbers, such as IOPS latency and throughput, for SVM-NFS protocol.
//
// swagger:model performance_svm_nfs_statistics
type PerformanceSvmNfsStatistics struct {

	// v3
	V3 *PerformanceSvmNfsStatisticsInlineV3 `json:"v3,omitempty"`

	// v4
	V4 *PerformanceSvmNfsStatisticsInlineV4 `json:"v4,omitempty"`

	// v41
	V41 *PerformanceSvmNfsStatisticsInlineV41 `json:"v41,omitempty"`
}

// Validate validates this performance svm nfs statistics
func (m *PerformanceSvmNfsStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateV3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateV41(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsStatistics) validateV3(formats strfmt.Registry) error {
	if swag.IsZero(m.V3) { // not required
		return nil
	}

	if m.V3 != nil {
		if err := m.V3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatistics) validateV4(formats strfmt.Registry) error {
	if swag.IsZero(m.V4) { // not required
		return nil
	}

	if m.V4 != nil {
		if err := m.V4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatistics) validateV41(formats strfmt.Registry) error {
	if swag.IsZero(m.V41) { // not required
		return nil
	}

	if m.V41 != nil {
		if err := m.V41.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this performance svm nfs statistics based on the context it is used
func (m *PerformanceSvmNfsStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateV3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateV41(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsStatistics) contextValidateV3(ctx context.Context, formats strfmt.Registry) error {

	if m.V3 != nil {
		if err := m.V3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatistics) contextValidateV4(ctx context.Context, formats strfmt.Registry) error {

	if m.V4 != nil {
		if err := m.V4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatistics) contextValidateV41(ctx context.Context, formats strfmt.Registry) error {

	if m.V41 != nil {
		if err := m.V41.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatistics) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV3 The NFSv3 operations
//
// swagger:model performance_svm_nfs_statistics_inline_v3
type PerformanceSvmNfsStatisticsInlineV3 struct {

	// iops raw
	IopsRaw *PerformanceSvmNfsStatisticsInlineV3InlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *PerformanceSvmNfsStatisticsInlineV3InlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *PerformanceSvmNfsStatisticsInlineV3InlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v3
func (m *PerformanceSvmNfsStatisticsInlineV3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsStatisticsInlineV3TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsStatisticsInlineV3TypeStatusPropEnum = append(performanceSvmNfsStatisticsInlineV3TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusOk captures enum value "ok"
	PerformanceSvmNfsStatisticsInlineV3StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusError captures enum value "error"
	PerformanceSvmNfsStatisticsInlineV3StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsStatisticsInlineV3StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsStatisticsInlineV3StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsStatisticsInlineV3StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsStatisticsInlineV3StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsStatisticsInlineV3StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsStatisticsInlineV3StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsStatisticsInlineV3StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsStatisticsInlineV3StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v3
	// PerformanceSvmNfsStatisticsInlineV3
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV3StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsStatisticsInlineV3StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsStatisticsInlineV3) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsStatisticsInlineV3TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v3"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v3"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v3 based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v3" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV3) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v3"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV3) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV3) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV3InlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model performance_svm_nfs_statistics_inline_v3_inline_iops_raw
type PerformanceSvmNfsStatisticsInlineV3InlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v3 inline iops raw
func (m *PerformanceSvmNfsStatisticsInlineV3InlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v3 inline iops raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV3InlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV3InlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV3InlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV3InlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV3InlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model performance_svm_nfs_statistics_inline_v3_inline_latency_raw
type PerformanceSvmNfsStatisticsInlineV3InlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v3 inline latency raw
func (m *PerformanceSvmNfsStatisticsInlineV3InlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v3 inline latency raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV3InlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV3InlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV3InlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV3InlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV3InlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model performance_svm_nfs_statistics_inline_v3_inline_throughput_raw
type PerformanceSvmNfsStatisticsInlineV3InlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v3 inline throughput raw
func (m *PerformanceSvmNfsStatisticsInlineV3InlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v3 inline throughput raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV3InlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV3InlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV3InlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV3InlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV4 The NFSv4 operations
//
// swagger:model performance_svm_nfs_statistics_inline_v4
type PerformanceSvmNfsStatisticsInlineV4 struct {

	// iops raw
	IopsRaw *PerformanceSvmNfsStatisticsInlineV4InlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *PerformanceSvmNfsStatisticsInlineV4InlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *PerformanceSvmNfsStatisticsInlineV4InlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v4
func (m *PerformanceSvmNfsStatisticsInlineV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsStatisticsInlineV4TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsStatisticsInlineV4TypeStatusPropEnum = append(performanceSvmNfsStatisticsInlineV4TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusOk captures enum value "ok"
	PerformanceSvmNfsStatisticsInlineV4StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusError captures enum value "error"
	PerformanceSvmNfsStatisticsInlineV4StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsStatisticsInlineV4StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsStatisticsInlineV4StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsStatisticsInlineV4StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsStatisticsInlineV4StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsStatisticsInlineV4StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsStatisticsInlineV4StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsStatisticsInlineV4StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsStatisticsInlineV4StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v4
	// PerformanceSvmNfsStatisticsInlineV4
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV4StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsStatisticsInlineV4StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsStatisticsInlineV4) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsStatisticsInlineV4TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v4"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v4"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v4 based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v4" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV4) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v4"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV4) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV41 The NFSv4.1 operations
//
// swagger:model performance_svm_nfs_statistics_inline_v41
type PerformanceSvmNfsStatisticsInlineV41 struct {

	// iops raw
	IopsRaw *PerformanceSvmNfsStatisticsInlineV41InlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *PerformanceSvmNfsStatisticsInlineV41InlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *PerformanceSvmNfsStatisticsInlineV41InlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v41
func (m *PerformanceSvmNfsStatisticsInlineV41) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var performanceSvmNfsStatisticsInlineV41TypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		performanceSvmNfsStatisticsInlineV41TypeStatusPropEnum = append(performanceSvmNfsStatisticsInlineV41TypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// ok
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusOk captures enum value "ok"
	PerformanceSvmNfsStatisticsInlineV41StatusOk string = "ok"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// error
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusError captures enum value "error"
	PerformanceSvmNfsStatisticsInlineV41StatusError string = "error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusPartialNoData captures enum value "partial_no_data"
	PerformanceSvmNfsStatisticsInlineV41StatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusPartialNoResponse captures enum value "partial_no_response"
	PerformanceSvmNfsStatisticsInlineV41StatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusPartialOtherError captures enum value "partial_other_error"
	PerformanceSvmNfsStatisticsInlineV41StatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusNegativeDelta captures enum value "negative_delta"
	PerformanceSvmNfsStatisticsInlineV41StatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// not_found
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusNotFound captures enum value "not_found"
	PerformanceSvmNfsStatisticsInlineV41StatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusBackfilledData captures enum value "backfilled_data"
	PerformanceSvmNfsStatisticsInlineV41StatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	PerformanceSvmNfsStatisticsInlineV41StatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusInconsistentOldData captures enum value "inconsistent_old_data"
	PerformanceSvmNfsStatisticsInlineV41StatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// performance_svm_nfs_statistics_inline_v41
	// PerformanceSvmNfsStatisticsInlineV41
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// PerformanceSvmNfsStatisticsInlineV41StatusPartialNoUUID captures enum value "partial_no_uuid"
	PerformanceSvmNfsStatisticsInlineV41StatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *PerformanceSvmNfsStatisticsInlineV41) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, performanceSvmNfsStatisticsInlineV41TypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("v41"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("v41"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v41 based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV41) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("v41" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *PerformanceSvmNfsStatisticsInlineV41) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "v41"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV41) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV41) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV41
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV41InlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model performance_svm_nfs_statistics_inline_v41_inline_iops_raw
type PerformanceSvmNfsStatisticsInlineV41InlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v41 inline iops raw
func (m *PerformanceSvmNfsStatisticsInlineV41InlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v41 inline iops raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV41InlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV41InlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV41InlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV41InlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV41InlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model performance_svm_nfs_statistics_inline_v41_inline_latency_raw
type PerformanceSvmNfsStatisticsInlineV41InlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v41 inline latency raw
func (m *PerformanceSvmNfsStatisticsInlineV41InlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v41 inline latency raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV41InlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV41InlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV41InlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV41InlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV41InlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model performance_svm_nfs_statistics_inline_v41_inline_throughput_raw
type PerformanceSvmNfsStatisticsInlineV41InlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v41 inline throughput raw
func (m *PerformanceSvmNfsStatisticsInlineV41InlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v41 inline throughput raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV41InlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV41InlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV41InlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV41InlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV4InlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model performance_svm_nfs_statistics_inline_v4_inline_iops_raw
type PerformanceSvmNfsStatisticsInlineV4InlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v4 inline iops raw
func (m *PerformanceSvmNfsStatisticsInlineV4InlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v4 inline iops raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV4InlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV4InlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV4InlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV4InlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV4InlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model performance_svm_nfs_statistics_inline_v4_inline_latency_raw
type PerformanceSvmNfsStatisticsInlineV4InlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v4 inline latency raw
func (m *PerformanceSvmNfsStatisticsInlineV4InlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v4 inline latency raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV4InlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV4InlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV4InlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV4InlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PerformanceSvmNfsStatisticsInlineV4InlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model performance_svm_nfs_statistics_inline_v4_inline_throughput_raw
type PerformanceSvmNfsStatisticsInlineV4InlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this performance svm nfs statistics inline v4 inline throughput raw
func (m *PerformanceSvmNfsStatisticsInlineV4InlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this performance svm nfs statistics inline v4 inline throughput raw based on the context it is used
func (m *PerformanceSvmNfsStatisticsInlineV4InlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV4InlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PerformanceSvmNfsStatisticsInlineV4InlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res PerformanceSvmNfsStatisticsInlineV4InlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
